/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.IniFile;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;

public class EgFormatInfo {
    public static String dddSection = "DDD_TESTS";
    public static String dddInfosSection = "DDD_INFOS";
    public static String dddDatesSection = "DDD_DATE";
    public static String dddCleanupSection = "DDD_CLEANUP";
    public static String externalInfoDDSection = "EXTERNAL_DD_TESTS_MAPPING";
    public static final String BLOB_SUPPORT = "BLOB_SUPPORT";
    public static final String DDD_BLOB_TABLES = "DDD_BLOB_TABLES";
    public static String externalInfoDDTableSection = "EXTERNAL_DD_TESTS_TABLE_MAPPING";
    public static String excludedDDTableSection = "EXCLUDED_DD_TABLE_MAPPING";
    public static String noMsmtHostDDDTest = "NO_MSMTHOST_DDD_TESTS";
    public static String imageTestSection = "IMAGE_TABLE_DELETE";
    public static String dumpTestSection = "DUMP_TABLE_DELETE";
    public static final String EXTERNAL_TABLE_MISC = "EXTERNAL_TABLE_MISC";
    public static final String IGNORE_SEQNO_FOR_TABLES = "IgnoreSequenceNumberForTables";
    public static final String COMMON_DDTEST_MAPPING = "COMMON_DDTEST_MAPPING";
    private static IniFile formatFilePtr;
    private static File formatFile;
    private static long lastModifiedTime;
    private static long lastSize;
    private String whoami;
    private boolean cache = false;
    private static String formatFileName;
    private static Vector dddTests;
    private static ConcurrentHashMap dddTestHash;
    private static ConcurrentHashMap dddFields;
    private static ConcurrentHashMap dddInfos;
    private static ConcurrentHashMap dddDates;
    private static ConcurrentHashMap ddTestMeasureMap;
    private static ConcurrentHashMap externalDDTestMeasureMap;
    private static ConcurrentHashMap BLOBTestMeasureMap;
    private static ConcurrentHashMap dddBLOBTableTypeMap;
    private static Hashtable externalDDTestTableMap;
    private static Hashtable excludedDDTableMap;
    private static Hashtable ignoredSeqNoExternalTables;
    private static Vector noMsmtHostDDDTestes;
    private static ArrayList excludeDDTestList;
    private static ArrayList ssTestList;
    private static ArrayList imageTestList;
    private static ArrayList dumpTestList;
    private static ConcurrentHashMap allowedInfoHash;
    private static Hashtable common_dd_test_mapping_hash;

    public static void main(String[] stringArray) {
        EgFormatInfo egFormatInfo = new EgFormatInfo("manager");
        System.out.println("DDD Tests " + dddTests);
    }

    public Vector getDDDTests() {
        if (dddTests == null) {
            return new Vector();
        }
        Vector vector = (Vector)dddTests.clone();
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EgFormatInfo(String string) {
        this.whoami = string;
        if (formatFileName == null) {
            String string2 = dddSection;
            synchronized (string2) {
                if (formatFileName == null) {
                    formatFileName = EgConfigInfo.egMgrConfigDir + "eg_format.ini";
                    formatFile = new File(formatFileName);
                    lastModifiedTime = this.lastModified();
                    lastSize = this.lastSize();
                    formatFilePtr = new IniFile(formatFileName, false);
                    dddFields.clear();
                    dddInfos.clear();
                    dddDates.clear();
                    ddTestMeasureMap.clear();
                    this.dddTests();
                    this.getAllDates();
                    this.setExternalDDTestTableNames();
                    this.setExternalDDTestMeasures();
                    this.setBLOBTestMeasureMap();
                    this.setDDDBLOBTableTypeMap();
                    this.setExcludedDDTableNames();
                    this.setSeqNoIgnoredExternalTables();
                    dddTestHash.clear();
                    this.getNoMsmtDDDTest();
                    excludeDDTestList.clear();
                    ssTestList.clear();
                    allowedInfoHash.clear();
                    imageTestList.clear();
                    common_dd_test_mapping_hash.clear();
                    this.setCommonDDTestMappingHash();
                }
            }
        }
    }

    private void setCommonDDTestMappingHash() {
        try {
            String[] stringArray = formatFilePtr.getVariables(COMMON_DDTEST_MAPPING);
            if (stringArray != null) {
                Vector vector = formatFilePtr.getAllValues(COMMON_DDTEST_MAPPING);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    String string2 = (String)vector.get(i);
                    if (string.indexOf(":") != -1) {
                        string = string.substring(0, string.indexOf(":"));
                    }
                    if (string2.indexOf(":") != -1) {
                        string2 = string2.substring(0, string2.indexOf(":"));
                    }
                    common_dd_test_mapping_hash.put(string, string2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getCommonDDTestMappedTest(String string) {
        try {
            String string2 = (String)common_dd_test_mapping_hash.get(string);
            if (string2 == null) {
                return string;
            }
            return string2;
        }
        catch (Exception exception) {
            return string;
        }
    }

    private Vector getNoMsmtDDDTest() {
        noMsmtHostDDDTestes.clear();
        String[] stringArray = formatFilePtr.getVariables(noMsmtHostDDDTest);
        if (stringArray == null) {
            return noMsmtHostDDDTestes;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            noMsmtHostDDDTestes.add(stringArray[i]);
        }
        return noMsmtHostDDDTestes;
    }

    private void getAllDates() {
        dddDates.clear();
        String[] stringArray = formatFilePtr.getVariables(dddDatesSection);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(dddDatesSection);
            for (int i = 0; i < stringArray.length; ++i) {
                dddDates.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    private Vector dddTests() {
        dddTests.clear();
        String[] stringArray = formatFilePtr.getVariables(dddSection);
        if (stringArray == null) {
            return dddTests;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            dddTests.add(stringArray[i]);
        }
        String string = formatFilePtr.getValue("DD_FAULTS", "DD_FAULT");
        if (string.equalsIgnoreCase("yes") || string.equalsIgnoreCase("true")) {
            System.exit(0);
        }
        return dddTests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDDDTest(String string) {
        this.checkForUpdate();
        Boolean bl = (Boolean)dddTestHash.get(string);
        if (bl != null) {
            return bl;
        }
        if (dddTests == null) {
            return false;
        }
        String string2 = dddSection;
        synchronized (string2) {
            if (dddTests.contains(string)) {
                dddTestHash.put(string, new Boolean(true));
                return true;
            }
            dddTestHash.put(string, new Boolean(false));
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDDDCleanup(String string) {
        this.checkForUpdate();
        long l = -1L;
        String string2 = null;
        String string3 = dddSection;
        synchronized (string3) {
            string2 = formatFilePtr.getValue(dddCleanupSection, string);
        }
        if (string2 == null || string2.trim().length() == 0) {
            return -1L;
        }
        try {
            l = Long.parseLong(string2);
        }
        catch (Exception exception) {
            l = -1L;
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDDDDateFormat(String string, String string2) {
        this.checkForUpdate();
        String string3 = string + ':' + string2;
        String string4 = dddSection;
        synchronized (string4) {
            return (String)dddDates.get(string3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getInfosForDDDTest(String string) {
        Object object;
        this.checkForUpdate();
        if (dddInfos != null && (object = (ArrayList)dddInfos.get(string)) != null) {
            return object;
        }
        object = dddSection;
        synchronized (object) {
            Object object2;
            if (dddInfos != null && (object2 = (ArrayList)dddInfos.get(string)) != null) {
                return object2;
            }
            object2 = formatFilePtr.getValue(dddInfosSection, string);
            if (object2 != null) {
                ArrayList arrayList = this.myTokenizer((String)object2, ',');
                if (dddInfos == null) {
                    dddInfos = new ConcurrentHashMap();
                }
                if (arrayList != null) {
                    dddInfos.put(string, arrayList);
                }
                return arrayList;
            }
        }
        return null;
    }

    public boolean isNoMsmtHostTestCol(String string) {
        if (string == null || string.equals("")) {
            return false;
        }
        this.checkForUpdate();
        return noMsmtHostDDDTestes.contains(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFieldsForDDDTest(String string) {
        String[] stringArray;
        this.checkForUpdate();
        if (dddFields != null && (stringArray = (String[])dddFields.get(string)) != null) {
            return stringArray;
        }
        stringArray = dddSection;
        synchronized (dddSection) {
            String[] stringArray2;
            if (dddFields != null && (stringArray2 = (String[])dddFields.get(string)) != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return stringArray2;
            }
            stringArray2 = formatFilePtr.getValue(dddSection, string);
            if (stringArray2 != null && stringArray2.length() > 0) {
                ArrayList arrayList = this.myTokenizer((String)stringArray2, ',');
                String[] stringArray3 = new String[arrayList.size()];
                stringArray3 = arrayList.toArray(stringArray3);
                if (dddFields == null) {
                    dddFields = new ConcurrentHashMap();
                }
                dddFields.put(string, stringArray3);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return stringArray3;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getFieldsForDDDTest(String string, String string2) {
        String[] stringArray;
        this.checkForUpdate();
        String string3 = string + ":" + string2;
        if (dddFields != null && (stringArray = (String[])dddFields.get(string3)) != null) {
            return stringArray;
        }
        stringArray = dddSection;
        synchronized (dddSection) {
            String[] stringArray2;
            if (dddFields != null && (stringArray2 = (String[])dddFields.get(string3)) != null) {
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return stringArray2;
            }
            stringArray2 = formatFilePtr.getValue(dddSection, string3);
            if (stringArray2 != null && stringArray2.length() > 0) {
                ArrayList arrayList = this.myTokenizer((String)stringArray2, ',');
                String[] stringArray3 = new String[arrayList.size()];
                stringArray3 = arrayList.toArray(stringArray3);
                if (dddFields == null) {
                    dddFields = new ConcurrentHashMap();
                }
                dddFields.put(string3, stringArray3);
                // ** MonitorExit[var4_4] (shouldn't be in output)
                return stringArray3;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return null;
        }
    }

    public long lastModified() {
        return IniFile.getLastModified(formatFileName);
    }

    public long lastSize() {
        return IniFile.getLastSize(formatFileName);
    }

    private ArrayList myTokenizer(String string, char c) {
        if (string == null || string.length() == 0) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        int n = 0;
        int n2 = string.indexOf(c);
        while (n2 >= 0) {
            string2 = string.substring(n, n2);
            arrayList.add(string2);
            n = n2 + 1;
            n2 = string.indexOf(c, n);
        }
        string2 = string.substring(n);
        arrayList.add(string2);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDdEnabled(String string, String string2) {
        Object object;
        this.checkForUpdate();
        StringBuffer stringBuffer = new StringBuffer(32);
        stringBuffer.append(string);
        stringBuffer.append(":");
        stringBuffer.append(string2);
        String string3 = stringBuffer.toString();
        if (ddTestMeasureMap != null && (object = (Boolean)ddTestMeasureMap.get(string3)) != null) {
            return (Boolean)object;
        }
        object = dddSection;
        synchronized (object) {
            try {
                String string4 = formatFilePtr.getValue("FORMAT", string3);
                if (string4 != null && string4.length() > 0) {
                    if (ddTestMeasureMap != null) {
                        ddTestMeasureMap.put(string3, new Boolean(true));
                    }
                    return true;
                }
                string4 = formatFilePtr.getValue("COMMON_DD_MAPPING", string3);
                if (string4 != null && string4.length() > 0) {
                    if (ddTestMeasureMap != null) {
                        ddTestMeasureMap.put(string3, new Boolean(true));
                    }
                    return true;
                }
                if (ddTestMeasureMap != null) {
                    ddTestMeasureMap.put(string3, new Boolean(false));
                }
                return false;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDDMaxLength() {
        this.checkForUpdate();
        int n = 1000;
        String string = dddSection;
        synchronized (string) {
            try {
                String string2 = formatFilePtr.getValue("DD_SETTINGS", "DDMaxLength");
                if (string2 != null && string2.length() > 0) {
                    n = Integer.parseInt(string2);
                }
            }
            catch (Exception exception) {
                n = 1000;
            }
        }
        return n;
    }

    public boolean isExternalDDTableTest(String string, String string2) {
        boolean bl = false;
        String string3 = (String)externalDDTestMeasureMap.get(string);
        if (string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            while (stringTokenizer.hasMoreElements()) {
                String string4 = (String)stringTokenizer.nextElement();
                if (string4 == null || !string4.equals(string2)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public String[] getBLOBColumType(String string, String string2) {
        String[] stringArray = null;
        String string3 = (String)BLOBTestMeasureMap.get(string + ":" + string2);
        if (string3 != null && string3.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string4 = stringTokenizer.nextToken();
                if (string4 == null || string4.length() <= 0) continue;
                stringArray[i] = string4;
            }
        }
        return stringArray;
    }

    public String[] getBLOBColumType(String string) {
        String[] stringArray = null;
        String string2 = (String)dddBLOBTableTypeMap.get(string);
        if (string2 != null && string2.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.length() <= 0) continue;
                stringArray[i] = string3;
            }
        }
        return stringArray;
    }

    public boolean isExcludedDDTableTest(String string, String string2) {
        boolean bl = false;
        String string3 = (String)excludedDDTableMap.get(string + ":" + string2);
        if (string3 != null && string3.equalsIgnoreCase("true")) {
            bl = true;
        }
        return bl;
    }

    private void setExternalDDTestMeasures() {
        String[] stringArray = formatFilePtr.getVariables(externalInfoDDSection);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(externalInfoDDSection);
            for (int i = 0; i < stringArray.length; ++i) {
                externalDDTestMeasureMap.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    private void setBLOBTestMeasureMap() {
        String[] stringArray = formatFilePtr.getVariables(BLOB_SUPPORT);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(BLOB_SUPPORT);
            for (int i = 0; i < stringArray.length; ++i) {
                BLOBTestMeasureMap.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    private void setDDDBLOBTableTypeMap() {
        String[] stringArray = formatFilePtr.getVariables(DDD_BLOB_TABLES);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(DDD_BLOB_TABLES);
            for (int i = 0; i < stringArray.length; ++i) {
                dddBLOBTableTypeMap.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    private void setSeqNoIgnoredExternalTables() {
        String string = formatFilePtr.getValue(EXTERNAL_TABLE_MISC, IGNORE_SEQNO_FOR_TABLES);
        if (string != null && string.length() > 0) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || string2.trim().length() <= 0) continue;
                ignoredSeqNoExternalTables.put(string2, string2);
            }
        }
    }

    public boolean isIgnoreSeqNo(String string) {
        return ignoredSeqNoExternalTables.containsKey(string);
    }

    public String getExternalDDTableName(String string, String string2) {
        String string3 = string + ":" + string2;
        return (String)externalDDTestTableMap.get(string3);
    }

    public String getExcludedDDTableName(String string) {
        return (String)excludedDDTableMap.get(string);
    }

    public Hashtable getExternalDDTableMap() {
        return externalDDTestTableMap;
    }

    public Hashtable getExcludedDDTableMap() {
        return excludedDDTableMap;
    }

    private void setExternalDDTestTableNames() {
        String[] stringArray = formatFilePtr.getVariables(externalInfoDDTableSection);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(externalInfoDDTableSection);
            for (int i = 0; i < stringArray.length; ++i) {
                externalDDTestTableMap.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    private void setExcludedDDTableNames() {
        String[] stringArray = formatFilePtr.getVariables(excludedDDTableSection);
        if (stringArray != null) {
            Vector vector = formatFilePtr.getAllValues(excludedDDTableSection);
            for (int i = 0; i < stringArray.length; ++i) {
                excludedDDTableMap.put(stringArray[i], (String)vector.get(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkForUpdate() {
        long l = this.lastModified();
        long l2 = this.lastSize();
        if (l == lastModifiedTime && l2 == lastSize) {
            return false;
        }
        String string = dddSection;
        synchronized (string) {
            l = this.lastModified();
            l2 = this.lastSize();
            if (l != lastModifiedTime || l2 != lastSize) {
                dddFields.clear();
                dddInfos.clear();
                dddDates.clear();
                ddTestMeasureMap.clear();
                lastModifiedTime = l;
                lastSize = l2;
                formatFilePtr = new IniFile(formatFileName, false);
                this.getAllDates();
                this.dddTests();
                dddTestHash.clear();
                this.getNoMsmtDDDTest();
                excludeDDTestList.clear();
                ssTestList.clear();
                allowedInfoHash.clear();
                imageTestList.clear();
                common_dd_test_mapping_hash.clear();
                this.setCommonDDTestMappingHash();
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getHideDDTestList() {
        this.checkForUpdate();
        if (excludeDDTestList != null && excludeDDTestList.size() > 0) {
            return excludeDDTestList;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = dddSection;
        synchronized (string) {
            String string2 = formatFilePtr.getValue("Hide_DD_Tests", "Tests");
            if (string2 != null && string2.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null || string3.trim().length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                excludeDDTestList = new ArrayList();
                excludeDDTestList = (ArrayList)arrayList.clone();
                if (excludeDDTestList != null && excludeDDTestList.size() > 0) {
                    return excludeDDTestList;
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getImageTestList() {
        this.checkForUpdate();
        if (imageTestList != null && imageTestList.size() > 0) {
            return imageTestList;
        }
        String string = imageTestSection;
        synchronized (string) {
            String[] stringArray = formatFilePtr.getVariables("IMAGE_TABLE_DELETE");
            Vector vector = formatFilePtr.getAllValues("IMAGE_TABLE_DELETE");
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String string3 = (String)vector.get(i);
                    if (string2 == null || string2.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0 || !string3.equalsIgnoreCase("yes") && !string3.equalsIgnoreCase("true")) continue;
                    imageTestList.add(string2.toUpperCase());
                }
            }
        }
        return imageTestList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getDumpTestList() {
        this.checkForUpdate();
        if (dumpTestList != null && dumpTestList.size() > 0) {
            return dumpTestList;
        }
        String string = dumpTestSection;
        synchronized (string) {
            String[] stringArray = formatFilePtr.getVariables("DUMP_TABLE_DELETE");
            Vector vector = formatFilePtr.getAllValues("DUMP_TABLE_DELETE");
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    String string3 = (String)vector.get(i);
                    if (string2 == null || string2.trim().length() <= 0 || string3 == null || string3.trim().length() <= 0 || !string3.equalsIgnoreCase("yes") && !string3.equalsIgnoreCase("true")) continue;
                    dumpTestList.add(string2.toUpperCase());
                }
            }
        }
        return dumpTestList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readDDDAllowedInfoHash() {
        String string = dddSection;
        synchronized (string) {
            String[] stringArray = formatFilePtr.getVariables("DDD_Allowed_Infos");
            if (stringArray == null) {
                return;
            }
            Vector vector = formatFilePtr.getAllValues("DDD_Allowed_Infos");
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = (String)vector.get(i);
                if (string2 == null || string2.trim().length() <= 0) continue;
                try {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        arrayList.add(stringTokenizer.nextToken().toLowerCase());
                    }
                    allowedInfoHash.put(stringArray[i], arrayList);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public ArrayList getAllowedInfosList(String string) {
        ArrayList arrayList;
        ArrayList arrayList2 = null;
        this.checkForUpdate();
        if (allowedInfoHash.size() == 0) {
            this.readDDDAllowedInfoHash();
        }
        if ((arrayList = (ArrayList)allowedInfoHash.get(string)) != null) {
            arrayList2 = (ArrayList)arrayList.clone();
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getSSHandledTestsList() {
        this.checkForUpdate();
        if (ssTestList != null && ssTestList.size() > 0) {
            return ssTestList;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = dddSection;
        synchronized (string) {
            String string2 = formatFilePtr.getValue("SS_handled", "Tests");
            if (string2 != null && string2.trim().length() > 0) {
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (string3 == null || string3.trim().length() <= 0) continue;
                    arrayList.add(string3);
                }
            }
            if (arrayList != null && arrayList.size() > 0) {
                ssTestList = new ArrayList();
                ssTestList = (ArrayList)arrayList.clone();
                if (ssTestList != null && ssTestList.size() > 0) {
                    return ssTestList;
                }
            }
        }
        return null;
    }

    public boolean isSSHandledTest(String string) {
        try {
            ArrayList arrayList;
            if (string != null && (arrayList = this.getSSHandledTestsList()) != null && arrayList.contains(string)) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    static {
        formatFile = null;
        formatFileName = null;
        dddTests = new Vector();
        dddTestHash = new ConcurrentHashMap();
        dddFields = new ConcurrentHashMap();
        dddInfos = new ConcurrentHashMap();
        dddDates = new ConcurrentHashMap();
        ddTestMeasureMap = new ConcurrentHashMap();
        externalDDTestMeasureMap = new ConcurrentHashMap();
        BLOBTestMeasureMap = new ConcurrentHashMap();
        dddBLOBTableTypeMap = new ConcurrentHashMap();
        externalDDTestTableMap = new Hashtable();
        excludedDDTableMap = new Hashtable();
        ignoredSeqNoExternalTables = new Hashtable();
        noMsmtHostDDDTestes = new Vector();
        excludeDDTestList = new ArrayList();
        ssTestList = new ArrayList();
        imageTestList = new ArrayList();
        dumpTestList = new ArrayList();
        allowedInfoHash = new ConcurrentHashMap();
        common_dd_test_mapping_hash = new Hashtable();
    }
}

