/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import java.awt.Dimension;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;

public class OSHelperThread
extends Thread {
    public long start = 0L;
    String hostIp;
    String osName;
    public static long maxFailTime = 900000L;
    int portNo;
    private int timeOut;
    public boolean done = false;
    public boolean status = false;
    public boolean isExist = true;
    int debug = 0;
    private final String lineBreaker1 = "login";
    private final String lineBreaker2 = "password";
    private final String lineBreaker3 = "copyright";
    private byte neg_state = 0;
    private static final byte STATE_DATA = 0;
    private static final byte STATE_IAC = 1;
    private static final byte STATE_IACSB = 2;
    private static final byte STATE_IACWILL = 3;
    private static final byte STATE_IACDO = 4;
    private static final byte STATE_IACWONT = 5;
    private static final byte STATE_IACDONT = 6;
    private static final byte STATE_IACSBIAC = 7;
    private static final byte STATE_IACSBDATA = 8;
    private static final byte STATE_IACSBDATAIAC = 9;
    private byte current_sb;
    private static final byte IAC = -1;
    private static final byte EOR = -17;
    private static final byte WILL = -5;
    private static final byte WONT = -4;
    private static final byte DO = -3;
    private static final byte DONT = -2;
    private static final byte SB = -6;
    private static final byte SE = -16;
    private static final byte TELOPT_ECHO = 1;
    private static final byte TELOPT_EOR = 25;
    private static final byte TELOPT_NAWS = 31;
    private static final byte TELOPT_TTYPE = 24;
    private static final byte[] IACWILL = new byte[]{-1, -5};
    private static final byte[] IACWONT = new byte[]{-1, -4};
    private static final byte[] IACDO = new byte[]{-1, -3};
    private static final byte[] IACDONT = new byte[]{-1, -2};
    private static final byte[] IACSB = new byte[]{-1, -6};
    private static final byte[] IACSE = new byte[]{-1, -16};
    private static final byte TELQUAL_IS = 0;
    private static final byte TELQUAL_SEND = 1;
    private byte[] receivedDX;
    private byte[] receivedWX;
    private byte[] sentDX;
    private byte[] sentWX;
    private Socket sd = null;
    private BufferedInputStream is;
    private BufferedOutputStream os;
    private ArrayList arrayObj;
    public static Hashtable failList = new Hashtable();

    public OSHelperThread(String string, int n, int n2, String string2) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = (int)((double)n2 * 0.9);
        this.osName = string2;
        this.setName("OSHelperThread");
        this.setDaemon(true);
        this.start();
    }

    public void connect() throws Exception {
        this.start = System.currentTimeMillis();
        String string = this.hostIp + ":" + this.portNo;
        Long l = (Long)failList.get(string);
        if (l != null) {
            long l2 = this.start;
            long l3 = l;
            if (l2 - l3 <= maxFailTime) {
                this.sd = null;
                this.done = true;
                return;
            }
            failList.remove(string);
        }
        this.sd = new Socket();
        int n = this.timeOut / 4;
        if (n < 400) {
            n = 400;
        }
        this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
        this.sd.setSoTimeout(this.timeOut);
        this.is = new BufferedInputStream(this.sd.getInputStream());
        this.os = new BufferedOutputStream(this.sd.getOutputStream());
        this.arrayObj = new ArrayList();
        BufferedReader bufferedReader = null;
        this.neg_state = 0;
        this.receivedDX = new byte[256];
        this.sentDX = new byte[256];
        this.receivedWX = new byte[256];
        this.sentWX = new byte[256];
        String string2 = "";
        String string3 = null;
        boolean bl = false;
        this.isExist = true;
        failList.remove(string);
        while (this.isExist) {
            try {
                string2 = new String(this.receive(), 0);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if ((string2 = string2.trim()).length() == 0) continue;
            bufferedReader = new BufferedReader(new StringReader(string2));
            while ((string3 = bufferedReader.readLine()) != null) {
                if ((string3 = string3.toLowerCase()).indexOf(this.osName) > -1) {
                    this.arrayObj.add(string3);
                    this.isExist = false;
                    break;
                }
                if (string3.indexOf("login") > -1 || string3.indexOf("password") > -1 || string3.indexOf("copyright") > -1) {
                    this.isExist = false;
                    break;
                }
                long l4 = System.currentTimeMillis();
                if (l4 - this.start <= (long)this.timeOut) continue;
                this.isExist = false;
                break;
            }
            if (bufferedReader == null) continue;
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
    }

    public void cleanup() {
        if (this.sd == null) {
            return;
        }
        try {
            this.sd.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public byte[] receive() throws IOException {
        int n = this.is.available();
        byte[] byArray = new byte[n];
        if ((n = this.is.read(byArray)) < 0) {
            throw new IOException("Connection closed.");
        }
        byArray = this.negotiate(byArray, n);
        return byArray;
    }

    private byte[] negotiate(byte[] byArray, int n) throws IOException {
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        byte[] byArray4 = new byte[3];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector<String> vector = new Vector<String>(2);
        block49: while (n3 < n) {
            byte by;
            if ((by = byArray[n3++]) >= 128) {
                by = (byte)(by - 256);
            }
            switch (this.neg_state) {
                case 0: {
                    if (by == -1) {
                        this.neg_state = 1;
                        continue block49;
                    }
                    byArray2[n4++] = by;
                    continue block49;
                }
                case 1: {
                    switch (by) {
                        case -1: {
                            if (this.debug > 2) {
                                System.out.print("IAC ");
                            }
                            this.neg_state = 0;
                            byArray2[n4++] = -1;
                            continue block49;
                        }
                        case -5: {
                            if (this.debug > 2) {
                                System.out.print("WILL ");
                            }
                            this.neg_state = (byte)3;
                            continue block49;
                        }
                        case -4: {
                            if (this.debug > 2) {
                                System.out.print("WONT ");
                            }
                            this.neg_state = (byte)5;
                            continue block49;
                        }
                        case -2: {
                            if (this.debug > 2) {
                                System.out.print("DONT ");
                            }
                            this.neg_state = (byte)6;
                            continue block49;
                        }
                        case -3: {
                            if (this.debug > 2) {
                                System.out.print("DO ");
                            }
                            this.neg_state = (byte)4;
                            continue block49;
                        }
                        case -17: {
                            if (this.debug > 2) {
                                System.out.print("EOR ");
                            }
                            this.neg_state = 0;
                            continue block49;
                        }
                        case -6: {
                            if (this.debug > 2) {
                                System.out.print("SB ");
                            }
                            this.neg_state = (byte)2;
                            n2 = 0;
                            continue block49;
                        }
                    }
                    if (this.debug > 2) {
                        System.out.print("<UNKNOWN " + by + " > ");
                    }
                    this.neg_state = 0;
                    continue block49;
                }
                case 3: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            if (this.debug > 2) {
                                System.out.println("ECHO");
                            }
                            by2 = -3;
                            vector = new Vector(2);
                            vector.addElement("NOLOCALECHO");
                            this.notifyStatus(vector);
                            break;
                        }
                        case 25: {
                            if (this.debug > 2) {
                                System.out.println("EOR");
                            }
                            by2 = -3;
                            break;
                        }
                        default: {
                            if (this.debug > 2) {
                                System.out.println("<UNKNOWN," + by + ">");
                            }
                            by2 = -2;
                        }
                    }
                    if (this.debug > 1) {
                        System.out.println("<" + by + ", WILL =" + -5 + ">");
                    }
                    if (by2 != this.sentDX[by + 128] || -5 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.send(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block49;
                }
                case 5: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            if (this.debug > 2) {
                                System.out.println("ECHO");
                            }
                            vector = new Vector(2);
                            vector.addElement("LOCALECHO");
                            this.notifyStatus(vector);
                            by2 = -2;
                            break;
                        }
                        case 25: {
                            if (this.debug > 2) {
                                System.out.println("EOR");
                            }
                            by2 = -2;
                            break;
                        }
                        default: {
                            if (this.debug > 2) {
                                System.out.println("<UNKNOWN," + by + ">");
                            }
                            by2 = -2;
                        }
                    }
                    if (by2 != this.sentDX[by + 128] || -4 != this.receivedWX[by + 128]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.send(byArray4);
                        this.sentDX[by + 128] = by2;
                        this.receivedWX[by + 128] = -5;
                    }
                    this.neg_state = 0;
                    continue block49;
                }
                case 4: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            if (this.debug > 2) {
                                System.out.println("ECHO");
                            }
                            by2 = -5;
                            vector = new Vector(2);
                            vector.addElement("LOCALECHO");
                            this.notifyStatus(vector);
                            break;
                        }
                        case 24: {
                            if (this.debug > 2) {
                                System.out.println("TTYPE");
                            }
                            by2 = -5;
                            break;
                        }
                        case 31: {
                            if (this.debug > 2) {
                                System.out.println("NAWS");
                            }
                            vector = new Vector(2);
                            vector.addElement("NAWS");
                            Dimension dimension = (Dimension)this.notifyStatus(vector);
                            this.receivedDX[by] = -3;
                            if (dimension == null) {
                                this.send((byte)-1);
                                this.send((byte)-4);
                                this.send((byte)31);
                                by2 = -4;
                                this.sentWX[by] = -4;
                                break;
                            }
                            by2 = -5;
                            this.sentWX[by] = -5;
                            byArray4[0] = -1;
                            byArray4[1] = -5;
                            byArray4[2] = 31;
                            this.send(byArray4);
                            this.send((byte)-1);
                            this.send((byte)-6);
                            this.send((byte)31);
                            this.send((byte)(dimension.width >> 8));
                            this.send((byte)(dimension.width & 0xFF));
                            this.send((byte)(dimension.height >> 8));
                            this.send((byte)(dimension.height & 0xFF));
                            this.send((byte)-1);
                            this.send((byte)-16);
                            break;
                        }
                        default: {
                            if (this.debug > 2) {
                                System.out.println("<UNKNOWN," + by + ">");
                            }
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[128 + by] || -3 != this.receivedDX[128 + by]) {
                        byArray4[0] = -1;
                        byArray4[1] = by2;
                        byArray4[2] = by;
                        this.send(byArray4);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -3;
                    }
                    this.neg_state = 0;
                    continue block49;
                }
                case 6: {
                    byte by2;
                    switch (by) {
                        case 1: {
                            if (this.debug > 2) {
                                System.out.println("ECHO");
                            }
                            by2 = -4;
                            vector = new Vector(2);
                            vector.addElement("NOLOCALECHO");
                            this.notifyStatus(vector);
                            break;
                        }
                        case 31: {
                            if (this.debug > 2) {
                                System.out.println("NAWS");
                            }
                            by2 = -4;
                            break;
                        }
                        default: {
                            if (this.debug > 2) {
                                System.out.println("<UNKNOWN," + by + ">");
                            }
                            by2 = -4;
                        }
                    }
                    if (by2 != this.sentWX[by + 128] || -2 != this.receivedDX[by + 128]) {
                        this.send((byte)-1);
                        this.send(by2);
                        this.send(by);
                        this.sentWX[by + 128] = by2;
                        this.receivedDX[by + 128] = -2;
                    }
                    this.neg_state = 0;
                    continue block49;
                }
                case 7: {
                    if (this.debug > 2) {
                        System.out.println("" + by + " ");
                    }
                    if (by == -1) {
                        n2 = 0;
                        this.current_sb = by;
                        this.neg_state = (byte)8;
                        continue block49;
                    }
                    System.out.println("(bad) " + by + " ");
                    this.neg_state = 0;
                    continue block49;
                }
                case 2: {
                    if (this.debug > 2) {
                        System.out.println("" + by + " ");
                    }
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)7;
                            continue block49;
                        }
                    }
                    this.current_sb = by;
                    n2 = 0;
                    this.neg_state = (byte)8;
                    continue block49;
                }
                case 8: {
                    if (this.debug > 2) {
                        System.out.println("" + by + " ");
                    }
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)9;
                            continue block49;
                        }
                    }
                    byArray3[n2++] = by;
                    continue block49;
                }
                case 9: {
                    if (this.debug > 2) {
                        System.out.println("" + by + " ");
                    }
                    switch (by) {
                        case -1: {
                            this.neg_state = (byte)8;
                            byArray3[n2++] = -1;
                            continue block49;
                        }
                        case -16: {
                            this.handle_sb(this.current_sb, byArray3, n2);
                            this.current_sb = 0;
                            this.neg_state = 0;
                            continue block49;
                        }
                        case -6: {
                            this.handle_sb(this.current_sb, byArray3, n2);
                            this.neg_state = (byte)2;
                            continue block49;
                        }
                    }
                    this.neg_state = 0;
                    continue block49;
                }
            }
            if (this.debug > 2) {
                System.out.println("This should not happen: " + this.neg_state + " ");
            }
            this.neg_state = 0;
        }
        byArray = new byte[n4];
        System.arraycopy(byArray2, 0, byArray, 0, n4);
        return byArray;
    }

    private void handle_sb(byte by, byte[] byArray, int n) throws IOException {
        if (this.debug > 1) {
            System.out.println("TelnetIO.handle_sb(" + by + ")");
        }
        switch (by) {
            case 24: {
                if (n <= 0 || byArray[0] != 1) break;
                this.send(IACSB);
                this.send((byte)24);
                this.send((byte)0);
                Vector<String> vector = new Vector<String>(2);
                vector.addElement("TTYPE");
                String string = (String)this.notifyStatus(vector);
                if (string == null) {
                    string = "dumb";
                }
                byte[] byArray2 = new byte[string.length()];
                string.getBytes(0, string.length(), byArray2, 0);
                this.send(byArray2);
                this.send(IACSE);
            }
        }
    }

    public void send(byte[] byArray) throws IOException {
        if (this.debug > 1) {
            System.out.println("TelnetIO.send(" + byArray + ")");
        }
        this.os.write(byArray);
        this.os.flush();
    }

    public void send(byte by) throws IOException {
        if (this.debug > 1) {
            System.out.println("TelnetIO.send(" + by + ")");
        }
        this.os.write(by);
        this.os.flush();
    }

    public Object notifyStatus(Vector vector) {
        if (this.debug > 0) {
            System.out.println("TelnetIO.notifyStatus(" + vector + ")");
        }
        return null;
    }

    public String getOSName() {
        if (this.arrayObj != null && this.arrayObj.size() > 0) {
            return this.arrayObj.get(0).toString();
        }
        return "-";
    }

    public void run() {
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.connect();
        }
        catch (Exception exception) {
            failList.put(this.hostIp + ":" + this.portNo, new Long(System.currentTimeMillis()));
            this.done = true;
            return;
        }
        if (this.sd != null) {
            this.status = true;
            try {
                this.cleanup();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.done = true;
    }
}

