/*
 * Decompiled with CFR 0.152.
 */
package com.eg;

import com.eg.EgConfigInfo;
import com.eg.EgSSL;
import com.eg.MyHostnameVerifier;
import com.eg.MyX509TrustManager;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.security.SecureRandom;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class WebServerHelperThread
extends Thread {
    private String hostIp;
    private int portNo;
    public Socket sd;
    private int timeOut;
    private PrintWriter pw;
    private BufferedReader br;
    private int webContentSize;
    public boolean status;
    public boolean done;
    public boolean isIIS = false;
    public boolean isApache = false;
    public boolean isNfuse = false;
    public boolean isWebLogic = false;
    public boolean isJRun = false;
    public boolean isXen = false;
    public boolean isSunOne = false;
    public boolean isXD = false;
    public boolean isGF = false;
    public boolean isWebSphere = false;
    public boolean isNginx = false;
    public String serverHeader = null;
    public boolean isWebServer;

    public WebServerHelperThread(String string, int n, int n2, int n3) {
        this.hostIp = string;
        this.portNo = n;
        this.timeOut = n2;
        this.webContentSize = n3;
        this.setName("WebServerHelperThread");
        this.setDaemon(true);
        this.start();
    }

    public void run() {
        String string;
        boolean bl = false;
        if (EgConfigInfo.todie) {
            return;
        }
        try {
            this.sd = new Socket();
            int n = this.timeOut / 4;
            if (n < 400) {
                n = 400;
            }
            this.sd.connect(new InetSocketAddress(this.hostIp, this.portNo), n);
            this.sd.setSoTimeout(this.timeOut);
        }
        catch (Exception exception) {
            this.status = false;
            this.done = true;
            this.cleanup();
            return;
        }
        this.status = true;
        if (this.portNo == 443) {
            bl = true;
        }
        if (!bl) {
            try {
                this.pw = new PrintWriter(this.sd.getOutputStream(), false);
                this.pw.print("GET / HTTP/1.0\r\n\r\n");
                this.pw.flush();
                this.br = new BufferedReader(new InputStreamReader(this.sd.getInputStream()));
                String string2 = null;
                int n = 0;
                if (this.br != null) {
                    string = this.br.readLine();
                    while (string != null) {
                        try {
                            n += string.length();
                            if (string.indexOf("<address>Xapi Server</address>") >= 0 || string.indexOf("XenServer") >= 0) {
                                this.isXen = true;
                            }
                            if (string.startsWith("Server:")) {
                                this.serverHeader = string;
                            } else if (string.startsWith("Content-Location")) {
                                string2 = string;
                            } else if (string.indexOf("/Citrix/DesktopWeb") >= 0) {
                                this.isXD = true;
                            }
                            string = this.br.readLine();
                        }
                        catch (Exception exception) {
                            // empty catch block
                            break;
                        }
                    }
                }
                if (n < this.webContentSize) {
                    this.status = false;
                    this.done = true;
                    this.cleanup();
                } else {
                    this.isWebServer = true;
                    if (this.serverHeader != null) {
                        if (this.serverHeader.indexOf("Microsoft") >= 0 || this.serverHeader.indexOf("IIS") >= 0) {
                            this.isIIS = true;
                        } else if (this.serverHeader.indexOf("Apache/") >= 0) {
                            this.isApache = true;
                        } else if (this.serverHeader.indexOf("WebLogic") >= 0) {
                            this.isWebLogic = true;
                        } else if (this.serverHeader.indexOf("Citrix") >= 0) {
                            this.isNfuse = true;
                        } else if (this.serverHeader.indexOf("JRun") >= 0) {
                            this.isJRun = true;
                        } else if (this.serverHeader.indexOf("Sun-ONE") >= 0) {
                            this.isSunOne = true;
                        } else if (this.serverHeader.indexOf("GlassFish Server") >= 0) {
                            this.isGF = true;
                        } else if (this.serverHeader.indexOf("WebSphere Application Server") >= 0) {
                            this.isWebSphere = true;
                        } else if (this.serverHeader.indexOf("nginx") >= 0) {
                            this.isNginx = true;
                        } else if (this.portNo != 80) {
                            bl = true;
                        }
                        if (!this.isNfuse && this.isIIS && string2 != null && (string2.indexOf("WebInterface.htm") >= 0 || string2.indexOf("nfuse.htm") >= 0)) {
                            this.isNfuse = true;
                        }
                    }
                    this.done = true;
                    this.cleanup();
                }
            }
            catch (Exception exception) {
                this.status = false;
                this.done = true;
                this.cleanup();
            }
        }
        if (bl) {
            try {
                EgSSL egSSL = EgSSL.getInstance();
                egSSL.enableSSL();
                System.setProperty("org.apache.axis.components.net.SecureSocketFactory", "org.apache.axis.components.net.SunFakeTrustSocketFactory");
                SSLSocketFactory sSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
                string = null;
                MyX509TrustManager myX509TrustManager = new MyX509TrustManager();
                KeyManager[] keyManagerArray = null;
                TrustManager[] trustManagerArray = new TrustManager[]{myX509TrustManager};
                SSLContext sSLContext = SSLContext.getInstance("SSL");
                sSLContext.init(keyManagerArray, trustManagerArray, new SecureRandom());
                SSLSocketFactory sSLSocketFactory2 = sSLContext.getSocketFactory();
                HttpsURLConnection.setDefaultSSLSocketFactory(sSLSocketFactory2);
                HttpsURLConnection.setDefaultHostnameVerifier(new MyHostnameVerifier());
                URL uRL = new URL("https://" + this.hostIp + ":" + this.portNo);
                URLConnection uRLConnection = uRL.openConnection();
                String string3 = uRLConnection.getHeaderField("Server");
                if (string3 != null) {
                    if (string3.indexOf("Microsoft") >= 0 || string3.indexOf("IIS") >= 0) {
                        this.isIIS = true;
                    } else if (string3.indexOf("Apache/") >= 0) {
                        this.isApache = true;
                    } else if (string3.indexOf("WebLogic") >= 0) {
                        this.isWebLogic = true;
                    } else if (string3.indexOf("Citrix") >= 0) {
                        this.isNfuse = true;
                    } else if (string3.indexOf("JRun") >= 0) {
                        this.isJRun = true;
                    } else if (string3.indexOf("Sun-ONE") >= 0) {
                        this.isSunOne = true;
                    } else if (string3.indexOf("GlassFish Server") >= 0) {
                        this.isGF = true;
                    } else if (string3.indexOf("WebSphere Application Server") >= 0) {
                        this.isWebSphere = true;
                    } else if (string3.indexOf("nginx") >= 0) {
                        this.isNginx = true;
                    }
                    this.done = true;
                    this.cleanup();
                }
            }
            catch (Exception exception) {
                System.out.println("[WebServerDiscovery] Exception_1 status = " + this.status);
                this.status = false;
                this.done = true;
                this.cleanup();
            }
        }
    }

    public void cleanup() {
        try {
            if (this.pw != null) {
                this.pw.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.br != null) {
                this.br.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.sd != null) {
                this.sd.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

