/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.APMDiscoveryLogger;
import com.eg.apm.APMUtils;
import com.eg.apm.ApmConfigManager;
import com.eg.apm.EgApmFilesSync;
import com.eg.jtm.BTMConstants;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.TreeSet;

public class APMDiscoveryHelper {
    protected static final String loggerDispStr = "[APMDiscoveryHelper]";
    private static final String apmSync = new String("apmSync");
    private static HashMap customPortForDiscoveredComponents = new HashMap();
    private static int lastUsedCustomPort = 7011;
    private static final TreeSet fullyDiscoveredContainerIds = new TreeSet();
    private static final String separatorString = "#~#";
    private static final String EG_APM_DISCOVERY_INI = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH;
    private static final HashMap<String, String> CONTAINER_NAME_MAPPINGS = new HashMap();

    private static void readCustomPortsFromIni() {
        try {
            IniFile iniFile;
            int n;
            IniFile iniFile2 = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_CUSTOM);
            String[] stringArray = iniFile2.getLinesUnderSubject("CUSTOM_PORTS_USED_FOR_DISCOVERY");
            customPortForDiscoveredComponents = APMDiscoveryHelper.getLinesAsMap(stringArray);
            int n2 = APMDiscoveryHelper.getPort(iniFile2, "LAST_CUSTOM_PORTS_USED_FOR_DISCOVERY", "Port");
            lastUsedCustomPort = n2 > 0 ? n2 : ((n = APMDiscoveryHelper.getPort(iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.AGENT_APM_FILEPATH), "APM_DISCOVERY", "Custom_Port_For_AutoManage")) > 0 ? n : 7011);
            APMDiscoveryLogger.discoveryLogger.info("{} customPortForDiscoveredComponents - {} ", (Object)loggerDispStr, (Object)customPortForDiscoveredComponents);
            APMDiscoveryLogger.discoveryLogger.info("{} lastUsedCustomPort - {} ", (Object)loggerDispStr, (Object)lastUsedCustomPort);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving custom port data !!...{} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    public static HashMap getLinesAsMap(String[] stringArray) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            if (stringArray != null && stringArray.length > 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    int n = string.indexOf("=");
                    if (n < 0) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    hashMap.put(string2, string3);
                }
            }
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Exception occured due to {} ", (Object)loggerDispStr, (Object)exception);
        }
        return hashMap;
    }

    private static int getPort(IniFile iniFile, String string, String string2) {
        try {
            String string3 = iniFile.getValue(string, string2);
            if (string3 != null && string3.length() > 0) {
                int n = Integer.parseInt(string3);
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            APMDiscoveryLogger.discoveryLogger.warn("{} Exception while retriving port from ini!!...{} ", (Object)loggerDispStr, (Object)numberFormatException);
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeBtmComponentDetails(String string, String string2, int n, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10) {
        ArrayList<IniHelper> arrayList;
        block41: {
            String string11;
            Object object;
            if (string.equals("-") || string2.equals("-") || string3.equals("-") || string2.equalsIgnoreCase("NONE")) {
                APMDiscoveryLogger.discoveryLogger.warn("{} Some details getting empty {} {} {} , So returning without storing details !!!", new Object[]{loggerDispStr, string, string2, string3});
                return;
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            APMDiscoveryLogger.discoveryLogger.info("[APMDiscoveryHelper] fullyDiscoveredContainerIds {} ", (Object)fullyDiscoveredContainerIds);
            APMDiscoveryLogger.discoveryLogger.info("{} lastUsedCustomPort - {} customPortForDiscoveredComponents - {}", new Object[]{loggerDispStr, lastUsedCustomPort, customPortForDiscoveredComponents});
            String string12 = string2 + ":" + n + ":" + string;
            if (APMDiscoveryHelper.isThisValidDocker(string8)) {
                string12 = string8 + ":" + n + ":" + string;
            } else if (n == 0) {
                if (!ApmConfigManager.getInstance().isManageByCustomPort()) {
                    APMDiscoveryLogger.discoveryLogger.warn("{} Unable to discover port for {}, So, Skipping the auto manage. Component type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, appTierName : {},  Podname&NameSpace : {}", new Object[]{loggerDispStr, string7, string, string2, n, string3, string5, string9, string10});
                    return;
                }
                n = customPortForDiscoveredComponents.containsKey(string7) ? (Integer)customPortForDiscoveredComponents.get(string7) : lastUsedCustomPort + 1;
                if (n == 7077) {
                    ++n;
                }
                if (n != 0) {
                    try {
                        string12 = string2 + ":" + n + ":" + string;
                        customPortForDiscoveredComponents.put(string7, n);
                        lastUsedCustomPort = n;
                        object = new ArrayList();
                        ((ArrayList)object).add(APMUtils.getIniHelper("CUSTOM_PORTS_USED_FOR_DISCOVERY", string7, n + ""));
                        ((ArrayList)object).add(APMUtils.getIniHelper("LAST_CUSTOM_PORTS_USED_FOR_DISCOVERY", "Port", lastUsedCustomPort + ""));
                        string11 = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_CUSTOM;
                        APMDiscoveryHelper.saveToIni(string11, (ArrayList)object, null);
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.warn("[APMDiscoveryHelper] Unable to store custom port details: ", (Throwable)exception);
                    }
                }
            }
            APMComponentIDRepository.addToTempComponentDiscoveryRepository(string12, System.currentTimeMillis() + "");
            if (APMDiscoveryHelper.isInDiscoverdList(string7)) {
                APMDiscoveryLogger.discoveryLogger.warn("{} - JVM is already discovered as {}, Skipping the entry [{}]", new Object[]{loggerDispStr, string7, string12});
                if (APMComponentIDRepository.isThisManaged(string12)) {
                    object = APMComponentIDRepository.getJvmGuidFromTemp(string12);
                    APMComponentIDRepository.addToTempComponentRepository((String)object, string7);
                    APMComponentIDRepository.addToTempComponentRepository(string7, (String)object);
                    APMDiscoveryLogger.discoveryLogger.info("{} - This Request discovery data[{}] is already discovered and auto-managed with {}:{}, registering temporary id into repo", new Object[]{loggerDispStr, string7, string12, object});
                }
                return;
            }
            object = new StringBuilder();
            ((StringBuilder)object).append(string5).append(separatorString);
            ((StringBuilder)object).append(string3).append(separatorString);
            ((StringBuilder)object).append(string2).append(separatorString);
            ((StringBuilder)object).append(n).append(separatorString);
            ((StringBuilder)object).append(new Date());
            string11 = ((StringBuilder)object).toString();
            String string13 = "JAVA_SERVER_DETAILS";
            String string14 = "JAVA_UNIQUE_GUID_MAPPING";
            String string15 = "APPFLOW_SERVICE_AUTO_NAME_MAPPING";
            String string16 = "JAVA_SERVER_JMX_MAPPING";
            if (APMDiscoveryHelper.isThisValidDocker(string8)) {
                if (n == 0) {
                    bl2 = true;
                }
                bl4 = true;
                string13 = "JAVA_SERVER_DETAILS_CONTAINER_BASED";
            } else {
                bl3 = true;
                if (n == 0) {
                    n = lastUsedCustomPort + 1;
                    string12 = string2 + ":" + n + ":" + string;
                }
            }
            if (bl2) {
                string13 = string13 + "_TEMP";
                string14 = string14 + "_TEMP";
                string15 = string15 + "_TEMP";
            }
            APMDiscoveryLogger.discoveryLogger.info("{} - storeForPortFinding : {} , isDockerBased: {} , isNonDockerBased : {} ", new Object[]{loggerDispStr, bl2, bl4, bl3});
            arrayList = new ArrayList<IniHelper>();
            IniFile iniFile = new IniFile(EG_APM_DISCOVERY_INI);
            try {
                block40: {
                    try {
                        boolean bl5 = APMUtils.isDetailsAvailableInFile(iniFile, string12, string11, string13);
                        if (bl5) {
                            bl = true;
                            APMDiscoveryLogger.discoveryLogger.trace("{} Component Details for :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, string12, string11, string13});
                        } else {
                            arrayList.add(APMUtils.getIniHelper(string13, string12, string11));
                            bl = true;
                            APMDiscoveryLogger.discoveryLogger.info("{} Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string12, string11, string13});
                        }
                        if (APMUtils.isDetailsAvailableInFile(iniFile, string12, string7, string14)) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} java unique guid details {}  with value {} already available...", new Object[]{loggerDispStr, string12, string7});
                        } else {
                            arrayList.add(APMUtils.getIniHelper(string14, string12, string7));
                            APMDiscoveryLogger.discoveryLogger.info("{} Adding {}={} under subject [{}]", new Object[]{loggerDispStr, string12, string7, string14});
                        }
                        if (APMUtils.isDetailsAvailableInFile(iniFile, string12, string9, string15)) {
                            APMDiscoveryLogger.discoveryLogger.trace("{} App name details {}  with value {} already available...", new Object[]{loggerDispStr, string12, string9});
                        } else {
                            arrayList.add(APMUtils.getIniHelper(string15, string12, string9));
                            APMDiscoveryLogger.discoveryLogger.info("{} Adding {}={} under subject [{}]", new Object[]{loggerDispStr, string12, string9, string14});
                        }
                        if (string4 != null && string4.length() > 1 && !string4.equalsIgnoreCase("0")) {
                            if (APMUtils.isDetailsAvailableInFile(iniFile, string12, string4, string16)) {
                                APMDiscoveryLogger.discoveryLogger.trace("{} Jmx Port For Component :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, string12, string4, string16});
                            } else {
                                arrayList.add(APMUtils.getIniHelper(string16, string12, string4));
                                APMDiscoveryLogger.discoveryLogger.info("{} Adding Jmx Port For Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string12, string4, string16});
                            }
                        }
                        if (bl4) {
                            String string17 = "KUBERNETES_DETAILS_TEMP";
                            arrayList.add(APMUtils.getIniHelper(string17, string8, string10));
                            APMDiscoveryLogger.discoveryLogger.info("{} Adding {}={} under subject [{}]", new Object[]{loggerDispStr, string17, string2, string10});
                        }
                        if (bl2) break block40;
                        arrayList.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS_DISCOVERD_TIME", string12, System.currentTimeMillis() + ""));
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, exception});
                        Object var27_29 = null;
                        if (!bl) break block41;
                        APMComponentIDRepository.setStatusForBtmDiscovery(string7, false);
                        if (bl3) {
                            APMComponentIDRepository.setStatusForBtmDiscovery(string7, true);
                            fullyDiscoveredContainerIds.add(string7);
                        }
                        if (bl3 || bl2) break block41;
                        fullyDiscoveredContainerIds.add(string7);
                        if (APMComponentIDRepository.isThisManaged(string12)) {
                            String string20 = APMComponentIDRepository.getJvmGuidFromTemp(string12);
                            APMComponentIDRepository.addToTempComponentRepository(string20, string7);
                            APMComponentIDRepository.addToTempComponentRepository(string7, string20);
                            APMDiscoveryLogger.discoveryLogger.info("[APMDiscoveryHelper] This Request discovery data[{}] is already discovered and auto-managed with {}:{}, registering temporary id into repo", new Object[]{string7, string12, string20});
                        }
                        break block41;
                    }
                }
                Object var27_28 = null;
                if (!bl) break block41;
            }
            catch (Throwable throwable) {
                Object var27_30 = null;
                if (bl) {
                    APMComponentIDRepository.setStatusForBtmDiscovery(string7, false);
                    if (bl3) {
                        APMComponentIDRepository.setStatusForBtmDiscovery(string7, true);
                        fullyDiscoveredContainerIds.add(string7);
                    }
                    if (!bl3 && !bl2) {
                        fullyDiscoveredContainerIds.add(string7);
                        if (APMComponentIDRepository.isThisManaged(string12)) {
                            String string18 = APMComponentIDRepository.getJvmGuidFromTemp(string12);
                            APMComponentIDRepository.addToTempComponentRepository(string18, string7);
                            APMComponentIDRepository.addToTempComponentRepository(string7, string18);
                            APMDiscoveryLogger.discoveryLogger.info("[APMDiscoveryHelper] This Request discovery data[{}] is already discovered and auto-managed with {}:{}, registering temporary id into repo", new Object[]{string7, string12, string18});
                        }
                    }
                }
                throw throwable;
            }
            APMComponentIDRepository.setStatusForBtmDiscovery(string7, false);
            if (bl3) {
                APMComponentIDRepository.setStatusForBtmDiscovery(string7, true);
                fullyDiscoveredContainerIds.add(string7);
            }
            if (!bl3 && !bl2) {
                fullyDiscoveredContainerIds.add(string7);
                if (APMComponentIDRepository.isThisManaged(string12)) {
                    String string19 = APMComponentIDRepository.getJvmGuidFromTemp(string12);
                    APMComponentIDRepository.addToTempComponentRepository(string19, string7);
                    APMComponentIDRepository.addToTempComponentRepository(string7, string19);
                    APMDiscoveryLogger.discoveryLogger.info("[APMDiscoveryHelper] This Request discovery data[{}] is already discovered and auto-managed with {}:{}, registering temporary id into repo", new Object[]{string7, string12, string19});
                }
            }
        }
        if (arrayList.size() > 0) {
            APMDiscoveryHelper.storeToIni(arrayList, null);
        }
    }

    public static void storeAutoDiscoveryDetails(Map map, String string) {
        String string2;
        Hashtable hashtable = (Hashtable)map.get("DO_HTTP_REQ");
        if (hashtable != null) {
            APMDiscoveryHelper.storeBtmDetailsForManualReq(string, hashtable);
            return;
        }
        Hashtable hashtable2 = (Hashtable)map.get("STARTUP_DISCOVERY_DETAILS");
        Hashtable hashtable3 = (Hashtable)map.get("REQUEST_DISCOVERY_DETAILS");
        APMDiscoveryLogger.discoveryLogger.debug("{} {} discoveryData - {} ", new Object[]{loggerDispStr, string, map});
        APMDiscoveryLogger.discoveryLogger.debug("{} {} STARTUP_DISCOVERY_DETAILS - {} ", new Object[]{loggerDispStr, string, hashtable2});
        APMDiscoveryLogger.discoveryLogger.debug("{} {} REQUEST_DISCOVERY_DETAILS - {} ", new Object[]{loggerDispStr, string, hashtable3});
        if (hashtable2 == null) {
            hashtable2 = new Hashtable();
        }
        if (hashtable3 == null) {
            hashtable3 = new Hashtable();
        }
        string2 = (string2 = (String)map.remove("appName")) == null || string2.length() <= 0 ? "MyApp" : string2;
        String string3 = (String)map.remove("tierName");
        string3 = string3 == null || string3.length() <= 0 ? "MyTier" : string3;
        String string4 = APMDiscoveryHelper.getDetails("POD_NAME", hashtable3, hashtable2, "NONE");
        string4 = string4 == null || string4.length() <= 0 ? "NONE" : string4;
        String string5 = APMDiscoveryHelper.getDetails("POD_NAME_SPACE", hashtable3, hashtable2, "NONE");
        string5 = string5 == null || string5.length() <= 0 ? "NONE" : string5;
        String string6 = APMDiscoveryHelper.getDetails("CONTAINER_NAME", hashtable3, hashtable2, "NONE");
        String string7 = APMDiscoveryHelper.getDetails("CONTAINER_SERVER_NAME", hashtable3, hashtable2, "NONE");
        String string8 = APMDiscoveryHelper.getDetails("CONTAINER_IP", hashtable3, hashtable2, "NONE");
        String string9 = APMDiscoveryHelper.getDetails("CONTAINER_PORT", hashtable3, hashtable2, "0");
        String string10 = APMDiscoveryHelper.getDetails("CONTAINER_SCHEME", hashtable3, hashtable2, "NONE");
        String string11 = APMDiscoveryHelper.getDetails("CONTAINER_JMX_PORT", hashtable3, hashtable2, "0");
        if (string9 == null) {
            string9 = "0000";
        }
        try {
            String string12;
            int n = Integer.parseInt(string9);
            if (string7 != null && string7.indexOf("Payara") > -1) {
                string7 = "GlassFish_server";
            }
            if ((string12 = CONTAINER_NAME_MAPPINGS.get(string7)) != null && string12.length() > 0 && !string12.equalsIgnoreCase("Java_virtual_machine")) {
                APMDiscoveryLogger.discoveryLogger.info("{} Successfully identified the COMPONENT TYPE via startup discovery.  DISCOVERY RESULT - Component Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {}", new Object[]{loggerDispStr, string12, string8, n, string10, string7, string});
            }
            if (string12 == null || string12.equalsIgnoreCase("Java_virtual_machine")) {
                string12 = APMUtils.getServerType(string7);
                APMDiscoveryLogger.discoveryLogger.info("{} Successfully identified the COMPONENT TYPE via request discovery - DISCOVERY RESULT - Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {}", new Object[]{loggerDispStr, string12, string8, n, string10, string7, string});
                if (string7.equalsIgnoreCase("JBoss_AS_server")) {
                    string12 = "JBoss_AS_server";
                } else if (string7.equalsIgnoreCase("JBoss_server")) {
                    string12 = "JBoss_server";
                }
            }
            if (string12 == null || string12.length() == 0) {
                string12 = "Java_virtual_machine";
            }
            String string13 = null;
            if (APMUtils.isDetailsAvailable(map, "JvmGUID")) {
                string13 = (String)map.get("JvmGUID");
            }
            String string14 = string2 + ":" + string3;
            String string15 = string4 + ":" + string5;
            APMDiscoveryLogger.discoveryLogger.info("{} DISCOVERY RESULT - Type :{} , IP :{}  , Port :{} , Scheme : {} , Server Name : {}, Node ID : {}  & JvmGUID : {} , appTierName : {},  Podname&NameSpace : {}", new Object[]{loggerDispStr, string12, string8, n, string10, string7, string, string13, string14, string15});
            APMDiscoveryHelper.storeBtmComponentDetails(string12, string8, n, string10, string11, string7, string, string13, string6, string14, string15);
        }
        catch (Exception exception) {
            APMDiscoveryLogger.discoveryLogger.error("{} Exception while getting server details !!.. so set the default value...{} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeBtmDetailsForManualReq(String string, Hashtable hashtable) {
        String string2;
        APMDiscoveryLogger.discoveryLogger.debug("{} {} discoveryData of manual http request - {} ", new Object[]{loggerDispStr, string, hashtable});
        APMDiscoveryLogger.discoveryLogger.info("[APMDiscoveryHelper] fullyDiscoveredContainerIds {} ", (Object)fullyDiscoveredContainerIds);
        String string3 = (String)hashtable.remove("CONTAINER_PID");
        String string4 = string2 = (String)hashtable.get("CONTAINER_IP");
        String string5 = (String)hashtable.remove("CONTAINER_NAME");
        if (APMDiscoveryHelper.isInDiscoverdList(string)) {
            APMDiscoveryLogger.discoveryLogger.warn("[APMDiscoveryHelper] {} Already discovered, so skipping HTTP Request entry to ini [{}] ", (Object)string, (Object)string4);
            return;
        }
        ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
        try {
            try {
                String string6 = "JAVA_SERVER_DETAILS";
                if (APMDiscoveryHelper.isThisValidDocker(string5)) {
                    string6 = "JAVA_SERVER_DETAILS_CONTAINER_BASED";
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string3).append(separatorString);
                stringBuilder.append(string).append(separatorString);
                stringBuilder.append(new Date());
                string6 = string6 + "_DO_HTTP_REQ";
                String string7 = stringBuilder.toString();
                boolean bl = APMUtils.isDetailsAvailableInFile(iniFile, string4, string7, string6);
                if (bl) {
                    APMDiscoveryLogger.discoveryLogger.trace("{} Component Details for :{} with value :{} is already available under [{}] subject...", new Object[]{loggerDispStr, string4, string7, string6});
                }
                arrayList.add(APMUtils.getIniHelper(string6, string4, string7));
                APMDiscoveryLogger.discoveryLogger.info("{} Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string4, string7, string6});
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, exception});
                Object var13_14 = null;
                if (arrayList.size() <= 0) return;
                APMDiscoveryHelper.storeToIni(arrayList, null);
                return;
            }
            Object var13_13 = null;
            if (arrayList.size() <= 0) return;
        }
        catch (Throwable throwable) {
            Object var13_15 = null;
            if (arrayList.size() <= 0) throw throwable;
            APMDiscoveryHelper.storeToIni(arrayList, null);
            throw throwable;
        }
        APMDiscoveryHelper.storeToIni(arrayList, null);
    }

    private static boolean isThisValidDocker(String string) {
        return string != null && !string.equalsIgnoreCase("NONE") && !string.equalsIgnoreCase("-") && string.length() > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean saveToIni(String string, ArrayList arrayList, ArrayList arrayList2) {
        String string2 = apmSync;
        synchronized (string2) {
            boolean bl;
            block10: {
                IniFile iniFile = EgApmFilesSync.getInstance(string, true);
                bl = false;
                try {
                    try {
                        String string3;
                        String string4;
                        String string5;
                        IniHelper iniHelper;
                        int n;
                        if (arrayList != null && arrayList.size() > 0) {
                            for (n = 0; n < arrayList.size(); ++n) {
                                iniHelper = (IniHelper)arrayList.get(n);
                                string5 = iniHelper.getSubject();
                                string4 = iniHelper.getVariable();
                                string3 = iniHelper.getValue();
                                iniFile.setValue(string5, string4, string3);
                                APMDiscoveryLogger.discoveryLogger.info("{} {} : Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string, string4, string3, string5});
                            }
                        }
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            for (n = 0; n < arrayList2.size(); ++n) {
                                iniHelper = (IniHelper)arrayList2.get(n);
                                string5 = iniHelper.getSubject();
                                string4 = iniHelper.getVariable();
                                string3 = iniHelper.getValue();
                                iniFile.deleteValue(string5, string4);
                                APMDiscoveryLogger.discoveryLogger.info("{} {}: Deleting Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string, string4, string3, string5});
                            }
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, string, exception});
                        bl = false;
                        Object var12_13 = null;
                        iniFile.saveFile();
                        EgApmFilesSync.releaseInstance(iniFile);
                        break block10;
                    }
                    Object var12_12 = null;
                    iniFile.saveFile();
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    iniFile.saveFile();
                    EgApmFilesSync.releaseInstance(iniFile);
                    throw throwable;
                }
                EgApmFilesSync.releaseInstance(iniFile);
            }
            return bl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean storeToIni(ArrayList arrayList, ArrayList arrayList2) {
        String string = apmSync;
        synchronized (string) {
            boolean bl;
            block10: {
                IniFile iniFile = EgApmFilesSync.getInstance(EG_APM_DISCOVERY_INI, true);
                bl = false;
                try {
                    try {
                        String string2;
                        String string3;
                        String string4;
                        IniHelper iniHelper;
                        int n;
                        if (arrayList != null && arrayList.size() > 0) {
                            for (n = 0; n < arrayList.size(); ++n) {
                                iniHelper = (IniHelper)arrayList.get(n);
                                string4 = iniHelper.getSubject();
                                string3 = iniHelper.getVariable();
                                string2 = iniHelper.getValue();
                                iniFile.setValue(string4, string3, string2);
                                APMDiscoveryLogger.discoveryLogger.info("{} StoreToIni() Adding Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string3, string2, string4});
                            }
                        }
                        if (arrayList2 != null && arrayList2.size() > 0) {
                            for (n = 0; n < arrayList2.size(); ++n) {
                                iniHelper = (IniHelper)arrayList2.get(n);
                                string4 = iniHelper.getSubject();
                                string3 = iniHelper.getVariable();
                                string2 = iniHelper.getValue();
                                iniFile.deleteValue(string4, string3);
                                APMDiscoveryLogger.discoveryLogger.info("{}  StoreToIni() Deleting Component {}={} details under subject [{}]", new Object[]{loggerDispStr, string3, string2, string4});
                            }
                        }
                        bl = true;
                    }
                    catch (Exception exception) {
                        APMDiscoveryLogger.discoveryLogger.error("{} Unable to update {} {} ", new Object[]{loggerDispStr, BTMConstants.APM_DISCOVERY_FILEPATH, exception});
                        bl = false;
                        Object var11_12 = null;
                        iniFile.saveFile();
                        EgApmFilesSync.releaseInstance(iniFile);
                        break block10;
                    }
                    Object var11_11 = null;
                    iniFile.saveFile();
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    iniFile.saveFile();
                    EgApmFilesSync.releaseInstance(iniFile);
                    throw throwable;
                }
                EgApmFilesSync.releaseInstance(iniFile);
            }
            return bl;
        }
    }

    private static String getDetails(String string, Hashtable hashtable, Hashtable hashtable2, String string2) {
        String string3 = null;
        string3 = (String)hashtable.remove(string);
        if (APMDiscoveryHelper.isValid(string3)) {
            return string3;
        }
        string3 = (String)hashtable2.remove(string);
        if (APMDiscoveryHelper.isValid(string3)) {
            return string3;
        }
        string3 = string2;
        return string3;
    }

    private static boolean isValid(String string) {
        return string != null && !string.equalsIgnoreCase("NONE") && string.length() != 0 && !string.equalsIgnoreCase("0000");
    }

    public static void addToDiscoveredList(String string) {
        if (string != null) {
            fullyDiscoveredContainerIds.add(string);
        }
    }

    public static void addToDiscoveredList(ArrayList arrayList) {
        if (arrayList != null) {
            fullyDiscoveredContainerIds.add(arrayList);
        }
    }

    public static boolean isInDiscoverdList(String string) {
        return fullyDiscoveredContainerIds.contains(string);
    }

    public static TreeSet getDiscoveredList() {
        return fullyDiscoveredContainerIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void removeEntriesFromApmDiscoveryIni(String string, String string2, boolean bl, boolean bl2) {
        if (string2 == null) {
            return;
        }
        ArrayList<IniHelper> arrayList = null;
        ArrayList<IniHelper> arrayList2 = null;
        IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
        try {
            try {
                String string3 = iniFile.getValue("JAVA_SERVER_DETAILS", string2);
                if (bl2) {
                    arrayList2 = new ArrayList<IniHelper>();
                    arrayList2.add(APMUtils.getIniHelper("JAVA_SERVER_DETAILS", string2, "DeleteME"));
                    arrayList2.add(APMUtils.getIniHelper("LAST_HEART_BEAT_CHECK_TIME", string, "DeleteME"));
                }
                if (bl) {
                    arrayList = new ArrayList<IniHelper>();
                    arrayList.add(APMUtils.getIniHelper("AUTO_DELETED_JAVA_SERVER_DETAILS", string2, string3 + separatorString + System.currentTimeMillis()));
                }
                APMDiscoveryLogger.discoveryLogger.debug("{} {} - related INI Entries are deleted from {} ", new Object[]{loggerDispStr, string, BTMConstants.APM_DISCOVERY_FILEPATH});
            }
            catch (Exception exception) {
                APMDiscoveryLogger.discoveryLogger.error("{} {}, Unable to delete INI Entries from {} ", new Object[]{loggerDispStr, string, BTMConstants.APM_DISCOVERY_FILEPATH});
                Object var9_10 = null;
                APMDiscoveryHelper.storeToIni(arrayList, arrayList2);
                return;
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            APMDiscoveryHelper.storeToIni(arrayList, arrayList2);
            throw throwable;
        }
        APMDiscoveryHelper.storeToIni(arrayList, arrayList2);
    }

    public static String getDiscoveredJmxPort(String string, String string2, String string3, String string4, String string5) {
        APMDiscoveryLogger.discoveryLogger.trace("{} ApmConfigManager.isApmMonitoringEnabled(): {}, nick: {}, targetHost: {} , portNo: {} , serverType: {}, jmxPort: {} ", new Object[]{loggerDispStr, ApmConfigManager.getInstance().isAPMMonitoringEnabled(), string, string2, string3, string4, string5});
        if (ApmConfigManager.getInstance().isAPMMonitoringEnabled() && string3 != null) {
            IniFile iniFile = new IniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH);
            String string6 = string2 + ":" + string3 + ":" + string4;
            string5 = iniFile.getValue("JAVA_SERVER_JMX_MAPPING", string6);
            APMDiscoveryLogger.discoveryLogger.info("{} APM discovered JMX port reading  key : {}, value : {} ", new Object[]{loggerDispStr, string6, string5});
            if (string5 != null && string5.length() == 0) {
                string6 = string + ":" + string3 + ":" + string4;
                string5 = iniFile.getValue("JAVA_SERVER_JMX_MAPPING", string6);
            }
            APMDiscoveryLogger.discoveryLogger.info("{} APM discovered JMX port reading  key : {}, value : {} ", new Object[]{loggerDispStr, string6, string5});
            if (string5 != null && string5.length() > 0) {
                return string5;
            }
        }
        return string5;
    }

    static {
        CONTAINER_NAME_MAPPINGS.put("Tomcat_server", "Tomcat_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss_server", "JBoss_server");
        CONTAINER_NAME_MAPPINGS.put("JBoss_AS_server", "JBoss_AS_server");
        CONTAINER_NAME_MAPPINGS.put("WildFly", "WildFly");
        CONTAINER_NAME_MAPPINGS.put("WebLogic_server", "WebLogic_server");
        CONTAINER_NAME_MAPPINGS.put("WebSphere_server", "WebSphere_server");
        CONTAINER_NAME_MAPPINGS.put("GlassFish_server", "GlassFish_server");
        CONTAINER_NAME_MAPPINGS.put("IBMWLP", "IBMWLP");
        CONTAINER_NAME_MAPPINGS.put("Java_virtual_machine", "Java_virtual_machine");
        CONTAINER_NAME_MAPPINGS.put("Atlassian_Confluence", "Atlassian_Confluence");
        CONTAINER_NAME_MAPPINGS.put("eG_Manager", "eG_Manager");
        APMDiscoveryHelper.readCustomPortsFromIni();
    }
}

