/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMFileOperations;
import com.eg.apm.APMUtils;
import com.eg.apm.AgentSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.ClientSocketListener;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.ThreadPoolManager;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Date;
import org.apache.commons.configuration.PropertiesConfiguration;

public final class AgentJavaSocketServer
extends AgentSocketServer {
    private static AgentJavaSocketServer instance = null;
    private static ServerSocket serverSocket = null;
    private static final String logPrefix = " [" + AgentJavaSocketServer.class.getClass().getName() + "] Java - ";
    private static final long AGENT_SOCKET_RETRY_SLEEP_DURATION = 1000L;
    private static final int AGENT_SOCKET_MAX_RETRY_ATTEMPTS = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AgentJavaSocketServer(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration, boolean bl) {
        String[] stringArray;
        Object object;
        int n;
        boolean bl2;
        block30: {
            bl2 = false;
            try {
                if (AgentJavaSocketServer.isServerSocketCreated()) break block30;
                n = bTMOffloadAPMSocketConfiguration.getOffloadJavaServerSocketPort();
                boolean bl3 = bTMOffloadAPMSocketConfiguration.isBindLocalHostOnly();
                object = bTMOffloadAPMSocketConfiguration.getOffloadServerSocketIP();
                AgentStartupLogger.logger.info("{} isBindLocalHostOnly-{} ,isDockerHost-{} ,isContainerHostIpAvailable-{} ", new Object[]{logPrefix, bl3, bl, APMUtils.isContainerHostIpAvailable()});
                if (bTMOffloadAPMSocketConfiguration.isCustomIPAvailable()) {
                    object = bTMOffloadAPMSocketConfiguration.getCustomOffloadServerSocketIP();
                } else if (bl && APMUtils.isContainerHostIpAvailable()) {
                    object = APMUtils.getContainerHostIp();
                } else if (!bl3) {
                    object = "0.0.0.0";
                } else if (bl3) {
                    object = "127.0.0.1";
                }
                if (n != -1) {
                    serverSocket = this.createServerSocket(serverSocket, n, (String)object);
                }
                if (serverSocket != null) {
                    bl2 = true;
                    System.out.println(new Date() + logPrefix + " BTM Offload Server Socket running on port -  " + (String)object + ":" + n);
                    AgentStartupLogger.logger.warn("{} INFO :- BTM Offload Server Socket running on port - {}:{} ", new Object[]{logPrefix, object, n});
                    if (bTMOffloadAPMSocketConfiguration.isAgentIPAssignedAsBindIp() || bTMOffloadAPMSocketConfiguration.isCustomIPAvailable() || APMUtils.isContainerHostIpAvailable()) {
                        this.updateBtmFiles((String)object, n);
                    }
                }
                if (bl2 || (stringArray = bTMOffloadAPMSocketConfiguration.getOffloadJavaPortList()) == null || stringArray.length <= 0) break block30;
                block7: for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    int n2 = -1;
                    try {
                        n2 = Integer.parseInt(string);
                    }
                    catch (Exception exception) {
                        AgentStartupLogger.logger.warn("{}  Invalid Port No {} is specified.", (Object)logPrefix, (Object)n2);
                        continue;
                    }
                    if (n2 <= 1024) {
                        AgentStartupLogger.logger.warn("{}  Invalid Port No {} is specified.", (Object)logPrefix, (Object)n2);
                        continue;
                    }
                    if (bl2) continue;
                    int n3 = 1;
                    while (!bl2) {
                        this.sleepMethod(1000L);
                        if (bl && APMUtils.isContainerHostIpAvailable()) {
                            object = APMUtils.getContainerHostIp();
                        } else if (!bl3) {
                            object = "0.0.0.0";
                        } else if (bl3) {
                            object = "127.0.0.1";
                        }
                        AgentStartupLogger.logger.debug("{}  Using {}  Re-attempt {}  to create server socket ...", new Object[]{logPrefix, n2, n3});
                        serverSocket = this.createServerSocket(serverSocket, n2, (String)object);
                        if (serverSocket != null) {
                            bl2 = true;
                            AgentStartupLogger.logger.warn("{} BTM Offload Server Socket running on port - {}:{} ", new Object[]{logPrefix, object, n});
                            System.out.println(new Date() + logPrefix + " BTM Offload Server Socket running on port -  " + (String)object + ":" + n2);
                            if (bTMOffloadAPMSocketConfiguration.isAgentIPAssignedAsBindIp() || bTMOffloadAPMSocketConfiguration.isCustomIPAvailable() || APMUtils.isContainerHostIpAvailable()) {
                                this.updateBtmFiles((String)object, n2);
                            }
                        }
                        if (n3 > 0) continue block7;
                        ++n3;
                    }
                }
            }
            catch (Exception exception) {
                AgentStartupLogger.logger.error("{} Unable to create server socket due to {} ... ", (Object)logPrefix, (Object)exception);
                return;
            }
        }
        if (bl2) {
            AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully ", (Object)logPrefix);
            n = bTMOffloadAPMSocketConfiguration.getOffloadWorkers();
            int n4 = bTMOffloadAPMSocketConfiguration.getQueueSize();
            ThreadPoolManager.getThreadPoolManager(true, n, n4);
            object = new ClientSocketListener(serverSocket);
            stringArray = new Thread((Runnable)object);
            stringArray.setName("Client Socket Listener");
            stringArray.setDaemon(true);
            stringArray.start();
            AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to ClientSocketListener !!!", (Object)logPrefix);
            return;
        }
        AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without socket creation ... ", (Object)logPrefix);
        return;
        finally {
            if (bl2) {
                AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully ", (Object)logPrefix);
                int n5 = bTMOffloadAPMSocketConfiguration.getOffloadWorkers();
                int n6 = bTMOffloadAPMSocketConfiguration.getQueueSize();
                ThreadPoolManager.getThreadPoolManager(true, n5, n6);
                ClientSocketListener clientSocketListener = new ClientSocketListener(serverSocket);
                Thread thread = new Thread(clientSocketListener);
                thread.setName("Client Socket Listener");
                thread.setDaemon(true);
                thread.start();
                AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to ClientSocketListener !!!", (Object)logPrefix);
            } else {
                AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without socket creation ... ", (Object)logPrefix);
            }
        }
    }

    private void updateBtmFiles(String string, int n) {
        try {
            String string2 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFolderPath;
            String string3 = string2 + "default" + BTMConstants.fileSeperator + "config.props";
            this.updateToOffloadConfigProperties(string3, string, n);
            APMFileOperations aPMFileOperations = new APMFileOperations();
            String string4 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFilePathTemp + "ipupdate";
            String string5 = EgInstallInfo.getInstallDir() + BTMConstants.javaApmSrcZipFilePath;
            String string6 = EgInstallInfo.getInstallDir() + BTMConstants.apmOffloadFolderPath + "btm_default.zip";
            File file = new File(string6);
            if (!file.exists()) {
                aPMFileOperations.copyFile(new File(string5), file);
            }
            aPMFileOperations.unZip(string5, string4);
            String string7 = string4 + BTMConstants.fileSeperator + "config.props";
            this.updateToOffloadConfigProperties(string7, string, n);
            aPMFileOperations.zipDirectory(new File(string4), string5);
            aPMFileOperations.deleteDirectory(string4);
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception Occurred while updating btm files {} ", (Object)logPrefix, (Object)exception);
        }
    }

    private void updateToOffloadConfigProperties(String string, String string2, int n) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration(string);
            propertiesConfiguration.setProperty("AGENT_PORT", (Object)n);
            propertiesConfiguration.setProperty("AGENT_IP", (Object)string2);
            propertiesConfiguration.setProperty("AGENT_CONTAINER_IP", (Object)string2);
            propertiesConfiguration.save();
            AgentStartupLogger.logger.debug("{} - {} - Bind IP : {}, Port: {}  - updated Successfully!!", new Object[]{logPrefix, propertiesConfiguration.getFileName(), string2, n});
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Exception Occurred while updating config.props {} ", (Object)logPrefix, (Object)exception);
        }
    }

    public static boolean isSocketServerStarted() {
        if (instance != null) {
            if (instance.isServerSocketCreated()) {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentJavaSocketServer startServer(BTMOffloadAPMSocketConfiguration bTMOffloadAPMSocketConfiguration, boolean bl) {
        if (instance != null) return instance;
        Class<AgentJavaSocketServer> clazz = AgentJavaSocketServer.class;
        synchronized (AgentJavaSocketServer.class) {
            if (instance != null) return instance;
            instance = new AgentJavaSocketServer(bTMOffloadAPMSocketConfiguration, bl);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    private static boolean isServerSocketCreated() {
        return serverSocket != null;
    }

    public static void closeServerSocket() {
        ThreadPoolManager threadPoolManager;
        if (serverSocket != null) {
            try {
                if (!serverSocket.isClosed()) {
                    serverSocket.close();
                    serverSocket = null;
                    AgentStartupLogger.logger.warn("{} eG APM - Java BTM Offload Server Socket Closed", (Object)logPrefix);
                }
            }
            catch (IOException iOException) {
                AgentStartupLogger.logger.error("{} I/O Error when try to close server socket port  : {}", (Object)logPrefix, (Object)iOException);
            }
        }
        if (instance != null) {
            instance = null;
        }
        if ((threadPoolManager = ThreadPoolManager.getInstance()) != null) {
            threadPoolManager.clearThreadPoolManager();
            threadPoolManager = null;
            AgentStartupLogger.logger.warn("{} Cleared ThreadPoolManager for eG APM - Java BTM", (Object)logPrefix);
        }
    }
}

