/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.AgentSocketServer;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.BTMOffloadAPMSocketConfiguration;
import com.eg.apm.NodeClientSocketListener;
import com.eg.jtm.NodeThreadPoolManager;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Date;

public final class AgentNodeSocketServer
extends AgentSocketServer {
    private static AgentNodeSocketServer instance;
    private static ServerSocket serverSocket;
    private static final String logPrefix;
    private static final long AGENT_SOCKET_RETRY_SLEEP_DURATION = 1000L;
    private static final int AGENT_SOCKET_MAX_RETRY_ATTEMPTS = 0;

    static {
        logPrefix = " [" + AgentNodeSocketServer.class.getName() + "] Node.js - ";
    }

    private AgentNodeSocketServer(BTMOffloadAPMSocketConfiguration configuration) {
        block22: {
            boolean isServerSocketCreated;
            block20: {
                isServerSocketCreated = false;
                try {
                    try {
                        String[] offloadPorts;
                        if (AgentNodeSocketServer.isServerSocketCreated()) break block20;
                        int offloadPort = configuration.getOffloadNodeServerSocketPort();
                        boolean bindLocalOnly = configuration.isBindLocalHostOnly();
                        String bindIP = configuration.getOffloadServerSocketIP();
                        if (offloadPort != -1) {
                            bindIP = bindLocalOnly ? "127.0.0.1" : "0.0.0.0";
                            serverSocket = this.createServerSocket(serverSocket, offloadPort, bindIP);
                        }
                        if (serverSocket != null) {
                            isServerSocketCreated = true;
                            System.out.println(new Date() + logPrefix + "BTM Offload Server Socket running on port -  " + bindIP + ":" + offloadPort);
                        }
                        if (isServerSocketCreated || (offloadPorts = configuration.getOffloadNodePortList()) == null || offloadPorts.length <= 0) break block20;
                        int i = 0;
                        while (i < offloadPorts.length) {
                            block21: {
                                String portString = offloadPorts[i];
                                int port_no = -1;
                                try {
                                    port_no = Integer.parseInt(portString);
                                }
                                catch (Exception e) {
                                    AgentStartupLogger.logger.warn("{} Invalid Port No ({}) is specified.", (Object)logPrefix, (Object)port_no);
                                    break block21;
                                }
                                if (port_no <= 1024) {
                                    AgentStartupLogger.logger.warn("{} Invalid Port No ({}) is specified.", (Object)logPrefix, (Object)port_no);
                                } else if (!isServerSocketCreated) {
                                    int retryCounter = 1;
                                    while (!isServerSocketCreated) {
                                        this.sleepMethod(1000L);
                                        AgentStartupLogger.logger.debug("{} Using {} Re-attempt ({}) to create server socket ...", new Object[]{logPrefix, port_no, retryCounter});
                                        bindIP = bindLocalOnly ? "127.0.0.1" : "0.0.0.0";
                                        serverSocket = this.createServerSocket(serverSocket, port_no, bindIP);
                                        if (serverSocket != null) {
                                            isServerSocketCreated = true;
                                            System.out.println(new Date() + logPrefix + "BTM Offload NodeJS Server Socket running on port : " + port_no);
                                        }
                                        if (retryCounter > 0) break;
                                        ++retryCounter;
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        AgentStartupLogger.logger.error("{} Unable to create server socket due to {} ... {} ", new Object[]{logPrefix, e.getMessage(), e});
                        if (isServerSocketCreated) {
                            AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                            int workers = configuration.getOffloadWorkers();
                            int queueSize = configuration.getQueueSize();
                            NodeThreadPoolManager.getThreadPoolManager(true, workers, queueSize);
                            NodeClientSocketListener listener = new NodeClientSocketListener(serverSocket);
                            Thread clientSocketListenerThread = new Thread(listener);
                            clientSocketListenerThread.setName("NodeJS_ClientSocketListener");
                            clientSocketListenerThread.setDaemon(true);
                            clientSocketListenerThread.start();
                            AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeClientSocketListener !!!", (Object)logPrefix);
                        } else {
                            AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                            AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
                        }
                        break block22;
                    }
                }
                catch (Throwable throwable) {
                    if (isServerSocketCreated) {
                        AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                        int workers = configuration.getOffloadWorkers();
                        int queueSize = configuration.getQueueSize();
                        NodeThreadPoolManager.getThreadPoolManager(true, workers, queueSize);
                        NodeClientSocketListener listener = new NodeClientSocketListener(serverSocket);
                        Thread clientSocketListenerThread = new Thread(listener);
                        clientSocketListenerThread.setName("NodeJS_ClientSocketListener");
                        clientSocketListenerThread.setDaemon(true);
                        clientSocketListenerThread.start();
                        AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeClientSocketListener !!!", (Object)logPrefix);
                    } else {
                        AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                        AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
                    }
                    throw throwable;
                }
            }
            if (isServerSocketCreated) {
                AgentStartupLogger.logger.info("{} Agent Server Socket has been created successfully", (Object)logPrefix);
                int workers = configuration.getOffloadWorkers();
                int queueSize = configuration.getQueueSize();
                NodeThreadPoolManager.getThreadPoolManager(true, workers, queueSize);
                NodeClientSocketListener listener = new NodeClientSocketListener(serverSocket);
                Thread clientSocketListenerThread = new Thread(listener);
                clientSocketListenerThread.setName("NodeJS_ClientSocketListener");
                clientSocketListenerThread.setDaemon(true);
                clientSocketListenerThread.start();
                AgentStartupLogger.logger.debug("{} Server Socket instance is handed off to NodeClientSocketListener !!!", (Object)logPrefix);
            } else {
                AgentStartupLogger.logger.error("{} Unable to create agent server socket, returning without NodeJS BTM Server Socket creation ... ", (Object)logPrefix);
                AgentStartupLogger.logger.error("{} Please specify available port to \"{}\" in (manager)eg_tests.ini under [{}] section, & restart eG Agent.", new Object[]{logPrefix, "NodeJSAgentServerSocketPortOrder", "AGENT_SOCKET_SETTINGS"});
            }
        }
    }

    public static boolean isSocketServerStarted() {
        return instance != null && AgentNodeSocketServer.isServerSocketCreated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AgentNodeSocketServer startServer(BTMOffloadAPMSocketConfiguration configuration) {
        if (instance != null) return instance;
        Class<AgentNodeSocketServer> clazz = AgentNodeSocketServer.class;
        synchronized (AgentNodeSocketServer.class) {
            if (instance != null) return instance;
            instance = new AgentNodeSocketServer(configuration);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public static boolean isServerSocketCreated() {
        return serverSocket != null;
    }

    public static void closeServerSocket() {
        NodeThreadPoolManager manager;
        if (serverSocket != null) {
            try {
                if (!serverSocket.isClosed()) {
                    serverSocket.close();
                    serverSocket = null;
                    AgentStartupLogger.logger.warn("{} eG APM - NodeJS BTM Offload Server Socket Closed", (Object)logPrefix);
                }
            }
            catch (IOException ioe) {
                AgentStartupLogger.logger.error("{} I/O Error when try to close NodeJS server socket port  : ", (Object)logPrefix, (Object)ioe);
            }
        }
        if (instance != null) {
            instance = null;
        }
        if ((manager = NodeThreadPoolManager.getInstance()) != null) {
            manager.clearThreadPoolManager();
            manager = null;
            AgentStartupLogger.logger.warn("{} Cleared ThreadPoolManager for Node.js BTM", (Object)logPrefix);
        }
    }
}

