/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.apm.APMComponentIDRepository;
import com.eg.apm.AgentStartupLogger;
import com.eg.apm.JavaAPMComponent;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.JavaTransactionFlowUtility;
import com.eg.apm.Status;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.ThreadPoolManager;
import com.eg.jvmmonitor.JVMMetricData;
import com.eg.org.apache.commons.lang3.SerializationUtils;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;

public final class ClientSocketHandler
implements Runnable {
    private Socket clientSocket;
    private final String logPrefix = " [" + this.getClass().getName() + "] ";
    private String clientSocketAddress;
    private boolean runThis = true;
    private boolean whileRunning = false;
    private static final Object configSync = new Object();
    private String nick;
    private String guid;

    public ClientSocketHandler(Socket socket) {
        try {
            this.clientSocket = socket;
        }
        catch (Exception exception) {
            AgentStartupLogger.logger.error("{} Java BTM - Unable to initialize ClientSocketHandler object {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block55: {
            if (this.clientSocket == null) {
                return;
            }
            this.clientSocketAddress = this.clientSocket.getInetAddress() + ":" + this.clientSocket.getPort();
            var1_1 = null;
            var2_2 = null;
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Java BTM - Client Socket Handler thread started with  : {}", (Object)this.logPrefix, (Object)this.clientSocketAddress);
            try {
                var1_1 = this.getDataInputStream();
                var2_2 = this.getDataOutputStream();
                JavaBTMOffloadLogger.btmOffLoadLogger.trace("{}  runThis : {} - {} ", new Object[]{this.logPrefix, this.runThis, this.clientSocketAddress});
                while (this.runThis && var1_1 != null) {
                    this.whileRunning = true;
                    try {
                        block56: {
                            var3_3 = 0;
                            try {
                                if (var1_1.available() < 0) continue;
                                var3_3 = var1_1.readInt();
                            }
                            catch (EOFException var4_10) {
                            }
                            catch (SocketTimeoutException var4_11) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Read Timed out while reading data from BTM clients. {} [{}-{}]", new Object[]{this.logPrefix, this.clientSocketAddress, this.nick, this.guid});
                            }
                            catch (SocketException var4_12) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Connection closed by client:{} [{}-{}] : {}", new Object[]{this.logPrefix, this.clientSocketAddress, this.nick, this.guid, var4_12.getMessage()});
                            }
                            catch (Exception var4_13) {
                                JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception occured while reading BTM data [{}-{}] {} ", new Object[]{this.logPrefix, this.nick, this.guid, var4_13});
                            }
                            if (var3_3 > 0) break block56;
                            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  [{}-{}] DataSize is {}, Going to close the connection - {} ", new Object[]{this.logPrefix, this.nick, this.guid, var3_3, this.clientSocketAddress});
                            ** GOTO lbl181
                        }
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from [{}-{}] btm client : {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress});
                        var4_9 = new byte[var3_3];
                        var1_1.readFully(var4_9);
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Received Byte[] from btm client {} [{}-{}] : {}", new Object[]{this.logPrefix, this.clientSocketAddress, this.nick, this.guid, var4_9.length});
                        var5_15 = SerializationUtils.deserialize((byte[])var4_9);
                        if (var5_15 == null) continue;
                        if (var5_15 instanceof String) {
                            var6_16 = this.readData(var1_1, var2_2, var3_3, var5_15);
                            if (var6_16) continue;
                            this.whileRunning = false;
                        }
                        ** GOTO lbl-1000
                    }
                    catch (EOFException var3_4) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} EOFException while reading data from BTM clients. [{}-{}]:{} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress});
                        continue;
                    }
                    catch (SocketTimeoutException var3_5) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Read Timed out while reading data from BTM clients. [{}-{}] {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress});
                        continue;
                    }
                    catch (IOException var3_6) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}   IO error while reading data from BTM clients. [{}-{}] {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress});
                        try {
                            this.closeServerSocket();
                        }
                        catch (Exception var4_14) {
                            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}   Unable to close clientSocket Connection [{}-{}]: {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var4_14});
                        }
                        ** GOTO lbl181
                    }
                    catch (Exception var3_7) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Error while reading data from BTM clients [{}-{}]: {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var3_7});
                        ** GOTO lbl181
                    }
                    var14_24 = null;
                    this.whileRunning = false;
                    ** GOTO lbl-1000
lbl-1000:
                    // 1 sources

                    {
                        var6_17 = null;
                        var7_18 = false;
                        if (var5_15 instanceof MethodInfo) {
                            var8_19 = (MethodInfo)var5_15;
                            var6_17 = (String)var8_19.getProperties().get("JvmGUID");
                            var9_21 = (String)var8_19.getProperties().get("NodeID");
                            this.nick = var9_21;
                            this.guid = var6_17;
                            var7_18 = true;
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Methodinfo from jvmGUID : {} Nick : {} - {} ", new Object[]{this.logPrefix, var6_17, var9_21, this.clientSocketAddress});
                        } else if (var5_15 instanceof JVMMetricData) {
                            var8_19 = (JVMMetricData)var5_15;
                            this.guid = var6_17 = (String)var8_19.getProperties().get("JvmGUID");
                        } else if (var5_15 instanceof HashMap) {
                            var8_19 = (HashMap)var5_15;
                            this.guid = var6_17 = (String)var8_19.get("JvmGUID");
                            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} DiscoveryInfo from jvmGUID : {} = {} - {} ", new Object[]{this.logPrefix, var6_17, var8_19, this.clientSocketAddress});
                        }
                        if (var6_17.equalsIgnoreCase("")) continue;
                        var8_20 = this.validatejvmGUID(var6_17, var2_2);
                        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Result of validatejvmGUID for the jvmGUID {} {}  ", new Object[]{this.logPrefix, var6_17, var8_20});
                        if (var8_20) ** GOTO lbl-1000
                        this.whileRunning = false;
                    }
                    ** GOTO lbl157
lbl-1000:
                    // 1 sources

                    {
                        block57: {
                            var9_21 = APMComponentIDRepository.getJavaAPMComponent(var6_17);
                            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  JavaAPMComponent Object {}  for the jvmGUID  : {}", new Object[]{this.logPrefix, var9_21, var6_17});
                            if (var9_21 != null) ** GOTO lbl-1000
                            if (!var6_17.startsWith("DISCOVER_ME")) break block57;
                            APMComponentIDRepository.registerJavaComponent(var6_17, "Discover_Me", true);
                            var9_21 = APMComponentIDRepository.getJavaAPMComponent(var6_17);
                            ** GOTO lbl-1000
                        }
                        this.whileRunning = false;
                    }
                    ** GOTO lbl169
lbl-1000:
                    // 2 sources

                    {
                        this.submitDataToQueue(var6_17, var5_15);
                        var10_22 = false;
                        if (var9_21.getHandlerObject() != null && var9_21.getHandlerObject().whileRunning) {
                            if (var9_21.getHandlerObject() == this) {
                                var10_22 = var7_18 ? this.isAnyDataAvailableToSend((JavaAPMComponent)var9_21, var2_2, true) : this.isAnyDataAvailableToSend((JavaAPMComponent)var9_21, var2_2);
                            }
                        } else {
                            var11_23 = ClientSocketHandler.configSync;
                            synchronized (var11_23) {
                                if (var9_21.getHandlerObject() == null || !var9_21.getHandlerObject().whileRunning) {
                                    var9_21.setHandlerObject(this);
                                }
                            }
                        }
                        if (var10_22) continue;
                        this.sendResponseToBTMjar("OK", var2_2, var6_17);
                    }
                }
                ** GOTO lbl181
            }
            catch (Exception var3_8) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unble to read BTM data [{}-{}] {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var3_8});
                var14_28 = null;
                this.whileRunning = false;
                try {
                    if (var1_1 != null) {
                        var1_1.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    this.closeServerSocket();
                }
                catch (Exception var15_34) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_34});
                }
                break block55;
            }
            {
                catch (Throwable var13_36) {
                    var14_29 = null;
                    this.whileRunning = false;
                    ** try [egrp 9[TRYBLOCK] [57 : 1339->1362)] { 
lbl138:
                    // 1 sources

                    if (var1_1 != null) {
                        var1_1.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    this.closeServerSocket();
                    throw var13_36;
lbl144:
                    // 1 sources

                    catch (Exception var15_35) {
                        JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_35});
                    }
                    throw var13_36;
                }
lbl-1000:
                // 1 sources

                try {}
                catch (Exception var15_30) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_30});
                    return;
                }
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
                return;
lbl157:
                // 1 sources

                var14_25 = null;
                this.whileRunning = false;
                try {}
                catch (Exception var15_31) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_31});
                    return;
                }
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
                return;
lbl169:
                // 1 sources

                var14_26 = null;
                this.whileRunning = false;
                try {}
                catch (Exception var15_32) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_32});
                    return;
                }
                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
                return;
lbl181:
                // 5 sources

                var14_27 = null;
                this.whileRunning = false;
                ** try [egrp 9[TRYBLOCK] [57 : 1339->1362)] { 
lbl184:
                // 1 sources

                if (var1_1 != null) {
                    var1_1.close();
                }
                if (var2_2 != null) {
                    var2_2.close();
                }
                this.closeServerSocket();
lbl190:
                // 1 sources

                catch (Exception var15_33) {}
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Unable to close clientSocket Connection  {} {} ", new Object[]{this.logPrefix, this.nick, this.guid, this.clientSocketAddress, var15_33});
            }
        }
        this.whileRunning = false;
    }

    private void submitDataToQueue(String string, Object object) {
        ThreadPoolManager threadPoolManager = ThreadPoolManager.getInstance();
        try {
            threadPoolManager.submitTask(object);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Object [{}] added into Queue for {} Queue Size is {}", new Object[]{this.logPrefix, object, string, threadPoolManager.getQueueSize()});
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Unable to add Object to the Queue for {} {} ", new Object[]{this.logPrefix, string, exception});
        }
    }

    private boolean readData(ObjectInputStream objectInputStream, ObjectOutputStream objectOutputStream, int n, Object object) {
        String string = object.toString();
        if (string.length() == 0) {
            return true;
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Data received from btm client, Data : {} {} ", new Object[]{this.logPrefix, string, this.clientSocketAddress});
        if (string.equalsIgnoreCase("OFFLOAD - PING")) {
            this.sendResponseToBTMjar("OFFLOAD - PONG", objectOutputStream, "");
            this.sleep(1000L);
            return false;
        }
        if (string.startsWith("OFFLOAD - PING")) {
            this.handlePingMsgWithNodeID(string, objectOutputStream);
            return false;
        }
        if (string.startsWith("HeartBeatCheck")) {
            String string2 = string.replace("HeartBeatCheck!;-;!", "");
            boolean bl = false;
            if (string.endsWith("!;-;!eGTest_Config_Request")) {
                string2 = string2.replace("!;-;!eGTest_Config_Request", "");
                bl = true;
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} eGTest_Config_Request received from {} on the {}", new Object[]{this.logPrefix, string2, this.clientSocketAddress});
            }
            if (APMComponentIDRepository.isSiteIdAvailable(string2)) {
                JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string2);
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Heart beat received from {} on the {}", new Object[]{this.logPrefix, string2, this.clientSocketAddress});
                long l = System.currentTimeMillis();
                this.updateAPMDiscoveryIniFile("LAST_HEART_BEAT_CHECK_TIME", string2, l + "");
                javaAPMComponent.setHeartBeatTime(l);
                javaAPMComponent.setHeartBeatStatus(Status.HEART_BEATING);
                if (bl) {
                    javaAPMComponent.prepareConfigs();
                }
                this.isAnyDataAvailableToSend(string2, objectOutputStream);
                this.sleep(100L);
            } else if (string2.startsWith("DISCOVER_ME")) {
                this.validateDiscoveredGuid(string2, objectOutputStream);
            }
            return true;
        }
        if (string.startsWith("LogPath")) {
            String string3;
            String[] stringArray = string.split("!;-;!");
            if (stringArray != null && stringArray.length == 4 && APMComponentIDRepository.isSiteIdAvailable(string3 = stringArray[1])) {
                String string4 = stringArray[2];
                String string5 = stringArray[3];
                this.updateAPMCleanUpIniFile("LOG_PATHS", string3, string4 + "^" + string5);
                this.sendResponseToBTMjar("LogPath_OK", objectOutputStream, "");
            }
            return true;
        }
        if (string.startsWith("ACK4BTM_")) {
            this.removeConfigFromRepository(string);
            this.sendResponseToBTMjar("OK", objectOutputStream, "");
            return true;
        }
        if (string.startsWith("DISCOVER_ME")) {
            this.validateDiscoveredGuid(string, objectOutputStream);
            return false;
        }
        return true;
    }

    private boolean validateDiscoveredGuid(String string, ObjectOutputStream objectOutputStream) {
        if (APMComponentIDRepository.isThisManaged(string)) {
            String string2 = APMComponentIDRepository.getJvmGuidFromTemp(string);
            if (string2 != null && string2.length() > 0) {
                this.sendResponseToBTMjar("COMPONENT_DISCOVERD_" + string2, objectOutputStream, string);
            }
            this.sleep(100L);
            return true;
        }
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
        if (javaAPMComponent != null && javaAPMComponent.isNewlyDiscoverd()) {
            if (javaAPMComponent.isDiscoveredDetailsFinalaized()) {
                this.sendResponseToBTMjar("DISCOVERY_DETAILS_FINALIZED", objectOutputStream, string);
            } else if (javaAPMComponent.isDiscoveredDetailsStored()) {
                this.sendResponseToBTMjar("DISCOVERY_DETAILS_RECEIVED", objectOutputStream, string);
            } else {
                this.sendResponseToBTMjar("OK", objectOutputStream, string);
            }
            return true;
        }
        this.sendResponseToBTMjar("OK", objectOutputStream, string);
        return true;
    }

    private void removeConfigFromRepository(String string) {
        String string2 = string.replace("ACK4BTM_!;-;!", "");
        String[] stringArray = string2.split("!;-;!");
        String string3 = stringArray[0];
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string3);
        if (javaAPMComponent == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string4 = stringArray[i];
            if (string4.length() <= 0) continue;
            if (string4.equalsIgnoreCase("BTM_PROPS_OK")) {
                javaAPMComponent.clearPropsDetails("BusinessTransTest");
                continue;
            }
            if (string4.equalsIgnoreCase("KBTM_PROPS_OK")) {
                javaAPMComponent.clearPropsDetails("KBusinessTransTest");
                continue;
            }
            if (string4.equalsIgnoreCase("BTM_THRESH_OK")) {
                javaAPMComponent.clearThresholdDetails("BusinessTransTest");
                continue;
            }
            if (string4.equalsIgnoreCase("KBTM_THRESH_OK")) {
                javaAPMComponent.clearThresholdDetails("KBusinessTransTest");
                continue;
            }
            if (string4.equalsIgnoreCase("OFFLOAD_CONFIG_OK")) {
                javaAPMComponent.clearJVMTestConfig();
                continue;
            }
            if (string4.equalsIgnoreCase("OFFLOAD_CPC_CONFIG_OK")) {
                javaAPMComponent.clearCPCDataMap();
                continue;
            }
            if (!string4.equalsIgnoreCase("New_JvmGuid_OK")) continue;
            if (string3.startsWith("DISCOVER_ME")) {
                APMComponentIDRepository.unRegisterJavaComponent(string3, false, true);
                continue;
            }
            String string5 = APMComponentIDRepository.getJvmGuidFromTemp(string3);
            APMComponentIDRepository.unRegisterJavaComponent(string5, false, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAPMDiscoveryIniFile(String string, String string2, String string3) {
        try {
            try {
                try {
                    JavaTransactionFlowUtility.storeToIni(string, string2, string3);
                }
                catch (Exception exception) {
                    Object var6_5 = null;
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                throw throwable;
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{}  Adding Component {}  details under subject {} ", new Object[]{this.logPrefix, string2, string});
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Unable to update {} {} ", new Object[]{this.logPrefix, BTMConstants.APM_DISCOVERY_FILEPATH, exception});
        }
    }

    private void updateAPMCleanUpIniFile(String string, String string2, String string3) {
        try {
            try {
                JavaTransactionFlowUtility.addToIniFile(EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_CLEANUP, string, string2, string3);
            }
            catch (Exception exception) {
                // empty catch block
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.info("{}  Adding log path {}={}  details under subject {} ", new Object[]{this.logPrefix, string2, string3, string});
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Unable to update {} {} ", new Object[]{this.logPrefix, BTMConstants.APM_DISCOVERY_CLEANUP, exception});
        }
    }

    private ObjectInputStream getDataInputStream() {
        ObjectInputStream objectInputStream = null;
        try {
            objectInputStream = new ObjectInputStream(this.clientSocket.getInputStream());
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Unable to get  ObjectInputStream {} ", (Object)this.logPrefix, (Object)exception);
        }
        return objectInputStream;
    }

    private ObjectOutputStream getDataOutputStream() {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(this.clientSocket.getOutputStream());
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Unable to get Buffered Reader  : {} ", (Object)this.logPrefix, (Object)exception);
        }
        return objectOutputStream;
    }

    private void isAnyDataAvailableToSend(String string, ObjectOutputStream objectOutputStream) {
        JavaAPMComponent javaAPMComponent = APMComponentIDRepository.getJavaAPMComponent(string);
        if (javaAPMComponent != null) {
            this.isAnyDataAvailableToSend(javaAPMComponent, objectOutputStream);
        }
    }

    private boolean isAnyDataAvailableToSend(JavaAPMComponent javaAPMComponent, ObjectOutputStream objectOutputStream) {
        HashMap hashMap = javaAPMComponent.getJVMTestConfig();
        if (hashMap != null && hashMap.size() > 0) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(hashMap);
            arrayList.add("OK");
            this.sendResponseToBTMjar(arrayList, objectOutputStream, javaAPMComponent.getID());
        } else {
            this.sendResponseToBTMjar("OK", objectOutputStream, javaAPMComponent.getID());
        }
        return true;
    }

    private boolean isAnyDataAvailableToSend(JavaAPMComponent javaAPMComponent, ObjectOutputStream objectOutputStream, boolean bl) {
        HashMap hashMap;
        HashMap hashMap2;
        HashMap hashMap3;
        HashMap hashMap4;
        HashMap hashMap5;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        HashMap hashMap6 = javaAPMComponent.getThresholdDetails("BusinessTransTest");
        if (hashMap6 != null) {
            arrayList.add(hashMap6);
        }
        if ((hashMap5 = javaAPMComponent.getThresholdDetails("KBusinessTransTest")) != null) {
            arrayList.add(hashMap5);
        }
        if ((hashMap4 = javaAPMComponent.getPropsDetails("BusinessTransTest")) != null && hashMap4.size() > 0) {
            arrayList.add(hashMap4);
        }
        if ((hashMap3 = javaAPMComponent.getPropsDetails("KBusinessTransTest")) != null && hashMap3.size() > 0) {
            arrayList.add(hashMap3);
        }
        if ((hashMap2 = javaAPMComponent.getJVMTestConfig()) != null && hashMap2.size() > 0) {
            arrayList.add(hashMap2);
        }
        if ((hashMap = javaAPMComponent.getCPCPatternMap()) != null && hashMap.size() > 0) {
            arrayList.add(hashMap);
        }
        String string = javaAPMComponent.getID();
        if (arrayList.size() > 0) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Sending config details for the Node : {} ", (Object)this.logPrefix, (Object)string);
            arrayList.add("OK");
            this.sendResponseToBTMjar(arrayList, objectOutputStream, string);
        } else {
            this.sendResponseToBTMjar("OK", objectOutputStream, string);
        }
        return true;
    }

    private void sendResponseToBTMjar(Object object, ObjectOutputStream objectOutputStream, String string) {
        try {
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Agent sent message {}  to  {} - {} : {} ", new Object[]{this.logPrefix, object.toString(), string, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{}  Exception in sendResponseToClientSocketConnection() while sending response to client socket  : ", (Object)this.logPrefix);
        }
    }

    private boolean validatejvmGUID(String string, ObjectOutputStream objectOutputStream) {
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Validating message {}", (Object)this.logPrefix, (Object)string);
        if (string.startsWith("DISCOVER_ME")) {
            return true;
        }
        if (APMComponentIDRepository.isSiteIdAvailable(string)) {
            if (!APMComponentIDRepository.isOffloadComponentID(string)) {
                APMComponentIDRepository.registerStatusAsManagedOffload(string);
            }
            return true;
        }
        this.sendResponseToBTMjar("UNMONITORED HOST", objectOutputStream, string);
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{}  Either NodeID: {} is not managed (or) [Key] Java Business Transaction Test(s) is not configured in the eG Manager console", (Object)this.logPrefix, (Object)string);
        this.sleep(3000L);
        return false;
    }

    private void handlePingMsgWithNodeID(String string, ObjectOutputStream objectOutputStream) {
        String[] stringArray = string.split("!;-;!");
        String string2 = stringArray[1];
        if (this.validatejvmGUID(string2, objectOutputStream)) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("OFFLOAD - PONG");
            stringBuffer.append("!;-;!");
            stringBuffer.append("OK");
            this.sendResponseToBTMjar(stringBuffer.toString(), objectOutputStream, string2);
            this.sleep(2000L);
        }
    }

    private void sleep(Long l) {
        try {
            Thread.sleep(l);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void closeServerSocket() {
        try {
            if (this.clientSocket != null) {
                this.clientSocket.close();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Connection closed {} ", (Object)this.logPrefix, (Object)this.clientSocketAddress);
                this.clientSocket = null;
            }
        }
        catch (IOException iOException) {
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Unable to close connection {} ", (Object)this.logPrefix, (Object)this.clientSocketAddress);
        }
    }

    public void setRunThis(boolean bl) {
        this.runThis = bl;
        if (!this.runThis) {
            JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} closing {} ", (Object)this.logPrefix, (Object)this.clientSocketAddress);
            this.closeServerSocket();
        }
    }
}

