/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.EgLogbackManager;
import com.eg.apm.EgLogbackProperties;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class EgLogbackWatcher
extends Thread {
    private static EgLogbackWatcher instance;
    private static final long sleepPeriod = 60000L;
    private long lastModLogProps = -1L;
    private File logPropsFile = null;

    private EgLogbackWatcher() {
        this.setDaemon(true);
        this.setName("EgLogbackWatcher");
        this.start();
        System.out.println("EgLogbackWatcher Started !!!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized EgLogbackWatcher getInstance() {
        if (instance != null) return instance;
        Class<EgLogbackWatcher> clazz = EgLogbackWatcher.class;
        synchronized (EgLogbackWatcher.class) {
            if (instance != null) return instance;
            instance = new EgLogbackWatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void run() {
        String fullPropsPath = EgLogbackProperties.getLogbackPropertiesPath();
        if (fullPropsPath == null) {
            System.out.println("[EgLogbackWatcher] - Unable to find the file :eg_logback.properties");
            return;
        }
        while (true) {
            try {
                this.logPropsFile = new File(fullPropsPath);
                if (this.logPropsFile.exists()) {
                    long lastModifiedTime = this.logPropsFile.lastModified();
                    if (this.lastModLogProps < 0L) {
                        this.lastModLogProps = lastModifiedTime;
                    } else if (lastModifiedTime != this.lastModLogProps) {
                        System.out.println("[EgLogbackWatcher] - eg_logback.properties file is modified");
                        Properties logProps = new Properties();
                        logProps.load(new BufferedInputStream(new FileInputStream(this.logPropsFile)));
                        EgLogbackManager.getInstance().updateConfig(logProps);
                        this.lastModLogProps = lastModifiedTime;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.sleepForSomeTime(60000L);
        }
    }

    private void sleepForSomeTime(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

