/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMExceptionDataRepository;
import com.eg.apm.APMStatusCodeDataRepository;
import com.eg.apm.ClientSocketHandler;
import com.eg.apm.HandlerController;
import com.eg.apm.JavaAPMExceptionObject;
import com.eg.apm.JavaAPMStatusCodeObject;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.apm.SnapShotTaker;
import com.eg.apm.SnapShotTakerWatcher;
import com.eg.apm.Status;
import com.eg.jtm.PropsManager;
import com.eg.jtm.UPDManager;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaAPMComponent {
    private String componentID;
    private String nickName;
    private String hostIp;
    private String hostPort;
    private String nickWithPort;
    private String componentType;
    private ArrayList<String> entityList;
    private ArrayList<String> entityListForConfigRequest;
    private Hashtable<String, HashMap> thresholdDetails;
    private Hashtable<String, HashMap> propsDetails;
    private HashMap jvmTestConfigDetails;
    private Status ModeStatus;
    private Status ComponentOrEntityStatus;
    private Status heartBeatStatus;
    private List previousComponentNameList;
    private long heartBeatTime = -1L;
    private PropsManager propsManager = null;
    private UPDManager UPDManagerObj = null;
    private HashMap cpcPatternMap;
    private Hashtable<String, String> sessionUserMapping = null;
    private APMExceptionDataRepository javaExceptionRepository = null;
    private APMStatusCodeDataRepository javaStatusCodeDataRepository = null;
    private String jvmTimeZone = null;
    private String blockedWaitedTimeNotSupported = null;
    private String cpuTimeNotSupported = null;
    private Hashtable customPCTable = null;
    private Timer snapShotTakerTimer = null;
    private SnapShotTaker snapShotTaker = null;
    private boolean isNewlyDiscoverd = false;
    private boolean isDiscoveredDetailsStored = false;
    private boolean isDiscoveredDetailsFinalized = false;
    private boolean appServerRestarted = false;
    private boolean prepareBtmTestConfigs = false;
    private boolean prepareJvmTestConfigs = false;
    private boolean prepareCpcConfigs = false;
    private boolean prepareTresholdConfigs = false;
    protected static String loggerDispStr = "[JavaAPMComponent]";
    final HandlerController control = new HandlerController();
    private static String threshConfigRequest = "_Threshold_Config_Request";
    private static String btmConfigRequest = "_BTM_Config_Request";

    public JavaAPMComponent(String string) {
        this.componentID = string;
        this.entityList = new ArrayList();
        this.ModeStatus = Status.NONE;
        this.ComponentOrEntityStatus = Status.NEW_COMPONENT;
        this.heartBeatStatus = Status.NONE;
        this.propsManager = new PropsManager();
        this.propsManager.initProps();
        this.propsManager.applyBTMProps();
        this.UPDManagerObj = new UPDManager(this.propsManager);
        this.sessionUserMapping = new Hashtable();
        SnapShotTakerWatcher.isWatcherNull(true, string);
    }

    public JavaAPMComponent(String string, String string2, String string3, String string4, String string5) {
        this(string);
        this.nickName = string2;
        this.hostIp = string3;
        this.hostPort = string4;
        this.componentType = string5;
        this.nickWithPort = "[" + string2 + ":" + string4 + "]";
    }

    public void changeComponentOrEntityStatus() {
        this.ComponentOrEntityStatus = Status.MANAGED_ALREADY;
    }

    public boolean isComponentOrEntityStatus() {
        return this.ComponentOrEntityStatus == Status.NEW_COMPONENT || this.ComponentOrEntityStatus == Status.NEW_ENTITY;
    }

    public String getID() {
        return this.componentID;
    }

    public String getNickName() {
        return this.nickName;
    }

    public String getNickWithPort() {
        return this.nickWithPort;
    }

    public String getHostIP() {
        return this.hostIp;
    }

    public String getHostPort() {
        return this.hostPort;
    }

    public String getComponentType() {
        return this.componentType;
    }

    public void addEntity(String string) {
        if (!this.entityList.contains(string)) {
            this.entityList.add(string);
            this.ComponentOrEntityStatus = Status.NEW_ENTITY;
        }
    }

    public boolean isEntityExists(String string) {
        return this.entityList.contains(string);
    }

    public void setHandlerObject(Object object) {
        this.control.setObject(object);
    }

    public ClientSocketHandler getHandlerObject() {
        return (ClientSocketHandler)this.control.getObject();
    }

    public void removeAllEntities() {
        this.entityList = null;
        this.thresholdDetails = null;
        this.propsDetails = null;
        this.jvmTestConfigDetails = null;
        this.javaExceptionRepository = null;
        this.ModeStatus = null;
        this.propsManager = null;
        this.UPDManagerObj = null;
        this.customPCTable = null;
        this.sessionUserMapping = null;
        this.cpcPatternMap = null;
        if (this.snapShotTakerTimer != null) {
            this.snapShotTakerTimer.cancel();
        }
        this.snapShotTaker = null;
        this.snapShotTakerTimer = null;
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Full repository reset[BTM&JVM] done for {} .", (Object)loggerDispStr, (Object)this.componentID);
    }

    public void reset() {
        this.propsManager = new PropsManager();
        this.propsManager.initProps();
        this.propsManager.applyBTMProps();
        this.javaExceptionRepository = null;
        this.javaStatusCodeDataRepository = null;
        this.UPDManagerObj = new UPDManager(this.propsManager);
        this.sessionUserMapping = new Hashtable();
        JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} BTM repository reset done for {} .", (Object)loggerDispStr, (Object)this.componentID);
    }

    public void removeEntity(String string) {
        boolean bl = false;
        bl = this.entityList.remove(string);
        if (this.thresholdDetails != null) {
            this.thresholdDetails.remove(string);
        }
        if (this.propsDetails != null) {
            this.propsDetails.remove(string);
        }
        if (bl) {
            if (string.equalsIgnoreCase("BusinessTransTest")) {
                this.UPDManagerObj.clearStoredDataForBusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.componentID});
            } else if (string.equalsIgnoreCase("KBusinessTransTest")) {
                this.UPDManagerObj.clearStoredDataForKbusinessTransTest();
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Data cleared for {}:{} ", new Object[]{loggerDispStr, string, this.componentID});
            }
        }
    }

    public Status getStatus() {
        return this.ModeStatus;
    }

    public void setStatus(Status status) {
        this.ModeStatus = status;
    }

    public void setHeartBeatStatus(Status status) {
        this.heartBeatStatus = status;
    }

    public Status getHeartbeatStatus() {
        return this.heartBeatStatus;
    }

    public void setPropsDetails(String string, HashMap hashMap) {
        if (this.propsDetails == null) {
            this.propsDetails = new Hashtable(2);
            this.propsDetails.put(string, hashMap);
        } else {
            HashMap hashMap2 = this.propsDetails.get(string);
            if (hashMap2 == null) {
                this.propsDetails.put(string, hashMap);
            } else {
                hashMap2.putAll(hashMap);
                this.propsDetails.put(string, hashMap2);
            }
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Registered entity {} & its propsMap {} into master proppsDetails {} - {} .", new Object[]{loggerDispStr, string, hashMap, this.propsDetails, this.componentID});
    }

    public HashMap getPropsDetails(String string) {
        if (this.propsDetails != null) {
            return this.propsDetails.get(string);
        }
        return null;
    }

    public void clearPropsDetails(String string) {
        if (this.propsDetails != null) {
            this.propsDetails.remove(string);
        }
        try {
            if (this.propsDetails.isEmpty()) {
                this.propsDetails = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Entity - {} props details are cleared for {}, Current propsDetails - {}.", new Object[]{loggerDispStr, string, this.componentID, this.propsDetails});
    }

    public void setThresholdDetails(String string, HashMap hashMap) {
        if (this.thresholdDetails == null) {
            this.thresholdDetails = new Hashtable(2);
            this.thresholdDetails.put(string, hashMap);
        } else {
            HashMap hashMap2 = this.thresholdDetails.get(string);
            if (hashMap2 == null) {
                this.thresholdDetails.put(string, hashMap);
            } else {
                hashMap2.putAll(hashMap);
                this.thresholdDetails.put(string, hashMap2);
            }
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Registered entity {} & its threshMap {} into master thresholdDetails {} - {} .", new Object[]{loggerDispStr, string, hashMap, this.thresholdDetails, this.componentID});
    }

    public HashMap getThresholdDetails(String string) {
        if (this.thresholdDetails != null) {
            return this.thresholdDetails.get(string);
        }
        return null;
    }

    public void clearThresholdDetails(String string) {
        if (this.thresholdDetails != null) {
            this.thresholdDetails.remove(string);
        }
        try {
            if (this.thresholdDetails.isEmpty()) {
                this.thresholdDetails = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Entity - {} threshold details are cleared for {}, Current thresholdDetails - {}.", new Object[]{loggerDispStr, string, this.componentID, this.thresholdDetails});
    }

    public void setJVMTestConfig(HashMap hashMap) {
        if (this.jvmTestConfigDetails == null) {
            this.jvmTestConfigDetails = hashMap;
        } else {
            this.jvmTestConfigDetails.putAll(hashMap);
        }
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} Registered JVM test config details  for {} - {} ", new Object[]{loggerDispStr, this.componentID, hashMap});
    }

    public HashMap getJVMTestConfig() {
        return this.jvmTestConfigDetails;
    }

    public void clearJVMTestConfig() {
        if (this.jvmTestConfigDetails != null) {
            this.jvmTestConfigDetails.clear();
        }
        this.jvmTestConfigDetails = null;
        JavaBTMOffloadLogger.btmOffLoadLogger.trace("{} JVM test config details are cleared for {} - {} ", new Object[]{loggerDispStr, this.componentID, this.jvmTestConfigDetails});
    }

    public void setPreviousComponentNameList(List list) {
        this.previousComponentNameList = list;
    }

    public List getPreviousComponentNameList() {
        return this.previousComponentNameList;
    }

    public PropsManager getPropsManager() {
        return this.propsManager;
    }

    public UPDManager getUPDManager() {
        return this.UPDManagerObj;
    }

    public String getTimeZone() {
        return this.jvmTimeZone;
    }

    public Hashtable getCustomPointDetails() {
        return this.customPCTable;
    }

    public String getCPUTimeNotSupported() {
        return this.cpuTimeNotSupported;
    }

    public String getBlockedWaitTimeNotSupported() {
        return this.blockedWaitedTimeNotSupported;
    }

    public void setTimeZone(String string) {
        this.jvmTimeZone = string;
    }

    public void setBlockedWaitNotSupported(String string) {
        this.blockedWaitedTimeNotSupported = string;
    }

    public void setCpuTimeNotSupported(String string) {
        this.cpuTimeNotSupported = string;
    }

    public void setCustomPointCuts(Hashtable hashtable) {
        this.customPCTable = hashtable;
    }

    public void updateSessionUserMapping(String string, String string2) {
        this.sessionUserMapping.put(string, string2);
    }

    public HashMap getSessionUserMapping() {
        if (this.sessionUserMapping.size() > 0) {
            Hashtable hashtable = (Hashtable)this.sessionUserMapping.clone();
            this.sessionUserMapping = new Hashtable();
            HashMap hashMap = new HashMap(hashtable);
            return hashMap;
        }
        return null;
    }

    public void setHeartBeatTime(long l) {
        this.heartBeatTime = l;
    }

    public long getHeartBeatTime() {
        return this.heartBeatTime;
    }

    public APMExceptionDataRepository getApmRepositoryForException() {
        if (this.javaExceptionRepository == null) {
            this.javaExceptionRepository = new APMExceptionDataRepository();
        }
        return this.javaExceptionRepository;
    }

    public ArrayList<JavaAPMExceptionObject> getJavaAPMExceptions() {
        if (this.javaExceptionRepository != null) {
            return this.javaExceptionRepository.getExceptions();
        }
        return null;
    }

    public APMStatusCodeDataRepository getApmRepositoryForStatusCode() {
        if (this.javaStatusCodeDataRepository == null) {
            this.javaStatusCodeDataRepository = new APMStatusCodeDataRepository();
        }
        return this.javaStatusCodeDataRepository;
    }

    public ArrayList<JavaAPMStatusCodeObject> getJavaAPMStatusCode() {
        if (this.javaStatusCodeDataRepository != null) {
            return this.javaStatusCodeDataRepository.getStatusCodes();
        }
        return null;
    }

    public void updateSnapShot() {
        this.UPDManagerObj.updateTransmitCopy4Auto();
        this.UPDManagerObj.updateTransmitCopy4Manual();
        this.UPDManagerObj.cleanupDeadPatterns();
    }

    public HashMap getCPCPatternMap() {
        return this.cpcPatternMap;
    }

    public void setCPCPatternMap(HashMap hashMap) {
        if (hashMap != null && hashMap.size() > 0) {
            this.cpcPatternMap = hashMap;
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  {} - {} CPC Patterns are registered.", new Object[]{loggerDispStr, this.componentID, hashMap});
        }
    }

    public void clearCPCDataMap() {
        this.cpcPatternMap = null;
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} {} CPC Patterns are cleared.", (Object)loggerDispStr, (Object)this.componentID);
    }

    public Timer getSnapShotTakerTimer() {
        return this.snapShotTakerTimer;
    }

    public void setSnapShotTakerTimer(Timer timer) {
        this.snapShotTakerTimer = timer;
    }

    public void setSnapShotTaker(SnapShotTaker snapShotTaker) {
        this.snapShotTaker = snapShotTaker;
    }

    public SnapShotTaker getSnapShotTaker() {
        return this.snapShotTaker;
    }

    public void initiateSnapShotTaker() {
        SnapShotTakerWatcher.isWatcherNull(true, this.componentID);
    }

    public void printAPMRepositoryDetails(Logger logger) {
        if (logger.isTraceEnabled()) {
            logger.trace("{} componentID - {}, \t nickName - {}, \t hostIp - {}, \t hostPort - {}, \t nickWithPort - {}, \t componentType - {},", new Object[]{loggerDispStr, this.componentID, this.nickName, this.hostIp, this.hostPort, this.nickWithPort, this.componentType});
            logger.trace("{} ModeStatus - {}, \t ComponentOrEntityStatus - {}, \t heartBeatTime - {}, \t jvmTimeZone - {}, \t blockedWaitedTimeNotSupported - {}, \t cpuTimeNotSupported - {} ", new Object[]{loggerDispStr, this.ModeStatus, this.ComponentOrEntityStatus, this.heartBeatTime, this.jvmTimeZone, this.blockedWaitedTimeNotSupported, this.cpuTimeNotSupported});
            logger.trace("{} HandlerController {} , snapShotTakerTimer - {}, \t snapShotTaker - {}", new Object[]{loggerDispStr, this.control.getObject(), this.snapShotTakerTimer, this.snapShotTaker});
            logger.trace("{} entityList - {}, \t propsDetails - {}, \t previousComponentNameList - {}", new Object[]{loggerDispStr, this.entityList, this.propsDetails, this.previousComponentNameList});
            logger.trace("{} thresholdDetails - {}, \t  jvmTestConfigDetails - {}, \t propsManager - {}, \t UPDManagerObj - {}", new Object[]{loggerDispStr, this.thresholdDetails, this.jvmTestConfigDetails, this.propsManager, this.UPDManagerObj});
            logger.trace("{} cpcPatternMap - {}, \t sessionUserMapping - {}, \t javaExceptionRepository - {}, \t customPCTable - {}", new Object[]{loggerDispStr, this.cpcPatternMap, this.sessionUserMapping, this.javaExceptionRepository, this.customPCTable});
            logger.trace("{} heartBeatStatus - {}, appServerRestarted : {}, prepareBtmTestConfigs : {}, prepareCpcConfigs : {}, prepareJvmTestConfigs  : {}, prepareTresholdConfigs : {}, entityListForConfigRequest : {}", new Object[]{loggerDispStr, this.heartBeatStatus, this.appServerRestarted, this.prepareBtmTestConfigs, this.prepareCpcConfigs, this.prepareJvmTestConfigs, this.prepareTresholdConfigs, this.entityListForConfigRequest});
        }
    }

    public void setNewlyDiscoverd(boolean bl) {
        this.isNewlyDiscoverd = bl;
    }

    public boolean isNewlyDiscoverd() {
        return this.isNewlyDiscoverd;
    }

    public void setDiscoveredDetailsStored(boolean bl) {
        this.isDiscoveredDetailsStored = bl;
    }

    public boolean isDiscoveredDetailsStored() {
        return this.isDiscoveredDetailsStored;
    }

    public void setDiscoveredDetailsFinalized(boolean bl) {
        this.isDiscoveredDetailsFinalized = bl;
    }

    public boolean isDiscoveredDetailsFinalaized() {
        return this.isDiscoveredDetailsFinalized;
    }

    public boolean isAppServerRestarted() {
        return this.appServerRestarted;
    }

    public void prepareConfigs() {
        this.entityListForConfigRequest = new ArrayList(2);
        this.setAppServerRestarted(true);
        this.setPrepareBtmTestConfigs("BusinessTransTest", true);
        this.setPrepareBtmTestConfigs("KBusinessTransTest", true);
        this.setPrepareTresholdConfigs("BusinessTransTest", true);
        this.setPrepareTresholdConfigs("KBusinessTransTest", true);
        this.setPrepareJvmTestConfigs(true);
        this.setPrepareCpcConfigs(true);
    }

    private void setAppServerRestarted(boolean bl) {
        this.appServerRestarted = bl;
    }

    public boolean isPrepareBtmTestConfigs(String string) {
        if (this.entityListForConfigRequest != null) {
            return this.entityListForConfigRequest.contains(string + btmConfigRequest);
        }
        return this.prepareBtmTestConfigs;
    }

    public void setPrepareBtmTestConfigs(String string, boolean bl) {
        String string2 = string + btmConfigRequest;
        if (this.entityListForConfigRequest != null) {
            if (bl && !this.entityListForConfigRequest.contains(string2)) {
                this.entityListForConfigRequest.add(string2);
            } else {
                this.entityListForConfigRequest.remove(string2);
            }
        }
        this.prepareBtmTestConfigs = bl;
    }

    public boolean isPrepareJvmTestConfigs() {
        return this.prepareJvmTestConfigs;
    }

    public void setPrepareJvmTestConfigs(boolean bl) {
        this.prepareJvmTestConfigs = bl;
    }

    public boolean isPrepareCpcConfigs() {
        return this.prepareCpcConfigs;
    }

    public void setPrepareCpcConfigs(boolean bl) {
        this.prepareCpcConfigs = bl;
    }

    public boolean isPrepareTresholdConfigs(String string) {
        if (this.entityListForConfigRequest != null) {
            return this.entityListForConfigRequest.contains(string + threshConfigRequest);
        }
        return this.prepareTresholdConfigs;
    }

    public void setPrepareTresholdConfigs(String string, boolean bl) {
        String string2 = string + threshConfigRequest;
        if (this.entityListForConfigRequest != null) {
            if (bl && !this.entityListForConfigRequest.contains(string2)) {
                this.entityListForConfigRequest.add(string2);
            } else {
                this.entityListForConfigRequest.remove(string2);
            }
        }
        this.prepareTresholdConfigs = bl;
    }
}

