/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.EgInstallInfo;
import com.eg.IniFile;
import com.eg.IniHelper;
import com.eg.apm.APMDiscoveryHelper;
import com.eg.apm.APMUtils;
import com.eg.apm.EgApmFilesSync;
import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.BTMConstants;
import com.eg.jtm.BTMDiscovery;
import com.eg.org.slf4j.Logger;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTransactionFlowUtility {
    private static final Hashtable<String, BTMDiscovery> BTMDiscoveryTable = new Hashtable();
    protected static final String loggerDispStr = "[JavaTransactionFlowUtility]";
    private static final HashMap AppflowTargetJvms = new HashMap();
    private static final String EG_APM_TEMP_INI = EgInstallInfo.getInstallDir() + BTMConstants.UNIQUE_JVM_FILEPATH;
    private static final String EG_APM_DISCOVERY_INI = EgInstallInfo.getInstallDir() + BTMConstants.APM_DISCOVERY_FILEPATH;

    public static void retriveTransactionFlowDetails(Map map, String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (!BTMDiscoveryTable.containsKey(string)) {
                BTMDiscoveryTable.put(string, new BTMDiscovery());
            }
            TreeSet<Object> treeSet = new TreeSet<Object>();
            HashMap<String, String> hashMap = new HashMap<String, String>();
            HashMap hashMap2 = (HashMap)map.remove("TRANSACTION_FLOW_DETAILS");
            if (hashMap2 != null && hashMap2.size() > 0) {
                object4 = (HashMap)hashMap2.clone();
                object3 = ((HashMap)object4).keySet().iterator();
                while (object3.hasNext()) {
                    object2 = object3.next();
                    object = (String)object2;
                    if (!((String)object).startsWith("UNIQUE_JVM_GUID")) continue;
                    hashMap2.remove(object);
                    String string2 = ((String)object).substring(((String)object).lastIndexOf("_") + 1);
                    String string3 = ((String)object).substring(((String)object).lastIndexOf("#") + 1, ((String)object).lastIndexOf("_"));
                    hashMap.put(string2, JavaTransactionFlowUtility.getIpPortUsingHttpUrl(string3));
                    treeSet.add(string2);
                }
            }
            if (hashMap != null && hashMap.size() > 0) {
                JavaTransactionFlowUtility.storeUniqueJvmGuidIntoTemp(hashMap);
            }
            object4 = string;
            if (treeSet.size() == 0) {
                treeSet.add(object4);
            }
            if ((object3 = (TreeSet)AppflowTargetJvms.get(object4)) == null) {
                if (treeSet.size() > 0) {
                    AppflowTargetJvms.put(object4, treeSet);
                }
            } else if (treeSet.size() > 0) {
                ((TreeSet)object3).addAll(treeSet);
            }
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} AppflowTargetJvms - {} ", (Object)loggerDispStr, (Object)AppflowTargetJvms);
            JavaBTMOffloadLogger.btmOffLoadLogger.debug("{}  Java Transaction Flow Test details getting updated for Node id {} : {} ", new Object[]{loggerDispStr, string, hashMap2});
            object2 = BTMDiscoveryTable.get(string);
            object = ((BTMDiscovery)object2).getWorkingCopy();
            ((Vector)object).add(hashMap2);
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.warn("{} Exception while retriving Transaction flow test data !!...{} ", (Object)loggerDispStr, (Object)exception);
        }
    }

    public static BTMDiscovery getBTMDiscoveryObject(String string) {
        BTMDiscovery bTMDiscovery = BTMDiscoveryTable.get(string);
        return bTMDiscovery;
    }

    public static Hashtable getBTMDiscoveryObject() {
        return BTMDiscoveryTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void storeUniqueJvmGuidIntoTemp(HashMap<String, String> hashMap) {
        IniFile iniFile = EgApmFilesSync.getInstance(EG_APM_TEMP_INI);
        try {
            try {
                if (hashMap != null) {
                    Iterator<String> iterator = hashMap.keySet().iterator();
                    while (iterator.hasNext()) {
                        boolean bl;
                        String string;
                        String string2 = string = iterator.next();
                        String string3 = hashMap.get(string2);
                        if (string2.startsWith("[")) {
                            string2 = string2.substring(string2.indexOf("[") + 1, string2.lastIndexOf("]"));
                        }
                        if (bl = JavaTransactionFlowUtility.isDetailsAvailableInFile(iniFile, string2, "NEW_UNIQUE_JVM_DETAILS")) {
                            JavaBTMOffloadLogger.btmOffLoadLogger.info("{}  JVM Unique Key Details {} already available with value {}", new Object[]{loggerDispStr, string2, string3});
                            continue;
                        }
                        iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string2, string3);
                        JavaTransactionFlowUtility.getAndStoreUniqueJvmDetails(iniFile);
                        JavaBTMOffloadLogger.btmOffLoadLogger.info("{} Adding JVM Unique Key Details [ {} ] with value [{}] details under subject [{}]", new Object[]{loggerDispStr, string2, string3, "NEW_UNIQUE_JVM_DETAILS"});
                    }
                }
                Object var8_8 = null;
                iniFile.saveFile();
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while storing data into INI files {}", (Object)loggerDispStr, (Object)exception);
                Object var8_9 = null;
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance(iniFile);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
            throw throwable;
        }
        EgApmFilesSync.releaseInstance(iniFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void storeAutoNameIntoIniFile(HashMap hashMap, String string, String string2, String string3, Logger logger) {
        if (hashMap == null) return;
        if (hashMap.size() < 0) {
            return;
        }
        IniFile iniFile = EgApmFilesSync.getInstance(EG_APM_TEMP_INI);
        try {
            try {
                for (Object k : hashMap.keySet()) {
                    boolean bl;
                    String string4 = k.toString();
                    String string5 = hashMap.get(string4).toString();
                    if (string4.startsWith("[") && string4.endsWith("]")) {
                        string4 = string4.substring(string4.indexOf("[") + 1, string4.lastIndexOf("]"));
                    }
                    if (string5.startsWith("[") && string5.endsWith("]")) {
                        string5 = string5.substring(string5.indexOf("[") + 1, string5.lastIndexOf("]"));
                        string5 = string5.replace(", ", ",");
                    }
                    if (bl = JavaTransactionFlowUtility.isDetailsAvailableInFile(iniFile, string4, string5, string, string2, true, string3, logger)) {
                        logger.info("{} Appflow Naming Details = {} already available with value = {}", new Object[]{loggerDispStr, string4, string5});
                        continue;
                    }
                    iniFile.setValue(string, string4, string5);
                    logger.info("{} Adding appflow name Details [{}] with value [{}] details under subject [{}]", new Object[]{loggerDispStr, string4, string5, string});
                }
                Object var12_12 = null;
                iniFile.saveFile();
            }
            catch (Exception exception) {
                logger.error("{} Exception while storing data into INI files {}", (Object)loggerDispStr, (Object)exception);
                Object var12_13 = null;
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance(iniFile);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
            throw throwable;
        }
        EgApmFilesSync.releaseInstance(iniFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void storeAppTiernameIntoTemp(String string, String string2, String string3) {
        IniFile iniFile = EgApmFilesSync.getInstance(EG_APM_TEMP_INI);
        try {
            try {
                String string4;
                boolean bl;
                if (string.startsWith("[")) {
                    string = string.substring(string.indexOf("[") + 1, string.lastIndexOf("]"));
                }
                if (bl = JavaTransactionFlowUtility.isDetailsAvailableInFile(iniFile, string4 = string2 + ":" + string, string3, "NEW_APPLICATION_NAME_DETAILS", "SEND_APPLICATION_NAME_DETAILS", false, "", JavaBTMOffloadLogger.btmOffLoadLogger)) {
                    JavaBTMOffloadLogger.btmOffLoadLogger.info("{} App&Tier name Details {} already available with value {} ", new Object[]{loggerDispStr, string4, string3});
                }
                iniFile.setValue("NEW_APPLICATION_NAME_DETAILS", string4, string3);
                JavaTransactionFlowUtility.getAndStoreUniqueJvmDetails(iniFile);
                JavaBTMOffloadLogger.btmOffLoadLogger.info("{} App&Tier name Details [ {} ] with value [{}] details under subject [{}]", new Object[]{loggerDispStr, string4, string3, "NEW_APPLICATION_NAME_DETAILS"});
            }
            catch (Exception exception) {
                JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while storing App&Tier name data into INI files {} ", (Object)loggerDispStr, (Object)exception);
                Object var7_8 = null;
                iniFile.saveFile();
                EgApmFilesSync.releaseInstance(iniFile);
                return;
            }
            Object var7_7 = null;
            iniFile.saveFile();
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            iniFile.saveFile();
            EgApmFilesSync.releaseInstance(iniFile);
            throw throwable;
        }
        EgApmFilesSync.releaseInstance(iniFile);
    }

    private static void getAndStoreUniqueJvmDetails(IniFile iniFile) {
        IniFile iniFile2 = new IniFile(EG_APM_DISCOVERY_INI);
        try {
            String[] stringArray = iniFile2.getVariables("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING");
            if (stringArray != null && stringArray.length > 0) {
                long l = stringArray.length;
                Vector vector = iniFile2.getAllValues("JAVA_UNIQUE_GUID_COMPONENT_NAME_MAPPING");
                int n = 0;
                while ((long)n < l) {
                    String string = (String)vector.get(n);
                    if (string.startsWith("[")) {
                        string = string.substring(string.indexOf("[") + 1, string.lastIndexOf("]"));
                    }
                    if (string.length() > 0) {
                        iniFile.setValue("NEW_UNIQUE_JVM_DETAILS", string, stringArray[n]);
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Exception while reading data from INI files {}", (Object)loggerDispStr, (Object)exception);
        }
    }

    private static String getIpPortUsingHttpUrl(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            URL uRL = new URL(string);
            if (uRL.getPort() < 0) {
                stringBuffer.append(uRL.getHost()).append(":").append(uRL.getDefaultPort());
            } else {
                stringBuffer.append(uRL.getHost()).append(":").append(uRL.getPort());
            }
        }
        catch (Exception exception) {
            JavaBTMOffloadLogger.btmOffLoadLogger.error("{} Error while creating webservice and http TFT URL : {}", (Object)loggerDispStr, (Object)exception);
        }
        return stringBuffer.toString();
    }

    public static boolean storeToIni(String string, String string2, String string3) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 & string3 != null && string3.length() > 0) {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            arrayList.add(APMUtils.getIniHelper(string, string2, string3));
            return APMDiscoveryHelper.storeToIni(arrayList, null);
        }
        return false;
    }

    public static boolean storeToIni(String string, String string2, String string3, boolean bl) {
        if (string != null && string.length() > 0 && string2 != null && string2.length() > 0 & string3 != null && string3.length() > 0) {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            arrayList.add(APMUtils.getIniHelper(string, string2, string3));
            return APMDiscoveryHelper.storeToIni(null, arrayList);
        }
        return false;
    }

    public static boolean addToIniFile(String string, String string2, String string3, String string4) {
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 & string4 != null && string4.length() > 0) {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            arrayList.add(APMUtils.getIniHelper(string2, string3, string4));
            return APMDiscoveryHelper.saveToIni(string, arrayList, null);
        }
        return false;
    }

    public static boolean deleteFromIniFile(String string, String string2, String string3, String string4, boolean bl) {
        if (string2 != null && string2.length() > 0 && string3 != null && string3.length() > 0 & string4 != null && string4.length() > 0) {
            ArrayList<IniHelper> arrayList = new ArrayList<IniHelper>();
            arrayList.add(APMUtils.getIniHelper(string2, string3, string4));
            return APMDiscoveryHelper.saveToIni(string, null, arrayList);
        }
        return false;
    }

    private static boolean isDetailsAvailableInFile(IniFile iniFile, String string, String string2) {
        String string3 = iniFile.getValue(string2, string);
        return string3 != null && string3.length() > 0;
    }

    private static boolean isDetailsAvailableInFile(IniFile iniFile, String string, String string2, String string3, String string4, boolean bl, String string5, Logger logger) {
        String string6 = iniFile.getValue(string4, string);
        logger.trace("{} reportingName {} , available {} & infoValue {} ", new Object[]{loggerDispStr, string5, string6, string2});
        if (string6.length() > 0 && string2.equals(string6)) {
            return true;
        }
        if (string6.length() > 0 && !string2.equals(string6) && bl) {
            String[] stringArray = string6.split(",");
            List<String> list = Arrays.asList(stringArray);
            String[] stringArray2 = string2.split(",");
            List<String> list2 = Arrays.asList(stringArray2);
            logger.trace("{} newCompList {}", (Object)loggerDispStr, list2);
            logger.trace("{} existingCompList {}", (Object)loggerDispStr, list);
            boolean bl2 = false;
            for (int i = 0; i < list2.size(); ++i) {
                String string7 = list2.get(i);
                if (!list.contains(string7)) {
                    bl2 = false;
                    logger.trace("{} Component {} not exist in the list {}", new Object[]{loggerDispStr, string7, list});
                    break;
                }
                logger.trace("{} Component {} already exist in the list {}", new Object[]{loggerDispStr, string7, list});
                bl2 = true;
            }
            return bl2;
        }
        return false;
    }

    public static HashMap getAppflowTargetJvms() {
        return (HashMap)AppflowTargetJvms.clone();
    }
}

