/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMNodeWorker;
import com.eg.apm.NodeBTM;
import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeCache;
import com.eg.apm.NodeDataRepository;
import com.eg.apm.NodeError;
import com.eg.apm.NodeErrorCluster;
import com.eg.apm.NodeExternalCallDetails;
import com.eg.apm.NodeHttp;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeNoSql;
import com.eg.apm.NodeSql;
import com.eg.apm.NodeTraceSpan;
import com.eg.jtm.NodeMethodInfo;
import com.eg.jtm.NodePropsManager;
import com.eg.org.slf4j.Logger;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NodeBTMDataParser {
    public static final String INFRA = "infra";
    public static final String ERROR = "error";
    protected static final Logger log = NodeBTMLogger.nodeLogger;
    public String logPrefix = " [" + this.getClass().getName() + "] ";
    public boolean isPrefixed = false;
    private static final String callTraceDelimiter = "#=#";
    private static final String callTraceLineDelimiter = "%*%";
    private static final String callTraceTimeDelimiter = "~$~";
    private static final String NOT_Available = "N/A";

    public void computeDDData(String siteId, String firstObject) {
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public ArrayList computeTestData(String siteId, String nodeMetrics, String type) {
        if (type.equals("cpu_dump") || type.equals("memory_dump")) {
            if (!NodeDataRepository.isInfraIdExists(siteId)) {
                log.info("{} New site id is initialized in NodeRepo in infra table : {}", (Object)this.logPrefix, (Object)siteId);
                NodeDataRepository.setInfraById(siteId, new NodeInfraCluster());
            } else {
                log.debug("{} site id is already exists in NodeRepo in infra table : {}", (Object)this.logPrefix, (Object)siteId);
            }
            NodeInfraCluster currentInfraObject = NodeDataRepository.getInfraById(siteId);
            try {
                if (type.equals("cpu_dump")) {
                    log.debug("{} CPU dump file stored in Repo => {}", (Object)this.logPrefix, (Object)nodeMetrics);
                    currentInfraObject.setCpuDump(nodeMetrics);
                } else if (type.equals("memory_dump")) {
                    log.debug("{} memory dump file stored in Repo => {} ", (Object)this.logPrefix, (Object)nodeMetrics);
                    currentInfraObject.setMemoryDump(nodeMetrics);
                }
                NodeDataRepository.setInfraById(siteId, currentInfraObject);
            }
            catch (Exception e) {
                log.error("{} Exception while storing the dump in node repo {}", (Object)this.logPrefix, (Object)e);
            }
            return null;
        }
        int workerCount = 0;
        boolean isMaster = true;
        String pid = null;
        NodeMethodInfo minfo = null;
        ArrayList<NodeMethodInfo> minfoDataList = new ArrayList<NodeMethodInfo>();
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        try {
            if (!this.isPrefixed) {
                this.isPrefixed = true;
            }
            JSONParser parser = new JSONParser();
            try {
                JSONArray array = (JSONArray)parser.parse(nodeMetrics);
                int i = 0;
                while (i < array.size()) {
                    block93: {
                        JSONObject jsonobj = (JSONObject)array.get(i);
                        if (jsonobj == null) {
                            log.error("{} parsed infra object is null", (Object)this.logPrefix);
                        } else if (jsonobj.containsKey((Object)INFRA)) {
                            log.trace("{} INFRA MEASURES => {}", (Object)this.logPrefix, (Object)jsonobj);
                            JSONObject infraJSON = (JSONObject)jsonobj.get((Object)INFRA);
                            JSONObject errorJSON = (JSONObject)infraJSON.get((Object)ERROR);
                            NodeError errorObj = null;
                            if (errorJSON != null) {
                                block92: {
                                    log.trace("{} INFRA UNCAUGHT EXCEPTION received => {}", (Object)this.logPrefix, (Object)jsonobj);
                                    try {
                                        errorObj = (NodeError)objectMapper.readValue(errorJSON.toJSONString(), NodeError.class);
                                        if (errorObj != null) break block92;
                                        log.info("{} error object is NULL", (Object)this.logPrefix);
                                        break block93;
                                    }
                                    catch (Exception parserError) {
                                        log.error("{} Node infra JSONObject parsing error {}", (Object)this.logPrefix, (Object)parserError);
                                    }
                                }
                                log.info(" {} data received for error obj", (Object)this.logPrefix);
                                log.trace("{} Error date time:: {}", (Object)this.logPrefix, (Object)errorObj.getErrorTime());
                                log.trace("{} Error message:: {}", (Object)this.logPrefix, (Object)errorObj.getMessage());
                                log.trace("{} Error stack:: {}", (Object)this.logPrefix, (Object)errorObj.getStack());
                                log.debug("{} Node error-Processid: {}", (Object)this.logPrefix, (Object)errorObj.getProcessID());
                                log.debug("{} Node error-IS master: {}", (Object)this.logPrefix, (Object)errorObj.isMaster());
                                log.debug("{} Node error-Worker count: {}", (Object)this.logPrefix, (Object)errorObj.getWorkerCount());
                                pid = errorObj.getProcessID();
                                isMaster = errorObj.isMaster();
                                workerCount = errorObj.getWorkerCount();
                                if (!NodeDataRepository.isErrorClusterIdExists(siteId)) {
                                    log.debug("{} New site id is initialized in NodeRepo in error table : {}", (Object)this.logPrefix, (Object)siteId);
                                    NodeDataRepository.setErrorClusterById(siteId, new NodeErrorCluster());
                                }
                                NodeErrorCluster currentErrorObj = NodeDataRepository.getErrorClusterById(siteId);
                                log.debug("{} error is from nodejs Master", (Object)this.logPrefix);
                                currentErrorObj.getMaster().add(errorObj);
                                NodeDataRepository.setErrorClusterById(siteId, currentErrorObj);
                                log.debug("{} Error object inserted into the node data repo", (Object)this.logPrefix);
                                return null;
                            }
                            NodeInfra infraObject = (NodeInfra)objectMapper.readValue(infraJSON.toJSONString(), NodeInfra.class);
                            pid = infraObject.getProcessID();
                            isMaster = infraObject.isMaster();
                            workerCount = infraObject.getWorkerCount();
                            log.info("PID : {}  isMaster : {}  workerCount : {}", new Object[]{pid, isMaster, workerCount});
                            try {
                                if (!NodeDataRepository.isInfraIdExists(siteId)) {
                                    log.info("{} New site id is initialized in NodeRepo in infra table : {}", (Object)this.logPrefix, (Object)siteId);
                                    NodeDataRepository.setInfraById(siteId, new NodeInfraCluster());
                                } else {
                                    log.info("{} site id is already exists in NodeRepo in infra table : {}", (Object)this.logPrefix, (Object)siteId);
                                }
                                NodeInfraCluster currentInfraObject = NodeDataRepository.getInfraById(siteId);
                                log.trace("{} CURRENT INFRA OBJECT {}", (Object)this.logPrefix, (Object)currentInfraObject);
                                if (isMaster) {
                                    log.info("{} metrics are from nodejs master", (Object)this.logPrefix);
                                    try {
                                        currentInfraObject.setMaster(infraObject);
                                    }
                                    catch (Exception e) {
                                        log.error("{} Exception while storing data into infra master table {}", (Object)this.logPrefix, (Object)e);
                                    }
                                    if (currentInfraObject.getWorkerCount() != workerCount) {
                                        currentInfraObject.setWorkerCount(workerCount);
                                    }
                                    log.info("{} metrics are from nodejs MASTER", (Object)this.logPrefix);
                                } else {
                                    log.info("{} metrics are from nodejs Worker", (Object)this.logPrefix);
                                    try {
                                        currentInfraObject.setWorker(pid, infraObject);
                                    }
                                    catch (Exception e) {
                                        log.error("Exception while storing data into infra worker table {}", (Throwable)e);
                                    }
                                }
                                log.info("{} Inserted into REPO", (Object)this.logPrefix);
                                NodeDataRepository.setInfraById(siteId, currentInfraObject);
                            }
                            catch (Exception e) {
                                log.error("{} Error while storing infra into repo {}", (Object)this.logPrefix, (Object)e);
                            }
                        } else if (jsonobj.containsKey((Object)"btm")) {
                            log.trace("{} BTM MEASURES => {}", (Object)this.logPrefix, (Object)jsonobj);
                            NodeBTM btmObject = null;
                            try {
                                JSONObject btmJSON = (JSONObject)jsonobj.get((Object)"btm");
                                log.trace("{} BTM JSON => {}", (Object)this.logPrefix, (Object)btmJSON);
                                btmObject = (NodeBTM)objectMapper.readValue(btmJSON.toJSONString(), NodeBTM.class);
                                if (btmObject != null) {
                                    NodePropsManager nodePropsManager = APMNodeWorker.getValueFromPropsManagerTable(siteId);
                                    Properties props = new Properties();
                                    props.setProperty("siteID", siteId);
                                    props.setProperty("PS", btmObject.getUri());
                                    boolean tr = true;
                                    boolean fal = false;
                                    props.put("keyTransaction", (Object)fal);
                                    props.put("isSQLPresent", (Object)fal);
                                    props.put("isSlowURL", (Object)fal);
                                    props.put("isErrorURL", (Object)fal);
                                    props.put("isStalled", (Object)fal);
                                    props.put("CONTEXT", btmObject.getUri());
                                    props.put("remoteHost", btmObject.getRemote_host());
                                    props.put("Thread_GUID", btmObject.getThreadGuid());
                                    props.put("SlowLimit", (Object)Double.parseDouble(btmObject.getSlowThreshOld()));
                                    props.put("StalledLimit", (Object)Double.parseDouble(btmObject.getStallThreshOld()));
                                    props.put("QUERYSTRING", btmObject.getQueryString());
                                    props.put("SESSIONID", btmObject.getSessid());
                                    props.put("THREAD", btmObject.getThreadId());
                                    props.put("DEVICE", btmObject.getDevice());
                                    props.put("OS", btmObject.getOs());
                                    props.put("BROWSER", btmObject.getBrowser());
                                    props.put("REFERER", btmObject.getReferer());
                                    int statusCode = btmObject.getStatusCode();
                                    if (statusCode == 404) {
                                        props.put("STATUS", (Object)statusCode);
                                        props.put("isErrorURL", (Object)true);
                                    } else {
                                        props.put("STATUS", (Object)statusCode);
                                    }
                                    try {
                                        String headers;
                                        Hashtable headersDetails;
                                        if (nodePropsManager != null && (nodePropsManager.captureHttpHeadersDetails() || nodePropsManager.captureHttpCookiesDetails()) && (headersDetails = this.getHeadersDeails(headers = btmObject.getHeaders())) != null) {
                                            props.put("HEADERS", headersDetails);
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error("{} error while getting Headers {}", (Object)this.logPrefix, (Object)e);
                                    }
                                    props.put("METHODTYPE", btmObject.getMethod());
                                    props.put("GUID", String.valueOf(btmObject.getEg_guid()) + "#~#" + btmObject.getNodeOrder());
                                    String reqTime = btmObject.getReqTime();
                                    Date date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss").parse(reqTime);
                                    SimpleDateFormat finalDate = new SimpleDateFormat("dd/MM/yy hh:mm:ss a", Locale.US);
                                    String requestTime = finalDate.format(date);
                                    props.put("requestID", String.valueOf(btmObject.getUri()) + " @ " + requestTime);
                                    props.put("DataBaseHT", "true");
                                    props.put("TimeZone", btmObject.getTz());
                                    props.setProperty("requestType", btmObject.getReqType());
                                    props.put("cpuTime", (Object)Long.parseLong(String.valueOf(btmObject.getCpuTime())));
                                    props.put("blockedTime", (Object)Long.parseLong(String.valueOf(btmObject.getBlockTime())));
                                    props.put("waitedTime", (Object)Long.parseLong(String.valueOf(btmObject.getWaitTime())));
                                    props.setProperty("urlPatternsMatched", btmObject.getUri());
                                    HashMap<Long, NodeMethodInfo> childMapReference = new HashMap<Long, NodeMethodInfo>();
                                    minfo = new NodeMethodInfo();
                                    minfo.setType("HTTP");
                                    int resTime = btmObject.getResTime();
                                    double slowThesh = 4000.0;
                                    long stalledThesh = 60000L;
                                    if (nodePropsManager != null) {
                                        slowThesh = nodePropsManager.getGlobalSlowURLThreshold();
                                        stalledThesh = nodePropsManager.getGlobalStalledThreshold();
                                    }
                                    try {
                                        minfo.setExecutionTime(Long.parseLong(String.valueOf(resTime)));
                                        if ((double)resTime >= slowThesh && (long)resTime < stalledThesh) {
                                            props.put("isSlowURL", (Object)true);
                                        } else if ((long)resTime >= stalledThesh) {
                                            props.put("isStalled", (Object)true);
                                        }
                                    }
                                    catch (Exception e) {
                                        log.error("{} error while setting slow and stalled threshold {}", (Object)this.logPrefix, (Object)e);
                                    }
                                    minfo.setExecutionTime(Long.parseLong(String.valueOf(resTime)));
                                    NodeTraceSpan[] callTraceArr = btmObject.getCallTrace();
                                    StringBuilder callTraceStrB = new StringBuilder();
                                    long callTraceStartTime = callTraceArr[0].getStartTime();
                                    if (callTraceArr != null) {
                                        int callTraceArrLength = callTraceArr.length;
                                        int j = 0;
                                        while (j < callTraceArrLength) {
                                            NodeTraceSpan span = callTraceArr[j];
                                            if (j == 0) {
                                                callTraceStrB.append("0");
                                            } else {
                                                callTraceStrB.append("0." + (j - 1));
                                            }
                                            callTraceStrB.append(callTraceDelimiter);
                                            if (j == 0) {
                                                callTraceStrB.append(btmObject.getResTime());
                                            } else {
                                                callTraceStrB.append(NOT_Available);
                                            }
                                            callTraceStrB.append(callTraceDelimiter);
                                            long startTime = span.getStartTime();
                                            callTraceStrB.append(span.getDuration());
                                            callTraceStrB.append(callTraceDelimiter);
                                            callTraceStrB.append(span.getName());
                                            callTraceStrB.append(callTraceDelimiter);
                                            callTraceStrB.append(span.getType());
                                            callTraceStrB.append(callTraceTimeDelimiter);
                                            callTraceStrB.append(startTime - callTraceStartTime);
                                            callTraceStrB.append(callTraceLineDelimiter);
                                            ++j;
                                        }
                                    }
                                    props.put("callTrace", callTraceStrB.toString());
                                    NodeExternalCallDetails externalCallDetails = null;
                                    NodeHttp[] httpArray = null;
                                    NodeSql[] sqlArray = null;
                                    NodeNoSql[] noSqlArray = null;
                                    NodeCache[] cacheArray = null;
                                    HashMap<String, StringBuffer> fastSqlDetails = new HashMap<String, StringBuffer>();
                                    externalCallDetails = btmObject.getExternalCallDetails();
                                    int extraCountsByException = 0;
                                    if (externalCallDetails != null) {
                                        block95: {
                                            block94: {
                                                try {
                                                    httpArray = externalCallDetails.getHttp();
                                                    if (httpArray != null) {
                                                        int httpSize = 0;
                                                        httpSize = httpArray.length;
                                                        NodeMethodInfo innerMethodinfo = null;
                                                        if (httpSize > 0) {
                                                            int httpCount = 0;
                                                            while (httpCount < httpSize) {
                                                                innerMethodinfo = new NodeMethodInfo();
                                                                NodeHttp httpNode = httpArray[httpCount];
                                                                long id = httpCount + 1;
                                                                innerMethodinfo.setId(id);
                                                                innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(httpNode.getResTime())));
                                                                innerMethodinfo.setType("HTTP");
                                                                Properties propsInner = new Properties();
                                                                propsInner.put("EXTURL", httpNode.getUri());
                                                                propsInner.put("METHOD", httpNode.getMethod());
                                                                String nodeOrder = httpNode.getNodeOrder();
                                                                propsInner.put("NODE_ORDER", String.valueOf(httpNode.getNodeOrder()));
                                                                propsInner.put("SC", String.valueOf(httpNode.getStatusCode()));
                                                                propsInner.put("RM", "-");
                                                                int innerStatusCode = httpNode.getStatusCode();
                                                                boolean addExtraMinfo = false;
                                                                if (innerStatusCode == 404) {
                                                                    addExtraMinfo = true;
                                                                    propsInner.put("STATUS", (Object)innerStatusCode);
                                                                    propsInner.put("isErrorURL", (Object)true);
                                                                    innerMethodinfo.setType("EXCEPTION");
                                                                    String httpError = httpNode.getError().replace("\\n", "?^?");
                                                                    propsInner.put("EXCEPTION", httpError);
                                                                } else {
                                                                    propsInner.put("STATUS", (Object)innerStatusCode);
                                                                    innerMethodinfo.setType("HTTP");
                                                                }
                                                                innerMethodinfo.setProperties(propsInner);
                                                                if (innerMethodinfo != null) {
                                                                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                                                                }
                                                                if (addExtraMinfo) {
                                                                    id = id + (long)httpSize + 1000L;
                                                                    ++extraCountsByException;
                                                                    addExtraMinfo = false;
                                                                    NodeMethodInfo innerMethodinfotemp = new NodeMethodInfo();
                                                                    innerMethodinfotemp.setId(id);
                                                                    innerMethodinfotemp.setExecutionTime(Long.parseLong(String.valueOf(httpNode.getResTime())));
                                                                    innerMethodinfotemp.setType("HTTP");
                                                                    propsInner.put("STATUS", (Object)innerStatusCode);
                                                                    innerMethodinfotemp.setProperties(propsInner);
                                                                    minfo.addToChildInfo(childMapReference, innerMethodinfotemp);
                                                                    log.warn("{} addExtraMinfo innerMethodinfo.getProperties(): {}", (Object)this.logPrefix, (Object)innerMethodinfotemp.getProperties());
                                                                    log.warn("{} addExtraMinfo innerMethodinfo.getType(): {} ", (Object)this.logPrefix, (Object)innerMethodinfotemp.getType());
                                                                    log.warn("{} addExtraMinfo nnerMethodinfo.getId(): {}", (Object)this.logPrefix, (Object)innerMethodinfotemp.getId());
                                                                }
                                                                ++httpCount;
                                                            }
                                                        }
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.error(String.valueOf(this.logPrefix) + "exception occurred while getting outbound calls", (Throwable)e);
                                                }
                                                try {
                                                    if (externalCallDetails.getFastQuery() != null && externalCallDetails.getFastQuery().size() > 0) {
                                                        HashMap<String, String> fastSqlMap = externalCallDetails.getFastQuery();
                                                        for (String key : fastSqlMap.keySet()) {
                                                            String sqlExecTimes = fastSqlMap.get(key);
                                                            fastSqlDetails.put(key, new StringBuffer(fastSqlMap.get(key)));
                                                        }
                                                    }
                                                    sqlArray = externalCallDetails.getSql();
                                                    int httpSize = 0;
                                                    httpSize = httpArray.length;
                                                    httpSize += extraCountsByException;
                                                    int sqlSize = 0;
                                                    if (sqlArray == null || (sqlSize = sqlArray.length) <= 0) break block94;
                                                    int sqlCount = 0;
                                                    while (sqlCount < sqlSize) {
                                                        NodeMethodInfo innerMethodinfo = new NodeMethodInfo();
                                                        NodeSql sqlNode = sqlArray[sqlCount];
                                                        long id = httpSize + sqlCount + 1;
                                                        innerMethodinfo.setId(id);
                                                        int sqlResTime = sqlNode.getResTime();
                                                        innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                                                        try {
                                                            if (nodePropsManager != null) {
                                                                if ((double)sqlResTime > nodePropsManager.getSQLExecCutOff()) {
                                                                    props.put("isSQLPresent", (Object)true);
                                                                    ArrayList<Double> slowSQLTimeDetails = new ArrayList<Double>();
                                                                    slowSQLTimeDetails.add(Double.valueOf(sqlResTime));
                                                                    props.put("SlowSQLTime", slowSQLTimeDetails);
                                                                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                                                                    innerMethodinfo.setType("SQL");
                                                                    Properties propsInner = new Properties();
                                                                    propsInner.put("sqlStmt", sqlNode.getQuery());
                                                                    propsInner.put("jdbcUrl", "jdbc:" + sqlNode.getServerType() + "://" + sqlNode.getHost() + ":" + sqlNode.getPort() + "/" + sqlNode.getDbName());
                                                                    String errStack = sqlNode.getError().replace("\\n", "?^?");
                                                                    propsInner.put("sqlError", errStack);
                                                                    propsInner.put("stackTrace", errStack);
                                                                    innerMethodinfo.setProperties(propsInner);
                                                                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                                                                } else {
                                                                    String url = "jdbc:" + sqlNode.getServerType() + "://" + sqlNode.getHost() + ":" + sqlNode.getPort() + "/" + sqlNode.getDbName();
                                                                    if (fastSqlDetails.containsKey(url)) {
                                                                        StringBuffer mergedResTime = ((StringBuffer)fastSqlDetails.get(url)).append(",").append(Integer.toString(sqlResTime));
                                                                        fastSqlDetails.put(url, mergedResTime);
                                                                    } else {
                                                                        fastSqlDetails.put(url, new StringBuffer(Integer.toString(sqlResTime)));
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        catch (Exception e) {
                                                            log.error("{} error while getting SQL execution cutoff {} ", (Object)this.logPrefix, (Object)e);
                                                        }
                                                        ++sqlCount;
                                                    }
                                                }
                                                catch (Exception e) {
                                                    log.error("{} exception occurred while getting sql calls {} ", (Object)this.logPrefix, (Object)e);
                                                }
                                            }
                                            if (fastSqlDetails.size() > 0) {
                                                props.put("Fast_Method_Map", fastSqlDetails);
                                            }
                                            try {
                                                noSqlArray = externalCallDetails.getNosql();
                                                int httpSize = 0;
                                                httpSize = httpArray.length;
                                                int sqlSize = 0;
                                                sqlSize = sqlArray.length;
                                                int nosqlSize = 0;
                                                if (noSqlArray == null || (nosqlSize = noSqlArray.length) <= 0) break block95;
                                                int nosqlCount = 0;
                                                while (nosqlCount < nosqlSize) {
                                                    NodeMethodInfo innerMethodinfo = new NodeMethodInfo();
                                                    NodeNoSql nosqlNode = noSqlArray[nosqlCount];
                                                    long id = httpSize + sqlSize + nosqlCount + 1;
                                                    innerMethodinfo.setId(id);
                                                    int sqlResTime = nosqlNode.getResTime();
                                                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                                                    try {
                                                        if (nodePropsManager != null && (double)sqlResTime > nodePropsManager.getSQLExecCutOff()) {
                                                            props.put("isSQLPresent", (Object)true);
                                                            ArrayList<Double> slowSQLTimeDetails = new ArrayList<Double>();
                                                            slowSQLTimeDetails.add(Double.valueOf(sqlResTime));
                                                            props.put("SlowSQLTime", slowSQLTimeDetails);
                                                        }
                                                    }
                                                    catch (Exception e) {
                                                        log.error("{} error while getting noSQL execution cutoff {}", (Object)this.logPrefix, (Object)e);
                                                    }
                                                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(sqlResTime)));
                                                    innerMethodinfo.setType("MONGODB");
                                                    Properties propsInner = new Properties();
                                                    propsInner.put("mongoServerDetails", "mongodb://" + nosqlNode.getHost() + ":" + nosqlNode.getPort());
                                                    propsInner.put("mongoDBName", nosqlNode.getDbName());
                                                    propsInner.put("mongoTableName", nosqlNode.getTableName());
                                                    propsInner.put("mongoMethodName", nosqlNode.getMethodName());
                                                    propsInner.put("mongoQuery", nosqlNode.getQuery());
                                                    innerMethodinfo.setProperties(propsInner);
                                                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                                                    ++nosqlCount;
                                                }
                                            }
                                            catch (Exception e) {
                                                log.error("{} exception occurred while getting nosql calls {}", (Object)this.logPrefix, (Object)e);
                                            }
                                        }
                                        try {
                                            int cacheSize;
                                            cacheArray = externalCallDetails.getCache();
                                            int httpSize = 0;
                                            httpSize = httpArray.length;
                                            int sqlSize = 0;
                                            sqlSize = sqlArray.length;
                                            int nosqlSize = 0;
                                            nosqlSize = noSqlArray.length;
                                            if (cacheArray != null && (cacheSize = cacheArray.length) > 0) {
                                                int cacheCount = 0;
                                                while (cacheCount < cacheSize) {
                                                    NodeMethodInfo innerMethodinfo = new NodeMethodInfo();
                                                    NodeCache cacheNode = cacheArray[cacheCount];
                                                    long id = httpSize + sqlSize + nosqlSize + cacheCount + 1;
                                                    innerMethodinfo.setId(id);
                                                    int cacheResTime = cacheNode.getResTime();
                                                    innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(cacheResTime)));
                                                    innerMethodinfo.setType("REDIS");
                                                    Properties propsInner = new Properties();
                                                    propsInner.put("redisIP", cacheNode.getHost());
                                                    propsInner.put("redisPort", cacheNode.getPort());
                                                    propsInner.put("redisDetails", cacheNode.getCommand());
                                                    innerMethodinfo.setProperties(propsInner);
                                                    minfo.addToChildInfo(childMapReference, innerMethodinfo);
                                                    ++cacheCount;
                                                }
                                            }
                                        }
                                        catch (Exception e) {
                                            log.error("{} exception occurred while getting sql calls {}", (Object)this.logPrefix, (Object)e);
                                        }
                                    } else {
                                        log.debug("{} BTM object : externalCallDetails returns Null ", (Object)this.logPrefix);
                                    }
                                    if (httpArray == null && sqlArray == null) {
                                        props.put("firstNode", (Object)tr);
                                    } else {
                                        props.put("firstNode", (Object)fal);
                                    }
                                    if (childMapReference.size() > 0) {
                                        props.put("CHILD_MAP", childMapReference);
                                    }
                                    minfo.setProperties(props);
                                    minfoDataList.add(minfo);
                                    break block93;
                                }
                                log.debug("{} BTM object returns Null ", (Object)this.logPrefix);
                            }
                            catch (Exception e) {
                                log.error("{} Error while parsing BTM {}", (Object)this.logPrefix, (Object)e);
                            }
                        } else {
                            log.info("{} Data is not from btm or infra , something else", (Object)this.logPrefix);
                        }
                    }
                    ++i;
                }
            }
            catch (ParseException e) {
                log.error("{} Nodejs JSON ARRAY conversion exception {}", (Object)this.logPrefix, (Object)e);
            }
        }
        catch (Exception e) {
            log.error("{} Exception occurred {}", (Object)this.logPrefix, (Object)e);
        }
        return minfoDataList;
    }

    public Hashtable getHeadersDeails(String headers) {
        Hashtable<String, String> headersDetails = new Hashtable<String, String>();
        JSONParser jsonParser = new JSONParser();
        JSONObject jsonHeader = null;
        try {
            jsonHeader = (JSONObject)jsonParser.parse(headers);
        }
        catch (ParseException e) {
            log.error("{} error while parsing headers {}", (Object)this.logPrefix, (Object)e);
        }
        if (jsonHeader != null && jsonHeader.size() > 0) {
            Set headerData = jsonHeader.keySet();
            Iterator itr = headerData.iterator();
            while (itr.hasNext()) {
                String headerKey = itr.next().toString();
                String headerValue = (String)jsonHeader.get((Object)headerKey);
                headersDetails.put(headerKey, headerValue);
            }
        }
        return headersDetails;
    }

    public NodeMethodInfo getHttpCallDetails(NodeHttp[] httpArray) {
        int httpSize = 0;
        httpSize = httpArray.length;
        NodeMethodInfo innerMethodinfo = null;
        if (httpSize > 0) {
            int httpCount = 0;
            while (httpCount < httpSize) {
                innerMethodinfo = new NodeMethodInfo();
                NodeHttp httpNode = httpArray[httpCount];
                long id = httpCount + 1;
                innerMethodinfo.setId(id);
                innerMethodinfo.setExecutionTime(Long.parseLong(String.valueOf(httpNode.getResTime())));
                innerMethodinfo.setType("HTTP");
                Properties propsInner = new Properties();
                propsInner.put("EXTURL", httpNode.getUri());
                propsInner.put("METHOD", httpNode.getMethod());
                String nodeOrder = httpNode.getNodeOrder();
                propsInner.put("NODE_ORDER", String.valueOf(httpNode.getNodeOrder()));
                propsInner.put("SC", String.valueOf(httpNode.getStatusCode()));
                propsInner.put("RM", "-");
                innerMethodinfo.setProperties(propsInner);
                ++httpCount;
            }
        }
        return innerMethodinfo;
    }
}

