/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.NodeBTMLogger;
import com.eg.apm.NodeBlockedAt;
import com.eg.apm.NodeCPU;
import com.eg.apm.NodeErrorCluster;
import com.eg.apm.NodeEventloop;
import com.eg.apm.NodeGC;
import com.eg.apm.NodeInfra;
import com.eg.apm.NodeInfraCluster;
import com.eg.apm.NodeMeasureTime;
import com.eg.apm.NodeMemory;
import com.eg.apm.NodeUtils;
import com.eg.org.slf4j.Logger;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeDataRepository {
    protected static final Logger logger = NodeBTMLogger.nodeLogger;
    protected static String prefix = "[ NodeDataRepository ]";
    private static HashMap<String, NodeMeasureTime> MeasureTimeMap = new HashMap();
    private static Hashtable<String, NodeInfraCluster> infraClusterTable = new Hashtable();
    private static Hashtable<String, NodeInfraCluster> infraClusterTablePrev = new Hashtable();
    private static Hashtable<String, NodeErrorCluster> nodeErrorClusterTable = new Hashtable();

    public static boolean isInfraIdExists(String siteID) {
        return infraClusterTable.containsKey(siteID);
    }

    public static NodeInfraCluster getInfraById(String siteID) {
        return infraClusterTable.get(siteID);
    }

    public static void setInfraById(String siteId, NodeInfraCluster nodeInfraCluster) {
        infraClusterTable.put(siteId, nodeInfraCluster);
    }

    public static boolean isInfraIdExistsForPrev(String siteID) {
        return infraClusterTablePrev.containsKey(siteID);
    }

    public static NodeInfraCluster getInfraByIdFromPrev(String siteID) {
        return infraClusterTablePrev.get(siteID);
    }

    public static void setInfraByIdToPrev(String siteId, NodeInfraCluster nodeInfraCluster) {
        infraClusterTablePrev.put(siteId, nodeInfraCluster);
    }

    public static boolean isErrorClusterIdExists(String siteID) {
        return nodeErrorClusterTable.containsKey(siteID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeErrorCluster removeErrorClusterById(String siteID) {
        Hashtable<String, NodeErrorCluster> hashtable = nodeErrorClusterTable;
        synchronized (hashtable) {
            return nodeErrorClusterTable.remove(siteID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NodeErrorCluster getErrorClusterById(String siteID) {
        Hashtable<String, NodeErrorCluster> hashtable = nodeErrorClusterTable;
        synchronized (hashtable) {
            return nodeErrorClusterTable.get(siteID);
        }
    }

    public static NodeErrorCluster setErrorClusterById(String siteID, NodeErrorCluster errorObj) {
        return nodeErrorClusterTable.put(siteID, errorObj);
    }

    public static boolean isMeasureTimeExists(String siteID) {
        return MeasureTimeMap.containsKey(siteID);
    }

    public static long getMeasureTimeByID(String siteID) {
        NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
        return timeMeasure.getMeasureTime();
    }

    public static void setMeasureTimeByID(String siteID, Long measurePeriod, boolean isChanged) {
        NodeMeasureTime timePeriod = new NodeMeasureTime();
        timePeriod.setMeasureTime(measurePeriod);
        timePeriod.setChanged(isChanged);
        MeasureTimeMap.put(siteID, timePeriod);
    }

    public static void setMeasureStatus(String siteID, boolean isChanged) {
        if (NodeDataRepository.isMeasureTimeExists(siteID)) {
            NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
            timeMeasure.setChanged(isChanged);
            MeasureTimeMap.put(siteID, timeMeasure);
        }
    }

    public static boolean isMeasureChanged(String siteID) {
        NodeMeasureTime timeMeasure = MeasureTimeMap.get(siteID);
        return timeMeasure.isChanged();
    }

    public static void deleteMeasureTimeByID(String siteID) {
        MeasureTimeMap.remove(siteID);
    }

    public static NodeCPU aggregateCPU(HashMap<String, NodeInfra> workers) {
        NodeCPU aggCpu;
        block8: {
            int workerCount = workers.size();
            aggCpu = new NodeCPU();
            Set<Map.Entry<String, NodeInfra>> set = workers.entrySet();
            Iterator<Map.Entry<String, NodeInfra>> iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, NodeInfra> mEntry = iterator.next();
                String key = mEntry.getKey();
                NodeInfra infraByPid = mEntry.getValue();
                if (infraByPid != null) {
                    NodeCPU cpuobj = infraByPid.getCpuUsage();
                    if (cpuobj != null) {
                        try {
                            aggCpu.setSystemPct(aggCpu.getSystemPct() + cpuobj.getSystemPct());
                            aggCpu.setUserPct(aggCpu.getUserPct() + cpuobj.getUserPct());
                            aggCpu.setSystemTime(aggCpu.getSystemTime() + cpuobj.getSystemTime());
                            aggCpu.setUserTime(aggCpu.getUserTime() + cpuobj.getUserTime());
                        }
                        catch (Exception e) {
                            --workerCount;
                            iterator.remove();
                            logger.error("{} Error while iterating CPU aggregation {}", (Object)prefix, (Object)e);
                        }
                        continue;
                    }
                    logger.warn("{} Aggregating nodejs CPU is null for processId-{}", (Object)prefix, (Object)key);
                    continue;
                }
                logger.warn("{} Aggregating nodejs CPU infra id is null for processId-{}", (Object)prefix, (Object)key);
            }
            if (workerCount != 0) break block8;
            return null;
        }
        try {
            logger.debug(String.valueOf(prefix) + "Agg CPU values");
            logger.debug(String.valueOf(prefix) + "system % :" + NodeUtils.formatDecimal(aggCpu.getSystemPct()));
            logger.debug(String.valueOf(prefix) + "user % :" + NodeUtils.formatDecimal(aggCpu.getUserPct()));
            logger.debug(String.valueOf(prefix) + "system time :" + NodeUtils.formatDecimal(aggCpu.getSystemTime()));
            logger.debug(String.valueOf(prefix) + "user time :" + NodeUtils.formatDecimal(aggCpu.getUserTime()));
        }
        catch (Exception e) {
            logger.error("{} Error while aggregating nodejs CPU {}", (Object)prefix, (Object)e);
        }
        return aggCpu;
    }

    public static NodeMemory aggregateMemory(HashMap workers) {
        NodeMemory aggMemory;
        int workerCount;
        block8: {
            workerCount = workers.size();
            aggMemory = new NodeMemory();
            try {
                Set set = workers.entrySet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Map.Entry mEntry = iterator.next();
                    String key = (String)mEntry.getKey();
                    NodeInfra infraByPid = (NodeInfra)mEntry.getValue();
                    if (infraByPid != null) {
                        NodeMemory memoryObj = infraByPid.getMemoryUsage();
                        if (memoryObj != null) {
                            try {
                                aggMemory.setPhysical(aggMemory.getPhysical() + memoryObj.getPhysical());
                                aggMemory.setNon_heap(aggMemory.getNon_heap() + memoryObj.getNon_heap());
                                aggMemory.setMax_heap(aggMemory.getMax_heap() + memoryObj.getMax_heap());
                                aggMemory.setHeap_used(aggMemory.getHeap_used() + memoryObj.getHeap_used());
                                aggMemory.setFree_heap(aggMemory.getFree_heap() + memoryObj.getFree_heap());
                            }
                            catch (Exception e) {
                                --workerCount;
                                iterator.remove();
                                logger.error("{} Error while iterating memory aggregation {}", (Object)prefix, (Object)e);
                            }
                            continue;
                        }
                        logger.warn("{} Aggregating nodejs Memory is null for processId-{}", (Object)prefix, (Object)key);
                        continue;
                    }
                    logger.warn("{} Aggregating nodejs Memory infra id is null for processId-{}", (Object)prefix, (Object)key);
                }
                if (workerCount != 0) break block8;
                return null;
            }
            catch (Exception e) {
                logger.error("{} Error while aggregating nodejs Memory {}", (Object)prefix, (Object)e);
                return null;
            }
        }
        logger.debug("{} Agg Memory values", (Object)prefix);
        logger.debug("{} nonheap {}", (Object)prefix, (Object)NodeUtils.formatDecimal(aggMemory.getNon_heap() / (double)workerCount));
        logger.debug("{} Max heap {}", (Object)prefix, (Object)NodeUtils.formatDecimal(aggMemory.getMax_heap() / (double)workerCount));
        logger.debug("{} Heap used {}", (Object)prefix, (Object)NodeUtils.formatDecimal(aggMemory.getHeap_used() / (double)workerCount));
        logger.debug("{} Free_heap {}", (Object)prefix, (Object)NodeUtils.formatDecimal(aggMemory.getFree_heap() / (double)workerCount));
        aggMemory.setPhysical(NodeUtils.formatDecimal(aggMemory.getPhysical() / (double)workerCount));
        aggMemory.setNon_heap(NodeUtils.formatDecimal(aggMemory.getNon_heap() / (double)workerCount));
        aggMemory.setMax_heap(NodeUtils.formatDecimal(aggMemory.getMax_heap() / (double)workerCount));
        aggMemory.setHeap_used(NodeUtils.formatDecimal(aggMemory.getHeap_used() / (double)workerCount));
        aggMemory.setFree_heap(NodeUtils.formatDecimal(aggMemory.getFree_heap() / (double)workerCount));
        return aggMemory;
    }

    public static NodeEventloop aggregateEventloop(HashMap workers) {
        NodeEventloop aggEventloop = new NodeEventloop();
        try {
            Set set = workers.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Map.Entry mEntry = iterator.next();
                String key = (String)mEntry.getKey();
                NodeInfra infraByPid = (NodeInfra)mEntry.getValue();
                if (infraByPid == null) {
                    NodeEventloop eventLoopobj = infraByPid.getEventloop();
                    if (eventLoopobj != null) {
                        try {
                            logger.trace("{} By pid : {}  Max: {}  Min: {}  Num:{}  Sum : {}", new Object[]{prefix, key, infraByPid.getEventloop().getMax(), infraByPid.getEventloop().getMin(), infraByPid.getEventloop().getNum(), infraByPid.getEventloop().getSum()});
                            aggEventloop.setMin(aggEventloop.getMin() + eventLoopobj.getMin());
                            aggEventloop.setMax(aggEventloop.getMax() + eventLoopobj.getMax());
                            aggEventloop.setNum(aggEventloop.getNum() + eventLoopobj.getNum());
                            aggEventloop.setSum(aggEventloop.getSum() + eventLoopobj.getSum());
                            aggEventloop.setLag(aggEventloop.getLag() + eventLoopobj.getLag());
                            NodeBlockedAt[] a = null;
                            a = aggEventloop.getBlockedAt() == null ? new NodeBlockedAt[]{} : aggEventloop.getBlockedAt();
                            if (eventLoopobj.getBlockedAt() != null) {
                                NodeBlockedAt[] b = eventLoopobj.getBlockedAt();
                                aggEventloop.setBlockedAt(NodeDataRepository.merge(a, b));
                                continue;
                            }
                            logger.debug("{} blocked is null while iterating for processId-{}", (Object)prefix, (Object)key);
                        }
                        catch (Exception e) {
                            iterator.remove();
                            logger.error("{} Error while iterating  eventloop aggregation {}", (Object)prefix, (Object)e);
                        }
                        continue;
                    }
                    logger.warn("{} Aggregating nodejs Eventloop is null for processId-{}", (Object)prefix, (Object)key);
                    continue;
                }
                logger.warn("{} Aggregating nodejs Eventloop infra id is null for processId-{}", (Object)prefix, (Object)key);
            }
            logger.debug("{} Agg Eventloop values", (Object)prefix);
            logger.debug("{} Min : {}", (Object)prefix, (Object)aggEventloop.getMin());
            logger.debug("{} Max : {}", (Object)prefix, (Object)aggEventloop.getMax());
            logger.debug("{} Num :{}", (Object)prefix, (Object)aggEventloop.getNum());
            logger.debug("{} Sum : {}", (Object)prefix, (Object)aggEventloop.getSum());
            logger.debug("{} Lag : {}", (Object)prefix, (Object)aggEventloop.getLag());
            logger.debug("{} blockedAt : {}", (Object)prefix, (Object)aggEventloop.getBlockedAt());
        }
        catch (Exception e) {
            logger.error(String.valueOf(prefix) + "Error while aggregating nodejs eventloop", (Throwable)e);
        }
        return aggEventloop;
    }

    public static NodeBlockedAt[] merge(NodeBlockedAt[] a, NodeBlockedAt[] b) {
        NodeBlockedAt[] c = new NodeBlockedAt[a.length + b.length];
        int count = 0;
        int i = 0;
        while (i < a.length) {
            c[i] = a[i];
            ++count;
            ++i;
        }
        int j = 0;
        while (j < b.length) {
            c[count++] = b[j];
            ++j;
        }
        return c;
    }

    public static NodeGC aggregateGC(HashMap workers, double measurePeriod, HashMap workersPrev) {
        NodeGC aggGC = new NodeGC();
        try {
            Set set = workers.entrySet();
            Iterator iterator = set.iterator();
            int size = 0;
            while (iterator.hasNext()) {
                Map.Entry mEntry = iterator.next();
                String key = (String)mEntry.getKey();
                NodeInfra infraByPid = (NodeInfra)mEntry.getValue();
                NodeInfra infraByPidPrev = (NodeInfra)workersPrev.get(key);
                if (infraByPid != null) {
                    try {
                        double fullGCTimePrev;
                        if (infraByPidPrev == null) {
                            infraByPidPrev = new NodeInfra();
                            infraByPidPrev.setGc(new NodeGC());
                            workersPrev.put(key, infraByPidPrev);
                            logger.debug("{} - Previous NodeInfraCluster worker-NodeInfra & NodeGC NOT-Available. Creating worker & GC for {}.", (Object)prefix, (Object)key);
                        }
                        NodeGC gcObj = infraByPid.getGc();
                        logger.debug("{} ProcessID - {} Previous GC: {}", new Object[]{prefix, key, infraByPidPrev.getGc()});
                        logger.debug("{} ProcessID - {} Current GC: {}", new Object[]{prefix, key, gcObj});
                        if (gcObj == null) continue;
                        double fullGCTime = gcObj.getFullTime();
                        double fullGCTimeDiff = fullGCTime - (fullGCTimePrev = infraByPidPrev.getGc().getFullTime());
                        if (fullGCTimeDiff > 0.0) {
                            double fullPercent = fullGCTimeDiff * 100.0 / measurePeriod;
                            gcObj.setFullPercentage(Math.min(fullPercent, 100.0));
                        } else {
                            gcObj.setFullPercentage(0.0);
                        }
                        double increamentalGCTime = gcObj.getIncTime();
                        double increamentalGCTimePrev = infraByPidPrev.getGc().getIncTime();
                        double increamentalGCTimeDiff = increamentalGCTime - increamentalGCTimePrev;
                        if (increamentalGCTimeDiff > 0.0) {
                            double incPercent = increamentalGCTimeDiff * 100.0 / measurePeriod;
                            gcObj.setIncPercentage(Math.min(incPercent, 100.0));
                        } else {
                            gcObj.setIncPercentage(0.0);
                        }
                        double minorGCTime = gcObj.getMinorTime();
                        double minorGCTimePrev = infraByPidPrev.getGc().getMinorTime();
                        double minorGCTimeDiff = minorGCTime - minorGCTimePrev;
                        if (minorGCTimeDiff > 0.0) {
                            double minorPercent = minorGCTimeDiff * 100.0 / measurePeriod;
                            gcObj.setMinorPercentage(Math.min(minorPercent, 100.0));
                        } else {
                            gcObj.setIncPercentage(0.0);
                        }
                        double gcTime = gcObj.getMinorTime();
                        double gcTimePrev = infraByPidPrev.getGc().getMinorTime();
                        double gcTimeDiff = gcTime - gcTimePrev;
                        if (gcTimeDiff > 0.0) {
                            double totalPercent = gcTimeDiff * 100.0 / measurePeriod;
                            gcObj.setTotalPercentage(Math.min(totalPercent, 100.0));
                        } else {
                            gcObj.setTotalPercentage(0.0);
                        }
                        aggGC.setFull(aggGC.getFull() + gcObj.getFull());
                        aggGC.setMinor(aggGC.getMinor() + gcObj.getMinor());
                        aggGC.setInc(aggGC.getInc() + gcObj.getInc());
                        aggGC.setFullTime(aggGC.getFullTime() + gcObj.getFullTime());
                        aggGC.setIncTime(aggGC.getFullTime() + gcObj.getIncTime());
                        aggGC.setMinorTime(aggGC.getMinorTime() + gcObj.getMinorTime());
                        aggGC.setTime(aggGC.getTime() + gcObj.getTime());
                        aggGC.setTick(aggGC.getTick() + gcObj.getTick());
                        aggGC.setReleasedMem(aggGC.getReleasedMem() + gcObj.getReleasedMem());
                        aggGC.setFullPercentage(aggGC.getFullPercentage() + gcObj.getFullPercentage());
                        aggGC.setIncPercentage(aggGC.getIncPercentage() + gcObj.getIncPercentage());
                        aggGC.setMinorPercentage(aggGC.getMinorPercentage() + gcObj.getMinorPercentage());
                        aggGC.setTotalPercentage(aggGC.getTotalPercentage() + gcObj.getTotalPercentage());
                        ++size;
                    }
                    catch (Exception e) {
                        iterator.remove();
                        logger.error("{} Error while iterating  gc aggregation {}", (Object)prefix, (Object)e);
                    }
                    continue;
                }
                logger.warn("{} Aggregating nodejs GC infra id is null for processId-{}", (Object)prefix, (Object)key);
            }
            double aggreFullGCTime = aggGC.getFullPercentage();
            double aggreIncreamentalGCTime = aggGC.getIncPercentage();
            double aggreMinorGCTime = aggGC.getMinorPercentage();
            double aggreTotalGCTime = aggGC.getTotalPercentage();
            logger.debug("{} Aggregated SUM GC - full:{}, inc:{},  minor:{}, total:{}, SIZE:{} ", new Object[]{prefix, aggreFullGCTime, aggreIncreamentalGCTime, aggreMinorGCTime, aggreTotalGCTime, size});
            if (aggreFullGCTime > 0.0) {
                aggGC.setFullPercentage(aggGC.getFullPercentage() / (double)size);
            } else {
                aggGC.setFullPercentage(0.0);
            }
            if (aggreIncreamentalGCTime > 0.0) {
                aggGC.setIncPercentage(aggGC.getIncPercentage() / (double)size);
            } else {
                aggGC.setIncPercentage(0.0);
            }
            if (aggreMinorGCTime > 0.0) {
                aggGC.setMinorPercentage(aggGC.getMinorPercentage() / (double)size);
            } else {
                aggGC.setMinorPercentage(0.0);
            }
            if (aggreTotalGCTime > 0.0) {
                aggGC.setTotalPercentage(aggGC.getTotalPercentage() / (double)size);
            } else {
                aggGC.setTotalPercentage(0.0);
            }
            logger.debug("{} Agg GC values", (Object)prefix);
            logger.debug("{} Full :{}", (Object)prefix, (Object)aggGC.getFull());
            logger.debug("{} Minor :{} ", (Object)prefix, (Object)aggGC.getMinor());
            logger.debug("{} Inc :{} ", (Object)prefix, (Object)aggGC.getInc());
            logger.debug("{} Full time :{} ", (Object)prefix, (Object)aggGC.getFullTime());
            logger.debug("{} Inc time :{} ", (Object)prefix, (Object)aggGC.getIncTime());
            logger.debug("{} Minor time :{} ", (Object)prefix, (Object)aggGC.getMinorTime());
            logger.debug("{} Ticks :{} ", (Object)prefix, (Object)aggGC.getTick());
            logger.debug("{} Time :{} ", (Object)prefix, (Object)aggGC.getTime());
            logger.debug("{} Released memory :{} ", (Object)prefix, (Object)aggGC.getReleasedMem());
            logger.debug("{} FULL GC % :{} ", (Object)prefix, (Object)aggGC.getFullPercentage());
            logger.debug("{} Increamental GC % :{} ", (Object)prefix, (Object)aggGC.getIncPercentage());
            logger.debug("{} Minor GC % :{} ", (Object)prefix, (Object)aggGC.getMinorPercentage());
            logger.debug("{} Total GC % :{} ", (Object)prefix, (Object)aggGC.getTotalPercentage());
        }
        catch (Exception e) {
            logger.error("{} Error while aggregating nodejs GC {}", (Object)prefix, (Object)e);
        }
        return aggGC;
    }
}

