/*
 * Decompiled with CFR 0.152.
 */
package com.eg.apm;

import com.eg.apm.APMUtils;
import com.eg.org.slf4j.Logger;
import java.io.PrintWriter;
import java.net.Socket;

public class ResponseSender
implements Runnable {
    private String message;
    private Socket clientSocket;
    private Logger logger = APMUtils.startupLogger;
    private String logPrefix = " [" + this.getClass().getName() + "] ";

    public ResponseSender(Socket socket, String string) {
        this.clientSocket = socket;
        this.message = string;
    }

    public void run() {
        PrintWriter printWriter = this.getPrintWriter(false);
        try {
            if (this.message == null || this.message.equals("null") || this.message.equals("")) {
                return;
            }
            printWriter.println(this.message);
            printWriter.flush();
            this.logger.warn("{} Agent sent message [{}] to {}:{}", new Object[]{this.logPrefix, this.message, this.clientSocket.getInetAddress(), this.clientSocket.getPort()});
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.logger.error("{} Exception in sendResponseToClientSocketConnection() while sending response to client socket  : {}", (Object)this.logPrefix, (Object)exception);
        }
    }

    private PrintWriter getPrintWriter(boolean bl) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(this.clientSocket.getOutputStream(), bl);
        }
        catch (Exception exception) {
            this.logger.error("{} Exception in getPrintWriter()  : {} ", (Object)this.logPrefix, (Object)exception);
        }
        return printWriter;
    }
}

