/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InformixDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:informix-sqli://";
    private static final String DIRECT_URL_PREFIX = "jdbc:informix-direct://";
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:informix://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:informix://";
    private static final String IFXHOST = "ifxhost";
    private static final String PORTNO = "portno";
    private static final String DATABASE = "database";
    private static final String SQLH_TYPE = "sqlh_type";

    public InformixDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    private boolean isParsingFailure() {
        return this.isParsingFailure;
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> informixDataBaseDetails = new Hashtable<String, String>();
        boolean parsingFailure = this.isParsingFailure();
        informixDataBaseDetails.put("SERVERTYPE", this.dbType);
        if (parsingFailure) {
            informixDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            informixDataBaseDetails.put("DATABASENAME", "-");
            informixDataBaseDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            informixDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            informixDataBaseDetails.put("DATABASENAME", "-");
            informixDataBaseDetails.put("PORTNUMBER", "-");
        } else {
            informixDataBaseDetails.put("SERVERNAME", this.hostName);
            informixDataBaseDetails.put("DATABASENAME", this.databaseName);
            informixDataBaseDetails.put("PORTNUMBER", this.portNo);
        }
        return informixDataBaseDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(URL_PREFIX)) {
                maker.after(URL_PREFIX);
                this.parseConnectionUrl(maker);
            } else if (normalizedUrl.startsWith(DIRECT_URL_PREFIX)) {
                this.logger.info("[" + this.dbType + " - parseUrl] JDBC url is startswith " + DIRECT_URL_PREFIX + " so, not parsing.");
                this.isParsingFailure = true;
            } else if (normalizedUrl.startsWith(WEBLOGIC_URL_PREFIX)) {
                maker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, "-");
                if (this.databaseName == null) {
                    this.databaseName = this.informixServer;
                }
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, "-");
                if (this.databaseName == null) {
                    this.databaseName = this.informixServer;
                }
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
    }

    private void parseConnectionUrl(StringMaker maker) {
        this.logger.debug("[" + this.dbType + " -parseConnectionUrl] - maker :  " + maker.toString());
        String makerString = maker.toString();
        int first_equal = makerString.indexOf("=");
        if (first_equal > 0) {
            String firstString = makerString.substring(0, first_equal);
            String secondString = makerString.substring(first_equal);
            this.logger.debug("[" + this.dbType + " -parseConnectionUrl] firstString :" + firstString);
            this.logger.debug("[" + this.dbType + " -parseConnectionUrl] secondString :" + secondString);
            int last_colon_index = firstString.lastIndexOf(":");
            String fromhost = null;
            String propertyString = null;
            if (last_colon_index > -1) {
                fromhost = firstString.substring(0, last_colon_index);
                String firstProperty = firstString.substring(last_colon_index + 1);
                propertyString = String.valueOf(firstProperty) + secondString;
            }
            this.logger.debug("[" + this.dbType + " -parseConnectionUrl] fromhost :" + fromhost + "  propertyString :" + propertyString);
            int sql_type_index = propertyString.indexOf(SQLH_TYPE);
            if (sql_type_index > -1) {
                this.isParsingFailure = true;
                return;
            }
            boolean foundDBDetails = false;
            boolean foundDetails = false;
            if (fromhost != null) {
                int slash_index = fromhost.indexOf("/");
                if (slash_index > -1) {
                    this.databaseName = fromhost.substring(slash_index + 1);
                    foundDBDetails = true;
                    fromhost = fromhost.substring(0, slash_index);
                } else {
                    this.logger.debug("[" + this.dbType + " -parseConnectionUrl] Database Name is not specified in the URL Part, might be available in the properties");
                }
                foundDetails = this.assignSqliHostNameAndPort(fromhost);
            }
            if (foundDBDetails && foundDetails) {
                this.logger.debug("[" + this.dbType + " -parseConnectionUrl] Found hostIp, PortNo & Database. So, no need to parse properties !!!");
            } else {
                this.logger.debug("[" + this.dbType + " -parseConnectionUrl] Not Found all the details (hostIp, PortNo & Database). Need to parse properties !!!");
                PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
                propertyTokenizer.parse();
                ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
                if (propertyList != null && propertyList.size() > 0) {
                    Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
                    int i = 0;
                    while (i < propertyList.size()) {
                        String propertyName = propertyList.get(i);
                        if (propertyName.equals(IFXHOST)) {
                            this.hostName = properties.get(propertyName);
                        } else if (propertyName.equals(PORTNO)) {
                            this.portNo = properties.get(propertyName);
                        } else if (propertyName.equals(DATABASE)) {
                            this.databaseName = properties.get(propertyName);
                        } else if (propertyName.equals("informixserver")) {
                            this.informixServer = properties.get(propertyName);
                        }
                        ++i;
                    }
                }
                if (this.databaseName == null) {
                    this.databaseName = this.informixServer;
                }
                if (this.portNo == null) {
                    this.portNo = "-";
                }
            }
        } else {
            this.logger.warn("[" + this.dbType + " -parseConnectionUrl] No Properties are specified in the URL " + this.jdbcUrl);
            this.isParsingFailure = true;
            return;
        }
        this.logger.debug("[" + this.dbType + " - parseConnectionUrl]  hostName :" + this.hostName + " PORT : " + this.portNo + " DB : " + this.databaseName);
    }

    private boolean assignSqliHostNameAndPort(String ipPortString) {
        if (ipPortString.length() == 0) {
            this.logger.debug("[" + this.dbType + " -assignSqliHostNameAndPort] Seems hostIP & PortNo are specified in the propery");
            return false;
        }
        boolean result = false;
        int colon_index = ipPortString.indexOf(":");
        if (colon_index > 0) {
            StringTokenizer colonTokenzier = new StringTokenizer(ipPortString, ":");
            int count = colonTokenzier.countTokens();
            this.logger.debug("[" + this.dbType + " -assignSqliHostNameAndPort] Count :" + count);
            if (count == 2) {
                this.logger.debug("[" + this.dbType + " -assignSqliHostNameAndPort] Host name is specified using IPv4 :" + ipPortString);
                this.hostName = colonTokenzier.nextToken();
                this.portNo = colonTokenzier.nextToken();
                result = true;
            } else if (count > 2) {
                this.logger.debug("[" + this.dbType + " -assignSqliHostNameAndPort] Host name is specified using IPv6 :" + ipPortString);
                int i = 0;
                while (i < count) {
                    this.portNo = colonTokenzier.nextToken();
                    ++i;
                }
                this.hostName = ipPortString.substring(0, ipPortString.lastIndexOf(this.portNo) - 1);
                if (this.portNo != null && this.portNo.length() > 0 && this.hostName != null && this.hostName.length() > 0) {
                    result = true;
                }
            }
        } else {
            this.hostName = ipPortString;
        }
        return result;
    }

    public static void main(String[] a) {
        String jdbcUrl = "jdbc:informix-sqli://123.45.67.89:1533/testDB:INFORMIXSERVER=myserver;user=rdtest;password=test";
        jdbcUrl = "jdbc:informix-sqli://123.45.67.89:1533:INFORMIXSERVER=myserver;user=rdtest;password=test;";
        jdbcUrl = "jdbc:informix-sqli://[::1]:33378/stores_demo:IFXHOST=lo_informix1210;DELIMIDENT=Y";
        InformixDatabaseInfo databaseInfo = new InformixDatabaseInfo(jdbcUrl, "Informix_server", null);
        System.out.println(" Result :" + databaseInfo.getDBInfo());
        System.out.println(" jdbcUrl :" + jdbcUrl);
    }
}

