/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.jtm.BaseDatabaseInfo;
import com.eg.jtm.PropertyTokenizer;
import com.eg.jtm.StringMaker;
import com.eg.org.slf4j.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MsSqlDatabaseInfo
extends BaseDatabaseInfo {
    private static final String URL_PREFIX = "jdbc:sqlserver://";
    private static final String JTDS_URL_PREFIX = "jdbc:jtds:sqlserver://";
    private static final String MICROSOFT_URL_PREFIX = "jdbc:microsoft:sqlserver://";
    private static final String WEBLOGIC_URL_PREFIX = "jdbc:weblogic:sqlserver://";
    private static final String DATADIRECT_URL_PREFIX = "jdbc:datadirect:sqlserver://";
    private static final String DEFAULT_PORT = "1433";
    private List<HashMap<String, String>> hostList = null;
    private static final String CLUSTERNAME = "clustername";
    private static final String NAMEDPIPE = "namedpipe";
    private static final String INSTANCE = "instance";
    private static final String INSTANCE_NAME = "instancename";
    private boolean isCluster = false;
    private String virtualIP = null;

    public MsSqlDatabaseInfo(String jdbcUrl, String dbType, Logger logger) {
        super(jdbcUrl, dbType, logger);
    }

    @Override
    public Hashtable<String, String> getDBInfo() {
        this.parseUrl();
        Hashtable<String, String> sqlDataBaseDetails = new Hashtable<String, String>();
        sqlDataBaseDetails.put("SERVERTYPE", this.dbType);
        if (this.isCluster) {
            sqlDataBaseDetails.put("SERVERTYPE", "Sql_cluster_service");
        }
        if (this.isParsingFailure) {
            sqlDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sqlDataBaseDetails.put("DATABASENAME", "-");
            sqlDataBaseDetails.put("PORTNUMBER", "-");
        } else if (this.hostName == null || this.portNo == null) {
            sqlDataBaseDetails.put("SERVERNAME", this.jdbcUrl);
            sqlDataBaseDetails.put("DATABASENAME", "-");
            sqlDataBaseDetails.put("PORTNUMBER", "-");
        } else {
            if (this.isCluster && this.virtualIP != null) {
                this.hostName = this.virtualIP;
            }
            sqlDataBaseDetails.put("SERVERNAME", this.hostName);
            sqlDataBaseDetails.put("DATABASENAME", this.databaseName);
            sqlDataBaseDetails.put("PORTNUMBER", this.portNo);
        }
        return sqlDataBaseDetails;
    }

    private void parseUrl() {
        if (this.jdbcUrl == null) {
            this.logger.warn("[" + this.dbType + " - parseUrl] jdbcUrl must not be null");
            return;
        }
        try {
            String normalizedUrl = this.jdbcUrl.toLowerCase();
            StringMaker maker = new StringMaker(normalizedUrl);
            if (normalizedUrl.startsWith(URL_PREFIX)) {
                maker.after(URL_PREFIX);
                this.parseUrl(maker);
            } else if (normalizedUrl.startsWith(JTDS_URL_PREFIX)) {
                maker.after(JTDS_URL_PREFIX);
                this.parseJtdsUrl(maker);
            } else if (normalizedUrl.startsWith(MICROSOFT_URL_PREFIX)) {
                maker.after(MICROSOFT_URL_PREFIX);
                this.parseUrl(maker);
            } else if (normalizedUrl.startsWith(WEBLOGIC_URL_PREFIX)) {
                maker.after(WEBLOGIC_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else if (normalizedUrl.startsWith(DATADIRECT_URL_PREFIX)) {
                maker.after(DATADIRECT_URL_PREFIX);
                this.parseWeblogicConnectionUrl(maker, DEFAULT_PORT);
            } else {
                this.isParsingFailure = true;
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.dbType + " - parseUrl] Exception occured while parsing JDBC Url :" + this.jdbcUrl);
            this.isParsingFailure = true;
        }
        if (this.databaseName == null) {
            this.databaseName = "-";
        }
        this.logger.debug("[" + this.dbType + " -parseUrl] hostName :" + this.hostName + " portNo :" + this.portNo + " databaseName :" + this.databaseName);
    }

    @Override
    protected void parseProperty(String propertyString, String defaultPort, String instanceName) {
        if (propertyString == null) {
            this.logger.warn("[" + this.dbType + " - parseProperty] propertyString is null for the URL :" + this.jdbcUrl);
            return;
        }
        PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
        propertyTokenizer.parse();
        ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
        if (propertyList != null && propertyList.size() > 0) {
            Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
            int i = 0;
            while (i < propertyList.size()) {
                String propertyName = propertyList.get(i);
                if (propertyName.equals("databasename") || propertyName.equals("database")) {
                    this.databaseName = properties.get(propertyName);
                } else if (propertyName.equals("portnumber")) {
                    this.portNo = properties.get(propertyName);
                } else if (propertyName.equals("servername")) {
                    this.hostName = properties.get(propertyName);
                } else if (propertyName.equals("alternateservers")) {
                    this.isCluster = true;
                }
                ++i;
            }
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
        if (this.portNo == null) {
            this.portNo = instanceName != null ? instanceName : defaultPort;
        }
    }

    private void parseUrl(StringMaker maker) {
        this.logger.debug("[" + this.dbType + "- parseUrl] Maker :" + maker);
        StringMaker before = maker.after("//").before(';');
        String hostAndPortAndDataBaseString = before.value();
        String propertyString = maker.next().value();
        this.logger.debug("[" + this.dbType + " - parseUrl]  hostAndPortAndDataBaseString : " + hostAndPortAndDataBaseString + "  maker :" + maker + " PropertyString :" + propertyString);
        String hostAndPortString = null;
        int databaseIdIndex = hostAndPortAndDataBaseString.indexOf(47);
        if (databaseIdIndex != -1) {
            hostAndPortString = hostAndPortAndDataBaseString.substring(0, databaseIdIndex);
            this.databaseName = hostAndPortAndDataBaseString.substring(databaseIdIndex + 1, hostAndPortAndDataBaseString.length());
        } else {
            hostAndPortString = hostAndPortAndDataBaseString;
        }
        String instanceName = null;
        if (hostAndPortString != null && hostAndPortString.length() > 0) {
            int colon_index = hostAndPortString.lastIndexOf(":");
            if (colon_index == 0) {
                this.logger.debug("[" + this.dbType + " - parseUrl] HostName is not specified in the JDBC URL");
                this.portNo = hostAndPortString.substring(1);
            } else if (colon_index > 0) {
                String hostString = hostAndPortString;
                this.portNo = hostAndPortString.substring(colon_index + 1);
                hostString = hostAndPortString.substring(0, colon_index);
                this.hostName = hostString.indexOf("\\") > 0 ? hostString.substring(0, hostString.indexOf("\\")) : hostString;
            } else if (hostAndPortString.indexOf("\\") > 0) {
                this.hostName = hostAndPortString.substring(0, hostAndPortString.indexOf("\\"));
                instanceName = hostAndPortString.substring(hostAndPortString.indexOf("\\") + 1);
            } else {
                this.hostName = hostAndPortString;
            }
        }
        if (propertyString != null && propertyString.length() > 1) {
            PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
            propertyTokenizer.parse();
            ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
            if (propertyList != null && propertyList.size() > 0) {
                Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
                int i = 0;
                while (i < propertyList.size()) {
                    String propertyName = propertyList.get(i);
                    if (propertyName.equals("databasename") || propertyName.equals("database") || propertyName.equals("database\\") || propertyName.equals("databasename\\")) {
                        this.databaseName = properties.get(propertyName);
                    } else if (propertyName.equals("portnumber") || propertyName.equals("port")) {
                        this.portNo = properties.get(propertyName);
                    } else if (propertyName.equals("servername") || propertyName.equals("server")) {
                        String hostString = properties.get(propertyName);
                        if (hostString.indexOf("\\") > 0) {
                            this.hostName = hostString.substring(0, hostString.indexOf("\\"));
                            instanceName = hostString.substring(hostString.indexOf("\\") + 1);
                        } else {
                            this.hostName = hostString;
                        }
                    } else if (propertyName.equals(INSTANCE) || propertyName.equals(INSTANCE_NAME)) {
                        instanceName = properties.get(propertyName);
                    }
                    ++i;
                }
            }
        }
        if (this.portNo == null) {
            this.portNo = instanceName != null ? instanceName : DEFAULT_PORT;
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    private void parseJtdsUrl(StringMaker maker) {
        StringMaker before = maker.after("//").before(';');
        String hostAndPortAndDataBaseString = before.value();
        String propertyString = maker.next().value();
        this.logger.debug("[" + this.dbType + " - parseJtdsUrl] hostAndPortAndDataBaseString : " + hostAndPortAndDataBaseString + "  maker :" + maker + " PropertyString :" + propertyString);
        String hostAndPortString = null;
        int databaseIdIndex = hostAndPortAndDataBaseString.indexOf(47);
        if (databaseIdIndex != -1) {
            hostAndPortString = hostAndPortAndDataBaseString.substring(0, databaseIdIndex);
            this.databaseName = hostAndPortAndDataBaseString.substring(databaseIdIndex + 1, hostAndPortAndDataBaseString.length());
        } else {
            hostAndPortString = hostAndPortAndDataBaseString;
        }
        String instanceName = null;
        if (propertyString != null && propertyString.length() > 1) {
            PropertyTokenizer propertyTokenizer = new PropertyTokenizer(propertyString, this.logger);
            propertyTokenizer.parse();
            ArrayList<String> propertyList = propertyTokenizer.getPropertyNames();
            if (propertyList != null && propertyList.size() > 0) {
                Hashtable<String, String> properties = propertyTokenizer.getAllPropertyKeyValues();
                int i = 0;
                while (i < propertyList.size()) {
                    String namedpipeString;
                    String propertyName = propertyList.get(i);
                    if (propertyName.equals("databasename")) {
                        this.databaseName = properties.get(propertyName);
                    } else if (propertyName.equals(CLUSTERNAME)) {
                        this.isCluster = true;
                        this.virtualIP = properties.get(propertyName);
                    } else if (propertyName.equals(INSTANCE) || propertyName.equals(INSTANCE_NAME)) {
                        instanceName = properties.get(propertyName);
                    } else if (propertyName.equals(NAMEDPIPE) && (namedpipeString = properties.get(propertyName)) != null && namedpipeString.equals("true")) {
                        this.isParsingFailure = true;
                    }
                    ++i;
                }
            }
        }
        if (this.isParsingFailure) {
            return;
        }
        if (this.portNo == null) {
            this.portNo = instanceName != null ? instanceName : DEFAULT_PORT;
        }
        if (hostAndPortString != null && hostAndPortString.length() > 0) {
            this.assignHostNameAndPort(hostAndPortString, this.portNo);
        }
        if (this.hostName == null) {
            this.hostName = "localhost";
        }
    }

    public static void main(String[] args) {
        String jdbcUrl = "jdbc:jtds:sqlserver://neptune.acme.com:1433/test";
        MsSqlDatabaseInfo databaseInfo = new MsSqlDatabaseInfo(jdbcUrl, "MS_sql_server", null);
        Hashtable<String, String> result = databaseInfo.getDBInfo();
        System.out.println(" result :" + result);
    }
}

