/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.APMQueue;
import com.eg.apm.APMWorker;
import com.eg.apm.AgentStartupLogger;
import java.util.ArrayList;

public final class ThreadPoolManager {
    private APMQueue<Object> myQueue = null;
    private static final String THREAD_NAME = "eG_BTM_Worker_";
    private static ThreadPoolManager poolManager = null;
    private static final String loggerDispStr = "[ThreadPoolManager]";
    private ArrayList workerList = null;
    private static final int DEFAULT_WORKERS = 5;
    private static final int DEFAULT_CAPACITY = 100000;
    private int maxQueueCapacity = 100000;
    private int maxWorkers = 5;

    private ThreadPoolManager(int n, int n2) {
        this.maxWorkers = n;
        this.maxQueueCapacity = n2;
        this.workerList = new ArrayList();
        this.myQueue = new APMQueue(n2);
        this.initAllConsumers();
    }

    private void initAllConsumers() {
        Integer n = 1;
        while (n <= this.maxWorkers) {
            Object object = new APMWorker(this.myQueue);
            Object object2 = new Thread((Runnable)object);
            ((Thread)object2).setDaemon(true);
            ((Thread)object2).setName("eG_BTM_Worker_ " + n);
            ((Thread)object2).start();
            this.workerList.add(object);
            object = n;
            n = n + 1;
            object2 = n;
        }
        AgentStartupLogger.logger.info("{} eG Java BTM Threadpool created with - maxWokers {} , workers {} & queue size {} ", new Object[]{loggerDispStr, this.workerList.size(), this.maxQueueCapacity});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ThreadPoolManager getThreadPoolManager(boolean bl, int n, int n2) {
        if (poolManager != null || !bl) return poolManager;
        Class<ThreadPoolManager> clazz = ThreadPoolManager.class;
        synchronized (ThreadPoolManager.class) {
            if (poolManager != null) return poolManager;
            poolManager = new ThreadPoolManager(n, n2);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return poolManager;
        }
    }

    public static ThreadPoolManager getInstance() {
        if (poolManager == null) {
            return ThreadPoolManager.getThreadPoolManager(true, 5, 100000);
        }
        return poolManager;
    }

    public void submitTask(Object object) {
        this.myQueue.enqueue(object);
    }

    public int getQueueSize() {
        return this.myQueue.getSize();
    }

    public void clearThreadPoolManager() {
        if (this.workerList != null && this.workerList.size() > 0) {
            int n = this.workerList.size();
            AgentStartupLogger.logger.warn("{} Closing all APM Java BTM worker threads ", (Object)loggerDispStr);
            AgentStartupLogger.logger.info("{} Current APM Java BTM workerList size : {}", (Object)n, (Object)this.workerList);
            for (int i = 0; i < n; ++i) {
                APMWorker aPMWorker = (APMWorker)this.workerList.get(i);
                aPMWorker.setRunThis(false);
                this.submitTask(new Object());
            }
        }
        this.workerList = new ArrayList();
        poolManager = null;
    }
}

