/*
 * Decompiled with CFR 0.152.
 */
package com.eg.jtm;

import com.eg.apm.JavaBTMOffloadLogger;
import com.eg.jtm.MethodInfo;
import com.eg.jtm.PropsManager;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLPatternData {
    String pName;
    boolean modified = false;
    public double[] sumOf;
    public double[] numOf;
    private ArrayList<MethodInfo> SlowURLsList = null;
    private ArrayList<MethodInfo> ErrorURLsList = null;
    private ArrayList<MethodInfo> AllURLsList = null;
    private ArrayList<MethodInfo> HealthyTHREADList = null;
    private ArrayList<MethodInfo> SlowTHREADsList = null;
    private ArrayList<MethodInfo> ErrorTHREADsList = null;
    private ArrayList<MethodInfo> StalledURLsList = null;
    private ArrayList<MethodInfo> StalledTHREADsList = null;
    protected static String logPrefix = "URLPatternData";
    protected static String loggerDispStr = "[" + logPrefix + "]";
    static final double defaultValue = 0.0;
    PropsManager propsManager;

    public URLPatternData(String pName, PropsManager propsManager) {
        this.pName = pName;
        this.modified = false;
        this.propsManager = propsManager;
        int length = PropsManager.getSubCompNameLength();
        this.sumOf = new double[length];
        this.numOf = new double[length];
    }

    public ArrayList<MethodInfo> getAllURLsList() {
        return this.AllURLsList;
    }

    public ArrayList<MethodInfo> getHealthyThreadList() {
        return this.HealthyTHREADList;
    }

    public ArrayList<MethodInfo> getSlowURLsList() {
        return this.SlowURLsList;
    }

    public ArrayList<MethodInfo> getErrorURLsList() {
        return this.ErrorURLsList;
    }

    public ArrayList<MethodInfo> getSlowTHREADsList() {
        return this.SlowTHREADsList;
    }

    public ArrayList<MethodInfo> getErrorTHREADsList() {
        return this.ErrorTHREADsList;
    }

    public ArrayList<MethodInfo> getStalledURLsList() {
        return this.StalledURLsList;
    }

    public ArrayList<MethodInfo> getStalledTHREADsList() {
        return this.StalledTHREADsList;
    }

    public void cleanStalledURLsList() {
        this.StalledURLsList = null;
    }

    public void cleanStalledTHREADsList() {
        this.StalledTHREADsList = null;
    }

    public void cleanAllURLsList() {
        this.AllURLsList = null;
    }

    public void cleanHealthyThreadList() {
        this.HealthyTHREADList = null;
    }

    public void cleanSlowURLsList() {
        this.SlowURLsList = null;
    }

    public void cleanErrorURLsList() {
        this.ErrorURLsList = null;
    }

    public void cleanSlowTHREADsList() {
        this.SlowTHREADsList = null;
    }

    public void cleanErrorTHREADsList() {
        this.ErrorTHREADsList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateHashtables(int subCompIndex, double time, double count) {
        if (time >= 0.0) {
            URLPatternData uRLPatternData = this;
            synchronized (uRLPatternData) {
                this.sumOf[subCompIndex] = this.sumOf[subCompIndex] + time;
                this.numOf[subCompIndex] = this.numOf[subCompIndex] + count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateThreadTimingHashtables(int subCompIndex, double time, double count) {
        URLPatternData uRLPatternData = this;
        synchronized (uRLPatternData) {
            this.sumOf[subCompIndex] = this.sumOf[subCompIndex] + time;
            this.numOf[subCompIndex] = this.numOf[subCompIndex] + count;
        }
    }

    private void parseMinfoAndCalc(MethodInfo Minfo) {
        ArrayList slowSQLTime = null;
        Object resultObj = Minfo.getProperties().remove("SlowSQLTime");
        if (resultObj != null) {
            double count = 0.0;
            double totalTime = 0.0;
            if (resultObj instanceof ArrayList) {
                slowSQLTime = (ArrayList)resultObj;
                int i = 0;
                while (i < slowSQLTime.size()) {
                    Double sqlExeTime = (Double)slowSQLTime.get(i);
                    double exclTime = sqlExeTime;
                    if (exclTime >= this.propsManager.getSQLExecCutOff()) {
                        count += 1.0;
                        totalTime += exclTime;
                    }
                    ++i;
                }
            } else {
                double[] result = (double[])resultObj;
                count = result[0];
                totalTime = result[1];
            }
            this.updateHashtables(4, totalTime, count);
        }
    }

    void SortedAddToURLList(ArrayList URLsList, MethodInfo MI2Add, String URLSubcompName, int MaxURLs) {
        MethodInfo thisMinfo;
        double MI2Add_ExecTime = MI2Add.getExecutionTime();
        int i = 0;
        while (i < URLsList.size()) {
            thisMinfo = (MethodInfo)URLsList.get(i);
            if ((double)thisMinfo.getExecutionTime() < MI2Add_ExecTime) break;
            ++i;
        }
        URLsList.add(i, MI2Add);
        if (URLsList.size() > MaxURLs && (thisMinfo = (MethodInfo)URLsList.remove(URLsList.size() - 1)) != null) {
            thisMinfo.clearURLTree();
        }
    }

    private void storeAllURLInfo(MethodInfo MI2Add, String callType) {
        JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following Healthy URL to All urls list for pattern {} ", (Object)loggerDispStr, (Object)this.pName);
        if (callType.equals("Web")) {
            if (this.AllURLsList == null) {
                this.AllURLsList = new ArrayList();
            }
            this.SortedAddToURLList(this.AllURLsList, MI2Add, "ALL_URLS", this.propsManager.getHelathyURLs());
        } else if (callType.equals("Thread")) {
            if (this.HealthyTHREADList == null) {
                this.HealthyTHREADList = new ArrayList();
            }
            this.SortedAddToURLList(this.HealthyTHREADList, MI2Add, "ALL_URLS", this.propsManager.getHelathyURLs());
        }
    }

    private boolean storeURLIfNeeded(MethodInfo MI2Add, boolean firstNode, String requestType) {
        double urlExecutionTime = MI2Add.getExecutionTime();
        if (!MI2Add.isSlowURL() && !MI2Add.isErrorURL() && !MI2Add.isStalled() || !(urlExecutionTime >= 0.0)) {
            return false;
        }
        if (MI2Add.isErrorURL()) {
            int maxErrorUrls = this.propsManager.getMaxErrorURLs();
            if (requestType.equals("Web")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following ERROR URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.ErrorURLsList == null) {
                    this.ErrorURLsList = new ArrayList();
                }
                this.updateHashtables(2, urlExecutionTime, 1.0);
                if (firstNode) {
                    this.updateHashtables(7, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.ErrorURLsList, MI2Add, "ERROR_URLS", maxErrorUrls);
            } else if (requestType.equals("Thread")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following Thread ERROR URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.ErrorTHREADsList == null) {
                    this.ErrorTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.ErrorTHREADsList, MI2Add, "ERROR_URLS", maxErrorUrls);
            }
        } else if (MI2Add.isStalled()) {
            int maxStalledUrls = this.propsManager.getMaxStalledURLs();
            if (requestType.equals("Web")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following STALLED URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.StalledURLsList == null) {
                    this.StalledURLsList = new ArrayList();
                }
                this.updateHashtables(3, urlExecutionTime, 1.0);
                if (firstNode) {
                    this.updateHashtables(8, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.StalledURLsList, MI2Add, "STALLED_URLS", maxStalledUrls);
            } else if (requestType.equals("Thread")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following Thread STALLED URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.StalledTHREADsList == null) {
                    this.StalledTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.StalledTHREADsList, MI2Add, "STALLED_URLS", maxStalledUrls);
            }
        } else if (MI2Add.isSlowURL()) {
            int maxSlowUrls = this.propsManager.getMaxSlowURLs();
            if (requestType.equals("Web")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following SLOW URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.SlowURLsList == null) {
                    this.SlowURLsList = new ArrayList();
                }
                this.updateHashtables(1, urlExecutionTime, 1.0);
                if (firstNode) {
                    this.updateHashtables(6, urlExecutionTime, 1.0);
                }
                this.SortedAddToURLList(this.SlowURLsList, MI2Add, "SLOW_URLS", maxSlowUrls);
            } else if (requestType.equals("Thread")) {
                JavaBTMOffloadLogger.btmOffLoadLogger.debug("{} Added the following Thread SLOW URL to error urls list for pattern {}", (Object)loggerDispStr, (Object)this.pName);
                if (this.SlowTHREADsList == null) {
                    this.SlowTHREADsList = new ArrayList();
                }
                this.SortedAddToURLList(this.SlowTHREADsList, MI2Add, "SLOW_URLS", maxSlowUrls);
            }
        }
        return true;
    }

    public void updateAllUrlCount(MethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equals("Web")) {
            this.updateHashtables(0, rootMI.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
        }
        if (rootMI.isSQLPresent()) {
            this.parseMinfoAndCalc(rootMI);
        }
        if (this.propsManager.isTraceHealthyURL()) {
            this.storeAllURLInfo(rootMI, callType);
        } else {
            rootMI.clearURLTree();
        }
    }

    public void addStalledURLInfo(MethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equals("Web")) {
            double urlExecutionTime = rootMI.getExecutionTime();
            this.updateHashtables(0, urlExecutionTime, 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
            if (rootMI.isSQLPresent()) {
                this.parseMinfoAndCalc(rootMI);
            }
        }
        this.storeURLIfNeeded(rootMI, firstNode, callType);
    }

    public void addURLInfo(MethodInfo rootMI, boolean firstNode, String callType, long cpuTime, long blockedTime, long waitedTime) {
        if ((double)rootMI.getExecutionTime() >= 0.0) {
            this.modified = true;
        }
        if (callType != null && callType.equals("Web")) {
            this.updateHashtables(0, rootMI.getExecutionTime(), 1.0);
            this.updateThreadDiagonosis(cpuTime, blockedTime, waitedTime);
            if (firstNode) {
                this.updateHashtables(5, rootMI.getExecutionTime(), 1.0);
            }
        }
        if (rootMI.isSQLPresent()) {
            this.parseMinfoAndCalc(rootMI);
        }
        this.storeURLIfNeeded(rootMI, firstNode, callType);
    }

    private void updateThreadDiagonosis(long cpuTime, long blockedTime, long waitedTime) {
        if (cpuTime >= 0L) {
            this.updateThreadTimingHashtables(9, cpuTime, 1.0);
        }
        if (blockedTime >= 0L) {
            this.updateThreadTimingHashtables(10, blockedTime, 1.0);
        }
        if (waitedTime >= 0L) {
            this.updateThreadTimingHashtables(11, waitedTime, 1.0);
        }
    }
}

