/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassData;
import com.evermind.bytecode.ClassPoolEntry;
import com.evermind.bytecode.DoublePoolEntry;
import com.evermind.bytecode.ExceptionsAttribute;
import com.evermind.bytecode.FieldData;
import com.evermind.bytecode.FieldPoolEntry;
import com.evermind.bytecode.FloatPoolEntry;
import com.evermind.bytecode.IntegerPoolEntry;
import com.evermind.bytecode.InterfaceMethodPoolEntry;
import com.evermind.bytecode.LineNumberTableAttribute;
import com.evermind.bytecode.LinkedClassData;
import com.evermind.bytecode.LinkedMethodData;
import com.evermind.bytecode.LongPoolEntry;
import com.evermind.bytecode.MethodData;
import com.evermind.bytecode.MethodPoolEntry;
import com.evermind.bytecode.NameAndTypePoolEntry;
import com.evermind.bytecode.PoolEntry;
import com.evermind.bytecode.RawAttribute;
import com.evermind.bytecode.RawCodeAttribute;
import com.evermind.bytecode.StringPoolEntry;
import com.evermind.bytecode.UTF8PoolEntry;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.PrintWriter;

public class ClassSerialization {
    static final ByteString CODE = new ByteString("Code");
    static final ByteString LINENUMBERTABLE = new ByteString("LineNumberTable");
    public static final int READ_ATTRIBUTES_ONLY = 1;
    public static final int READ_COMPILER = 2;
    public static final int READ_FULLY = 3;
    public ClassData type;
    private PoolEntry[] constantPool = new PoolEntry[10];
    private int constantPoolCount;
    short classNameIndex;
    short superClassNameIndex;
    private UTF8PoolEntry[] firstUTF8Entry = new UTF8PoolEntry[32];
    private NameAndTypePoolEntry[] nameAndTypeEntries = new NameAndTypePoolEntry[10];
    private int nameAndTypeEntryCount;
    private FieldPoolEntry[] fieldEntries = new FieldPoolEntry[10];
    private int fieldEntryCount;
    private MethodPoolEntry[] methodEntries = new MethodPoolEntry[10];
    private int methodEntryCount;
    private UTF8PoolEntry[] utf8Cache = new UTF8PoolEntry[10];
    private int utf8CachePos;
    private int utf8CacheSize;
    private NameAndTypePoolEntry[] nameAndTypeCache = new NameAndTypePoolEntry[10];
    private int nameAndTypeCachePos;
    private int nameAndTypeCacheSize;
    private FieldPoolEntry[] fieldEntryCache = new FieldPoolEntry[10];
    private int fieldEntryCachePos;
    private int fieldEntryCacheSize;
    private MethodPoolEntry[] methodEntryCache = new MethodPoolEntry[10];
    private int methodEntryCachePos;
    private int methodEntryCacheSize;

    public void init(ClassData type) {
        this.type = type;
        this.utf8CachePos = 0;
        this.nameAndTypeCachePos = 0;
        this.fieldEntryCachePos = 0;
        this.methodEntryCachePos = 0;
        this.methodEntryCount = 0;
        this.fieldEntryCount = 0;
        this.constantPoolCount = 0;
        this.classNameIndex = 0;
        this.superClassNameIndex = 0;
        for (int i = 0; i < 32; ++i) {
            this.firstUTF8Entry[i] = null;
        }
        this.nameAndTypeEntryCount = 0;
    }

    public ClassData getType() {
        return this.type;
    }

    public void write(InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        int i;
        this.classNameIndex = this.getClassPoolIndex(this.type.name);
        this.superClassNameIndex = this.getClassPoolIndex(this.type.superClassName);
        out.writeInt(-889275714);
        out.writeShort(3);
        out.writeShort(45);
        InteractiveByteArrayOutputStream nestedOut = new InteractiveByteArrayOutputStream();
        nestedOut.writeShort(this.type.modifiers);
        int classNamePos = out.getPos();
        short[] interfaceIDs = new short[this.type.interfaceCount];
        for (i = 0; i < interfaceIDs.length; ++i) {
            interfaceIDs[i] = this.getClassPoolIndex(this.type.interfaces[i]);
        }
        nestedOut.writeShort(this.classNameIndex);
        nestedOut.writeShort(this.superClassNameIndex);
        nestedOut.writeShort((short)interfaceIDs.length);
        for (i = 0; i < interfaceIDs.length; ++i) {
            nestedOut.writeShort(interfaceIDs[i]);
        }
        this.writeFieldData(nestedOut);
        this.writeMethodData(nestedOut);
        int attributeCount = (short)(this.type.attributes == null ? 0 : (short)this.type.attributeCount);
        short s = (short)attributeCount;
        if (this.type.sourceFile != null) {
            ++attributeCount;
        }
        nestedOut.writeShort(attributeCount);
        if (this.type.sourceFile != null) {
            nestedOut.writeShort(this.getPoolIndex(new ByteString("SourceFile")));
            nestedOut.writeInt(2);
            nestedOut.writeShort(this.getPoolIndex(this.type.sourceFile));
        }
        if (this.type.attributes != null) {
            for (int i2 = 0; i2 < this.type.attributeCount; ++i2) {
                this.type.attributes[i2].write(this, nestedOut);
            }
        }
        int constantPoolPos = out.getPos();
        out.writeShort(this.constantPoolCount + 1);
        for (int i3 = 0; i3 < this.constantPoolCount; ++i3) {
            PoolEntry entry = this.constantPool[i3];
            entry.write(out);
            if (!(entry instanceof LongPoolEntry) && !(entry instanceof DoublePoolEntry)) continue;
            ++i3;
        }
        ByteString nested = nestedOut.toByteString();
        out.write(nested.data, nested.offset, nested.length);
    }

    public PoolEntry getPoolEntry(int pos) {
        try {
            return this.constantPool[pos - 1];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ClassFormatError("Illegal constant pool index: " + pos);
        }
    }

    public ClassData read(Object identifier, DataInputStream in, PrintWriter out, int readType, boolean linked) throws IOException {
        this.init(null);
        try {
            ClassData data;
            if (in.readInt() != -889275714) {
                throw new IOException("Bad magic number");
            }
            short minor = in.readShort();
            short major = in.readShort();
            int constantPoolSize = in.readShort() - 1;
            if (out != null) {
                out.println("Pool size: " + constantPoolSize);
            }
            for (int i = 0; i < constantPoolSize; ++i) {
                PoolEntry entry = ClassSerialization.readEntry(in, i + 1);
                if (out != null) {
                    out.println("Entry " + (i + 1) + ": " + entry);
                }
                this.addPoolEntry(entry);
                if (!(entry instanceof LongPoolEntry) && !(entry instanceof DoublePoolEntry)) continue;
                this.addPoolEntry(entry);
                entry.pos = (short)(entry.pos - 1);
                ++i;
            }
            this.constantPoolCount = constantPoolSize;
            if (readType == 1) {
                return null;
            }
            this.type = data = linked ? new LinkedClassData() : new ClassData();
            data.modifiers = in.readShort();
            data.name = this.getUTF8Entry(((ClassPoolEntry)this.getPoolEntry((int)in.readShort())).classNameIndex);
            short superClassIndex = in.readShort();
            if (superClassIndex >= 1) {
                data.superClassName = this.getUTF8Entry(((ClassPoolEntry)this.getPoolEntry((int)superClassIndex)).classNameIndex);
            }
            int interfaceCount = in.readShort();
            for (int i = 0; i < interfaceCount; ++i) {
                data.addInterface(this.getClassEntry(in.readShort()));
            }
            int fieldCount = in.readShort();
            for (int i = 0; i < fieldCount; ++i) {
                data.addField(this.readField(in, readType));
            }
            int methodCount = in.readShort();
            for (int i = 0; i < methodCount; ++i) {
                data.addMethod(this.readMethod(in, linked));
            }
            int attributeCount = in.readShort();
            for (int i = 0; i < attributeCount; ++i) {
                data.add(this.readAttribute(in));
            }
            return data;
        }
        catch (ClassFormatError e) {
            e.printStackTrace();
            throw new ClassFormatError(identifier + ": " + e.getMessage());
        }
    }

    public ByteString getUTF8Entry(int index) {
        try {
            return ((UTF8PoolEntry)this.constantPool[index - 1]).getValue();
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not an UTF8 entry");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ClassFormatError("Invalid constant pool index: " + index);
        }
    }

    public ByteString getClassEntry(int index) {
        try {
            return this.getUTF8Entry(((ClassPoolEntry)this.constantPool[index - 1]).classNameIndex);
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not a class entry");
        }
    }

    public MethodPoolEntry getMethodEntry(int index) {
        try {
            return (MethodPoolEntry)this.constantPool[index - 1];
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not a method entry");
        }
    }

    public InterfaceMethodPoolEntry getInterfaceMethodEntry(int index) {
        try {
            return (InterfaceMethodPoolEntry)this.constantPool[index - 1];
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not a interface method entry");
        }
    }

    public NameAndTypePoolEntry getNameAndTypeEntry(int index) {
        try {
            return (NameAndTypePoolEntry)this.constantPool[index - 1];
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not a name and type entry");
        }
    }

    public FieldPoolEntry getFieldEntry(int index) {
        try {
            return (FieldPoolEntry)this.constantPool[index - 1];
        }
        catch (ClassCastException e) {
            throw new ClassFormatError("Pool entry " + index + " contained a " + this.constantPool[index - 1].getClass().getName() + ", not a field entry");
        }
    }

    public FieldData readField(DataInputStream in, int readType) throws IOException {
        short modifiers = in.readShort();
        short nameIndex = in.readShort();
        short typeIndex = in.readShort();
        if (nameIndex < 1 || nameIndex > this.constantPoolCount) {
            throw new IOException("Illegal name index for field entry: " + nameIndex + " of " + this.constantPoolCount);
        }
        if (typeIndex < 1 || typeIndex > this.constantPoolCount) {
            throw new IOException("Illegal type index for field entry: " + typeIndex + " of " + this.constantPoolCount);
        }
        FieldData data = new FieldData(this.getUTF8Entry(nameIndex), this.getUTF8Entry(typeIndex), modifiers);
        if (readType == 2) {
            data.readAcknowledgedAttributes(in, this);
        } else {
            int attributeCount = in.readShort();
            for (int i = 0; i < attributeCount; ++i) {
                data.add(this.readAttribute(in));
            }
        }
        return data;
    }

    public MethodData readMethod(DataInputStream in, boolean linked) throws IOException {
        short modifiers = in.readShort();
        short nameIndex = in.readShort();
        ByteString name = this.getUTF8Entry(nameIndex);
        ByteString descriptor = this.getUTF8Entry(in.readShort());
        MethodData data = linked ? new LinkedMethodData(name, descriptor, modifiers, (LinkedClassData)this.type) : new MethodData(name, descriptor, modifiers);
        int attributeCount = in.readShort();
        for (int i = 0; i < attributeCount; ++i) {
            Attribute attribute = this.readAttribute(in);
            if (attribute instanceof ExceptionsAttribute) {
                data.exceptions = ((ExceptionsAttribute)attribute).getExceptions();
                continue;
            }
            data.add(attribute);
        }
        return data;
    }

    public Attribute readAttribute(DataInputStream in) throws IOException {
        short entryIndex = in.readShort();
        ByteString name = this.getUTF8Entry(entryIndex);
        int size = in.readInt();
        if (name.equals(CODE)) {
            RawCodeAttribute attribute = new RawCodeAttribute(this, in);
            return attribute;
        }
        if (name.equals(LINENUMBERTABLE)) {
            LineNumberTableAttribute attribute = new LineNumberTableAttribute(in);
            return attribute;
        }
        if (name.equals(MethodData.EXCEPTIONS)) {
            ExceptionsAttribute attribute = new ExceptionsAttribute(this, in);
            return attribute;
        }
        byte[] data = new byte[size];
        try {
            in.readFully(data);
        }
        catch (EOFException e) {
            throw new EOFException("EOF while reading " + size + " long attribute " + name);
        }
        return new RawAttribute(name, data);
    }

    public static PoolEntry readEntry(DataInputStream in, int index) throws IOException {
        byte type = in.readByte();
        switch (type) {
            case 7: {
                return new ClassPoolEntry(in.readShort());
            }
            case 9: {
                return new FieldPoolEntry(in.readShort(), in.readShort());
            }
            case 11: {
                return new InterfaceMethodPoolEntry(in.readShort(), in.readShort());
            }
            case 10: {
                return new MethodPoolEntry(in.readShort(), in.readShort());
            }
            case 12: {
                return new NameAndTypePoolEntry(in.readShort(), in.readShort());
            }
            case 3: {
                return new IntegerPoolEntry(in.readInt());
            }
            case 4: {
                return new FloatPoolEntry(in.readFloat());
            }
            case 5: {
                return new LongPoolEntry(in.readLong());
            }
            case 6: {
                return new DoublePoolEntry(in.readDouble());
            }
            case 8: {
                return new StringPoolEntry(in.readShort());
            }
            case 1: {
                short length = in.readShort();
                byte[] data = new byte[length];
                in.readFully(data);
                ByteString string = new ByteString(data);
                return new UTF8PoolEntry(string, string.hashCode());
            }
        }
        throw new IOException("Unsupported pool entry type (nr " + index + "): " + type);
    }

    public short getClassPoolIndex(ByteString value) {
        UTF8PoolEntry utf8 = this.getPoolEntry(value);
        if (utf8.classEntryPos > 0) {
            return utf8.classEntryPos;
        }
        ClassPoolEntry classEntry = new ClassPoolEntry(utf8.pos);
        this.addPoolEntry(classEntry);
        utf8.classEntryPos = classEntry.pos;
        return classEntry.pos;
    }

    public short getStringPoolIndex(ByteString value) {
        UTF8PoolEntry utf8 = this.getPoolEntry(value);
        if (utf8.stringEntryPos > 0) {
            return utf8.stringEntryPos;
        }
        StringPoolEntry stringEntry = new StringPoolEntry(utf8.pos);
        this.addPoolEntry(stringEntry);
        utf8.stringEntryPos = stringEntry.pos;
        return stringEntry.pos;
    }

    public short getPoolIndex(ByteString value) {
        return this.getPoolEntry((ByteString)value).pos;
    }

    private UTF8PoolEntry getPoolEntry(ByteString value) {
        UTF8PoolEntry utf8Entry;
        int hashCode = value.hashCode();
        int category = hashCode & 0x1F;
        UTF8PoolEntry next = this.firstUTF8Entry[category];
        UTF8PoolEntry current = null;
        while (next != null) {
            if (next.hashCode < hashCode) {
                current = next;
                next = next.next;
                continue;
            }
            if (next.hashCode != hashCode) break;
            do {
                current = next;
                if (next.value != value && !next.value.equals(value)) continue;
                return next;
            } while ((next = next.next) != null && next.hashCode == hashCode);
        }
        if (this.utf8CachePos >= this.utf8CacheSize) {
            if (this.utf8CacheSize >= this.utf8Cache.length) {
                UTF8PoolEntry[] newCache = new UTF8PoolEntry[this.utf8Cache.length * 2];
                System.arraycopy(this.utf8Cache, 0, newCache, 0, this.utf8CacheSize);
                this.utf8Cache = newCache;
            }
            UTF8PoolEntry uTF8PoolEntry = new UTF8PoolEntry();
            this.utf8Cache[this.utf8CachePos++] = uTF8PoolEntry;
            utf8Entry = uTF8PoolEntry;
            ++this.utf8CacheSize;
        } else {
            utf8Entry = this.utf8Cache[this.utf8CachePos++];
        }
        utf8Entry.value = value;
        utf8Entry.hashCode = hashCode;
        utf8Entry.stringEntryPos = 0;
        utf8Entry.classEntryPos = 0;
        this.addPoolEntry(utf8Entry);
        if (current == null) {
            if (this.firstUTF8Entry[category] == null) {
                this.firstUTF8Entry[category] = utf8Entry;
                utf8Entry.next = null;
            } else {
                utf8Entry.next = this.firstUTF8Entry[category];
                this.firstUTF8Entry[category] = utf8Entry;
            }
        } else {
            utf8Entry.next = current.next;
            current.next = utf8Entry;
        }
        return utf8Entry;
    }

    public short getPoolIndex(int value) {
        for (int i = this.constantPoolCount - 1; i >= 0; --i) {
            if (!(this.constantPool[i] instanceof IntegerPoolEntry) || ((IntegerPoolEntry)this.constantPool[i]).value != value) continue;
            return (short)(i + 1);
        }
        return this.addPoolEntry(new IntegerPoolEntry(value));
    }

    public short getPoolIndex(float value) {
        for (int i = this.constantPoolCount - 1; i >= 0; --i) {
            if (!(this.constantPool[i] instanceof FloatPoolEntry) || ((FloatPoolEntry)this.constantPool[i]).value != value) continue;
            return (short)(i + 1);
        }
        return this.addPoolEntry(new FloatPoolEntry(value));
    }

    public short getPoolIndex(double value) {
        for (int i = this.constantPoolCount - 1; i >= 0; --i) {
            if (!(this.constantPool[i] instanceof DoublePoolEntry) || ((DoublePoolEntry)this.constantPool[i]).value != value) continue;
            return (short)i;
        }
        DoublePoolEntry entry = new DoublePoolEntry(value);
        this.addPoolEntry(entry);
        this.addPoolEntry(entry);
        entry.pos = (short)(entry.pos - 1);
        return entry.pos;
    }

    public short getPoolIndex(long value) {
        for (int i = this.constantPoolCount - 1; i >= 0; --i) {
            if (!(this.constantPool[i] instanceof LongPoolEntry) || ((LongPoolEntry)this.constantPool[i]).value != value) continue;
            return (short)i;
        }
        LongPoolEntry entry = new LongPoolEntry(value);
        this.addPoolEntry(entry);
        this.addPoolEntry(entry);
        entry.pos = (short)(entry.pos - 1);
        return entry.pos;
    }

    public short getInterfaceMethodPoolIndex(ByteString className, ByteString fieldName, ByteString args) {
        short classStringEntryIndex = this.getClassPoolIndex(className);
        short nameAndTypeEntryIndex = this.getNameAndTypePoolIndex(fieldName, args);
        for (int i = this.constantPoolCount - 1; i >= 0; --i) {
            if (!(this.constantPool[i] instanceof InterfaceMethodPoolEntry)) continue;
            InterfaceMethodPoolEntry entry = (InterfaceMethodPoolEntry)this.constantPool[i];
            if (entry.classDataIndex != classStringEntryIndex || entry.nameAndTypeIndex != nameAndTypeEntryIndex) continue;
            return (short)(i + 1);
        }
        return this.addPoolEntry(new InterfaceMethodPoolEntry(classStringEntryIndex, nameAndTypeEntryIndex));
    }

    public short getMethodPoolIndex(ByteString className, ByteString methodName, ByteString coded) {
        MethodPoolEntry methodEntry;
        short classStringEntryIndex = this.getClassPoolIndex(className);
        short nameAndTypeEntryIndex = this.getNameAndTypePoolIndex(methodName, coded);
        for (int i = this.methodEntryCount - 1; i >= 0; --i) {
            MethodPoolEntry entry = this.methodEntries[i];
            if (entry.classDataIndex != classStringEntryIndex || entry.nameAndTypeIndex != nameAndTypeEntryIndex) continue;
            return this.methodEntries[i].pos;
        }
        if (this.methodEntryCachePos >= this.methodEntryCacheSize) {
            if (this.methodEntryCacheSize >= this.methodEntryCache.length) {
                MethodPoolEntry[] newCache = new MethodPoolEntry[this.methodEntryCache.length * 2];
                System.arraycopy(this.methodEntryCache, 0, newCache, 0, this.methodEntryCacheSize);
                this.methodEntryCache = newCache;
            }
            MethodPoolEntry methodPoolEntry = new MethodPoolEntry();
            this.methodEntryCache[this.methodEntryCachePos++] = methodPoolEntry;
            methodEntry = methodPoolEntry;
            ++this.methodEntryCacheSize;
        } else {
            methodEntry = this.methodEntryCache[this.methodEntryCachePos++];
        }
        methodEntry.classDataIndex = classStringEntryIndex;
        methodEntry.nameAndTypeIndex = nameAndTypeEntryIndex;
        short pos = this.addPoolEntry(methodEntry);
        if (this.methodEntryCount >= this.methodEntries.length) {
            MethodPoolEntry[] newEntries = new MethodPoolEntry[this.methodEntries.length * 2];
            System.arraycopy(this.methodEntries, 0, newEntries, 0, this.methodEntryCount);
            this.methodEntries = newEntries;
        }
        this.methodEntries[this.methodEntryCount++] = methodEntry;
        return pos;
    }

    private short getNameAndTypePoolIndex(ByteString name, ByteString type) {
        NameAndTypePoolEntry nameAndTypeEntry;
        short nameIndex = this.getPoolIndex(name);
        short typeIndex = this.getPoolIndex(type);
        for (int i = this.nameAndTypeEntryCount - 1; i >= 0; --i) {
            NameAndTypePoolEntry entry = this.nameAndTypeEntries[i];
            if (entry.nameIndex != nameIndex || entry.typeIndex != typeIndex) continue;
            return this.nameAndTypeEntries[i].pos;
        }
        if (this.nameAndTypeCachePos >= this.nameAndTypeCacheSize) {
            if (this.nameAndTypeCacheSize >= this.nameAndTypeCache.length) {
                NameAndTypePoolEntry[] newCache = new NameAndTypePoolEntry[this.nameAndTypeCache.length * 2];
                System.arraycopy(this.nameAndTypeCache, 0, newCache, 0, this.nameAndTypeCacheSize);
                this.nameAndTypeCache = newCache;
            }
            NameAndTypePoolEntry nameAndTypePoolEntry = new NameAndTypePoolEntry();
            this.nameAndTypeCache[this.nameAndTypeCachePos++] = nameAndTypePoolEntry;
            nameAndTypeEntry = nameAndTypePoolEntry;
            ++this.nameAndTypeCacheSize;
        } else {
            nameAndTypeEntry = this.nameAndTypeCache[this.nameAndTypeCachePos++];
        }
        nameAndTypeEntry.nameIndex = nameIndex;
        nameAndTypeEntry.typeIndex = typeIndex;
        this.addPoolEntry(nameAndTypeEntry);
        if (this.nameAndTypeEntryCount >= this.nameAndTypeEntries.length) {
            NameAndTypePoolEntry[] newEntries = new NameAndTypePoolEntry[this.nameAndTypeEntries.length * 2];
            System.arraycopy(this.nameAndTypeEntries, 0, newEntries, 0, this.nameAndTypeEntryCount);
            this.nameAndTypeEntries = newEntries;
        }
        this.nameAndTypeEntries[this.nameAndTypeEntryCount++] = nameAndTypeEntry;
        return nameAndTypeEntry.pos;
    }

    public short getFieldPoolIndex(ByteString className, ByteString fieldName, ByteString coded) {
        FieldPoolEntry fieldEntry;
        short classStringEntryIndex = this.getClassPoolIndex(className);
        short nameAndTypeEntryIndex = this.getNameAndTypePoolIndex(fieldName, coded);
        for (int i = this.fieldEntryCount - 1; i >= 0; --i) {
            FieldPoolEntry entry = this.fieldEntries[i];
            if (entry.classDataIndex != classStringEntryIndex || entry.nameAndTypeIndex != nameAndTypeEntryIndex) continue;
            return this.fieldEntries[i].pos;
        }
        if (this.fieldEntryCachePos >= this.fieldEntryCacheSize) {
            if (this.fieldEntryCacheSize >= this.fieldEntryCache.length) {
                FieldPoolEntry[] newCache = new FieldPoolEntry[this.fieldEntryCache.length * 2];
                System.arraycopy(this.fieldEntryCache, 0, newCache, 0, this.fieldEntryCacheSize);
                this.fieldEntryCache = newCache;
            }
            FieldPoolEntry fieldPoolEntry = new FieldPoolEntry();
            this.fieldEntryCache[this.fieldEntryCachePos++] = fieldPoolEntry;
            fieldEntry = fieldPoolEntry;
            ++this.fieldEntryCacheSize;
        } else {
            fieldEntry = this.fieldEntryCache[this.fieldEntryCachePos++];
        }
        fieldEntry.classDataIndex = classStringEntryIndex;
        fieldEntry.nameAndTypeIndex = nameAndTypeEntryIndex;
        this.addPoolEntry(fieldEntry);
        if (this.fieldEntryCount >= this.fieldEntries.length) {
            FieldPoolEntry[] newEntries = new FieldPoolEntry[this.fieldEntries.length * 2];
            System.arraycopy(this.fieldEntries, 0, newEntries, 0, this.fieldEntryCount);
            this.fieldEntries = newEntries;
        }
        this.fieldEntries[this.fieldEntryCount++] = fieldEntry;
        return fieldEntry.pos;
    }

    public short addPoolEntry(PoolEntry entry) {
        short pos;
        if (this.constantPoolCount >= this.constantPool.length) {
            PoolEntry[] newEntries = new PoolEntry[this.constantPool.length * 2];
            System.arraycopy(this.constantPool, 0, newEntries, 0, this.constantPoolCount);
            this.constantPool = newEntries;
        }
        this.constantPool[this.constantPoolCount++] = entry;
        entry.pos = pos = (short)this.constantPoolCount;
        return pos;
    }

    public void writeFieldData(InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        if (this.type.fields == null) {
            out.writeShort(0);
        } else {
            out.writeShort((short)this.type.fieldCount);
            for (int i = 0; i < this.type.fieldCount; ++i) {
                this.type.fields[i].write(this, out);
            }
        }
    }

    public void writeMethodData(InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        if (this.type.methods == null) {
            out.writeShort(0);
        } else {
            out.writeShort((short)this.type.methodCount);
            for (int i = 0; i < this.type.methodCount; ++i) {
                this.type.methods[i].write(this, out);
            }
        }
    }

    public static void main(String[] args) {
        ClassSerialization serialization = new ClassSerialization();
        serialization.init(new ClassData());
        serialization.getPoolEntry(new ByteString("A"));
        serialization.getPoolEntry(new ByteString("()V"));
        serialization.getPoolEntry(new ByteString("D"));
        serialization.getPoolEntry(new ByteString("C"));
        serialization.getPoolEntry(new ByteString("B"));
        serialization.getPoolEntry(new ByteString("()V"));
        serialization.getPoolEntry(new ByteString("F"));
        serialization.getPoolEntry(new ByteString("E"));
        serialization.getPoolEntry(new ByteString("()V"));
    }

    public void verifyConstantPool() {
        for (int i = 0; i < this.constantPoolCount; ++i) {
            PoolEntry entry = this.constantPool[i];
            if (entry instanceof MethodPoolEntry) {
                if (this.constantPool[((MethodPoolEntry)entry).classDataIndex - 1] instanceof ClassPoolEntry && this.constantPool[((MethodPoolEntry)entry).nameAndTypeIndex - 1] instanceof NameAndTypePoolEntry) continue;
                throw new VerifyError("Corrupt method entry: " + i);
            }
            if (entry instanceof InterfaceMethodPoolEntry) {
                if (this.constantPool[((InterfaceMethodPoolEntry)entry).classDataIndex - 1] instanceof ClassPoolEntry && this.constantPool[((InterfaceMethodPoolEntry)entry).nameAndTypeIndex - 1] instanceof NameAndTypePoolEntry) continue;
                throw new VerifyError("Corrupt interface method entry: " + i);
            }
            if (entry instanceof FieldPoolEntry) {
                if (this.constantPool[((FieldPoolEntry)entry).classDataIndex - 1] instanceof ClassPoolEntry && this.constantPool[((FieldPoolEntry)entry).nameAndTypeIndex - 1] instanceof NameAndTypePoolEntry) continue;
                throw new VerifyError("Corrupt field entry: " + i);
            }
            if (entry instanceof ClassPoolEntry) {
                if (this.constantPool[((ClassPoolEntry)entry).classNameIndex - 1] instanceof UTF8PoolEntry) continue;
                throw new VerifyError("Corrupt class entry: " + i);
            }
            if (entry instanceof StringPoolEntry) {
                if (this.constantPool[((StringPoolEntry)entry).index - 1] instanceof UTF8PoolEntry) continue;
                throw new VerifyError("Corrupt string entry: " + i);
            }
            if (!(entry instanceof NameAndTypePoolEntry) || this.constantPool[((NameAndTypePoolEntry)entry).nameIndex - 1] instanceof UTF8PoolEntry && this.constantPool[((NameAndTypePoolEntry)entry).typeIndex - 1] instanceof UTF8PoolEntry) continue;
            throw new VerifyError("Corrupt name and type entry: " + i);
        }
    }

    public ByteString accessesPackage(ByteString packageName) {
        for (int i = 0; i < this.constantPoolCount; ++i) {
            if (!(this.constantPool[i] instanceof ClassPoolEntry)) continue;
            ClassPoolEntry entry = (ClassPoolEntry)this.constantPool[i];
            ByteString targetName = this.getUTF8Entry(entry.classNameIndex);
            if (!targetName.startsWith(packageName)) continue;
            return targetName;
        }
        return null;
    }

    public PoolEntry[] getConstantPool() {
        return this.constantPool;
    }

    public int getConstantPoolCount() {
        return this.constantPoolCount;
    }

    public void initUTF8EntryTable() {
        int i;
        for (i = 0; i < this.constantPoolCount; ++i) {
            if (!(this.constantPool[i] instanceof UTF8PoolEntry)) continue;
            UTF8PoolEntry entry = (UTF8PoolEntry)this.constantPool[i];
            ByteString value = entry.getValue();
            int hashCode = value.hashCode();
            int category = hashCode & 0x1F;
            UTF8PoolEntry next = this.firstUTF8Entry[category];
            UTF8PoolEntry current = null;
            while (next != null && next.value.hashCode() < hashCode) {
                current = next;
                next = next.next;
            }
            if (next != null) {
                entry.next = next;
            }
            if (current == null) {
                this.firstUTF8Entry[category] = entry;
                continue;
            }
            current.next = entry;
        }
        for (i = 0; i < this.constantPoolCount; ++i) {
            if (!(this.constantPool[i] instanceof ClassPoolEntry)) continue;
            ClassPoolEntry classEntry = (ClassPoolEntry)this.constantPool[i];
            ((UTF8PoolEntry)this.constantPool[classEntry.classNameIndex - 1]).classEntryPos = (short)(i + 1);
        }
    }
}

