/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.bytecode;

import com.evermind.bytecode.Attribute;
import com.evermind.bytecode.ClassSerialization;
import com.evermind.bytecode.DoublePoolEntry;
import com.evermind.bytecode.FloatPoolEntry;
import com.evermind.bytecode.IntegerPoolEntry;
import com.evermind.bytecode.LongPoolEntry;
import com.evermind.bytecode.PoolEntry;
import com.evermind.bytecode.StringPoolEntry;
import com.evermind.compiler.CompilationException;
import com.evermind.io.InteractiveByteArrayOutputStream;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.evermind.util.ObjectUtils;
import java.io.DataInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;

public class FieldData {
    public static final ByteString CONSTANTVALUE = new ByteString("ConstantValue");
    public int modifiers;
    public ByteString name;
    public ByteString descriptor;
    public Object initialValue;
    public short flags;
    public Attribute[] attributes;

    public FieldData(ByteString name, ByteString descriptor, int modifiers) {
        this.modifiers = modifiers;
        this.name = name;
        this.descriptor = descriptor;
    }

    public void write(ClassSerialization type, InteractiveByteArrayOutputStream out) throws IOException, CompilationException {
        out.writeShort(this.modifiers);
        out.writeShort(type.getPoolIndex(this.name));
        out.writeShort(type.getPoolIndex(this.descriptor));
        out.writeShort((short)(this.attributes == null ? 0 : (short)this.attributes.length));
        if (this.attributes != null) {
            for (int i = 0; i < this.attributes.length; ++i) {
                this.attributes[i].write(type, out);
            }
        }
    }

    public void add(Attribute attribute) {
        if (this.attributes == null) {
            this.attributes = new Attribute[1];
        } else {
            Attribute[] newAttributes = new Attribute[this.attributes.length + 1];
            System.arraycopy(this.attributes, 0, newAttributes, 0, this.attributes.length);
            this.attributes = newAttributes;
        }
        this.attributes[this.attributes.length - 1] = attribute;
    }

    public void readAcknowledgedAttributes(DataInputStream in, ClassSerialization type) throws IOException {
        int attributeCount = in.readShort();
        try {
            for (int i = 0; i < attributeCount; ++i) {
                short entryIndex = in.readShort();
                ByteString attributeName = type.getUTF8Entry(entryIndex);
                int size = in.readInt();
                if (attributeName.equals(CONSTANTVALUE)) {
                    short index = in.readShort();
                    this.initialValue = FieldData.getValueFromIndex(type, index);
                    continue;
                }
                in.skip(size);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Object getValueFromIndex(ClassSerialization type, int index) {
        PoolEntry entry = type.getPoolEntry(index);
        if (entry instanceof IntegerPoolEntry) {
            return ObjectUtils.getInteger(((IntegerPoolEntry)entry).value);
        }
        if (entry instanceof FloatPoolEntry) {
            return new Float(((FloatPoolEntry)entry).value);
        }
        if (entry instanceof LongPoolEntry) {
            return new Long(((LongPoolEntry)entry).value);
        }
        if (entry instanceof DoublePoolEntry) {
            return new Double(((DoublePoolEntry)entry).value);
        }
        if (entry instanceof StringPoolEntry) {
            return type.getUTF8Entry(((StringPoolEntry)entry).index);
        }
        throw new ClassFormatError("Expected constant pool entry at " + index + " (not " + entry + ")");
    }

    public String getReadableForm() {
        StringBuffer response = new StringBuffer();
        if (Modifier.isPublic(this.modifiers)) {
            response.append("public ");
        }
        if (Modifier.isPrivate(this.modifiers)) {
            response.append("private ");
        }
        if (Modifier.isProtected(this.modifiers)) {
            response.append("protected ");
        }
        if (Modifier.isAbstract(this.modifiers)) {
            response.append("abstract ");
        }
        if (Modifier.isSynchronized(this.modifiers)) {
            response.append("synchronized ");
        }
        if (Modifier.isStatic(this.modifiers)) {
            response.append("static ");
        }
        if (Modifier.isFinal(this.modifiers)) {
            response.append("final ");
        }
        if (Modifier.isNative(this.modifiers)) {
            response.append("native ");
        }
        response.append(ClassUtils.getStandaloneParams(this.descriptor.toString()));
        response.append(" ");
        response.append(this.name.toString());
        return response.toString();
    }
}

