/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.compiler;

import com.evermind.compiler.ClassDescription;
import com.evermind.compiler.ClassNotFoundCompilationException;
import com.evermind.compiler.CodeCompiler;
import com.evermind.compiler.CodeStringTokenizer;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.ExistingClassDescription;
import com.evermind.compiler.LiteralClassDescription;
import com.evermind.compiler.SyntaxError;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class JavaCompiler
implements CodeCompiler {
    public static final ClassDescription intType = new ExistingClassDescription("java.lang.Integer");
    public static final ClassDescription longType = new ExistingClassDescription("java.lang.Long");
    public static final ClassDescription floatType = new ExistingClassDescription("java.lang.Float");
    public static final ClassDescription doubleType = new ExistingClassDescription("java.lang.Double");
    public static final ClassDescription booleanType = new ExistingClassDescription("java.lang.Boolean");
    public static final ClassDescription byteType = new ExistingClassDescription("java.lang.Byte");
    public static final ClassDescription charType = new ExistingClassDescription("java.lang.Char");
    public static final ClassDescription shortType = new ExistingClassDescription("java.lang.Short");
    public static final ClassDescription voidType = new ExistingClassDescription("java.lang.Void");
    public Vector classDescriptions = new Vector();
    public static final Vector emptyVector = new Vector();

    public static void main(String[] args) throws CompilationException {
        if (args.length < 1) {
            System.err.println("Usage: JavaCompiler <classname>");
            return;
        }
        new JavaCompiler(args[0].replace('.', '/'));
    }

    public JavaCompiler(String className) throws CompilationException {
        this.findClass(emptyVector, className);
        Enumeration enumeration = this.classDescriptions.elements();
        while (enumeration.hasMoreElements()) {
            System.err.println(((ClassDescription)enumeration.nextElement()).getName());
        }
    }

    public byte[] compile(String source) throws SyntaxError {
        return null;
    }

    public ClassDescription createClassDescription(String source) throws CompilationException {
        String word;
        LiteralClassDescription classDescription = new LiteralClassDescription(this);
        CodeStringTokenizer tokenizer = new CodeStringTokenizer(source);
        while (tokenizer.nextCommandIsSingleLine()) {
            String line = tokenizer.readSingleLine();
            if (line.startsWith("package ")) {
                classDescription.packageName = line.substring(8, line.length()).replace('.', '/').concat("/");
                System.err.println("Package name: " + classDescription.packageName);
                continue;
            }
            if (line.startsWith("import ")) {
                if (line.endsWith(".*")) {
                    classDescription.imports.add(line.substring(7, line.length() - 1));
                    continue;
                }
                classDescription.imports.add(line.substring(7, line.length()));
                continue;
            }
            throw new SyntaxError("Unknown syntax: \"" + line + "\"");
        }
        while ((word = tokenizer.readSingleWord()) != null) {
            if (word.equals("public")) {
                classDescription.modifier |= 1;
                continue;
            }
            if (word.equals("private")) {
                classDescription.modifier |= 2;
                continue;
            }
            if (word.equals("protected")) {
                classDescription.modifier |= 4;
                continue;
            }
            if (word.equals("final")) {
                classDescription.modifier |= 0x10;
                continue;
            }
            if (word.equals("static")) {
                classDescription.modifier |= 8;
                continue;
            }
            if (word.equals("strict")) {
                classDescription.modifier |= 0x800;
                continue;
            }
            if (word.equals("transient")) {
                classDescription.modifier |= 0x80;
                continue;
            }
            if (word.equals("volatile")) {
                classDescription.modifier |= 0x40;
                continue;
            }
            if (word.equals("synchronized")) {
                classDescription.modifier |= 0x20;
                continue;
            }
            if (word.equals("native")) {
                classDescription.modifier |= 0x100;
                continue;
            }
            if (word.equals("abstract")) {
                classDescription.modifier |= 0x400;
                continue;
            }
            if (word.equals("interface")) {
                classDescription.modifier |= 0x200;
            } else if (!word.equals("class")) {
                throw new SyntaxError("Expected class or interface");
            }
            classDescription.name = classDescription.packageName == null ? tokenizer.readSingleWord() : classDescription.packageName.concat(tokenizer.readSingleWord().replace('.', '/'));
            while ((word = tokenizer.readSingleWord()) != null) {
                if (word.equals("extends")) {
                    classDescription.superName = tokenizer.readSingleWord();
                    continue;
                }
                if (!word.equals("implements")) continue;
                while ((word = tokenizer.readSingleWord()) != null) {
                    classDescription.interfaceNames.add(word);
                }
            }
        }
        if (classDescription.superName == null) {
            classDescription.superName = "java/lang/Object";
        }
        System.err.println(classDescription.name + " extends " + classDescription.superName);
        this.classDescriptions.add(classDescription);
        System.err.println("Added class " + classDescription.getName());
        classDescription.parseBody(tokenizer.readBracketRegion());
        return classDescription;
    }

    public ClassDescription findClass(Vector imports, String name) throws CompilationException {
        ClassDescription description;
        Enumeration enumeration = this.classDescriptions.elements();
        System.err.println("findClass(" + name + ")");
        while (enumeration.hasMoreElements()) {
            description = (ClassDescription)enumeration.nextElement();
            if (description.getName().equals(name)) {
                return description;
            }
            Enumeration importNames = imports.elements();
            while (importNames.hasMoreElements()) {
                String importName = (String)importNames.nextElement();
                if (!(importName.endsWith("/") ? description.getName().equals(importName.concat(name)) : description.getName().equals(importName))) continue;
                return description;
            }
        }
        System.err.println(name + " NOT found in loaded classes list");
        description = this.loadClassDescription(imports, name);
        if (description != null) {
            return description;
        }
        System.err.println("createExistingClassDescription(" + name + ")");
        description = this.createExistingClassDescription(imports, name);
        System.err.println("createExistingClassDescription(" + name + ") end");
        return description;
    }

    public ClassDescription loadClassDescription(Vector imports, String name) throws CompilationException {
        ClassDescription description = this.loadClassDescriptionFromFile(name);
        if (description != null) {
            return description;
        }
        Enumeration enumeration = imports.elements();
        while (enumeration.hasMoreElements()) {
            String importName = (String)enumeration.nextElement();
            String className = importName.endsWith("/") ? importName + name : importName;
            description = this.loadClassDescriptionFromFile(importName.concat(name));
            if (description == null) continue;
            return description;
        }
        return null;
    }

    public ClassDescription createExistingClassDescription(Vector imports, String name) throws CompilationException {
        name = name.replace('/', '.');
        try {
            return new ExistingClassDescription(Class.forName(name), this);
        }
        catch (ClassNotFoundException e) {
            Enumeration enumeration = imports.elements();
            while (enumeration.hasMoreElements()) {
                String importName = (String)enumeration.nextElement();
                if (importName.endsWith("/")) {
                    try {
                        return new ExistingClassDescription(Class.forName(importName.replace('/', '.').concat(name)), this);
                    }
                    catch (ClassNotFoundException e2) {
                        continue;
                    }
                }
                try {
                    return new ExistingClassDescription(Class.forName(importName.replace('/', '.')), this);
                }
                catch (ClassNotFoundException e3) {
                }
            }
            throw new ClassNotFoundCompilationException(name);
        }
    }

    public ClassDescription loadClassDescriptionFromFile(String name) throws CompilationException {
        try {
            File file = new File(name.replace('.', File.separatorChar).concat(".java"));
            if (!file.exists()) {
                return null;
            }
            FileInputStream in = new FileInputStream(file);
            byte[] buffer = new byte[(int)file.length()];
            in.read(buffer);
            return this.createClassDescription(new String(buffer));
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + name + " not found");
            return null;
        }
        catch (IOException e) {
            System.err.println("Error reading " + name);
            return null;
        }
    }
}

