/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming;

import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.util.ByteString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.NamingException;

public class ContextLocation {
    public Context context;
    public Context sourceContext;
    public CodeSource codeSource;
    public ProtectionDomain domain;
    private Manifest manifest;
    private boolean manifestLoaded = false;

    public String toString() {
        return "[" + this.context + "]";
    }

    private InputStream getManifestData() throws IOException, NamingException {
        if (this.context instanceof MemoryArchiveContext) {
            ByteString string = ((MemoryArchiveContext)this.context).getArchive().getContent("META-INF/MANIFEST.MF");
            if (string != null) {
                return new ByteArrayInputStream(string.data, string.offset, string.length);
            }
            return null;
        }
        return new ByteArrayInputStream((byte[])this.context.lookup("META-INF/MANIFEST.MF"));
    }

    public String getManifestAttribute(Attributes.Name name) throws IOException, NamingException {
        Manifest man = this.getManifest();
        if (man != null) {
            return man.getMainAttributes().getValue(name);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Manifest getManifest() throws IOException, NamingException {
        InputStream data = null;
        try {
            if (!this.manifestLoaded) {
                this.manifestLoaded = true;
                data = this.getManifestData();
                if (data != null) {
                    this.manifest = new Manifest(data);
                    data.close();
                }
            }
            Manifest manifest = this.manifest;
            return manifest;
        }
        finally {
            if (data != null) {
                data.close();
            }
        }
    }

    public synchronized void cleanManifest() {
        this.manifest = null;
        this.manifestLoaded = false;
    }
}

