/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.archive;

import com.evermind.io.IOUtils;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.AwareSubContext;
import com.evermind.naming.FlatContext;
import com.evermind.naming.RelativeContext;
import com.evermind.naming.archive.ArchiveNamingEnumeration;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.archive.SerializableArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.naming.file.SerializableFileContext;
import com.evermind.util.LengthContainer;
import com.evermind.util.ServerProperties;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NotContextException;
import javax.naming.OperationNotSupportedException;

public class ArchiveContext
extends FlatContext
implements LastModifiedContainer,
LengthContainer,
RelativeContext {
    private static final Object REMOVE_OBJECT = new Object();
    private static final Object DESTROY_DIRECTORY = new Object();
    private static final byte[] BYTEARRAY_DIRECTORY = new byte[0];
    private static final int EXISTS_NO = 0;
    private static final int EXISTS_OBJECT = 1;
    private static final int EXISTS_CONTEXT = 2;
    protected Map newEntries;
    protected String deleteDirectory;
    protected File file;
    protected ZipFile zip;
    protected boolean burstMode = true;
    private static HashMap allInstances = new HashMap();

    public ArchiveContext(File file, boolean burstMode) {
        this.file = ArchiveContext.makeCanonical(file);
        this.burstMode = true;
        ArchiveContext.register(this);
    }

    private static File makeCanonical(File file) {
        try {
            return file.getCanonicalFile();
        }
        catch (IOException e) {
            System.out.println("Conversion to canonical file failed: " + e.getMessage());
            return file;
        }
    }

    private static synchronized void register(ArchiveContext context) {
        int index = -1;
        File file = context.file;
        WeakReference[] list = (WeakReference[])allInstances.get(file);
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                WeakReference ref = list[i];
                if (ref.get() != null) continue;
                index = i;
                break;
            }
            if (index < 0) {
                int length = list.length;
                WeakReference[] newList = new WeakReference[length + 1];
                System.arraycopy(list, 0, newList, 0, length);
                list = newList;
                index = length;
            }
        } else {
            index = 0;
            list = new WeakReference[1];
        }
        list[index] = new WeakReference<ArchiveContext>(context);
        allInstances.put(file, list);
    }

    public static synchronized boolean close(File file) {
        boolean result = false;
        File key = ArchiveContext.makeCanonical(file);
        WeakReference[] list = (WeakReference[])allInstances.get(key);
        if (list != null) {
            boolean foundValid = false;
            boolean closedAll = true;
            for (int i = 0; i < list.length; ++i) {
                WeakReference ref = list[i];
                Object value = ref.get();
                if (value == null) continue;
                foundValid = true;
                ArchiveContext context = (ArchiveContext)value;
                try {
                    context.close();
                    continue;
                }
                catch (NamingException e) {
                    closedAll = false;
                }
            }
            if (!foundValid) {
                allInstances.remove(key);
            } else {
                result = closedAll;
            }
        }
        return result;
    }

    public File getFile() {
        return this.file;
    }

    public synchronized void setBurstMode(boolean active) throws NamingException {
    }

    public String getNameInNamespace() throws NamingException {
        if (this.file != null) {
            return this.file.getPath();
        }
        return null;
    }

    protected Object getObject(ZipEntry entry) throws IOException, NamingException {
        return entry;
    }

    protected void writeObject(ZipOutputStream out, String name, Object object) throws IOException, NamingException {
        ZipEntry entry = new ZipEntry(name);
        out.putNextEntry(entry);
        out.closeEntry();
    }

    public void rebind(String path, Object value) throws NamingException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.bind(path, value, true);
    }

    public void unbind(String path) throws NamingException {
        this.bind(path, null, true);
    }

    public void bind(String path, Object value) throws NamingException {
        if (value == null) {
            throw new NullPointerException("value");
        }
        this.bind(path, value, false);
    }

    public ZipFile getZip() throws IOException {
        if (this.zip == null) {
            this.zip = new ZipFile(this.file);
        }
        return this.zip;
    }

    public Map getWriteMap() {
        if (this.newEntries == null) {
            this.newEntries = new HashMap();
        }
        return this.newEntries;
    }

    protected int exists(String path) throws IOException {
        if (!this.file.exists()) {
            return 0;
        }
        ZipEntry entry = this.getZip().getEntry(path);
        if (entry != null) {
            return entry.getSize() > 0L ? 1 : 2;
        }
        String dirPath = path.concat("/");
        Enumeration<? extends ZipEntry> entries = this.getZip().entries();
        while (entries.hasMoreElements()) {
            entry = entries.nextElement();
            if (!entry.getName().startsWith(dirPath)) continue;
            return 2;
        }
        return 0;
    }

    public Object bind(String path, Object value, boolean overwrite) throws NamingException {
        try {
            int exists = this.exists(path);
            if (value == DESTROY_DIRECTORY) {
                if (exists == 2) {
                    this.deleteDirectory = path;
                    this.endMode(true);
                    Object var5_6 = null;
                    return var5_6;
                }
                if (exists == 1) {
                    throw new NotContextException(path);
                }
                throw new NameNotFoundException(path);
            }
            if (value == BYTEARRAY_DIRECTORY && exists != 0) {
                throw new NameAlreadyBoundException(path);
            }
            if (!overwrite && exists != 0) {
                throw new NameAlreadyBoundException(path);
            }
            if (value == null) {
                this.getWriteMap().put(path, REMOVE_OBJECT);
            } else {
                this.getWriteMap().put(path, value);
            }
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
        finally {
            this.endMode();
        }
        if (value == BYTEARRAY_DIRECTORY) {
            return new AwareSubContext(this, path);
        }
        return null;
    }

    protected void endMode() throws NamingException {
        this.endMode(false);
    }

    protected void endMode(boolean hard) throws NamingException {
        if (!this.burstMode || hard) {
            if (this.newEntries != null) {
                try {
                    this.flushCache();
                }
                catch (IOException e) {
                    throw new NamingException("IO Error: " + e.getMessage());
                }
                finally {
                    this.newEntries = null;
                }
            }
            if (this.zip != null) {
                try {
                    this.zip.close();
                    this.zip = null;
                }
                catch (IOException e) {
                    this.zip = null;
                    throw new NamingException("IO Error: " + e.getMessage());
                }
            }
        }
    }

    public synchronized void rename(String from, String to) throws NamingException {
        Object data = null;
    }

    protected void writeEntries(ZipOutputStream out) throws IOException, NamingException {
        Object entry;
        if (this.file.exists()) {
            Enumeration<? extends ZipEntry> enumeration = this.getZip().entries();
            while (enumeration.hasMoreElements()) {
                byte[] entryData;
                entry = enumeration.nextElement();
                if (this.getWriteMap().containsKey(((ZipEntry)entry).getName())) continue;
                int size = (int)((ZipEntry)entry).getSize();
                InputStream in = this.zip.getInputStream((ZipEntry)entry);
                if (size > 0) {
                    int lengthRead;
                    entryData = new byte[size];
                    for (int pos = 0; pos < size && (lengthRead = in.read(entryData, pos, entryData.length - pos)) >= 0; pos += lengthRead) {
                    }
                } else {
                    entryData = IOUtils.getContent(in);
                }
                in.close();
                ZipEntry newEntry = new ZipEntry(((ZipEntry)entry).getName());
                newEntry.setSize(entryData.length);
                out.putNextEntry(newEntry);
                out.write(entryData);
                out.flush();
                out.closeEntry();
            }
        }
        Iterator iterator = this.getWriteMap().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            if (entry.getValue() == REMOVE_OBJECT) continue;
            if (entry.getValue() == BYTEARRAY_DIRECTORY) {
                out.putNextEntry(new ZipEntry((String)entry.getKey() + '/'));
                out.flush();
                out.closeEntry();
                continue;
            }
            this.writeObject(out, (String)entry.getKey(), entry.getValue());
        }
    }

    public void setReadMode() throws NamingException {
        try {
            this.flushCache();
            if (this.zip == null && this.burstMode) {
                this.zip = new ZipFile(this.file);
            }
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public synchronized void flush() throws IOException, NamingException {
        this.flushCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushCache() throws IOException, NamingException {
        if (this.newEntries != null) {
            try {
                ByteArrayOutputStream cacheOut = new ByteArrayOutputStream();
                ZipOutputStream zipOut = new ZipOutputStream(cacheOut);
                this.writeEntries(zipOut);
                zipOut.flush();
                zipOut.close();
                byte[] data = cacheOut.toByteArray();
                if (this.zip != null) {
                    this.zip.close();
                    this.zip = null;
                }
                FileOutputStream out = new FileOutputStream(this.file);
                out.write(data);
                out.close();
            }
            finally {
                this.newEntries = null;
            }
        }
    }

    public Object lookup(String path) throws NamingException {
        return this.lookup(path, true);
    }

    public synchronized Object lookup(String path, boolean lookForDirectories) throws NamingException {
        if (path.equals("")) {
            return this;
        }
        try {
            Object object;
            ZipEntry entry;
            this.setReadMode();
            if (this.zip == null) {
                this.zip = new ZipFile(this.file);
            }
            if ((entry = this.zip.getEntry(path)) == null) {
                if (!path.endsWith(".class") && lookForDirectories && this.containsDirectory(path, this.zip.entries())) {
                    AwareSubContext awareSubContext = new AwareSubContext(this, path);
                    return awareSubContext;
                }
                throw new NameNotFoundException(path);
            }
            if (entry.getSize() <= 0L || entry.isDirectory()) {
                AwareSubContext awareSubContext = new AwareSubContext(this, path);
                return awareSubContext;
            }
            Object object2 = object = this.getObject(entry);
            return object2;
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
        finally {
            this.endMode();
        }
    }

    public synchronized NamingEnumeration list(String path) throws NamingException {
        ArrayList<ZipEntry> entries = new ArrayList<ZipEntry>();
        ArrayList<String> directories = new ArrayList<String>();
        String dirPath = path.equals("") ? "" : path.concat("/");
        try {
            this.setReadMode();
            if (this.zip == null) {
                this.zip = new ZipFile(this.file);
            }
            Enumeration<? extends ZipEntry> enumeration = this.zip.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String name = entry.getName();
                if (!name.startsWith(dirPath)) continue;
                if (name.lastIndexOf(47) == path.length() || path.length() == 0 && name.lastIndexOf(47) < 0) {
                    if (entry.getSize() > 0L) {
                        entries.add(entry);
                        continue;
                    }
                    if (name.length() == path.length() + 1 || directories.contains(entry.getName())) continue;
                    directories.add(entry.getName());
                    continue;
                }
                String directory = name.substring(0, name.indexOf(47, path.length() + 1));
                if (directories.contains(directory)) continue;
                directories.add(directory);
            }
            for (int i = 0; i < directories.size(); ++i) {
                entries.add(new ZipEntry((String)directories.get(i) + "/"));
            }
            ArchiveNamingEnumeration archiveNamingEnumeration = new ArchiveNamingEnumeration(entries, this);
            return archiveNamingEnumeration;
        }
        catch (IOException e) {
            throw new NamingException("IO Error: " + e.getMessage());
        }
        finally {
            this.endMode();
        }
    }

    protected boolean containsDirectory(String path, Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = (ZipEntry)enumeration.nextElement();
            String name = entry.getName();
            if (!name.startsWith(path)) continue;
            if (name.startsWith(path.concat("/"))) {
                if (ServerProperties.getTraceContainsDirectory()) {
                    System.out.println("ArchiveContext: containsDirectory(" + path + ") plus '/' found in " + this.file + " in entry " + name);
                }
                return true;
            }
            if (name.length() != path.length() || entry.getSize() > 0L) continue;
            if (ServerProperties.getTraceContainsDirectory()) {
                System.out.println("ArchiveContext: containsDirectory(" + path + ") found in " + this.file + " in entry " + name);
            }
            return true;
        }
        return false;
    }

    public synchronized NamingEnumeration listBindings(String path) throws NamingException {
        throw new OperationNotSupportedException("Listing not supported");
    }

    public synchronized void destroySubcontext(String path) throws NamingException {
        this.bind(path, DESTROY_DIRECTORY, true);
    }

    public synchronized Context createSubcontext(String path) throws NamingException {
        return (Context)this.bind(path, BYTEARRAY_DIRECTORY, false);
    }

    public synchronized Object lookupLink(String path) throws NamingException {
        throw new OperationNotSupportedException("lookupLink() not supported");
    }

    public Object addToEnvironment(String name, Object object) throws NamingException {
        if (name.equals("burstmode")) {
            this.burstMode = Boolean.getBoolean(object.toString());
        }
        return null;
    }

    public Object removeFromEnvironment(String name) throws NamingException {
        return null;
    }

    public Hashtable getEnvironment() throws NamingException {
        return new Hashtable();
    }

    public void close() throws NamingException {
        try {
            this.flushCache();
            if (this.zip != null) {
                this.zip.close();
            }
            this.zip = null;
        }
        catch (IOException e) {
            this.zip = null;
            throw new NamingException("IO Error: " + e.getMessage());
        }
    }

    public boolean setLastModified(String path, long lastModified) {
        return false;
    }

    public long getLastModified(String path) throws IOException {
        try {
            if (this.zip == null) {
                this.zip = new ZipFile(this.file);
            }
            ZipEntry entry = this.zip.getEntry(path);
            this.endMode();
            if (entry != null) {
                return entry.getTime();
            }
            return -1L;
        }
        catch (NamingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public long getLength(String path) throws IOException {
        if (this.zip == null) {
            this.zip = new ZipFile(this.file);
        }
        ZipEntry entry = this.zip.getEntry(path);
        try {
            this.endMode();
            if (entry != null) {
                return entry.getSize();
            }
            return 0L;
        }
        catch (NamingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ArchiveContext)) {
            return false;
        }
        return ((ArchiveContext)other).file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode() + 5;
    }

    public Context getRelative(String name) throws NamingException {
        if (name.equals(this.file.getName())) {
            throw new NamingException("Relative was myself");
        }
        String fileName = this.file.getPath().substring(0, this.file.getPath().lastIndexOf(File.separator) + 1) + name;
        File newFile = new File(fileName);
        if (!newFile.exists()) {
            throw new NamingException("Relative " + name + " does not exist (" + newFile + ")");
        }
        if (newFile.isDirectory()) {
            if (this instanceof ContentArchiveContext) {
                return new ContentFileContext(newFile, null);
            }
            if (this instanceof SerializableArchiveContext) {
                return new SerializableFileContext(newFile, null);
            }
            return new FileContext(newFile, null);
        }
        if (this instanceof ContentArchiveContext) {
            return new ContentArchiveContext(newFile, false);
        }
        if (this instanceof SerializableArchiveContext) {
            return new SerializableArchiveContext(newFile, false);
        }
        return new ArchiveContext(newFile, false);
    }

    public String toString() {
        return this.file + " archive";
    }
}

