/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.naming.archive;

import com.evermind.naming.archive.ArchiveContext;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.archive.SerializableArchiveContext;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.zip.ZipEntry;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class ArchiveNamingEnumeration
implements NamingEnumeration {
    protected List entries;
    protected ArchiveContext context;
    protected int pos;
    protected NameClassPair current;
    protected NamingException exception;

    public ArchiveNamingEnumeration(List entries, ArchiveContext context) {
        this.entries = entries;
        this.context = context;
        this.current = this.getNameClassPair();
    }

    public boolean hasMore() {
        return this.hasMoreElements();
    }

    public boolean hasMoreElements() {
        return this.current != null;
    }

    public void close() {
    }

    public Object nextElement() {
        if (this.current == null) {
            throw new NoSuchElementException(String.valueOf(this.pos - 1));
        }
        NameClassPair value = this.current;
        this.current = this.getNameClassPair();
        return value;
    }

    public NameClassPair getNameClassPair() {
        ZipEntry entry;
        if (this.entries == null) {
            return null;
        }
        if (this.pos >= this.entries.size()) {
            return null;
        }
        if ((entry = (ZipEntry)this.entries.get(this.pos++)).isDirectory()) {
            String name = entry.getName().substring(entry.getName().lastIndexOf(47, entry.getName().length() - 2) + 1, entry.getName().length() - 1);
            return new NameClassPair(name, "com.evermind.naming.SubContext");
        }
        String name = entry.getName().substring(entry.getName().lastIndexOf(47) + 1);
        if (this.context instanceof ContentArchiveContext) {
            return new NameClassPair(name, "[B");
        }
        if (this.context instanceof SerializableArchiveContext) {
            return new NameClassPair(name, "java.lang.Object");
        }
        return new NameClassPair(name, "java.util.zip.Entry");
    }

    public Object next() throws NamingException {
        if (this.current == null && this.exception != null) {
            throw this.exception;
        }
        NameClassPair pair = this.current;
        this.current = this.getNameClassPair();
        return pair;
    }
}

