/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.j2ee.util.TraceLogger;

public final class IpAddressUtils {
    static final String SYSPROP_PREFER_IPv4_STACK = "java.net.preferIPv4Stack";
    static final String SYSPROP_PREFER_IPv6_ADDRESSES = "java.net.preferIPv6Addresses";
    static final String IPv4_ANY_ADDRESS = "0.0.0.0";
    static final String IPv4_LOOPBACK_ADDRESS = "127.0.0.1";
    static final String IPv4_DEFAULT_MULTICAST_ADDRESS = "230.230.0.1";
    static final String LOCALHOST = "localhost";
    static final String IPv6_ANY_ADDRESS;
    static final String IPv6_LOOPBACK_ADDRESS;
    private static Logger logger;
    private static boolean DUAL_STACK;
    private static boolean IPv6MODULE_LOADED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIPv6AnyAddress() {
        String ipAddr = "::";
        String returnAddr = "::";
        try {
            returnAddr = InetAddress.getByName("::").getHostAddress();
            return returnAddr;
        }
        catch (UnknownHostException unknownHostException) {}
        finally {
            return returnAddr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getIPv6LoopbackAddress() {
        String ipAddr = "::1";
        String returnAddr = "::1";
        try {
            returnAddr = InetAddress.getByName("::1").getHostAddress();
            return returnAddr;
        }
        catch (UnknownHostException unknownHostException) {}
        finally {
            return returnAddr;
        }
    }

    public static InetAddress getIpAnyAddress() throws UnknownHostException {
        return InetAddress.getByName(IpAddressUtils.getIpAnyAddressAsString());
    }

    public static String getIpAnyAddressAsString() {
        String address = IPv4_ANY_ADDRESS;
        if (!IpAddressUtils.isPreferIPv4Stack() && IpAddressUtils.isIPv6ModuleLoaded() && IpAddressUtils.isPreferIPv6Addresses()) {
            address = IPv6_ANY_ADDRESS;
        }
        return address;
    }

    public static InetAddress getIpLoopbackAddress() throws UnknownHostException {
        return InetAddress.getByName(LOCALHOST);
    }

    public static String getIpLoopbackAddressAsString() {
        String address = IPv4_LOOPBACK_ADDRESS;
        try {
            address = IpAddressUtils.getIpLoopbackAddress().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return address;
    }

    public static InetAddress getIpDefaultMulticastAddress() throws UnknownHostException {
        return InetAddress.getByName(IPv4_DEFAULT_MULTICAST_ADDRESS);
    }

    public static String getIpDefaultMulticastAddressAsString() {
        return IPv4_DEFAULT_MULTICAST_ADDRESS;
    }

    public static void setIpAddressStack() {
        String preferIPv4Stack = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(IpAddressUtils.SYSPROP_PREFER_IPv4_STACK);
            }
        });
        String EMPTY = "";
        if (null == preferIPv4Stack) {
            preferIPv4Stack = "";
        }
        if ("".equals(preferIPv4Stack)) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.setProperty(IpAddressUtils.SYSPROP_PREFER_IPv4_STACK, Boolean.TRUE.toString());
                }
            });
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "No ''{0}'' system property specified, defaulting to 'true'.", new Object[]{SYSPROP_PREFER_IPv4_STACK});
            }
        } else if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "''{0}'' system property previously specified with value ''{1}'', not applying default value.", new Object[]{SYSPROP_PREFER_IPv4_STACK, preferIPv4Stack});
        }
    }

    public static boolean isPreferIPv4Stack() {
        String preferIPv4Stack = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(IpAddressUtils.SYSPROP_PREFER_IPv4_STACK);
            }
        });
        return preferIPv4Stack != null && preferIPv4Stack.equalsIgnoreCase("true");
    }

    public static boolean isPreferIPv6Addresses() {
        String preferIPv6Addresses = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(IpAddressUtils.SYSPROP_PREFER_IPv6_ADDRESSES);
            }
        });
        return preferIPv6Addresses != null && preferIPv6Addresses.equalsIgnoreCase("true");
    }

    public static boolean isIPv6ModuleLoaded() {
        return IPv6MODULE_LOADED;
    }

    static {
        Enumeration<NetworkInterface> nifs;
        block5: {
            IPv6_ANY_ADDRESS = IpAddressUtils.getIPv6AnyAddress();
            IPv6_LOOPBACK_ADDRESS = IpAddressUtils.getIPv6LoopbackAddress();
            logger = TraceLogger.getLogger(IpAddressUtils.class);
            DUAL_STACK = false;
            IPv6MODULE_LOADED = false;
            nifs = null;
            try {
                nifs = NetworkInterface.getNetworkInterfaces();
            }
            catch (SocketException se) {
                if (!logger.isLoggable(Level.FINEST)) break block5;
                logger.log(Level.FINEST, "Error encountered while querying network interfaces :" + se.toString());
            }
        }
        block2: while (nifs != null && nifs.hasMoreElements()) {
            NetworkInterface ni = nifs.nextElement();
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias != null && ias.hasMoreElements()) {
                InetAddress ia = ias.nextElement();
                boolean ipv6 = ia instanceof Inet6Address;
                if (!IPv6MODULE_LOADED && ipv6) {
                    IPv6MODULE_LOADED = ipv6;
                }
                if (DUAL_STACK || !ipv6 || ia.isMulticastAddress() || ia.isAnyLocalAddress() || ia.isLoopbackAddress() || ia.isLinkLocalAddress() || ia.isSiteLocalAddress() || ia.isMCGlobal() || ia.isMCLinkLocal() || ia.isMCSiteLocal() || ia.isMCOrgLocal() || ia.isMCNodeLocal()) continue;
                DUAL_STACK = true;
                break block2;
            }
        }
    }
}

