/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.net;

import com.evermind.util.HTTPProperties;
import java.io.IOException;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;

public class MulticastSender
extends OutputStream {
    public static final String secondInterface = HTTPProperties.getOc4jMulticastBindInterface();
    protected InetAddress group;
    protected int port;
    protected MulticastSocket socket;
    protected byte[] buffer = new byte[1000];
    protected int bufferPos = 17;
    protected long clientID;
    protected int currentMessageID;
    protected int segmentID;

    public MulticastSender(InetAddress address, int port, long id) throws IOException {
        if (id == -1L) {
            throw new InternalError("bah");
        }
        this.port = port;
        this.group = address;
        this.socket = new MulticastSocket(port);
        if (secondInterface != null) {
            this.socket.setInterface(InetAddress.getByName(secondInterface));
        }
        this.clientID = id;
    }

    protected void sendSegment(boolean last) throws IOException {
        this.buffer[0] = last ? (byte)1 : 0;
        this.buffer[1] = (byte)this.clientID;
        this.buffer[2] = (byte)(this.clientID >> 8);
        this.buffer[3] = (byte)(this.clientID >> 16);
        this.buffer[4] = (byte)(this.clientID >> 24);
        this.buffer[5] = (byte)(this.clientID >> 32);
        this.buffer[6] = (byte)(this.clientID >> 40);
        this.buffer[7] = (byte)(this.clientID >> 48);
        this.buffer[8] = (byte)(this.clientID >> 56);
        this.buffer[9] = (byte)this.currentMessageID;
        this.buffer[10] = (byte)(this.currentMessageID >> 8);
        this.buffer[11] = (byte)(this.currentMessageID >> 16);
        this.buffer[12] = (byte)(this.currentMessageID >> 24);
        this.buffer[13] = (byte)this.segmentID;
        this.buffer[14] = (byte)(this.segmentID >> 8);
        this.buffer[15] = (byte)(this.segmentID >> 16);
        this.buffer[16] = (byte)(this.segmentID >> 24);
        if (HTTPProperties.getMulticastDebug()) {
            System.out.println("Multicast: Sending " + (this.bufferPos - 17) + " long message...");
        }
        DatagramPacket packet = new DatagramPacket(this.buffer, this.bufferPos, this.group, this.port);
        this.socket.send(packet);
        ++this.segmentID;
        this.bufferPos = 17;
    }

    public void nextMessage() throws IOException {
        this.sendSegment(true);
        ++this.currentMessageID;
        this.segmentID = 0;
    }

    public void write(int i) throws IOException {
        if (this.bufferPos >= 1000) {
            this.sendSegment(false);
        }
        this.buffer[this.bufferPos++] = (byte)i;
    }

    public void write(int[] data, int offset, int length) throws IOException {
        while (length + this.bufferPos > 1000) {
            System.arraycopy(data, offset, this.buffer, this.bufferPos, 1000 - this.bufferPos);
            length -= 1000 - this.bufferPos;
            offset += 1000 - this.bufferPos;
            this.sendSegment(false);
        }
        System.arraycopy(data, offset, this.buffer, this.bufferPos, length);
    }
}

