/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.parser;

import com.evermind.parser.Expression;
import com.evermind.parser.ExpressionContext;
import com.evermind.parser.NumberExpression;
import com.evermind.parser.Settable;
import com.evermind.parser.StringExpression;

public class ParameterExpression
implements NumberExpression,
StringExpression,
Settable {
    private String name;

    public ParameterExpression(String name) {
        this.name = name;
    }

    public double evaluate(ExpressionContext context) {
        return context.getDoubleParameter(this.name);
    }

    public void set(ExpressionContext context, double value) {
        context.setParameter(this.name, value);
    }

    public String evaluateString(ExpressionContext context) {
        return context.getParameter(this.name);
    }

    public void write(StringBuffer buffer, ExpressionContext context, Expression enclosing) {
        context.writeParameter(buffer, this.name, enclosing);
    }

    public String toString() {
        return "[parameter: " + this.name + "]";
    }
}

