/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.security.Group;
import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.util.ObjectUtils;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.math.BigInteger;
import java.security.Permission;
import java.security.cert.X509Certificate;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import oracle.security.jazn.realm.DeactivatableUser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationServerUser
implements User,
XMLizable,
Comparable,
DeactivatableUser {
    protected UserManager manager;
    protected String name;
    protected String description;
    protected String username;
    protected String password;
    protected Locale locale;
    protected Properties properties;
    protected Set groups;
    protected boolean deactivated;
    protected boolean locked;
    protected String certificateIssuerDN;
    protected BigInteger certificateSerial;

    public ApplicationServerUser(UserManager manager, String username) {
        this.manager = manager;
        this.username = username;
    }

    public ApplicationServerUser(UserManager manager, String username, String password) {
        this.manager = manager;
        this.username = username;
        this.password = password;
    }

    public ApplicationServerUser(Node parent, UserManager manager) throws InstantiationException {
        this.manager = manager;
        this.username = XMLUtils.getNodeAttribute(parent, "username");
        if (this.username == null) {
            this.username = XMLUtils.getNodeAttribute(parent, "name");
        }
        this.deactivated = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "deactivated"));
        this.locale = ObjectUtils.toLocale(XMLUtils.getNodeAttribute(parent, "locale"));
        this.setRealName(XMLUtils.getNodeAttribute(parent, "realname"));
        this.certificateIssuerDN = XMLUtils.getNodeAttribute(parent, "certificate-issuer");
        String serialIDString = XMLUtils.getNodeAttribute(parent, "certificate-serial-id");
        if (serialIDString != null) {
            this.certificateSerial = new BigInteger(serialIDString);
        }
        this.setPassword(XMLUtils.getNodeAttribute(parent, "password"));
        if (this.username == null) {
            throw new InstantiationException("User's username was null");
        }
        NodeList list = parent.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Group group;
            String groupName;
            Node node = list.item(i);
            String name = node.getNodeName();
            if (name.equals("name")) {
                this.setRealName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("certificate-issuer")) {
                this.certificateIssuerDN = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("certificate-serial-id")) {
                this.certificateSerial = new BigInteger(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("group-membership") || (groupName = XMLUtils.getNodeAttribute(node, "group")) == null || (group = manager.getGroup(groupName)) == null) continue;
            this.addToGroup(group);
        }
        this.locked = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "locked"));
    }

    public String getDescription() {
        return this.description;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getName() {
        return this.username;
    }

    public String getRealName() {
        return this.name;
    }

    public boolean authenticate(String password) {
        return !this.deactivated && password.equals(this.password);
    }

    public void setRealName(String realName) {
        this.name = realName;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void addToGroup(Group group) {
        if (this.locked) {
            throw new SecurityException("Cannot add locked user to group");
        }
        if (this.groups == null) {
            this.groups = new HashSet();
        }
        this.groups.add(group);
    }

    public void removeFromGroup(Group group) throws UnsupportedOperationException {
        if (this.locked) {
            throw new SecurityException("Cannot remove locked user from group");
        }
        if (this.groups == null) {
            return;
        }
        this.groups.remove(group);
    }

    public String getPassword() {
        return this.password;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof ApplicationServerUser)) {
            return false;
        }
        return this.username.equals(((ApplicationServerUser)other).username);
    }

    public boolean hasPermission(Permission permission) {
        if (this.groups == null) {
            return false;
        }
        Iterator iterator = this.groups.iterator();
        while (iterator.hasNext()) {
            Group group = (Group)iterator.next();
            if (!group.hasPermission(permission)) continue;
            return true;
        }
        return false;
    }

    public boolean isMemberOf(Group group) {
        if (this.manager.getDefaultGroups().contains(group)) {
            return true;
        }
        if (this.groups == null) {
            return false;
        }
        return this.groups.contains(group);
    }

    public String toString() {
        return this.username;
    }

    public void writeXML(PrintWriter writer, String indention) {
        String language;
        writer.write(indention + "<user username=\"" + XMLUtils.encode(this.username) + "\"");
        if (this.password != null) {
            writer.write(" password=\"" + this.password + "\"");
        }
        if (this.name != null) {
            writer.print(" realname=\"" + XMLUtils.encode(this.name) + "\"");
        }
        if (this.locale != null && (language = this.locale.getLanguage()) != null) {
            writer.write(" locale=\"");
            writer.write(language);
            if (this.locale.getCountry() != null) {
                writer.write("_");
                writer.write(this.locale.getCountry());
            }
            writer.write("\"");
        }
        if (this.locked) {
            writer.write(" locked=\"true\"");
        }
        if (this.deactivated) {
            writer.write(" deactivated=\"true\"");
        }
        writer.println(">");
        if (this.description != null) {
            writer.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
        }
        if (this.certificateIssuerDN != null) {
            writer.println(indention + "\t<certificate-issuer>" + XMLUtils.encode(this.certificateIssuerDN) + "</certificate-issuer>");
        }
        if (this.certificateSerial != null) {
            writer.println(indention + "\t<certificate-serial-id>" + this.certificateSerial + "</certificate-serial-id>");
        }
        if (this.groups != null && !this.groups.isEmpty()) {
            Iterator iterator = this.groups.iterator();
            while (iterator.hasNext()) {
                writer.println(indention + "\t<group-membership group=\"" + XMLUtils.encode(((Group)iterator.next()).getName()) + "\" />");
            }
        }
        writer.println(indention + "</user>");
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setProperty(String name, String value) {
        if (value == null) {
            if (this.properties == null) {
                return;
            }
            this.properties.remove(name);
            if (this.properties.isEmpty()) {
                this.properties = null;
            }
        } else {
            if (this.properties == null) {
                this.properties = new Properties();
            }
            this.properties.put(name, value);
        }
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(name);
    }

    public BigInteger getCertificateSerial() {
        return this.certificateSerial;
    }

    public String getCertificateIssuerDN() {
        return this.certificateIssuerDN;
    }

    public void setCertificate(String issuerDN, BigInteger serial) {
        this.certificateIssuerDN = issuerDN;
        this.certificateSerial = serial;
    }

    public void setCertificate(X509Certificate cert) {
        if (cert == null) {
            this.certificateIssuerDN = null;
            this.certificateSerial = null;
        } else {
            this.certificateIssuerDN = cert.getIssuerDN().getName();
            this.certificateSerial = cert.getSerialNumber();
        }
    }

    public boolean isDeactivated() {
        return this.deactivated;
    }

    public void setDeactivated(boolean deactivated) {
        this.deactivated = deactivated;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int compareTo(Object other) {
        if (!(other instanceof User)) {
            return -1;
        }
        return this.username.compareTo(((User)other).getName());
    }

    public Set getGroups() {
        return this.groups;
    }
}

