/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.ApplicationContext;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ApplicationServerTransaction;
import com.evermind.server.TwoPhaseCommitProvider;
import com.evermind.server.WrappedXAResource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import oracle.as.j2ee.transaction.propagation.ParentReference;
import oracle.as.j2ee.transaction.tpc.GlobalTransaction;
import oracle.as.j2ee.transaction.tpc.ProtocolErrorWithNotification;
import oracle.j2ee.transaction.TransactionMessages;
import oracle.jdbc.xa.OracleMultiPhaseArgs;
import oracle.jdbc.xa.OracleXAException;
import oracle.jdbc.xa.client.OracleXAResource;
import oracle.oc4j.sql.spi.XAResourceWrapper;

public class OracleTwoPhaseCommitDriver
implements TwoPhaseCommitProvider {
    private String m_jndiName;
    private String m_username;
    private String m_password;
    private Hashtable m_allResources = new Hashtable();
    private ApplicationServerTransaction m_tx;
    static final String DBLINK_IS_NULL = "One or more DBLinks is null, insure a dblink property is defined on all participant datasources";
    private static final String ORACLETPCDRIVERCLASSNAME = OracleTwoPhaseCommitDriver.class.getName();

    public void commit(XAResource[] resources, Xid[] xids) throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SystemException {
        if (resources.length == 0) {
            throw new RollbackException("Commit called on transaction with no resources");
        }
        this.gatherAllResources(resources, xids);
        Connection conn = this.getConnection(resources, xids);
        this.doCommitAndCleanup(resources, xids, conn);
    }

    void gatherAllResources(XAResource[] resources, Xid[] xids) throws RollbackException {
        int i;
        OracleXAResource[] oresources = new OracleXAResource[resources.length];
        for (i = 0; i < resources.length; ++i) {
            if (resources[i] == null) {
                throw new RollbackException(TransactionMessages.warningXAResourceIsNull());
            }
            if (this.getSQLXAResourceWrapper(resources[i]) == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, TransactionMessages.warningNonXAResourceWrapper(resources[i]));
            }
            if (this.getUnwrappedXAResource(resources[i]) == null) {
                throw new RollbackException(TransactionMessages.warningXAResourceIsNull());
            }
            if (!(this.getUnwrappedXAResource(resources[i]) instanceof OracleXAResource)) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, TransactionMessages.warningNonOracleXAResource(this.getUnwrappedXAResource(resources[i])));
            }
            oresources[i] = (OracleXAResource)this.getUnwrappedXAResource(resources[i]);
        }
        for (i = 0; i < oresources.length; ++i) {
            Vector<Xid> v;
            OracleXAResource oResource = oresources[i];
            if (oResource.getDBLink() == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, DBLINK_IS_NULL);
            }
            if ((v = (Vector<Xid>)this.m_allResources.get(oResource.getDBLink())) != null) continue;
            v = new Vector<Xid>();
            for (int j = 0; j < resources.length; ++j) {
                TransactionMessages.fineDBLinkEquals(oResource.getDBLink());
                if (!oResource.getDBLink().equals(oresources[j].getDBLink())) continue;
                v.addElement(xids[j]);
                TransactionMessages.fineAddedResourceForDBLink(oResource.getDBLink());
            }
            this.m_allResources.put(oResource.getDBLink(), v);
        }
    }

    private Connection getConnection(XAResource[] resources, Xid[] xids) throws RollbackException {
        Connection conn = null;
        try {
            TransactionMessages.fineAttemptingToCreateConnForJNDIAndUser(this.m_jndiName, this.m_username);
            if (this.m_jndiName == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "JNDI name for datasource in commit coordinator properties is null");
            }
            Object dataSourceObject = null;
            if (this.getContext() != null) {
                try {
                    dataSourceObject = this.getContext().lookup(this.m_jndiName);
                }
                catch (NameNotFoundException e) {
                    this.attemptToRollbackAndThrowRollbackException(resources, xids, TransactionMessages.warningNoDSFoundForJNDI(this.m_jndiName));
                }
                catch (NamingException e) {
                    this.attemptToRollbackAndThrowRollbackException(resources, xids, TransactionMessages.warningNoDSFoundForJNDI(this.m_jndiName));
                }
            }
            if (dataSourceObject != null && dataSourceObject instanceof DataSource) {
                TransactionMessages.fineOracleTwoPhaseCommitDriverDataSourceEquals(dataSourceObject);
                this.m_tx.setTransactionState(5);
                conn = this.m_username == null || this.m_password == null || this.m_username.equals("") || this.m_password.equals("") ? ((DataSource)dataSourceObject).getConnection() : ((DataSource)dataSourceObject).getConnection(this.m_username, this.m_password);
            } else if (dataSourceObject == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "internal error: defaultContext is null");
            } else {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "dataSource for CommitCoOrdinator should be of type javax.sql.DataSource");
            }
            if (conn == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "Connection to in-database coordinator was null");
            }
        }
        catch (SQLException e) {
            TransactionMessages.warningSQLExDuringInDBCoordCreation(e);
            this.attemptToRollbackAndThrowRollbackException(resources, xids, "SQLException during creation of in-database coordinator connection = " + e);
        }
        return conn;
    }

    ApplicationContext getContext() {
        return ApplicationServer.getInstance().getDefaultApplication().getContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void doCommitAndCleanup(XAResource[] resources, Xid[] xids, Connection conn) throws RollbackException {
        block16: {
            byte[] toServer;
            OracleMultiPhaseArgs multiPhaseArgs = this.getMultiPhaseArgs(1);
            if (multiPhaseArgs == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "Arguments for in-database coordinator were null");
            }
            if ((toServer = multiPhaseArgs.toByteArray()) == null) {
                this.attemptToRollbackAndThrowRollbackException(resources, xids, "Arguments byte array for in-database coordinator was null");
            }
            this.thinTwoPhase(conn, toServer);
            for (int i = 0; i < resources.length; ++i) {
                try {
                    this.getSQLXAResourceWrapper(resources[i]).commit(xids[i], false, true);
                    continue;
                }
                catch (XAException e) {
                    TransactionMessages.warningXAExDuringWrapperCleanup(this.getSQLXAResourceWrapper(resources[i]), e);
                }
            }
            Object var9_9 = null;
            try {
                if (conn != null) {
                    conn.close();
                }
                break block16;
            }
            catch (SQLException e2) {
                e2.printStackTrace();
            }
            break block16;
            {
                catch (SQLException e) {
                    this.attemptToRollbackAndThrowRollbackException(resources, xids, "Could not commit: error code " + e.getErrorCode() + "- for additional error code check Oracle log file");
                    Object var9_10 = null;
                    try {
                        if (conn != null) {
                            conn.close();
                        }
                        break block16;
                    }
                    catch (SQLException e2) {
                        e2.printStackTrace();
                    }
                }
            }
            catch (Throwable throwable) {
                Object var9_11 = null;
                try {
                    if (conn != null) {
                        conn.close();
                    }
                }
                catch (SQLException e2) {
                    e2.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    void attemptToRollbackAndThrowRollbackException(XAResource[] resources, Xid[] xids, String msg) throws RollbackException {
        this.rollbackResources(resources, xids);
        throw new RollbackException(msg);
    }

    private void rollbackResources(XAResource[] resources, Xid[] xids) {
        for (int i = 0; i < resources.length; ++i) {
            try {
                if (resources[i] == null) continue;
                resources[i].rollback(xids[i]);
                continue;
            }
            catch (XAException e) {
                TransactionMessages.warningXAExceptionDuringRollbackCleanup(e);
            }
        }
    }

    private OracleMultiPhaseArgs getMultiPhaseArgs(int action) {
        Vector<String> dblinks = new Vector<String>();
        Vector<Object> xids = new Vector<Object>();
        Enumeration eDBLinks = this.m_allResources.keys();
        while (eDBLinks.hasMoreElements()) {
            String dblink = (String)eDBLinks.nextElement();
            TransactionMessages.fineDBLinkInArgs(dblink);
            Vector v = (Vector)this.m_allResources.get(dblink);
            for (int i = 0; i < v.size(); ++i) {
                Xid xid = (Xid)v.elementAt(i);
                xids.addElement(new Integer(xid.getFormatId()));
                xids.addElement(xid.getGlobalTransactionId());
                xids.addElement(xid.getBranchQualifier());
                dblinks.addElement(dblink);
                TransactionMessages.fineXid(xid);
                TransactionMessages.fineAddedIntoDBLinks(dblink);
            }
        }
        OracleMultiPhaseArgs mpargs = new OracleMultiPhaseArgs(action, dblinks.size(), xids, dblinks);
        return mpargs;
    }

    private int thinTwoPhase(Connection conn, byte[] toServer) throws SQLException {
        int retValue = -1;
        CallableStatement cstmt = conn.prepareCall(" begin ? := JAVA_XA.xa_thinTwophase (?); end; ");
        cstmt.registerOutParameter(1, 2);
        cstmt.setBytes(2, toServer);
        cstmt.execute();
        retValue = cstmt.getInt(1);
        if (retValue > 0) {
            OracleXAException oe = new OracleXAException(retValue);
            throw new SQLException(TransactionMessages.warningSQLExceptionDuringThinTwoPhase(oe.getOracleError(), oe.getOracleSQLError()));
        }
        return retValue;
    }

    private XAResourceWrapper getSQLXAResourceWrapper(XAResource resource) {
        while (resource instanceof WrappedXAResource) {
            if (resource instanceof XAResourceWrapper) {
                return (XAResourceWrapper)resource;
            }
            resource = ((WrappedXAResource)((Object)resource)).getWrappedResource();
        }
        return null;
    }

    private XAResource getUnwrappedXAResource(XAResource resource) {
        while (resource instanceof WrappedXAResource) {
            resource = ((WrappedXAResource)((Object)resource)).getWrappedResource();
        }
        return resource;
    }

    public void setTransactionHandle(ApplicationServerTransaction t) {
        this.m_tx = t;
    }

    public int getStatus() {
        return 0;
    }

    public String getJndiName() {
        return this.m_jndiName;
    }

    public void setJndiName(String name) {
        this.m_jndiName = name;
    }

    public String getPassword() {
        return this.m_password;
    }

    public void setPassword(String password) {
        this.m_password = password;
    }

    public String getUserName() {
        return this.m_username;
    }

    public void setUserName(String userName) {
        this.m_username = userName;
    }

    public GlobalTransaction getGlobalTransaction() {
        return null;
    }

    public void commit(boolean heuristic) {
        throw new ProtocolErrorWithNotification("Database Commit Provider does not support this operation: mid-tier commit");
    }

    public int prepare(Xid[] xids, XAResource[] resources, ParentReference pr) throws XAException {
        throw new ProtocolErrorWithNotification("Database Commit Provider does not support this operation: prepare");
    }

    public void rollback(boolean heuristic) {
        throw new ProtocolErrorWithNotification("Database Commit Provider does not support this operation: mid-tier rollback");
    }
}

