/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.server.AbstractThreadPoolConfig;
import com.evermind.server.ApplicationServerThreadPoolConfig;
import java.io.IOException;
import java.io.PrintWriter;
import oracle.j2ee.connector.ConnectorMessages;
import oracle.oc4j.configuration.ConfigException;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

public class WorkManagerThreadPoolConfig
extends AbstractThreadPoolConfig {
    protected static final int MIN_ALLOWED_MIN_POOL_SIZE = 2;

    public WorkManagerThreadPoolConfig() {
        super("work-manager");
        this.setMinPoolSize(1);
        this.setMaxPoolSize(1024);
        this.setQueueSize(0);
        this.setImplicit(true);
    }

    public WorkManagerThreadPoolConfig(Node node, String name) throws ConfigException {
        super(node, name);
    }

    public void validateMinPoolSize() {
        int min = this.getMinPoolSize();
        int n = min = min < 0 ? 0 : min;
        if (min < 2) {
            ConnectorMessages.warningMinPoolSize(2);
            this.setMinPoolSize(2);
            this.setMaxPoolSize(this.getMaxPoolSize() + (2 - min));
        }
        if (this.getMinPoolSize() == this.getMaxPoolSize()) {
            this.setMaxPoolSize(this.getMaxPoolSize() + 1);
        }
    }

    public void read(Node node, String name) throws DOMException {
        super.read(node, name);
    }

    public void write(PrintWriter out, String indent) throws IOException {
        if (ApplicationServerThreadPoolConfig.THREADPOOL_OUTPUT_OLDFORMAT) {
            super.write(out, indent);
            return;
        }
        super.writeNewFormat(out, indent);
    }
}

