/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server;

import com.evermind.net.NetUtils;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.ServerConfig;
import com.evermind.util.ClassDescriptor;
import com.evermind.util.CollectionLogger;
import com.evermind.util.Logger;
import com.evermind.xml.XMLConfig;
import java.net.InetAddress;
import java.util.ArrayList;
import oracle.oc4j.admin.config.LogConfig;
import oracle.oc4j.configuration.ConfigException;
import org.w3c.dom.Node;

public abstract class XMLServerConfig
extends XMLConfig
implements ServerConfig {
    private XMLServerConfig parent;
    private InetAddress address;
    protected int port = -1;
    protected CollectionLogger logger;
    protected LogConfig logConfig;
    protected boolean development;
    protected ArrayList startupClasses;
    protected ArrayList shutdownClasses;
    private long taskManagerInterval = -1L;
    private static int globalId = 0;
    private final int myId = ++globalId;

    public XMLServerConfig(XMLServerConfig parent) {
        this.parent = parent;
    }

    public XMLServerConfig getParent() {
        return this.parent;
    }

    public long getTaskManagerInterval() {
        return this.taskManagerInterval;
    }

    public int getPort() {
        if (this.port < 0) {
            return this.getDefaultPort();
        }
        return this.port;
    }

    protected void postInit() throws InstantiationException {
        super.postInit();
        this.assignDefaultPort();
        this.postInitLogger();
    }

    protected void assignDefaultPort() {
        if (this.port <= 0) {
            this.port = this.getDefaultPort();
        }
    }

    public synchronized InetAddress getAddress() {
        if (this.address == null) {
            this.address = this.parent != null ? this.parent.getAddress() : NetUtils.ZERO_ADDRESS;
        }
        return this.address;
    }

    public synchronized void setAddress(InetAddress address) {
        this.address = address;
    }

    public synchronized void setPort(int port) {
        this.port = port;
    }

    protected synchronized int getDefaultPort() {
        return 0;
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("log")) {
            this.parseLogConfig(node);
        } else if (name.equals("startup-classes")) {
            if (this.startupClasses == null) {
                this.startupClasses = new ArrayList();
            }
            ClassDescriptor.parseClasses(node, "startup-class", this.startupClasses);
        } else if (name.equals("shutdown-classes")) {
            if (this.shutdownClasses == null) {
                this.shutdownClasses = new ArrayList();
            }
            ClassDescriptor.parseClasses(node, "shutdown-class", this.shutdownClasses);
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("host")) {
            if (value.equalsIgnoreCase("[ALL]")) {
                this.address = NetUtils.ZERO_ADDRESS;
            } else {
                try {
                    this.address = InetAddress.getByName(value);
                }
                catch (Exception e) {
                    throw new InstantiationException("Illegal/unknown hostname: " + value);
                }
            }
        } else if (name.equals("port")) {
            try {
                this.port = Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Illegal port value (not a number between 0 and 65535): '" + value + "'");
            }
        } else if (name.equals("taskmanager-interval")) {
            try {
                this.taskManagerInterval = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Illegal taskmanager-interval value (not a valid long): '" + value + "'");
            }
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = new CollectionLogger();
        }
        return this.logger;
    }

    protected void reset() {
        super.reset();
        this.address = null;
        this.port = -1;
        this.logger = null;
        this.development = false;
    }

    private void parseLogConfig(Node node) throws InstantiationException {
        try {
            this.logConfig = new LogConfig(this, node);
        }
        catch (ConfigException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    private void postInitLogger() throws InstantiationException {
        if (this.logConfig == null) {
            return;
        }
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
        try {
            this.logger = this.logConfig.getCollectionLogger();
        }
        catch (ConfigException e) {
            throw new InstantiationException(e.getMessage());
        }
        String dmsStr = this.logConfig.getDMSString();
        if (ApplicationServer.DMS_GATE && dmsStr != null && OC4JServer.getInstanceId() != null) {
            this.createDMSState(dmsStr);
        }
    }

    protected void createDMSState(String dmsStr) {
    }
}

