/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.cluster;

import com.evermind.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;

public class ServerIdentification
implements Serializable {
    public static final long serialVersionUID = 34545474343L;
    private String address;
    private int port;
    private long clusterID;

    public ServerIdentification(String address, int port) {
        this.address = address;
        this.port = port;
    }

    public ServerIdentification(String address, int port, long clusterID) {
        this.address = address;
        this.port = port;
        this.clusterID = clusterID;
    }

    public String getAddress() {
        return this.address;
    }

    public int getPort() {
        return this.port;
    }

    public String toString() {
        return this.address + ":" + this.port;
    }

    public void write(OutputStream out) throws IOException {
        IOUtils.writeUTF(out, this.address);
        IOUtils.writeCompressedInt(out, this.port);
        IOUtils.writeCompressedLong(out, this.clusterID);
    }

    public static ServerIdentification read(InputStream in) throws IOException {
        String address = IOUtils.readUTF(in);
        int port = IOUtils.readCompressedInt(in);
        long clusterID = IOUtils.readCompressedLong(in);
        return new ServerIdentification(address, port, clusterID);
    }

    public boolean equals(Object o) {
        if (o instanceof ServerIdentification) {
            ServerIdentification other = (ServerIdentification)o;
            return this.address.equals(other.address) && this.port == other.port;
        }
        return false;
    }
}

