/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.connector;

import com.evermind.security.User;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ContextContainer;
import com.evermind.server.ThreadState;
import com.evermind.server.connector.ApplicationConnectionManager;
import com.evermind.server.connector.ContainerAuthenticationData;
import com.evermind.server.connector.deployment.PrincipalHolder;
import java.io.Serializable;
import java.security.Principal;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NamingException;
import javax.resource.ResourceException;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import oracle.as.j2ee.transaction.tpc.ResourceManagerFactory;
import oracle.as.j2ee.transaction.tpc.TPCException;
import oracle.j2ee.connector.ConnectionPoolConnFactoryContext;
import oracle.j2ee.connector.InitiatingGroup;
import oracle.j2ee.connector.InitiatingPrincipal;
import oracle.j2ee.connector.logging.JCATransactionMessages;
import oracle.j2ee.connector.transaction.EmulatedXAResource;
import oracle.security.jazn.oc4j.JAZNGroupAdaptor;

public class JCAResourceManagerFactory
implements ResourceManagerFactory,
Serializable {
    private ApplicationConnectionManager m_acm;
    public static final String APPNAME_LENGTH_DELIMITER = "_";

    public JCAResourceManagerFactory(ApplicationConnectionManager acm) {
        this.m_acm = acm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XAResource connect(String rmArgs) throws TPCException {
        boolean isoriginalContextContainerNull = this.isContextContainerNull();
        try {
            XAResource xAResource = this.connect(rmArgs, isoriginalContextContainerNull);
            return xAResource;
        }
        finally {
            if (isoriginalContextContainerNull) {
                ThreadState.getCurrentState().setContextContainer(null);
            }
        }
    }

    boolean isContextContainerNull() {
        return ThreadState.getCurrentState().getContextContainer() == null;
    }

    private XAResource connect(String rmArgs, boolean isoriginalContextContainerNull) throws TPCException {
        TPCException tpc;
        ContainerAuthenticationData containerAuthenticationData;
        Subject resSubject;
        String oc4jUserInfo = this.setupJNDIContext(rmArgs, isoriginalContextContainerNull);
        JCATransactionMessages.fineConnectCalled(oc4jUserInfo);
        if (!this.m_acm.m_xaRecoveryCredentials.isEmpty()) {
            resSubject = new Subject();
            Set<Object> resPrivateCredentials = resSubject.getPrivateCredentials();
            containerAuthenticationData = new ContainerAuthenticationData();
            containerAuthenticationData.setSubject(resSubject);
            Iterator iterator = this.m_acm.m_xaRecoveryCredentials.iterator();
            while (iterator.hasNext()) {
                Object m_xaRecoveryCredential = iterator.next();
                PrincipalHolder xaUser = (PrincipalHolder)m_xaRecoveryCredential;
                String password = xaUser.getPassword();
                char[] pwCharArray = new char[]{};
                if (password != null) {
                    pwCharArray = password.toCharArray();
                }
                PasswordCredential pwCred = new PasswordCredential(xaUser.getUser(), pwCharArray);
                pwCred.setManagedConnectionFactory(this.m_acm.mcf);
                resPrivateCredentials.add(pwCred);
            }
        } else {
            resSubject = new Subject();
            if (oc4jUserInfo != null && !oc4jUserInfo.equals("null")) {
                Set<Principal> principals = resSubject.getPrincipals();
                this.addPrincipalsWithGroups(principals, oc4jUserInfo);
            }
            containerAuthenticationData = this.m_acm.getContainerAuthenticationData(this.m_acm.mcf, resSubject);
        }
        if (resSubject == null) {
            JCATransactionMessages.warningNullRecoveryUser(this.m_acm.m_displayName);
            throw new TPCException("Could not get XAResource for " + this.m_acm.m_displayName + " as Subject was null.  " + "This may be due to misconfigured or missing recovery credentials");
        }
        ManagedConnection mc = null;
        XAResource xaRes = null;
        try {
            mc = this.m_acm.connectionPool.getManagedConnection(this.m_acm, new ConnectionPoolConnFactoryContext(this.m_acm.mcf, containerAuthenticationData, null));
        }
        catch (ResourceException e) {
            JCATransactionMessages.warningRecoveryFailed(this.m_acm.m_displayName, e);
            tpc = new TPCException("Could not get ManagedConnection in order to get XAResource for " + this.m_acm.m_displayName);
            tpc.initCause(e);
            throw tpc;
        }
        try {
            if (mc == null) {
                throw new TPCException("Unable to create a JCA ManagedConnection for " + this.m_acm.m_displayName);
            }
            if (3 == this.m_acm.m_transactionSupport) {
                xaRes = mc.getXAResource();
            }
        }
        catch (ResourceException e) {
            JCATransactionMessages.warningRecoveryFailed(this.m_acm.m_displayName, e);
            tpc = new TPCException("Could not get XAResource for " + this.m_acm.m_displayName);
            tpc.initCause(e);
            throw tpc;
        }
        if (2 == this.m_acm.m_transactionSupport) {
            xaRes = new EmulatedXAResource(mc);
        }
        return xaRes;
    }

    String setupJNDIContext(String rmArgs, boolean isContextToBeSet) throws TPCException {
        int indexOfDelimiter = rmArgs.indexOf(APPNAME_LENGTH_DELIMITER);
        int lengthOfAppName = new Integer(rmArgs.substring(0, indexOfDelimiter));
        int indexOfEndOfAppName = indexOfDelimiter + 1 + lengthOfAppName;
        String appName = rmArgs.substring(indexOfDelimiter + 1, indexOfEndOfAppName);
        if (isContextToBeSet) {
            this.setApplicationContextOnThreadState(appName);
        }
        return indexOfEndOfAppName == rmArgs.length() ? null : rmArgs.substring(indexOfEndOfAppName, rmArgs.length());
    }

    void setApplicationContextOnThreadState(String appName) throws TPCException {
        Application application = this.getApplication(appName);
        if (application == null) {
            throw new TPCException("Unable to set " + appName + " application context on thread for JCA resource " + "recovery.  This may be expected during startup if the the application has not been initialized yet");
        }
        ThreadState.getCurrentState().setContextContainer(application);
    }

    Application getApplication(String appName) throws TPCException {
        Application application;
        try {
            application = ApplicationServer.getInstance().getApplication(appName);
        }
        catch (InstantiationException e) {
            TPCException tpcException = new TPCException("InstantiationException while attempting to get application with name:" + appName);
            tpcException.initCause(e);
            throw tpcException;
        }
        return application;
    }

    void addPrincipalsWithGroups(Set principals, String oc4jUserInfo) throws TPCException {
        ThreadState currentState = ThreadState.getCurrentState();
        currentState.setContextContainer(this.m_acm.application);
        Application application = null;
        ContextContainer container = null;
        try {
            container = currentState.getContextContainer();
            application = container.getApplication();
        }
        catch (NamingException e) {
            TPCException tpc = new TPCException("Could not get application for ManagedConnection from container " + container + " for " + this.m_acm.m_displayName);
            tpc.initCause(e);
            throw tpc;
        }
        UserManager userManager = application.getUserManager();
        User user = userManager.getUser(oc4jUserInfo);
        Iterator groupIterator = user.getGroups().iterator();
        InitiatingPrincipal initiatingPrincipal = new InitiatingPrincipal(oc4jUserInfo);
        while (groupIterator.hasNext()) {
            initiatingPrincipal.addGroup(new InitiatingGroup(((JAZNGroupAdaptor)groupIterator.next()).getName()));
        }
        principals.add(initiatingPrincipal);
    }
}

