/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.Module;
import com.evermind.xml.XMLUtils;
import java.io.File;
import java.io.PrintWriter;
import org.w3c.dom.Node;

public class EJBModule
extends Module {
    protected String name;
    private boolean remote;

    public EJBModule(String path) {
        super(path);
    }

    public EJBModule(Node parent) throws InstantiationException {
        super(parent);
        if (parent.getNodeName().equals("module")) {
            this.path = this.checkPath(XMLUtils.getSubnodeValue(parent, "ejb")).replace('\\', '/');
        } else {
            this.remote = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "remote"));
            this.path = XMLUtils.getNodeAttribute(parent, "path");
            this.name = XMLUtils.getNodeAttribute(parent, "id");
        }
        if (this.path == null) {
            throw new InstantiationException("Missing 'path' attribute in <ejb-module> tag");
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.println(indention + this);
    }

    public String getName() {
        if (this.name == null) {
            String name = this.getPath();
            if (name.endsWith(".jar")) {
                name = name.substring(0, name.lastIndexOf("."));
            }
            return name;
        }
        return this.name;
    }

    public String getShortName() {
        int indexOfSeparator;
        String moduleName = this.getName();
        if (moduleName.endsWith("/")) {
            moduleName = moduleName.substring(0, moduleName.length() - 1);
        }
        if ((indexOfSeparator = moduleName.lastIndexOf(File.pathSeparator)) == -1) {
            indexOfSeparator = moduleName.lastIndexOf("/");
        }
        if (indexOfSeparator != -1) {
            moduleName = moduleName.substring(indexOfSeparator + 1, moduleName.length());
        }
        return moduleName;
    }

    public String toString() {
        String msg = "<ejb-module";
        if (this.name != null) {
            msg = msg + " id=\"" + XMLUtils.encode(this.name) + "\"";
        }
        return msg + " remote=\"" + this.remote + "\" path=\"" + XMLUtils.encode(this.getPath()) + "\" /> ";
    }

    public boolean isRemote() {
        return this.remote;
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<module>");
        out.println(indention + "\t<ejb>" + XMLUtils.encode(this.path) + "</ejb>");
        out.println(indention + "</module>");
    }
}

