/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.io.IOUtils;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.ContentArchiveContext;
import com.evermind.naming.file.ContentFileContext;
import com.evermind.naming.file.FileContext;
import com.evermind.naming.memory.MapContext;
import com.evermind.security.Group;
import com.evermind.security.IndirectUserManager;
import com.evermind.security.SecuritySensitive;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.NamespaceAccessController;
import com.evermind.server.OC4JServer;
import com.evermind.server.ServerComponent;
import com.evermind.server.XMLConnectorsConfig;
import com.evermind.server.XMLDataSourcesConfig;
import com.evermind.server.XMLUserManager;
import com.evermind.server.deployment.ApplicationClientServerArchive;
import com.evermind.server.deployment.ClientModule;
import com.evermind.server.deployment.ConnectorModule;
import com.evermind.server.deployment.EJBModule;
import com.evermind.server.deployment.IconDescriptor;
import com.evermind.server.deployment.JMXMBeanDescriptor;
import com.evermind.server.deployment.MailSessionInfo;
import com.evermind.server.deployment.Module;
import com.evermind.server.deployment.ResourceProviderDescriptor;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleContainer;
import com.evermind.server.deployment.UserManagerConfig;
import com.evermind.server.deployment.UserManagerConfigList;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.EJBContainerConfig;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.util.CollectionLogger;
import com.evermind.util.ConfigUtils;
import com.evermind.util.EJBProperties;
import com.evermind.util.Logger;
import com.evermind.util.SecurityProperties;
import com.evermind.xml.XMLUtils;
import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.classloader.util.ClassLoadLogger;
import oracle.classloader.util.FileUtils;
import oracle.classloader.util.PathElement;
import oracle.oc4j.admin.config.ApplicationServerConfig;
import oracle.oc4j.admin.config.LogConfig;
import oracle.oc4j.admin.internal.Notifier;
import oracle.oc4j.admin.jmx.server.Oc4jMBeanServerFactory;
import oracle.oc4j.admin.jmx.shared.util.ObjectNameFactory;
import oracle.oc4j.configuration.ConfigException;
import oracle.oc4j.loader.config.ImportedSharedLibrariesType;
import oracle.oc4j.loader.config.xml.ImportedSharedLibrariesElement;
import oracle.oc4j.sql.config.DataSourceConfigException;
import oracle.oc4j.sql.config.DataSourcesConfig;
import oracle.security.jazn.oc4j.JAZNUserManager;
import oracle.security.jazn.spi.xml.XMLJAZNProvider;
import oracle.security.jazn.util.Env;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EnterpriseArchive
extends ServerComponent
implements ApplicationConfig,
EJBContainerConfig,
SecurityRoleContainer {
    public static final String DEFAULT_DATASOURCES_FILE_NAME = "./data-sources.xml";
    public static final String DATA_SOURCES_CONNECTOR_MODULE_NAME = "datasources";
    private static final String DEFAULT_LIBRARY_DIRECTORY_NAME = "lib";
    public static final int J2EE_1_4 = 0;
    public static final int J2EE_5 = 1;
    private IconDescriptor icon;
    private Collection ejbPackages;
    private Collection webApplications;
    private Collection clients;
    private Collection connectors = new TreeSet();
    private String connectorsPath;
    private List securityRoles;
    protected NamespaceAccessController namespaceAccessController;
    private final Object namespaceAccessControllerLock = new Object();
    private String persistencePath;
    private boolean autoCreateTables = true;
    private boolean autoDeleteTables = false;
    private boolean deployInBatch = true;
    protected String dataSourcesPath;
    private String libraryDirectory;
    protected List libraryPaths;
    protected List canonicalLibraryPaths;
    protected ImportedSharedLibrariesElement importedSharedLibraries;
    protected Map databaseSchemas;
    protected boolean prependDeploymentName;
    protected String defaultDataSource;
    protected boolean treatZeroAsNull = false;
    protected List resourceProviders;
    protected String componentClassification = "external";
    protected List jmxMBeans;
    protected boolean seeParentDataSources = true;
    private boolean isGlobalApplication;
    private Map _extraParams;
    private UserManagerConfigList userManagerList;
    private UserManagerConfigList sensitiveManagerList;
    private boolean explicitSensitive;
    private boolean jaznLoginConfigParsed = false;
    private List mailSessions;
    private MailSessionInfo defaultMailSession;
    private long taskManagerInterval = -1L;
    private CollectionLogger logger;
    private LogConfig logConfig;
    private ApplicationConfig parent;
    private ApplicationServerConfig _applicationServerConfig;
    private JGroupConfig clusterConfig;
    private DataSourcesConfig m_dataSourcesConfig = null;
    private static ConnectorModule m_dataSourcesConnectorModule = null;
    protected Properties properties;
    private int compatibility = 0;
    private boolean firstDeployment = false;
    private boolean isExplodedDeployment = false;

    public EnterpriseArchive(String name, boolean autoUnpack, ApplicationConfig parent) {
        this.setName(name);
        this.setContext(new MapContext());
        this.autoUnpack = autoUnpack;
        this.parent = parent;
        this.userManagerList = new UserManagerConfigList(this.userManagerCompat());
        this.sensitiveManagerList = new UserManagerConfigList(0);
        this.userManagerList.setParent(this.getParentUserManager());
    }

    public EnterpriseArchive(String name, boolean autoUnpack) {
        this(name, autoUnpack, null);
    }

    public EnterpriseArchive(String name, URL url, URL deploymentURL, ApplicationServerConfig applicationServerConfig, ApplicationConfig parentArchive, boolean autoUnpack, Map extraParams) throws IOException, InstantiationException {
        this.setName(name);
        this._extraParams = extraParams;
        this.autoUnpack = autoUnpack;
        this._applicationServerConfig = applicationServerConfig;
        this.parent = parentArchive;
        URL expandURL = url;
        String fname = url.getFile();
        if (!fname.equals("")) {
            File target;
            int idx = fname.lastIndexOf(46);
            if (idx != -1) {
                fname = fname.substring(0, idx);
            }
            if (!(target = new File(fname)).exists()) {
                this.firstDeployment = true;
            }
        }
        if (url.getFile().endsWith(".ear")) {
            expandURL = oracle.oc4j.util.FileUtils.autoUnpack(url, autoUnpack, null);
        }
        Context context = expandURL.getFile().endsWith(".xml") ? null : ContextUtils.getContext(expandURL, true);
        this.setContext(context);
        if (autoUnpack && url != expandURL) {
            this.setURL(expandURL);
            this.setArchiveURL(url);
        } else {
            this.setURL(url);
        }
        if (deploymentURL != null) {
            this.setDeploymentURL(deploymentURL);
        }
        if ("true".equals(this.getExtraParam("explodedDeployment"))) {
            this.isExplodedDeployment = true;
        }
        this.setGlobalApplication(parentArchive == null);
        this.init();
        String data = (String)this.getExtraParam("<main>");
        if (data != null) {
            this.setDeploymentData(data);
        }
        this.initDeployment();
        this.getNamespaceAccessController();
        if ("true".equals(this.getExtraParam("autoCreateTables"))) {
            this.autoCreateTables = true;
        }
        if (this.userManagerList == null) {
            this.userManagerList = new UserManagerConfigList(this.userManagerCompat());
            this.sensitiveManagerList = new UserManagerConfigList(0);
        }
        if (parentArchive == null) {
            UserManager sensitiveManager = this.getSensitiveManager();
            if (sensitiveManager == null) {
                throw new InstantiationException("no UserManager available for password hiding");
            }
            if (SecuritySensitive.global() == null) {
                SecuritySensitive.setGlobal(this.getInitializedUserManager());
            }
        }
        this.initDefaultSettings();
    }

    public ApplicationConfig getParent() {
        return this.parent;
    }

    protected void reset() {
        super.reset();
        this.libraryDirectory = null;
        this.libraryPaths = null;
        this.canonicalLibraryPaths = null;
        this.importedSharedLibraries = null;
        this.seeParentDataSources = true;
        this.icon = null;
        this.ejbPackages = new ArrayList();
        this.webApplications = new ArrayList();
        this.clients = new ArrayList();
        this.connectors = new TreeSet();
        this.securityRoles = null;
        this.namespaceAccessController = null;
        this.persistencePath = null;
        this.autoCreateTables = true;
        this.autoDeleteTables = false;
        this.deployInBatch = true;
        this.m_dataSourcesConfig = null;
        this.dataSourcesPath = null;
        this.componentClassification = "external";
        if (this.parent != null) {
            this.copyParentArchive((EnterpriseArchive)this.parent);
        }
        this.userManagerList = new UserManagerConfigList(this.userManagerCompat());
        this.sensitiveManagerList = new UserManagerConfigList(0);
        this.userManagerList.setParent(this.getParentUserManager());
        this.mailSessions = null;
        this.defaultMailSession = null;
        this.logger = null;
    }

    private int userManagerCompat() {
        int compat = 2;
        if (SecurityProperties.getUserManagerMixed()) {
            compat = 1;
        }
        return compat;
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("autocreate-tables")) {
            this.autoCreateTables = !"false".equalsIgnoreCase(value);
        } else if (name.equals("autodelete-tables")) {
            this.autoDeleteTables = "true".equalsIgnoreCase(value);
        } else if (name.equals("batch-compile")) {
            this.deployInBatch = "true".equalsIgnoreCase(value);
        } else if (name.equals("default-data-source")) {
            this.defaultDataSource = value;
        } else if (name.equals("treat-zero-as-null")) {
            this.treatZeroAsNull = "true".equalsIgnoreCase(value);
        } else if (name.equals("prepend-deployment-name")) {
            this.prependDeploymentName = "true".equalsIgnoreCase(value);
        } else if (name.equals("see-parent-data-sources")) {
            this.seeParentDataSources = "true".equalsIgnoreCase(value);
        } else if (name.equals("taskmanager-interval")) {
            try {
                this.taskManagerInterval = Long.parseLong(value);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("Illegal taskmanager-interval value (not a valid long): '" + value + "'");
            }
        } else if (name.equals("component-classification")) {
            this.componentClassification = value;
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public boolean prependDeploymentName() {
        return this.prependDeploymentName;
    }

    protected void parseMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.equals("icon")) {
            this.icon = new IconDescriptor(node);
        } else if (name.equals("display-name")) {
            this.setDisplayName(XMLUtils.getStringValue(node));
        } else if (name.equals("description")) {
            this.setDescription(XMLUtils.getStringValue(node));
        } else if (name.equals("module")) {
            this.addModule(EnterpriseArchive.getModule(node), false);
        } else if (name.equals("security-role")) {
            this.addSecurityRole(new SecurityRole(node));
        } else if (name.equals("library-directory")) {
            this.setLibraryDirectory(XMLUtils.getStringValue(node));
        } else {
            super.parseMainNode(node);
        }
    }

    protected void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name = node.getNodeName();
        if (name.startsWith("#")) {
            return;
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (int i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                if (!ApplicationServer.serverExtensionProviders[i].parseApplicationMainNode(this, node)) continue;
                return;
            }
        }
        if (name.equals("data-sources")) {
            String path = XMLUtils.getNodeAttribute(node, "path");
            if (path == null) {
                throw new InstantiationException("Missing path attribute in <data-sources> tag");
            }
            if (this.getExtraParam("data-sources") != null) {
                if (path.indexOf(File.separator) >= 0) {
                    throw new InstantiationException("path cannot contain path separators");
                }
                Notifier notifier = Notifier.getNotifier();
                if (notifier != null) {
                    notifier.sendNotification("DATASOURCES_FROM_DEPL_PLAN");
                }
                String dataSourcesContent = (String)this.getExtraParam("data-sources");
                byte[] data = dataSourcesContent.getBytes();
                URL url = null;
                try {
                    url = ConfigUtils.getURL(this.getDeploymentURL(), path);
                    IOUtils.writeContent(url, data);
                }
                catch (MalformedURLException e) {
                    throw new InstantiationException("Invalid URL: " + path);
                }
                catch (IOException e) {
                    throw new InstantiationException("Could not write datasource file at " + url);
                }
                this.parseDataSources(path, false);
            } else {
                this.parseDataSources(path, true);
            }
        } else if (name.equals("web-module")) {
            this.addModule(new WebModule(node), true);
        } else if (name.equals("ejb-module")) {
            this.addModule(new EJBModule(node), true);
        } else if (name.equals("connector-module")) {
            this.addModule(new ConnectorModule(node), true);
        } else if (name.equals("connectors")) {
            this.parseConnectors(XMLUtils.getNodeAttribute(node, "path"));
        } else if (name.equals("client-module")) {
            this.addModule(new ClientModule(node), true);
        } else if (name.equals("persistence")) {
            this.persistencePath = XMLUtils.getNodeAttribute(node, "path");
        } else if (name.equals("namespace-access")) {
            this.namespaceAccessController = new NamespaceAccessController(node);
        } else if (name.equals("security-role-mapping")) {
            this.parseSecurityRoleMapping(node);
        } else if (name.equals("library")) {
            this.parseLibrary(node);
        } else if (name.equals("imported-shared-libraries")) {
            this.parseImportedSharedLibraries(node);
        } else if (name.equals("resource-provider")) {
            this.addResourceProvider(new ResourceProviderDescriptor(node));
        } else if (name.equals("jmx-mbean")) {
            this.addJMXMBean(new JMXMBeanDescriptor(node));
        } else if (name.equals("user-manager")) {
            this.parseUserManager(node);
        } else if (name.equals("jazn")) {
            this.parseUserManager(node);
        } else if (name.equals("principals")) {
            this.parseUserManager(node);
        } else if (name.equals("password-manager")) {
            this.parseSensitive(node);
        } else if (name.equals("mail-session")) {
            this.addMailSession(new MailSessionInfo(node));
        } else if (name.equals("log")) {
            this.parseLogConfig(node);
        } else if (name.equals("cluster")) {
            this.parseClusterConfig(node);
        } else if (name.equals("jazn-loginconfig")) {
            this.parseJaznLoginConfig(node);
        } else if (name.equals("property")) {
            this.parseProperty(node);
        } else {
            super.parseDeploymentMainNode(node);
        }
    }

    public JGroupConfig getClusterConfig() {
        if (this.clusterConfig != null) {
            return this.clusterConfig;
        }
        return this.getParentClusterConfig();
    }

    public JGroupConfig getParentClusterConfig() {
        if (this.parent != null) {
            return this.parent.getClusterConfig();
        }
        return null;
    }

    public boolean usingParentClusterConfig() {
        return this.clusterConfig == null && this.getParentClusterConfig() != null;
    }

    private void parseClusterConfig(Node node) throws InstantiationException {
        try {
            JGroupConfig jConfig = new JGroupConfig(this, node);
            this.setClusterConfig(jConfig);
        }
        catch (ConfigException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    public void setClusterConfig(JGroupConfig jConfig) {
        this.clusterConfig = jConfig;
        if (EJBProperties.getEjbClusterDebug() && this.clusterConfig != null) {
            System.out.println(this.clusterConfig.getJGroupsProps());
            PrintWriter writer = new PrintWriter(System.out);
            try {
                this.clusterConfig.write(writer, "");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            writer.flush();
        }
    }

    public boolean isClusterConfigured() {
        return this.clusterConfig != null;
    }

    protected void verifyDocumentType(String name) throws InstantiationException {
        if (!name.equalsIgnoreCase("application") && !name.equalsIgnoreCase("orion-application")) {
            throw new InstantiationException("Document-type of application expected (not " + name + ")");
        }
    }

    protected void writeConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println("<!DOCTYPE application PUBLIC \"-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN\" \"http://java.sun.com/dtd/application_1_3.dtd\">");
        out.println();
        out.println("<application>");
        if (this.getDisplayName() == null) {
            this.setDisplayName(this.getName());
        }
        out.println("\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        if (this.getDescription() != null) {
            out.println("\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getLibraryDirectory() != null) {
            out.println("\t<library-directory>" + XMLUtils.encode(this.getLibraryDirectory()) + "</library-directory>");
        }
        if (this.icon != null) {
            this.icon.writeXML(out, "\t");
        }
        if (this.ejbPackages != null) {
            XMLUtils.writeAll(this.ejbPackages, out, "\t");
        }
        if (this.webApplications != null) {
            XMLUtils.writeAll(this.webApplications, out, "\t");
        }
        if (this.clients != null) {
            XMLUtils.writeAll(this.clients, out, "\t");
        }
        if (this.connectors != null) {
            XMLUtils.writeAll(this.connectors, out, "\t");
        }
        if (this.securityRoles != null) {
            XMLUtils.writeAll(this.securityRoles, out, "\t");
        }
        out.println("</application>");
    }

    protected void writeOrionConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\"?>");
        out.println();
        this.writeOrionXML(out, "");
    }

    private void writeOrionXML(PrintWriter out, String indention) throws IOException {
        int i;
        out.print(indention + "<orion-application  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/orion-application-10_0.xsd\" " + " deployment-version=\"" + XMLUtils.encode(ApplicationServer.VERSION) + "\"");
        if (!this.autoCreateTables) {
            out.print(" autocreate-tables=\"false\"");
        }
        if (this.autoDeleteTables) {
            out.print(" autodelete-tables=\"true\"");
        }
        if (!this.deployInBatch) {
            out.print(" batch-compile=\"false\"");
        }
        if (this.getTaskManagerInterval() > 0L) {
            // empty if block
        }
        if (this.defaultDataSource != null) {
            out.print(" default-data-source=\"" + XMLUtils.encode(this.defaultDataSource) + "\"");
        }
        if (this.treatZeroAsNull) {
            out.print(" treat-zero-as-null=\"true\"");
        }
        if (!this.seeParentDataSources) {
            out.print(" see-parent-data-sources=\"false\"");
        }
        out.println(" component-classification=\"" + this.componentClassification + "\"");
        out.println("  schema-major-version=\"10\" schema-minor-version=\"0\" >");
        EnterpriseArchive.writeModules(out, indention + "\t", this.ejbPackages);
        EnterpriseArchive.writeModules(out, indention + "\t", this.webApplications);
        EnterpriseArchive.writeModules(out, indention + "\t", this.clients);
        if (this.securityRoles != null) {
            for (i = 0; i < this.securityRoles.size(); ++i) {
                ((SecurityRole)this.securityRoles.get(i)).writeOrionXML(out, indention + "\t");
            }
        }
        if (this.persistencePath != null) {
            out.println(indention + "\t<persistence path=\"" + this.persistencePath + "\" />");
        }
        if (this.libraryPaths != null) {
            for (i = 0; i < this.libraryPaths.size(); ++i) {
                PathElement elem = (PathElement)this.libraryPaths.get(i);
                if (elem.getIncludeArchivesFlag()) {
                    out.println(indention + "\t<library path=\"" + XMLUtils.encode(elem.getPathName()) + "\" />");
                    continue;
                }
                out.println(indention + "\t<library path=\"" + XMLUtils.encode(elem.getPathName()) + "\"" + " include-archives=\"false\"" + "/>");
            }
        }
        if (this.importedSharedLibraries != null) {
            this.importedSharedLibraries.write(out, indention + "\t");
        }
        if (this.mailSessions != null) {
            XMLUtils.writeAll(this.mailSessions, out, indention + "\t");
        }
        this.userManagerList.writeXML(out, indention + "\t");
        if (!this.sensitiveManagerList.isEmpty() && this.explicitSensitive) {
            out.println(indention + "\t<password-manager>");
            this.sensitiveManagerList.writeXML(out, indention + "\t\t");
            out.println(indention + "\t</password-manager>");
        }
        if (this.logConfig != null) {
            this.logConfig.write(out, indention + "\t");
        }
        if (this.dataSourcesPath != null) {
            out.println(indention + "\t<data-sources path=\"" + XMLUtils.encode(this.dataSourcesPath) + "\" />");
        }
        if (this.connectorsPath != null) {
            out.println(indention + "\t<connectors path=\"" + XMLUtils.encode(this.connectorsPath) + "\" />");
        }
        if (this.resourceProviders != null) {
            XMLUtils.writeAll(this.resourceProviders, out, indention + "\t");
        }
        if (this.jmxMBeans != null) {
            XMLUtils.writeAll(this.jmxMBeans, out, indention + "\t");
        }
        if (this.namespaceAccessController != null) {
            this.getNamespaceAccessController().writeXML(out, indention + "\t");
        }
        if (ApplicationServer.serverExtensionProviders != null) {
            for (i = 0; i < ApplicationServer.serverExtensionProviders.length; ++i) {
                ApplicationServer.serverExtensionProviders[i].writeApplicationMainNodes(this, out, indention + "\t");
            }
        }
        if (this.clusterConfig != null) {
            this.clusterConfig.write(out, indention + "\t");
        }
        if (this.properties != null) {
            Enumeration<?> e = this.properties.propertyNames();
            while (e.hasMoreElements()) {
                String propName = (String)e.nextElement();
                String propValue = this.properties.getProperty(propName);
                out.println(indention + "\t<property name=\"" + XMLUtils.encode(propName) + "\" value=\"" + XMLUtils.encode(propValue) + "\" />");
            }
        }
        out.println(indention + "</orion-application>");
    }

    public String getDisplayName() {
        String name = super.getDisplayName();
        if (name != null) {
            return name;
        }
        return "Generic Enterprise Archive";
    }

    public void addSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            this.securityRoles = new ArrayList();
        }
        this.securityRoles.add(role);
    }

    public void addModule(Module module, boolean deployment) {
        File testFile;
        if (!this.isExplodedDeployment && (testFile = new File(module.getPath())).isAbsolute() && !testFile.exists() && module.getPath().startsWith(File.separator)) {
            module.setPath(module.getPath().substring(1));
        }
        if (module instanceof WebModule) {
            WebModule webModule = (WebModule)module;
            if (deployment && !this.webApplications.contains(webModule) && this.getContext() != null) {
                return;
            }
            if (this.getURL() != null && webModule.getPath().endsWith(".war") && this.autoUnpack) {
                try {
                    oracle.oc4j.util.FileUtils.autoUnpack(ConfigUtils.getURL(this.getURL(), webModule.getPath()), true, this.logger);
                    webModule.setUnpackedPath(webModule.getPath().substring(0, webModule.getPath().lastIndexOf(46)));
                }
                catch (IOException e) {
                    System.err.println("Error unpacking web-app: " + e.getMessage());
                }
            }
            this.updateModule(this.webApplications, module);
        } else if (module instanceof ConnectorModule) {
            ConnectorModule connectorModule = (ConnectorModule)module;
            ConnectorModule originalConnectorModule = null;
            if (deployment && this.getContext() != null && (originalConnectorModule = this.getConnectorModuleByPath(connectorModule.path)) == null) {
                System.err.println("Error: " + connectorModule + " will not be bootstrapped since corresponding module declaration was not found in application.xml.");
                return;
            }
            if (this.getURL() != null && connectorModule.getPath().endsWith(".rar") && this.autoUnpack) {
                try {
                    if (this.getContext() == null) {
                        String connectorDirectory = null;
                        connectorDirectory = this._applicationServerConfig.getConnectorDirectory() + File.separator + connectorModule.getName() + File.separator;
                        oracle.oc4j.util.FileUtils.autoUnpack(ConfigUtils.getURL(this.getURL(), connectorDirectory + connectorModule.getPath()), true, this.logger);
                        connectorModule.setUnpackedPath(connectorDirectory + connectorModule.getPath().substring(0, connectorModule.getPath().lastIndexOf(46)));
                    } else {
                        oracle.oc4j.util.FileUtils.autoUnpack(ConfigUtils.getURL(this.getURL(), connectorModule.getPath()), true, this.logger);
                        connectorModule.setUnpackedPath(connectorModule.getPath().substring(0, connectorModule.getPath().lastIndexOf(46)));
                    }
                }
                catch (IOException e) {
                    System.err.println("Error unpacking connector: " + e.getMessage());
                }
            }
            if (originalConnectorModule != null) {
                this.connectors.remove(originalConnectorModule);
            }
            this.updateModule(this.connectors, module);
        } else if (module instanceof EJBModule) {
            if (deployment && this.getContext() != null && !this.ejbPackages.contains(module)) {
                return;
            }
            this.updateModule(this.ejbPackages, module);
        } else if (module instanceof ClientModule) {
            if (deployment && this.getContext() != null && !this.clients.contains(module)) {
                return;
            }
            ClientModule clientModule = (ClientModule)module;
            if (this.getURL() != null && clientModule.getPath().endsWith(".jar") && this.autoUnpack) {
                try {
                    oracle.oc4j.util.FileUtils.autoUnpack(ConfigUtils.getURL(this.getURL(), clientModule.getPath()), true, this.logger);
                    clientModule.setUnpackedPath(clientModule.getPath().substring(0, clientModule.getPath().lastIndexOf(46)));
                }
                catch (IOException e) {
                    System.err.println("Error unpacking app-client: " + e.getMessage());
                }
            }
            this.updateModule(this.clients, module);
        }
        this.firePropertyChangeEvent("modules", null, module);
    }

    private void updateModule(Collection modules, Module module) {
        Iterator iter = modules.iterator();
        while (iter.hasNext()) {
            Module next = (Module)iter.next();
            if (!next.equals(module)) continue;
            if (next.getAltDD() != null && module.getAltDD() == null) {
                module.setAltDD(next.getAltDD());
            }
            if (!(module instanceof WebModule)) break;
            ((WebModule)module).setContextRoot(((WebModule)next).getContextRoot());
            break;
        }
        modules.remove(module);
        modules.add(module);
    }

    public Collection getWebApplications() {
        return this.webApplications;
    }

    public Collection getEJBPackages() {
        return this.ejbPackages;
    }

    public Collection getClients() {
        return this.clients;
    }

    public Collection getConnectorModules() {
        return this.connectors;
    }

    private static Module getModule(Node parent) throws InstantiationException {
        if (XMLUtils.getSubnode(parent, "web") != null) {
            return new WebModule(parent);
        }
        if (XMLUtils.getSubnode(parent, "ejb") != null) {
            return new EJBModule(parent);
        }
        if (XMLUtils.getSubnode(parent, "connector") != null) {
            return new ConnectorModule(parent);
        }
        return new ClientModule(parent);
    }

    public String toString() {
        return this.getName();
    }

    public WebModule getWebApplication(String name) {
        Iterator iterator = this.webApplications.iterator();
        while (iterator.hasNext()) {
            WebModule module = (WebModule)iterator.next();
            if (!module.getName().equals(name)) continue;
            return module;
        }
        return null;
    }

    private static void writeModules(PrintWriter out, String indention, Collection modules) {
        if (modules != null) {
            Iterator iterator = modules.iterator();
            while (iterator.hasNext()) {
                ((Module)iterator.next()).writeOrionXML(out, indention);
            }
        }
    }

    public EJBContainerConfig getEJBContainerConfig() {
        return this;
    }

    public URL getPersistenceURL() {
        try {
            if (this.persistencePath == null) {
                return null;
            }
            return ConfigUtils.getURL(this.getDeploymentURL(), this.persistencePath);
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof EnterpriseArchive)) {
            return false;
        }
        if (!((EnterpriseArchive)other).getName().equals(this.getName())) {
            return false;
        }
        return super.equals(other);
    }

    public List getSecurityRoles() {
        if (this.securityRoles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoles;
    }

    public SecurityRole getSecurityRole(String name) {
        if (this.securityRoles == null) {
            return null;
        }
        for (int i = 0; i < this.securityRoles.size(); ++i) {
            if (!((SecurityRole)this.securityRoles.get(i)).getName().equals(name)) continue;
            return (SecurityRole)this.securityRoles.get(i);
        }
        return null;
    }

    public ApplicationClientServerArchive getClientArchive(String path, ClassLoader parentLoader) throws InstantiationException, IOException {
        Context context = null;
        Context parentContext = this.getContext();
        if (parentContext != null) {
            if (parentContext instanceof FileContext) {
                context = ContextUtils.getContext(ConfigUtils.getURL(ContextUtils.getURL(parentContext, false), path), false);
            } else {
                try {
                    context = ContextUtils.getContext(parentContext, path, false);
                }
                catch (NamingException e) {
                    // empty catch block
                }
            }
        }
        if (context == null) {
            context = path.endsWith(".jar") ? new ContentArchiveContext(new File(ConfigUtils.getURL(this.getURL(), path).getFile()), false) : new ContentFileContext(new File(ConfigUtils.getURL(this.getURL(), path).getFile()), null);
        }
        ApplicationClientServerArchive arch = new ApplicationClientServerArchive(path, context);
        if (this.getAllMailSessions() != null) {
            arch.setMailSessions(this.getAllMailSessions());
        }
        return arch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    void generateDefaultUserManagerSettings() {
        block25: {
            if (!this.userManagerList.isEmpty()) {
                return;
            }
            generatePrincipalsOnly = false;
            if (this.parent != null) {
                myParent = this.parent;
                globalEnterpriseArchive = null;
                while (myParent.getParent() != null) {
                    myParent = myParent.getParent();
                }
                globalEnterpriseArchive = myParent;
                try {
                    generatePrincipalsOnly = UserManagerConfig.ultimate(globalEnterpriseArchive.getUserManager()) instanceof XMLUserManager;
                }
                catch (InstantiationException e) {
                    // empty catch block
                }
            }
            try {
                principals = new XMLUserManager();
                principalsURL = ConfigUtils.getURL(this.getDeploymentURL(), "principals.xml");
                principals.setURL(principalsURL);
                principals.store();
                principalsConfig = new UserManagerConfig.Principals();
                principalsConfig.setPath("principals.xml");
                principalsConfig.setDeploymentURL(this.getDeploymentURL());
                this.userManagerList.add(principalsConfig);
            }
            catch (InstantiationException iex) {
            }
            catch (IOException ioex) {
                // empty catch block
            }
            if (generatePrincipalsOnly) {
                return;
            }
            jaznConfig = new UserManagerConfig.JAZN();
            jaznConfig.setProperty(Env.PROVIDER_TYPE, Env.PROVIDER_TYPE_XML);
            jaznConfig.setProperty("deployment.url", this.getDeploymentURL().toString());
            if ("true".equalsIgnoreCase(System.getProperty(Env.XML_SKELETON_AUTO_CREATE, Env.XML_SKELETON_AUTO_CREATE_DEFAULT))) {
                jaznConfig.setProperty(Env.PROP_LOCATION, "jazn-data.xml");
                out = null;
                writer = null;
                try {
                    block24: {
                        url = ConfigUtils.getURL(this.getDeploymentURL(), "jazn-data.xml");
                        file = new File(url.getFile());
                        if (file.exists()) break block24;
                        out = new FileOutputStream(file);
                        writer = new PrintWriter(new OutputStreamWriter(out, this.getDocumentEncoding()));
                        XMLJAZNProvider.writeSkeletonXML((int)0, (Writer)writer);
                    }
                    var8_11 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    ** if (out == null) goto lbl-1000
                }
                catch (Throwable var7_17) {
                    var8_13 = null;
                    if (writer != null) {
                        writer.close();
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    throw var7_17;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        out.close();
                    }
                    catch (Exception e) {}
                }
lbl-1000:
                // 2 sources

                {
                    break block25;
                    catch (Exception e) {
                        var8_12 = null;
                        if (writer != null) {
                            writer.close();
                        }
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (Exception e) {}
                        }
                    }
                }
            }
        }
        this.userManagerList.add(jaznConfig);
    }

    protected void initDefaultSettings() throws InstantiationException {
        if (this.persistencePath == null) {
            this.persistencePath = "persistence";
        }
        this.initLogger();
        this.handleMetricRules();
        if (this.isSeparateDeploymentContext() || this.getContext() != null) {
            this.generateDefaultUserManagerSettings();
        }
        if (this.securityRoles != null) {
            Iterator iterator = this.securityRoles.iterator();
            while (iterator.hasNext()) {
                Group group;
                SecurityRole role = (SecurityRole)iterator.next();
                if (!role.getUsers().isEmpty() || !role.getGroups().isEmpty() || this.getUserManager() == null || (group = this.getUserManager().getGroup(role.getName())) == null) continue;
                role.addGroup(role.getName());
            }
        }
        if (this.getCompatibility() >= 1 && this.getLibraryDirectory() == null) {
            this.setLibraryDirectory(DEFAULT_LIBRARY_DIRECTORY_NAME);
        }
    }

    protected void postInit() throws InstantiationException {
        if (this.isSeparateDeploymentContext() || this.getContext() != null) {
            this.generateDefaultUserManagerSettings();
        }
        this.setJaznLoginConfigProperty();
        super.postInit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamespaceAccessController getNamespaceAccessController() {
        if (this.namespaceAccessController == null) {
            Object object = this.namespaceAccessControllerLock;
            synchronized (object) {
                if (this.namespaceAccessController == null) {
                    NamespaceAccessController nsac = new NamespaceAccessController();
                    if (this.parent != null) {
                        nsac.setReadMap(this.parent.getNamespaceAccessController().getReadMap());
                        nsac.setWriteMap(this.parent.getNamespaceAccessController().getWriteMap());
                    }
                    this.namespaceAccessController = nsac;
                }
            }
        }
        return this.namespaceAccessController;
    }

    public boolean getAutoCreateTables() {
        return this.autoCreateTables;
    }

    public boolean getAutoDeleteTables() {
        return this.autoDeleteTables;
    }

    public boolean getEJBDeployInBatch() {
        return this.deployInBatch;
    }

    protected String getDefaultDeploymentSubname() {
        return "META-INF";
    }

    protected String getAssemblyDescriptorPath() {
        return "META-INF/application.xml";
    }

    public String getDeploymentDescriptorPath() {
        return "orion-application.xml";
    }

    public String getComponentClassification() {
        return this.componentClassification;
    }

    public List getDataSourceConfigs() {
        return Collections.EMPTY_LIST;
    }

    private void parseConnectors(String path) throws InstantiationException {
        if (path == null) {
            throw new InstantiationException("Missing path attribute in <connectors> tag");
        }
        URL url = null;
        try {
            this.connectorsPath = path;
            url = ConfigUtils.getURL(this.getDeploymentURL(), path);
            XMLConnectorsConfig connectorsConfig = null;
            try {
                connectorsConfig = new XMLConnectorsConfig(url);
            }
            catch (IOException e) {
                URL tempUrl = ConfigUtils.getURL(this.getURL(), this.getDefaultDeploymentSubname());
                url = ConfigUtils.getURL(tempUrl, path);
                connectorsConfig = new XMLConnectorsConfig(url);
            }
            Iterator iter = connectorsConfig.getConnectors().iterator();
            while (iter.hasNext()) {
                ConnectorModule module = (ConnectorModule)iter.next();
                if (module.getName().equals(DATA_SOURCES_CONNECTOR_MODULE_NAME) && m_dataSourcesConnectorModule == null) {
                    m_dataSourcesConnectorModule = module;
                }
                this.addModule(module, true);
            }
        }
        catch (InstantiationException e) {
            throw new InstantiationException("Error parsing connectors config at " + url + ": " + e.getMessage());
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + path);
        }
        catch (SAXException e) {
            throw new InstantiationException("Error parsing " + path + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new InstantiationException("Could not read connectors file" + (url == null ? "" : " at " + url) + ": " + path);
        }
    }

    public void parseDataSources(String path, boolean copy) throws InstantiationException {
        if (path == null) {
            throw new InstantiationException("Missing path attribute in <data-sources> tag");
        }
        URL url = null;
        try {
            this.dataSourcesPath = path;
            url = ConfigUtils.getURL(this.getDeploymentURL(), path);
            if (copy && this.getDeploymentContext() != this.getContext() && this.getContext() != null) {
                long deplTime = 0L;
                long copyTime = 0L;
                if (this.getDeploymentContext() instanceof LastModifiedContainer) {
                    copyTime = ConfigUtils.getLastModified((LastModifiedContainer)((Object)this.getDeploymentContext()), path);
                }
                if (this.getContext() instanceof LastModifiedContainer) {
                    deplTime = ConfigUtils.getLastModified((LastModifiedContainer)((Object)this.getContext()), this.getDefaultDeploymentSubname() + "/" + path);
                }
                if (deplTime > copyTime) {
                    try {
                        byte[] data = (byte[])this.getContext().lookup(this.getDefaultDeploymentSubname() + "/" + path);
                        IOUtils.writeContent(url, data);
                        this.parseDataSources(path, false);
                        return;
                    }
                    catch (NamingException ne) {
                        // empty catch block
                    }
                }
            }
            try {
                XMLDataSourcesConfig config = new XMLDataSourcesConfig(url);
                this.m_dataSourcesConfig = config.getDataSourcesConfig();
            }
            catch (InstantiationException e) {
                throw new InstantiationException("Error parsing data-sources config at " + url + ": " + e.getMessage());
            }
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + path);
        }
        catch (SAXException e) {
            throw new InstantiationException("Error parsing " + path + ": " + e.getMessage());
        }
        catch (IOException e) {
            throw new InstantiationException("Could not read datasource file" + (url == null ? "" : " at " + url) + ": " + path);
        }
    }

    public void storeDataSources() throws IOException {
        boolean updateOrionApplicationXML = false;
        if (this.dataSourcesPath == null) {
            this.dataSourcesPath = DEFAULT_DATASOURCES_FILE_NAME;
            updateOrionApplicationXML = true;
        }
        XMLDataSourcesConfig config = new XMLDataSourcesConfig(this.m_dataSourcesConfig);
        try {
            config.setURL(ConfigUtils.getURL(this.getDeploymentURL(), this.dataSourcesPath));
        }
        catch (InstantiationException e) {
            // empty catch block
        }
        config.store();
        try {
            if (updateOrionApplicationXML) {
                this.storeDeployment();
            }
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            throw new IOException(e.getMessage());
        }
    }

    public void storeInDeployment() throws IOException {
        try {
            this.storeDeployment();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public String getDataSourcesDescriptor() throws IOException {
        if (this.m_dataSourcesConfig == null) {
            return "";
        }
        try {
            return this.m_dataSourcesConfig.createXMLString();
        }
        catch (DataSourceConfigException dataSourceConfigException) {
            throw new IOException(dataSourceConfigException.getMessage());
        }
    }

    public ConnectorModule getConnectorModuleByName(String name) {
        if (this.connectors == null) {
            return null;
        }
        boolean found = false;
        ConnectorModule returnModule = null;
        Iterator iter = this.connectors.iterator();
        while (iter.hasNext() && !found) {
            ConnectorModule module = (ConnectorModule)iter.next();
            if (!module.getName().equals(name)) continue;
            returnModule = module;
            found = true;
        }
        return returnModule;
    }

    private ConnectorModule getConnectorModuleByPath(String path) {
        if (this.connectors == null) {
            return null;
        }
        boolean found = false;
        ConnectorModule returnModule = null;
        Iterator iter = this.connectors.iterator();
        while (iter.hasNext() && !found) {
            ConnectorModule module = (ConnectorModule)iter.next();
            if (!module.path.equals(path)) continue;
            returnModule = module;
            found = true;
        }
        return returnModule;
    }

    public void removeConnectorModule(ConnectorModule moduleToRemove) {
        if (this.connectors == null) {
            return;
        }
        this.connectors.remove(moduleToRemove);
        Application.removeResourceAdapterModuleMBean(moduleToRemove.getName(), this.getName());
    }

    public void storeConnectors() throws IOException {
        if (this.connectorsPath == null) {
            this.connectorsPath = "./oc4j-connectors.xml";
        }
        XMLConnectorsConfig config = new XMLConnectorsConfig(this.connectors);
        try {
            config.setURL(ConfigUtils.getURL(this.getDeploymentURL(), this.connectorsPath));
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        config.store();
    }

    public String getConnectorsPath() {
        return this.connectorsPath;
    }

    public String getLibraryDirectory() {
        return this.libraryDirectory;
    }

    private void setLibraryDirectory(String libDirectory) {
        this.libraryDirectory = libDirectory;
    }

    public synchronized List getCanonicalLibraryPaths() {
        if (this.canonicalLibraryPaths == null) {
            try {
                this.canonicalLibraryPaths = FileUtils.getCanonicalPaths((String)this.getDirectoryURLString(), (List)this.libraryPaths);
            }
            catch (MalformedURLException e) {
                ClassLoadLogger.logException((String)"Unable to add <library>.", (Throwable)e, (boolean)false);
                this.canonicalLibraryPaths = Collections.EMPTY_LIST;
            }
        }
        return this.canonicalLibraryPaths;
    }

    public List getLibraryPaths() {
        if (this.libraryPaths == null) {
            return Collections.EMPTY_LIST;
        }
        return this.libraryPaths;
    }

    public void setLibraryPaths(List libraryPaths) {
        this.libraryPaths = libraryPaths;
    }

    public ImportedSharedLibrariesType getImportedSharedLibraries() {
        return this.importedSharedLibraries;
    }

    public void setImportedSharedLibraries(ImportedSharedLibrariesType importedSharedLibs) {
        this.importedSharedLibraries = (ImportedSharedLibrariesElement)importedSharedLibs;
    }

    public DatabaseSchema getDatabaseSchema(String path) throws InstantiationException {
        DatabaseSchema schema;
        DatabaseSchema databaseSchema = schema = this.databaseSchemas == null ? null : (DatabaseSchema)this.databaseSchemas.get(path);
        if (schema != null) {
            return schema;
        }
        try {
            if (this.dataSourcesPath == null) {
                if (this.parent != null) {
                    return this.parent.getDatabaseSchema(path);
                }
                return this._applicationServerConfig.getDatabaseSchema(path);
            }
            URL schemaURL = ConfigUtils.getURL(this.getDeploymentURL(), this.dataSourcesPath);
            schemaURL = ConfigUtils.getURL(schemaURL, path);
            schema = new DatabaseSchema(XMLUtils.getRootNode(IOUtils.getContent(schemaURL), this, path), path);
            if (this.databaseSchemas == null) {
                this.databaseSchemas = new HashMap();
            }
            this.databaseSchemas.put(path, schema);
            return schema;
        }
        catch (IOException e) {
            if (this.parent != null) {
                return this.parent.getDatabaseSchema(path);
            }
            return this._applicationServerConfig.getDatabaseSchema(path);
        }
    }

    public String getDefaultDataSource() {
        return this.defaultDataSource;
    }

    public boolean getTreatZeroAsNull() {
        return this.treatZeroAsNull;
    }

    public void removeSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            return;
        }
        this.securityRoles.remove(role);
        this.firePropertyChangeEvent("securityRoles", role, null);
    }

    public void init(URL url) throws InstantiationException, IOException {
        super.init(url);
        if (this.persistencePath != null && OC4JServer.getInstanceId() != null) {
            this.persistencePath = IOUtils.getInstanceDir(this.getPersistenceURL().getFile(), OC4JServer.getInstanceId(), true);
        }
    }

    public void addResourceProvider(ResourceProviderDescriptor descriptor) {
        if (this.resourceProviders == null) {
            this.resourceProviders = new ArrayList();
        }
        this.resourceProviders.add(descriptor);
    }

    public boolean removeResourceProvider(String name) {
        ResourceProviderDescriptor resourceProviderToRemove = null;
        if (this.resourceProviders != null) {
            Iterator iterator = this.resourceProviders.iterator();
            while (iterator.hasNext()) {
                ResourceProviderDescriptor resourceProviderDescriptor = (ResourceProviderDescriptor)iterator.next();
                if (!resourceProviderDescriptor.getName().equals(name)) continue;
                resourceProviderToRemove = resourceProviderDescriptor;
            }
        }
        if (resourceProviderToRemove == null) {
            return false;
        }
        this.resourceProviders.remove(resourceProviderToRemove);
        return true;
    }

    public List getResourceProviders() {
        return this.resourceProviders == null ? Collections.EMPTY_LIST : this.resourceProviders;
    }

    private void addJMXMBean(JMXMBeanDescriptor descriptor) {
        if (this.jmxMBeans == null) {
            this.jmxMBeans = new ArrayList();
        }
        this.jmxMBeans.add(descriptor);
    }

    public final List getJMXMBeans() {
        return this.jmxMBeans == null ? Collections.EMPTY_LIST : this.jmxMBeans;
    }

    public boolean getSeeParentDataSources() {
        return this.seeParentDataSources;
    }

    public String getDataSourcesPath() {
        return this.dataSourcesPath;
    }

    private void setGlobalApplication(boolean is) {
        this.isGlobalApplication = is;
    }

    public Object getExtraParam(String key) {
        if (this._extraParams == null || key == null || !this._extraParams.containsKey(key)) {
            return null;
        }
        return this._extraParams.get(key);
    }

    public void initUserManagers(ClassLoader classLoader) {
        this.userManagerList.setClassLoader(classLoader);
        this.userManagerList.start();
        this.sensitiveManagerList.setClassLoader(classLoader);
        if (this.isGlobalApplication && !this.explicitSensitive) {
            this.sensitiveManagerList = new UserManagerConfigList(0);
            UserManagerConfig.Generic indirect = new UserManagerConfig.Generic();
            ((IndirectUserManager)indirect).setUnderlying(this.userManagerList.getUserManager());
            this.sensitiveManagerList.add(indirect);
        } else {
            this.sensitiveManagerList.start();
        }
    }

    public void validateUserManagers() throws InstantiationException {
        try {
            this.userManagerList.validate();
            this.sensitiveManagerList.validate();
        }
        catch (RuntimeException rex) {
            InstantiationException iex = new InstantiationException("Could not construct UserManager for " + this);
            iex.initCause(rex);
            throw iex;
        }
    }

    public UserManager getUserManager() {
        return this.userManagerList.getUserManager();
    }

    private UserManager getInitializedUserManager() {
        if (null == this.userManagerList) {
            this.userManagerList = new UserManagerConfigList(this.userManagerCompat());
        }
        return this.getUserManager();
    }

    public UserManager getSensitiveManager() {
        return this.sensitiveManagerList.getUserManager();
    }

    public ApplicationServerConfig getApplicationServer() {
        return this._applicationServerConfig;
    }

    public UserManager getParentUserManager() {
        UserManager u = null;
        ApplicationConfig parent = this.getParent();
        if (parent != null) {
            u = parent.getUserManager();
        }
        return u;
    }

    private void parseSensitive(Node parent) throws InstantiationException {
        this.explicitSensitive = true;
        NodeList list = parent.getChildNodes();
        for (int xElement = 0; xElement < list.getLength(); ++xElement) {
            Node node = list.item(xElement);
            if (!(node instanceof Element)) continue;
            this.sensitiveManagerList.add(this.parseUserManagerElement(node));
        }
    }

    private void parseUserManager(Node node) throws InstantiationException {
        this.userManagerList.add(this.parseUserManagerElement(node));
    }

    private UserManagerConfig parseUserManagerElement(Node node) throws InstantiationException {
        UserManagerConfig u = UserManagerConfig.parse(node, this.isGlobalApplication);
        u.setDeploymentURL(this.getDeploymentURL());
        u.deploy(this);
        return u;
    }

    public synchronized void addMailSession(MailSessionInfo session) throws InstantiationException {
        if (this.mailSessions == null) {
            this.mailSessions = new ArrayList();
        } else {
            for (int i = 0; i < this.mailSessions.size(); ++i) {
                MailSessionInfo other = (MailSessionInfo)this.mailSessions.get(i);
                if (other.getLocation() == null || !other.getLocation().equals(session.getLocation())) continue;
                if (this.defaultMailSession == other) {
                    this.defaultMailSession = null;
                }
                this.mailSessions.remove(i);
                --i;
            }
        }
        this.mailSessions.add(session);
        if (this.defaultMailSession == null) {
            this.defaultMailSession = session;
        }
    }

    public synchronized void removeMailSession(String location) {
        if (this.mailSessions != null) {
            for (int i = 0; i < this.mailSessions.size(); ++i) {
                MailSessionInfo info = (MailSessionInfo)this.mailSessions.get(i);
                if (!location.equals(info.getLocation())) continue;
                this.mailSessions.remove(i--);
            }
        }
    }

    public synchronized List getMailSessions() {
        if (this.mailSessions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.mailSessions;
    }

    public synchronized List getAllMailSessions() {
        ApplicationConfig father;
        ArrayList all = new ArrayList();
        if (this.parent != null && (father = this.parent) != null && father.getMailSessions() != null) {
            Iterator msIter = father.getMailSessions().iterator();
            while (msIter.hasNext()) {
                all.add(msIter.next());
            }
        }
        if (this.mailSessions != null) {
            Iterator msIter = this.mailSessions.iterator();
            while (msIter.hasNext()) {
                all.add(msIter.next());
            }
        }
        return all;
    }

    public synchronized MailSessionInfo getDefaultMailSession(boolean recursive) {
        if (this.defaultMailSession != null) {
            return this.defaultMailSession;
        }
        if (recursive && this.parent != null) {
            return this.parent.getDefaultMailSession(true);
        }
        return null;
    }

    public long getTaskManagerInterval() {
        return this.taskManagerInterval;
    }

    private void parseSecurityRoleMapping(Node node) throws InstantiationException {
        String roleName = XMLUtils.getNodeAttribute(node, "name");
        if (roleName != null) {
            SecurityRole role = this.getSecurityRole(roleName);
            if (role == null) {
                role = new SecurityRole(roleName);
                role.parseOrionXML(node);
                this.addSecurityRole(role);
            } else {
                role.parseOrionXML(node);
            }
        }
    }

    private void parseLibrary(Node node) {
        if (this.libraryPaths == null) {
            this.libraryPaths = new ArrayList();
        }
        StringTokenizer tokenizer = new StringTokenizer(XMLUtils.getNodeAttribute(node, "path"), ";\n\r\t");
        while (tokenizer.hasMoreElements()) {
            PathElement pathElem;
            String pathToken = (String)tokenizer.nextElement();
            String inclArchiveVal = XMLUtils.getNodeAttribute(node, "include-archives");
            boolean includeArchiveVal = true;
            if (inclArchiveVal != null && inclArchiveVal.equals("false")) {
                includeArchiveVal = false;
            }
            if (this.libraryPaths.contains(pathElem = new PathElement(pathToken, includeArchiveVal))) continue;
            this.libraryPaths.add(pathElem);
        }
    }

    private void parseImportedSharedLibraries(Node node) {
        this.importedSharedLibraries = new ImportedSharedLibrariesElement();
        this.importedSharedLibraries.read(node);
    }

    private void initLogger() throws InstantiationException {
        if (this.logger != null) {
            this.logger.close();
            this.logger = null;
        }
        try {
            if (this.logConfig == null) {
                this.logConfig = new LogConfig(this);
            }
            this.logger = this.logConfig.getCollectionLogger();
        }
        catch (ConfigException e) {
            throw new InstantiationException(e.getMessage());
        }
        String dmsStr = this.logConfig.getDMSString();
        if (ApplicationServer.DMS_GATE && dmsStr != null) {
            if (OC4JServer.getInstanceId() != null && this.getName().equals("default")) {
                ApplicationServer.stateFactory().create(OC4JServer.getOpmnNoun(), "default_application_log", "", "Application log file path", (Object)dmsStr);
            }
            ApplicationServer.stateFactory().create(Application.getApplicationNoun(this.getName()), "application_log", "", "Log file path", (Object)dmsStr);
        }
    }

    public synchronized Logger getLogger() {
        if (this.logger == null) {
            this.logger = new CollectionLogger();
        }
        return this.logger;
    }

    private void parseLogConfig(Node node) throws InstantiationException {
        try {
            this.logConfig = new LogConfig(this, node);
        }
        catch (ConfigException e) {
            throw new InstantiationException(e.getMessage());
        }
    }

    private void parseProperty(Node node) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        String propertyName = XMLUtils.getNodeAttribute(node, "name");
        String propertyValue = XMLUtils.getNodeAttribute(node, "value");
        this.setProperty(propertyName, propertyValue);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperty(String name, String value) {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        this.properties.setProperty(name, value);
    }

    public String getProperty(String name) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.getProperty(name);
    }

    public void removeProperty(String name) {
        if (this.properties != null) {
            this.properties.remove(name);
        }
    }

    private void copyParentArchive(EnterpriseArchive parentArchive) {
        this.autoCreateTables = parentArchive.autoCreateTables;
        this.autoDeleteTables = parentArchive.autoDeleteTables;
        this.deployInBatch = parentArchive.deployInBatch;
        this.prependDeploymentName = parentArchive.prependDeploymentName;
        this.defaultDataSource = parentArchive.defaultDataSource;
        this.treatZeroAsNull = parentArchive.treatZeroAsNull;
    }

    public DataSourcesConfig getDataSourcesConfig() {
        if (this.m_dataSourcesConfig == null) {
            try {
                this.m_dataSourcesConfig = new DataSourcesConfig(null, null, null);
            }
            catch (DataSourceConfigException dataSourceConfigException) {
                // empty catch block
            }
        }
        return this.m_dataSourcesConfig;
    }

    protected void setDataSourcesConfig(DataSourcesConfig dataSourcesConfig) {
        this.m_dataSourcesConfig = dataSourcesConfig;
    }

    protected void parseRootNode(Node node, boolean deployment) throws InstantiationException {
        super.parseRootNode(node, deployment);
        if (m_dataSourcesConnectorModule != null && !this.getName().equals(ApplicationServer.getSystemApplicationName())) {
            this.updateModule(this.connectors, m_dataSourcesConnectorModule);
            this.firePropertyChangeEvent("modules", null, m_dataSourcesConnectorModule);
        }
    }

    protected void handleMetricRules() throws InstantiationException {
        Context ctx = null;
        Context deplCtx = null;
        try {
            ctx = this.getContext();
            deplCtx = this.getDeploymentContext();
        }
        catch (InstantiationException iEX) {
            return;
        }
        if (ctx != null && deplCtx != null) {
            byte[] content = null;
            try {
                content = (byte[])ctx.lookup("META-INF/metricservice/metric-rules.xml");
            }
            catch (NamingException e) {
                return;
            }
            URL url = null;
            try {
                url = ConfigUtils.getURL(this.getDeploymentURL(), "metric-rules.xml");
                IOUtils.writeContent(url, content);
            }
            catch (MalformedURLException e) {
                throw new InstantiationException("Invalid URL: " + url);
            }
            catch (IOException e) {
                throw new InstantiationException("Could not write metric-rules.xml file at " + url);
            }
        }
    }

    protected void setDataSourcesConnectorModule(ConnectorModule module) {
        m_dataSourcesConnectorModule = module;
    }

    private void parseJaznLoginConfig(Node node) throws InstantiationException {
        try {
            Node appNode = XMLUtils.getSubnode(node, "application");
            Node appNameNode = XMLUtils.getSubnode(appNode, "name");
            String appName = XMLUtils.getStringValue(appNameNode);
            if (appName == null || appName.length() == 0 || !appName.equals(this.getName())) {
                throw new InstantiationException("Incorrect application name");
            }
            Node modulesNode = XMLUtils.getSubnode(appNode, "login-modules");
            NodeList moduleNodes = modulesNode.getChildNodes();
            ApplicationConfigReference globalApp = this._applicationServerConfig.getSystemApplicationConfigReference();
            String globalAppName = globalApp.getName();
            ObjectName securityProviderName = ObjectNameFactory.create((String)("oc4j:j2eeType=Security,name=SecurityProvider,J2EEApplication=" + globalAppName + ",J2EEServer=" + "standalone"));
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (!oc4jMBeanServer.isRegistered(securityProviderName)) {
                throw new InstantiationException("Security Provider is not registered");
            }
            Object[] params = new Object[4];
            String[] signature = new String[]{"java.lang.String", "java.lang.String", "java.lang.String", "java.util.Map"};
            for (int n = 0; n < moduleNodes.getLength(); ++n) {
                String className = "";
                String controlFlag = "";
                Node moduleNode = moduleNodes.item(n);
                if ("login-module".equals(moduleNode.getNodeName())) {
                    NodeList optionNodes;
                    Node controlFlagNode;
                    Node classNode = XMLUtils.getSubnode(moduleNode, "class");
                    if (classNode != null) {
                        className = XMLUtils.getStringValue(classNode);
                    }
                    if ((controlFlagNode = XMLUtils.getSubnode(moduleNode, "control-flag")) != null) {
                        controlFlag = XMLUtils.getStringValue(controlFlagNode);
                    }
                    HashMap<String, String> map = new HashMap<String, String>();
                    Node optionsNode = XMLUtils.getSubnode(moduleNode, "options");
                    if (optionsNode != null && (optionNodes = optionsNode.getChildNodes()) != null) {
                        for (int opt = 0; opt < optionNodes.getLength(); ++opt) {
                            Node optionValueNode;
                            Node optionNode = optionNodes.item(opt);
                            if (optionNode == null) continue;
                            String optionName = "";
                            String optionValue = "";
                            Node optionNameNode = XMLUtils.getSubnode(optionNode, "name");
                            if (optionNameNode != null) {
                                optionName = XMLUtils.getStringValue(optionNameNode);
                            }
                            if ((optionValueNode = XMLUtils.getSubnode(optionNode, "value")) != null) {
                                optionValue = XMLUtils.getStringValue(optionValueNode);
                            }
                            if (optionName == null || optionName.length() <= 0 || optionValue == null || optionValue.length() <= 0) continue;
                            map.put(optionName, optionValue);
                        }
                    }
                    params[0] = appName;
                    params[1] = className;
                    params[2] = controlFlag;
                    params[3] = map;
                    oc4jMBeanServer.invoke(securityProviderName, "setLoginModule", params, signature);
                }
                this.jaznLoginConfigParsed = true;
            }
        }
        catch (Throwable t) {
            throw new InstantiationException("Error parsing jazn-loginconfig: " + t.getMessage());
        }
    }

    private void setJaznLoginConfigProperty() throws InstantiationException {
        if (!this.jaznLoginConfigParsed) {
            return;
        }
        UserManager userManager = UserManagerConfig.ultimate(this.getUserManager());
        if (!(userManager instanceof JAZNUserManager)) {
            return;
        }
        try {
            ArrayList loginModuleInfo;
            String loginModuleName;
            ApplicationConfigReference globalApp = this._applicationServerConfig.getSystemApplicationConfigReference();
            String globalAppName = globalApp.getName();
            ObjectName securityProviderName = ObjectNameFactory.create((String)("oc4j:j2eeType=Security,name=SecurityProvider,J2EEApplication=" + globalAppName + ",J2EEServer=" + "standalone"));
            MBeanServer oc4jMBeanServer = Oc4jMBeanServerFactory.getMBeanServer();
            if (!oc4jMBeanServer.isRegistered(securityProviderName)) {
                throw new InstantiationException("Security Provider is not registered");
            }
            Object[] params = new Object[1];
            String[] signature = new String[]{"java.lang.String"};
            params[0] = this.getName();
            Vector loginModulesInfo = (Vector)oc4jMBeanServer.invoke(securityProviderName, "listLoginModules", params, signature);
            if (loginModulesInfo.size() < 1) {
                return;
            }
            String propertyName = Env.CUSTOM_LOGINMODULE_PROVIDER;
            if (loginModulesInfo.size() == 1 && "oracle.security.jazn.login.module.LDAPLoginModule".equals(loginModuleName = (String)(loginModuleInfo = (ArrayList)loginModulesInfo.firstElement()).get(1))) {
                propertyName = Env.CUSTOM_LDAP_PROVIDER;
            }
            ((JAZNUserManager)userManager).getJAZNConfig().setProperty(propertyName, "true");
            if (Env.CUSTOM_LOGINMODULE_PROVIDER.equals(propertyName)) {
                ((JAZNUserManager)userManager).getJAZNConfig().setProperty(Env.ROLE_MAPPING_DYNAMIC, "true");
            }
        }
        catch (Throwable t) {
            throw new InstantiationException("Error configuring jazn-loginconfig: " + t.getMessage());
        }
    }

    protected void parseRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("version") && value.equals("5")) {
            this.setCompatibility(1);
        }
    }

    private void setCompatibility(int compatibility) {
        this.compatibility = compatibility;
    }

    public int getCompatibility() {
        return this.compatibility;
    }

    public boolean applicationExplodedFirstTime() {
        return this.firstDeployment;
    }

    public boolean isExplodedDeployment() {
        return this.isExplodedDeployment;
    }
}

