/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.server.deployment.ResourceEnvironmentReference;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import oracle.oc4j.admin.management.shared.WebModuleLookupContext;
import oracle.oc4j.admin.management.shared.WebModuleResourceRefMapping;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceReference
extends ResourceEnvironmentReference
implements XMLizable,
Serializable {
    private static final long serialVersionUID = 2602375924676186403L;
    public static final byte CMT_UNSET = 0;
    public static final byte CMT_NO = 1;
    public static final byte CMT_YES = 2;
    protected Properties contextAttributes;
    protected boolean containerAuthentication;
    protected boolean shareable = true;
    protected byte containerManagedTransactions;

    public ResourceReference() {
    }

    public ResourceReference(String name, String type, String containerAuthentication, String sharingScope, String description) throws InstantiationException {
        super(name, type);
        this.setDescription(description);
        this.setAuth(containerAuthentication);
        this.setSharingScope(sharingScope);
    }

    public ResourceReference(String name, String type, boolean containerAuthentication) throws InstantiationException {
        super(name, type);
        this.containerAuthentication = containerAuthentication;
    }

    public ResourceReference(String name, String type, boolean containerAuthentication, boolean shareable) throws InstantiationException {
        super(name, type);
        this.shareable = shareable;
        this.containerAuthentication = containerAuthentication;
    }

    public ResourceReference(Node parent) throws InstantiationException {
        this.parseXML(parent);
    }

    public void parseXML(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName)) continue;
                String value = XMLUtils.getStringValue(node);
                if (nodeName.equals("res-ref-name")) {
                    this.setName(value);
                    continue;
                }
                if (nodeName.equals("description")) {
                    this.setDescription(value);
                    continue;
                }
                if (nodeName.equals("res-type")) {
                    this.setType(value);
                    continue;
                }
                if (nodeName.equals("res-auth")) {
                    this.containerAuthentication = "Container".equalsIgnoreCase(value);
                    continue;
                }
                if (nodeName.equals("res-sharing-scope")) {
                    if ("Shareable".equals(value)) {
                        this.shareable = true;
                        continue;
                    }
                    if ("Unshareable".equals(value)) {
                        this.shareable = false;
                        continue;
                    }
                    throw new InstantiationException("Illegal res-sharing-scope value: '" + value + "' for resource-ref" + (this.getName() == null ? "" : " '" + this.getName() + "'") + ", legal values are 'Shareable' and 'Unshareable'");
                }
                if (nodeName.equals("mapped-name") && value.length() > 0) {
                    this.setLocation(value);
                    continue;
                }
                if (this.parseInjectionTarget(node)) continue;
                throw new InstantiationException("Unknown resource-ref tag: " + nodeName);
            }
        }
        if (this.getName() == null) {
            throw new InstantiationException("resource-ref tag with missing res-ref-name subtag");
        }
        if (this.getType() == null) {
            throw new InstantiationException("resource-ref tag with missing res-type subtag");
        }
    }

    public String getLocation() {
        return this.location;
    }

    public boolean getContainerAuthentication() {
        return this.containerAuthentication;
    }

    public void setLocation(String location) {
        this.location = location != null && location.length() == 0 ? null : location;
        this.firePropertyChangeEvent("location", this.location, location);
    }

    public void writeXML(PrintWriter out, String indention) {
        out.println(indention + "<resource-ref>");
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getName() != null) {
            out.println(indention + "\t<res-ref-name>" + XMLUtils.encode(this.getName()) + "</res-ref-name>");
        } else {
            out.println(indention + "\t<res-ref-name>unnamed</res-ref-name>");
        }
        if (this.getType() != null) {
            out.println(indention + "\t<res-type>" + XMLUtils.encode(this.getType()) + "</res-type>");
        } else {
            out.println(indention + "\t<res-type>javax.sql.DataSource</res-type>");
        }
        out.println(indention + "\t<res-auth>" + (this.containerAuthentication ? "Container" : "Application") + "</res-auth>");
        if (!this.shareable) {
            out.println(indention + "\t<res-sharing-scope>Unshareable</res-sharing-scope>");
        }
        this.writeMappedName(out, indention + "\t", this.location);
        this.writeInjectableXML(out, indention + "\t");
        out.println(indention + "</resource-ref>");
    }

    public void parseOrionXML(Node parent) throws InstantiationException {
        NodeList nodes;
        this.location = XMLUtils.getNodeAttribute(parent, "location");
        String cmt = XMLUtils.getNodeAttribute(parent, "container-managed-transactions");
        if (cmt != null) {
            if (cmt.equals("true")) {
                this.containerManagedTransactions = (byte)2;
            } else if (cmt.equals("false")) {
                this.containerManagedTransactions = 1;
            } else if (cmt.equals("unspecified")) {
                this.containerManagedTransactions = 0;
            } else {
                throw new InstantiationException("Illegal 'container-managed-transactions' attribute value: '" + cmt + "', legal values are 'true', 'false', and 'unspecified'");
            }
        }
        if ((nodes = parent.getChildNodes()) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String nodeName = node.getNodeName();
                if (XMLUtils.isCommentOrID(nodeName) || !nodeName.equals("lookup-context")) continue;
                this.parseLookupContext(node);
            }
        }
    }

    protected void parseLookupContext(Node parent) throws InstantiationException {
        String location = XMLUtils.getNodeAttribute(parent, "location");
        if (location == null) {
            throw new InstantiationException("Missing 'location' attribute in lookup-context tag");
        }
        Properties attributes = new Properties();
        attributes.put("context-location", location);
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("context-attribute")) {
                    String attributeName = XMLUtils.getNodeAttribute(node, "name");
                    String attributeValue = XMLUtils.getNodeAttribute(node, "value");
                    if (attributeName == null) {
                        throw new InstantiationException("Missing name attribute in context-attribute tag");
                    }
                    if (attributeValue == null) {
                        throw new InstantiationException("Missing value attribute in context-attribute tag");
                    }
                    attributes.put(attributeName, attributeValue);
                    continue;
                }
                throw new InstantiationException("Illegal lookup-context subtag: " + name);
            }
        }
        this.contextAttributes = attributes;
    }

    public void writeOrionXML(PrintWriter out, String indention) {
        out.print(indention + "<resource-ref-mapping name=\"" + XMLUtils.encode(this.getName()) + "\"");
        if (this.containerManagedTransactions != 0) {
            out.print(" container-managed-transactions=\"" + ResourceReference.getContainerManagedTransactionsTypeName(this.containerManagedTransactions) + "\"");
        }
        if (this.location != null) {
            out.print(" location=\"" + XMLUtils.encode(this.location) + "\"");
        }
        if (this.contextAttributes != null && !this.contextAttributes.isEmpty()) {
            out.println(">");
            String contextLocation = (String)this.contextAttributes.get("context-location");
            if (contextLocation != null && contextLocation.length() > 0) {
                out.println(indention + "\t<lookup-context location=\"" + XMLUtils.encode(contextLocation) + "\">");
            } else {
                out.println(indention + "\t<lookup-context>");
            }
            HashMap<Object, Object> attributes = new HashMap<Object, Object>(this.contextAttributes);
            attributes.remove("context-location");
            XMLUtils.writeCompressedMap(attributes, "context-attribute", out, "name", "value", indention + "\t\t");
            out.println(indention + "\t</lookup-context>");
            out.println(indention + "</resource-ref-mapping>");
        } else {
            out.println(" />");
        }
    }

    public void setContainerManagedAuthentication(boolean value) {
        this.containerAuthentication = value;
        this.firePropertyChangeEvent("containerAuthentication", this.containerAuthentication ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
    }

    public Object getValue() throws InstantiationException {
        if (this.contextAttributes != null && this.value == null) {
            Properties attributes = new Properties(this.contextAttributes);
            String location = (String)attributes.remove("context-location");
            try {
                InitialContext context = new InitialContext(attributes);
                this.value = context.lookup(location);
                return this.value;
            }
            catch (NamingException e) {
                throw new InstantiationException("Error accessing lookup-context for resource '" + this.getName() + "': " + e);
            }
        }
        return this.value;
    }

    public boolean isShareable() {
        return this.shareable;
    }

    public byte getContainerManagedTransactions() {
        return this.containerManagedTransactions;
    }

    public static String getContainerManagedTransactionsTypeName(int cmt) {
        switch (cmt) {
            case 2: {
                return "true";
            }
            case 1: {
                return "false";
            }
        }
        return "unspecified";
    }

    public String getAuth() {
        return this.containerAuthentication ? "Container" : "Application";
    }

    public void setAuth(String value) {
        this.containerAuthentication = value.equals("Container");
    }

    public String getSharingScope() {
        return this.shareable ? "Shareable" : "Unshareable";
    }

    public void setSharingScope(String value) {
        this.shareable = value.equals("Shareable");
    }

    public Properties getContextAttributes() {
        return this.contextAttributes;
    }

    public void resetContextAttributes() {
        if (this.contextAttributes != null) {
            this.contextAttributes.clear();
        }
    }

    public WebModuleResourceRefMapping getResourceRefMapping() {
        if (this.location != null || this.contextAttributes != null && !this.contextAttributes.isEmpty()) {
            return new WebModuleResourceRefMapping(this);
        }
        return null;
    }

    public void setResourceRefMapping(WebModuleResourceRefMapping mapping) {
        WebModuleLookupContext ctx;
        this.location = mapping.getLocation();
        if (this.location == null || this.location.length() == 0) {
            this.location = null;
        }
        if ((ctx = mapping.getWebModuleLookupContext()) != null) {
            Properties ctxAttrs = ctx.getContextAttributes();
            if (ctxAttrs != null && !ctxAttrs.isEmpty()) {
                if (this.contextAttributes == null) {
                    this.contextAttributes = new Properties();
                }
                this.contextAttributes.putAll((Map<?, ?>)ctxAttrs);
            }
            if (ctx.getLocation() != null) {
                if (this.contextAttributes == null) {
                    this.contextAttributes = new Properties();
                }
                this.contextAttributes.put("context-location", ctx.getLocation());
            }
        }
    }

    public void setContextAttributes(Properties ctxAttrs) {
        this.contextAttributes = ctxAttrs;
    }

    public void addContextAttribute(String attrName, String attrValue) {
        if (this.contextAttributes == null) {
            this.contextAttributes = new Properties();
        }
        this.contextAttributes.put(attrName, attrValue);
    }

    public void removeContextAttribute(String attrName) {
        if (this.contextAttributes != null) {
            this.contextAttributes.remove(attrName);
        }
    }

    public void setContextLocation(String location) {
        if (this.contextAttributes == null) {
            this.contextAttributes = new Properties();
        }
        this.contextAttributes.put("context-location", location);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("resource-ref: ");
        buf.append("\n");
        buf.append("  description: ");
        buf.append(this.getDescription());
        buf.append("\n");
        buf.append("  res-ref-name: ");
        buf.append(this.getName());
        buf.append("\n");
        buf.append("  res-type: ");
        buf.append(this.getType());
        buf.append("\n");
        buf.append("  res-auth: ");
        buf.append(this.getAuth());
        buf.append("\n");
        buf.append("  res-sharing-scope: ");
        buf.append(this.getSharingScope());
        buf.append("\n");
        WebModuleResourceRefMapping mapping = this.getResourceRefMapping();
        buf.append(mapping == null ? "resource-ref-mapping: \nnull\n" : mapping.toString());
        return buf.toString();
    }
}

