/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.deployment;

import com.evermind.io.IOUtils;
import com.evermind.security.IndirectUserManager;
import com.evermind.security.UserManager;
import com.evermind.server.XMLUserManager;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.util.ConfigUtils;
import com.evermind.xml.XMLUtils;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import oracle.j2ee.security.SecurityMessageBundle;
import oracle.j2ee.util.CustomerLogger;
import oracle.j2ee.util.LoggingUtils;
import oracle.oc4j.admin.internal.Notifier;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.oc4j.JAZNUserManager;
import oracle.security.jazn.util.Env;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class UserManagerConfig
extends IndirectUserManager {
    private static Logger m_customerFacingSecurityLogger = CustomerLogger.getLogger("oracle.j2ee.security.oc4j", SecurityMessageBundle.class.getName());
    static final int KIND_GENERIC = 0;
    static final int KIND_JAZN = 1;
    static final int KIND_PRINCIPALS = 2;
    static final int KIND_CUSTOM = 3;
    private UserManager parent;
    private Properties properties;
    private ClassLoader classLoader;
    private InstantiationException exception;
    private URL deploymentURL;

    static Logger getCustomerFacingSecurityLogger() {
        return m_customerFacingSecurityLogger;
    }

    protected void resetUnderlying() {
        this.setUnderlying(null);
    }

    public void start() {
    }

    protected void error(InstantiationException ex) {
        this.exception = ex;
    }

    void checkException() throws InstantiationException {
        InstantiationException state = this.exception;
        this.exception = null;
        if (state != null) {
            throw state;
        }
    }

    public void reset() {
        this.resetUnderlying();
        this.parent = null;
        this.properties = null;
        this.deploymentURL = null;
        this.classLoader = null;
        this.exception = null;
    }

    protected void setting(Object oldValue, Object newValue) {
        if (!(oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue))) {
            this.resetUnderlying();
        }
    }

    public void setProperties(Properties properties) {
        this.setting(this.properties, properties);
        this.properties = (Properties)properties.clone();
    }

    public String getProperty(String key) {
        return (String)this.getProperties().get(key);
    }

    public void setProperty(String key, String value) {
        Properties properties = this.getProperties();
        this.setting(properties.getProperty(key), value);
        properties.setProperty(key, value);
    }

    public void setDeploymentURL(URL url) {
        this.deploymentURL = url;
    }

    public URL getDeploymentURL() {
        return this.deploymentURL;
    }

    protected Properties getProperties() {
        if (this.properties == null) {
            this.properties = new Properties();
        }
        return this.properties;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.setting(this.classLoader, classLoader);
        this.classLoader = classLoader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    public static UserManagerConfig parse(Node node) throws InstantiationException {
        return UserManagerConfig.parse(node, false);
    }

    public static UserManagerConfig parse(Node node, boolean isSystemApp) throws InstantiationException {
        UserManagerConfig userManagerConfig = null;
        String name = node.getNodeName();
        if (name.equals("jazn")) {
            userManagerConfig = new JAZN(node);
        } else if (name.equals("principals")) {
            userManagerConfig = new Principals(node);
        } else if (name.equals("user-manager")) {
            UserManagerConfig.advisory(name, isSystemApp);
            userManagerConfig = new Custom(node);
        } else {
            throw new IllegalArgumentException("Internal Error: " + node + " is not a UserManager description");
        }
        return userManagerConfig;
    }

    static void advisory(String tagName, boolean isSystemApp) {
        if (!isSystemApp) {
            if (UserManagerConfig.getCustomerFacingSecurityLogger().isLoggable(Level.WARNING)) {
                UserManagerConfig.getCustomerFacingSecurityLogger().log(Level.WARNING, "J2EE SECUR-00100", tagName);
            }
            System.err.println(LoggingUtils.getMessage(UserManagerConfig.getCustomerFacingSecurityLogger(), "J2EE SECUR-00100", tagName));
        }
    }

    public UserManager delegatee() {
        UserManager underlying = this.getUnderlying();
        if (underlying == null) {
            try {
                this.exception = null;
                underlying = this.construct();
                this.setUnderlying(underlying);
            }
            catch (InstantiationException iex) {
                this.error(iex);
            }
        }
        return underlying;
    }

    boolean isConstructed() {
        return this.getUnderlying() != null;
    }

    public UserManager ultimate() throws InstantiationException {
        return UserManagerConfig.ultimate(this);
    }

    public static UserManager ultimate(UserManager userManager) throws InstantiationException {
        UserManager um = userManager;
        while (um != null && um instanceof IndirectUserManager) {
            um = ((IndirectUserManager)um).delegatee();
        }
        return um;
    }

    public String element() {
        try {
            CharArrayWriter writer = new CharArrayWriter();
            PrintWriter pWriter = new PrintWriter(writer);
            this.writeXML(pWriter, "");
            pWriter.flush();
            return writer.toString();
        }
        catch (IOException ioex) {
            return "";
        }
    }

    public abstract void writeXML(PrintWriter var1, String var2) throws IOException;

    abstract UserManager construct() throws InstantiationException;

    abstract int kind();

    abstract File file();

    public void deploy(EnterpriseArchive applicationConfig) throws InstantiationException {
        String jaznData = (String)applicationConfig.getExtraParam("jazn-data");
        File target = this.file();
        if (jaznData != null && this instanceof JAZN) {
            this.jaznInDeploymentPlan(target, jaznData);
        } else if (target != null) {
            this.copyOnDeploy(applicationConfig, target);
        }
    }

    public static InstantiationException instantiationException(String message, Exception ex) {
        InstantiationException iex = new InstantiationException(message);
        iex.initCause(ex);
        return iex;
    }

    private void copyOnDeploy(EnterpriseArchive applicationConfig, File target) throws InstantiationException {
        URL destinationURL;
        if (target.isAbsolute()) {
            throw new InstantiationException(target + " is absolute path");
        }
        String targetAsURL = target.getPath().replace(File.separatorChar, '/');
        try {
            destinationURL = ConfigUtils.getURL(applicationConfig.getDeploymentURL(), targetAsURL);
        }
        catch (IOException e) {
            throw UserManagerConfig.instantiationException("error during deployment", e);
        }
        File destination = new File(destinationURL.getFile().replace('/', File.separatorChar));
        if (!destination.exists() && applicationConfig.getContext() != null && applicationConfig.getDeploymentContext() != applicationConfig.getContext()) {
            byte[] data;
            String sourcePath = applicationConfig.getDefaultDeploymentSubname() + "/" + targetAsURL;
            Context sourceContext = applicationConfig.getContext();
            try {
                data = (byte[])sourceContext.lookup(sourcePath);
            }
            catch (NamingException e) {
                data = null;
            }
            try {
                if (data != null) {
                    IOUtils.makePath(destination);
                    IOUtils.writeContent(destination, data);
                }
            }
            catch (IOException e) {
                throw UserManagerConfig.instantiationException("could not write " + destination, e);
            }
        }
    }

    private void jaznInDeploymentPlan(File target, String jaznData) throws InstantiationException {
        if (target == null) {
            throw new InstantiationException("location is missing");
        }
        if (target.isAbsolute()) {
            throw new InstantiationException("location cannot be absolute path");
        }
        String location = target.getPath();
        if (location.indexOf(File.pathSeparator) >= 0) {
            throw new InstantiationException("location cannot contain path separators");
        }
        Notifier notifier = Notifier.getNotifier();
        if (notifier != null) {
            notifier.sendNotification("JAZNDATA_FROM_DEPL_PLAN");
        }
        byte[] data = jaznData.getBytes();
        URL url = null;
        try {
            url = ConfigUtils.getURL(this.getDeploymentURL(), location);
            IOUtils.makePath(new File(url.getFile().replace('/', File.separatorChar)));
            IOUtils.writeContent(url, data);
        }
        catch (MalformedURLException e) {
            throw new InstantiationException("Invalid URL: " + location);
        }
        catch (IOException e) {
            throw new InstantiationException("Could not write jazn-data file at " + url);
        }
    }

    public void init(Properties properties) throws InstantiationException {
        this.properties = properties;
        if (this.getUnderlying() != null) {
            super.init(properties);
        }
    }

    public void setParent(UserManager parent) {
        this.parent = parent;
        if (this.getUnderlying() != null) {
            super.setParent(parent);
        }
    }

    public UserManager getParent() {
        if (this.getUnderlying() != null) {
            this.parent = super.getParent();
        }
        return this.parent;
    }

    public static class Generic
    extends UserManagerConfig {
        private UserManagerConfig underlyingConfig;

        public int kind() {
            return 0;
        }

        public void setUnderlying(UserManager underlying) {
            if (underlying instanceof UserManagerConfig) {
                this.underlyingConfig = (UserManagerConfig)underlying;
            }
            super.setUnderlying(underlying);
        }

        public UserManager construct() throws InstantiationException {
            throw new InstantiationException("Cannot construct a UserManagerConfig.Generic");
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            if (this.underlyingConfig == null) {
                throw new IOException("Unimplemented: UserManagerConfig.Generic.writeXML on " + this.getUnderlying());
            }
            this.underlyingConfig.writeXML(out, indention);
        }

        public void start() {
            if (this.underlyingConfig != null) {
                this.underlyingConfig.start();
            }
        }

        public File file() {
            if (this.underlyingConfig != null) {
                return this.underlyingConfig.file();
            }
            return null;
        }

        public void setDeploymentURL(URL url) {
            if (this.underlyingConfig != null) {
                this.underlyingConfig.setDeploymentURL(url);
            }
        }

        public String toString() {
            StringBuffer buf = new StringBuffer(" -->");
            if (this.getUnderlying() != null) {
                buf.append("" + this.getUnderlying());
            }
            return buf.toString();
        }
    }

    public static class Custom
    extends UserManagerConfig {
        String className;
        String displayName;
        String description;

        private Custom(Node node) throws InstantiationException {
            this.className = XMLUtils.getNodeAttribute(node, "class");
            this.displayName = XMLUtils.getNodeAttribute(node, "name");
            if (this.className == null) {
                throw new InstantiationException("No class specified for user-manager");
            }
            NodeList children = node.getChildNodes();
            if (children != null) {
                for (int i = 0; i < children.getLength(); ++i) {
                    Node child = children.item(i);
                    String name = child.getNodeName();
                    if (name.startsWith("#")) continue;
                    if (name.equals("property")) {
                        String paramName = XMLUtils.getNodeAttribute(child, "name");
                        String paramValue = XMLUtils.getNodeAttribute(child, "value");
                        if (paramName == null) {
                            throw new InstantiationException("property tag with missing 'name' attribute");
                        }
                        if (paramValue == null) {
                            throw new InstantiationException("property tag with missing 'value' attribute");
                        }
                        this.setProperty(paramName, paramValue);
                        continue;
                    }
                    if (name.equals("description")) {
                        this.description = XMLUtils.getStringValue(child);
                        continue;
                    }
                    throw new InstantiationException("Unknown user-manager subtag: " + name);
                }
            }
        }

        public int kind() {
            return 3;
        }

        void setClassName(String className) {
            this.className = className;
        }

        String getClassName() {
            return this.className;
        }

        public UserManager construct() throws InstantiationException {
            if (this.className == null) {
                throw new InstantiationException("ClassName not initialized");
            }
            Object constructed = null;
            try {
                Class<?> userManagerClass;
                ClassLoader cl = this.getClassLoader();
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                if (!((constructed = (userManagerClass = Class.forName(this.className, true, cl)).newInstance()) instanceof UserManager)) {
                    throw new InstantiationException("Class " + this.className + " does not implement UserManager");
                }
            }
            catch (ClassNotFoundException ex) {
                InstantiationException iex = new InstantiationException("UserManager class " + this.className + " not found");
                iex.initCause(ex);
                throw iex;
            }
            catch (IllegalAccessException ex) {
                InstantiationException iex = new InstantiationException("UserManager class " + this.className + " can not be instantiated");
                iex.initCause(ex);
                throw iex;
            }
            UserManager userManager = constructed;
            userManager.init(this.getProperties());
            userManager.setParent(this.getParent());
            return userManager;
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            out.print(indention + "<user-manager class=\"" + XMLUtils.encode(this.className) + '\"');
            if (this.displayName == null) {
                out.print(" name=\"" + XMLUtils.encode(this.displayName) + "\"");
            }
            out.println(">");
            if (this.description != null && this.description.length() > 0) {
                out.println(indention + "\t<description>" + XMLUtils.encode(this.description) + "</description>");
            }
            XMLUtils.writeCompressedMap(this.getProperties(), "property", out, "name", "value", indention + "\t");
            out.println(indention + "</user-manager>");
        }

        public File file() {
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("<CustomUserManager");
            if (this.description != null) {
                buf.append(this.description).append(": ");
            } else if (this.displayName != null) {
                buf.append(this.displayName).append(": ");
            }
            buf.append(this.className);
            buf.append(">");
            return buf.toString();
        }
    }

    public static class Principals
    extends UserManagerConfig {
        public Principals() {
        }

        Principals(Node node) {
            String path = XMLUtils.getNodeAttribute(node, "path");
            this.setProperty("path", path);
        }

        public int kind() {
            return 2;
        }

        public void setPath(String path) {
            this.setProperty("path", path);
        }

        public String getPath() {
            return this.getProperty("path");
        }

        public UserManager construct() throws InstantiationException {
            try {
                XMLUserManager userManager = new XMLUserManager();
                URL url = ConfigUtils.getURL(this.getDeploymentURL(), this.getPath());
                userManager.init(url);
                userManager.setParent(this.getParent());
                return userManager;
            }
            catch (IOException ioex) {
                InstantiationException iex = new InstantiationException("Could not create UserManager");
                iex.initCause(ioex);
                throw iex;
            }
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            String path = this.getPath();
            out.println(indention + "<principals path=\"" + XMLUtils.encode(path) + "\" />");
        }

        File file() {
            String path = this.getPath();
            if (path != null) {
                return new File(path);
            }
            return null;
        }

        public String toString() {
            return "<Principals User Manager " + this.getProperties() + ">";
        }
    }

    public static class JAZN
    extends UserManagerConfig {
        JAZNConfig jaznConfig;

        public JAZN() {
        }

        public int kind() {
            return 1;
        }

        JAZN(Node node) throws InstantiationException {
            try {
                this.setProperties(JAZNConfig.parseJAZNConfig((Node)node));
            }
            catch (IllegalArgumentException ex) {
                InstantiationException iex = new InstantiationException("Error parsing jazn element");
                iex.initCause(ex);
                throw iex;
            }
        }

        public void setDeploymentURL(URL url) {
            this.setProperty("deployment.url", url.toString());
            super.setDeploymentURL(url);
        }

        public void setJAZNConfig(JAZNConfig jaznConfig) {
            this.setting(this.jaznConfig, jaznConfig);
            this.jaznConfig = jaznConfig;
        }

        public JAZNConfig getJAZNConfig() {
            return this.jaznConfig;
        }

        public void start() {
            if (this.jaznConfig != null && this.jaznConfig.getSecurityProviderJAZNConfig() != null) {
                this.setJAZNConfig(this.jaznConfig.getSecurityProviderJAZNConfig());
            }
            this.resetUnderlying();
        }

        public UserManager construct() throws InstantiationException {
            if (this.jaznConfig == null) {
                this.jaznConfig = new JAZNConfig(this.getProperties());
            }
            JAZNUserManager userManager = new JAZNUserManager(this.jaznConfig);
            if (this.getParent() != null) {
                UserManager realParent = this.getParent();
                userManager.setParent(realParent);
            }
            return userManager;
        }

        public void setProperties(Properties properties) {
            if (this.jaznConfig != null) {
                this.error(new InstantiationException("Modifying properties after JAZNUserManager is constructed"));
            }
            super.setProperties(properties);
        }

        public void setProperty(String key, String value) {
            if (this.jaznConfig != null) {
                this.jaznConfig.setProperty(key, value);
            } else {
                super.setProperty(key, value);
            }
        }

        public String getProperty(String key) {
            String value = this.jaznConfig != null ? this.jaznConfig.getProperty(key) : super.getProperty(key);
            return value;
        }

        public void writeXML(PrintWriter out, String indention) throws IOException {
            int indentLength;
            int n = indentLength = indention == null ? 0 : indention.length();
            if (this.jaznConfig == null) {
                new JAZNConfig(this.getProperties()).writeXML(indentLength, (Writer)out);
            } else if (this.jaznConfig.getSecurityProviderJAZNConfig() == null) {
                this.jaznConfig.writeXML(indentLength, (Writer)out);
            } else {
                this.jaznConfig.getSecurityProviderJAZNConfig().writeXML(indentLength, (Writer)out);
            }
        }

        public File file() {
            String providerType;
            String path;
            if (this.jaznConfig != null) {
                path = this.jaznConfig.getLocationPath();
                providerType = this.jaznConfig.getProperty(Env.PROVIDER_TYPE);
            } else {
                path = this.getProperty(Env.PROP_LOCATION);
                providerType = this.getProperty(Env.PROVIDER_TYPE);
            }
            if (path != null && Env.PROVIDER_TYPE_XML.equals(providerType)) {
                return new File(path);
            }
            return null;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer("<Jazn UserManager based on ");
            if (this.jaznConfig != null) {
                buf.append(this.jaznConfig.toString());
            } else {
                buf.append("" + this.getProperties());
            }
            buf.append(">");
            return buf.toString();
        }
    }
}

