/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import java.io.Serializable;
import java.rmi.RemoteException;
import javax.ejb.EJBException;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.HomeHandle;

abstract class EJBMetaDataImpl
implements EJBMetaData,
Serializable {
    private HomeHandle m_homeHandle;
    private String m_homeClassName;
    private String m_remoteClassName;
    private transient EJBHome m_home;
    private transient Class m_homeInterface;
    private transient Class m_remoteInterface;

    protected EJBMetaDataImpl(EJBHome home, Class homeInterface, Class remoteInterface) throws RemoteException {
        this.m_home = home;
        this.m_homeInterface = homeInterface;
        this.m_remoteInterface = remoteInterface;
        this.m_homeHandle = this.m_home.getHomeHandle();
        this.m_homeClassName = homeInterface.getName();
        this.m_remoteClassName = remoteInterface.getName();
    }

    public EJBHome getEJBHome() {
        if (this.m_home == null) {
            this.m_home = this.loadHome();
        }
        return this.m_home;
    }

    private EJBHome loadHome() {
        try {
            return this.m_homeHandle.getEJBHome();
        }
        catch (RemoteException e) {
            throw (EJBException)new EJBException((Exception)e).initCause((Throwable)e);
        }
    }

    public Class getHomeInterfaceClass() {
        if (this.m_homeInterface == null) {
            this.m_homeInterface = this.loadClass(this.m_homeClassName);
        }
        return this.m_homeInterface;
    }

    public Class getRemoteInterfaceClass() {
        if (this.m_remoteInterface == null) {
            this.m_remoteInterface = this.loadClass(this.m_remoteClassName);
        }
        return this.m_remoteInterface;
    }

    protected Class loadClass(String className) {
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return loader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e.toString());
        }
    }
}

