/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.net.AddressContainer;
import com.evermind.security.User;
import com.evermind.server.Flag;
import com.evermind.server.RuntimeSecurityRole;
import com.evermind.server.ThreadState;
import com.evermind.server.ejb.DataSourceConnection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import oracle.oc4j.security.OC4JPrivilegedAction;
import oracle.oc4j.security.OC4JSecurity;

public class EJBPrivileged {
    public static User getUser(ThreadState threadState) {
        return ThreadState.getUser(threadState);
    }

    public static String getUserName(ThreadState threadState) {
        User user = EJBPrivileged.getUser(threadState);
        return user == null ? "" : user.getName();
    }

    public static boolean impliesUser(final RuntimeSecurityRole runtimeRole, final User user, final AddressContainer addressContainer) {
        if (!OC4JSecurity.isSecurityOn()) {
            return runtimeRole.impliesUser(user, addressContainer);
        }
        OC4JPrivilegedAction.NoException action = new OC4JPrivilegedAction.NoException(){

            public Object oc4jRun() {
                return runtimeRole.impliesUser(user, addressContainer) ? Boolean.TRUE : Boolean.FALSE;
            }
        };
        return (Boolean)OC4JSecurity.doPrivileged(action);
    }

    public static PreparedStatement getCustomStatement(final DataSourceConnection connection, final Flag flag, final String syntax) throws SQLException {
        if (!OC4JSecurity.isSecurityOn()) {
            return connection.getCustomStatement(flag, syntax);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws SQLException {
                return connection.getCustomStatement(flag, syntax);
            }
        };
        try {
            return (PreparedStatement)OC4JSecurity.doPrivileged(action);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static PreparedStatement getCustomStatement(final DataSourceConnection connection, final String syntax) throws SQLException {
        if (!OC4JSecurity.isSecurityOn()) {
            return connection.getCustomStatement(syntax);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws SQLException {
                return connection.getCustomStatement(syntax);
            }
        };
        try {
            return (PreparedStatement)OC4JSecurity.doPrivileged(action);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static PreparedStatement getCustomStatement(final DataSourceConnection connection, final Flag isCached, final String syntax, final int executeBatchSize, final boolean delayUntilCommit) throws SQLException {
        if (!OC4JSecurity.isSecurityOn()) {
            return connection.getCustomStatement(isCached, syntax, executeBatchSize, delayUntilCommit);
        }
        OC4JPrivilegedAction action = new OC4JPrivilegedAction(){

            public Object oc4jRun() throws SQLException {
                return connection.getCustomStatement(isCached, syntax, executeBatchSize, delayUntilCommit);
            }
        };
        try {
            return (PreparedStatement)OC4JSecurity.doPrivileged(action);
        }
        catch (SQLException ex) {
            throw ex;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

