/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.EJBClassTransformer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBUtils;
import com.oracle.server.ejb.entitymanager.ClassTransformer;
import com.oracle.server.ejb.entitymanager.EntityManagerFactory;
import com.oracle.server.ejb.entitymanager.EntityManagerSetup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.naming.Context;
import oracle.classloader.PolicyClassLoader;

public class EntityManagerDeployer {
    private static final String TOPLINK_ENTITY_MANAGER_SETUP = "oracle.toplink.internal.ejb.cmp3.oc4j.OC4JEntityManagerSetupImpl";
    private EntityManagerFactory entityManagerFactory;
    private EntityManagerSetup entityManagerSetup;
    private EJBPackageDeployment deployment;
    private Collection pojoEntityClasses;
    private Collection pojoEntityClassNames;
    private static Logger logger = Logger.getLogger(EntityManagerDeployer.class.getName());

    public EntityManagerDeployer(EJBPackageDeployment deployment) {
        this.deployment = deployment;
    }

    protected void predeploy(PolicyClassLoader tempLoader, Context ctx, EJBClassTransformer transformer) throws InstantiationException {
        ClassTransformer ct = this.getEntityManagerSetup().predeploy(this.deployment.getPackage().getApplication().getName() + "_" + this.deployment.getPackage().getName(), this.getPOJOEntityClasses(), (ClassLoader)tempLoader);
        this.getPOJOEntityClassNames().clear();
        Iterator i = this.getPOJOEntityClasses().iterator();
        while (i.hasNext()) {
            Class c = (Class)i.next();
            this.getPOJOEntityClassNames().add(c.getName());
        }
        this.getPOJOEntityClasses().clear();
        transformer.setEntityTransformer(ct);
        i = this.getPOJOEntityClassNames().iterator();
        while (i.hasNext()) {
            transformer.addEntityBeanName((String)i.next());
        }
    }

    protected void deploy() {
        if (this.getPOJOEntityClassNames().isEmpty()) {
            return;
        }
        String defaultDatasource = this.deployment.getContainer().getApplication().getDefaultDataSourceJNDILocation();
        this.setEntityManagerFactory(this.getEntityManagerSetup().deploy(this.loadRealEntityClasses(), (ClassLoader)this.deployment.getEJBClassLoader(), defaultDatasource));
    }

    private Collection loadRealEntityClasses() {
        PolicyClassLoader ejbLoader = this.deployment.getEJBClassLoader();
        ArrayList realClasses = new ArrayList(this.getPOJOEntityClassNames().size());
        Iterator i = this.getPOJOEntityClassNames().iterator();
        while (i.hasNext()) {
            String className = (String)i.next();
            try {
                logger.fine("Loading entity class " + className);
                realClasses.add(ejbLoader.loadClass(className));
            }
            catch (ClassNotFoundException e) {
                throw EJBUtils.createEJBException(e);
            }
        }
        return realClasses;
    }

    public void undeploy() {
        if (this.getPOJOEntityClassNames().isEmpty()) {
            return;
        }
        this.getEntityManagerSetup().undeploy();
    }

    public EntityManagerFactory getEntityManagerFactory() {
        return this.entityManagerFactory;
    }

    private void setEntityManagerFactory(EntityManagerFactory entityManagerFactory) {
        this.entityManagerFactory = entityManagerFactory;
    }

    private EntityManagerSetup getEntityManagerSetup() {
        if (this.entityManagerSetup == null) {
            try {
                this.entityManagerSetup = (EntityManagerSetup)Class.forName(TOPLINK_ENTITY_MANAGER_SETUP).newInstance();
            }
            catch (Exception e) {
                throw EJBUtils.createEJBException(e);
            }
        }
        return this.entityManagerSetup;
    }

    private Collection getPOJOEntityClasses() {
        if (this.pojoEntityClasses == null) {
            this.pojoEntityClasses = new ArrayList();
        }
        return this.pojoEntityClasses;
    }

    private Collection getPOJOEntityClassNames() {
        if (this.pojoEntityClassNames == null) {
            this.pojoEntityClassNames = new ArrayList();
        }
        return this.pojoEntityClassNames;
    }

    public void setPOJOEntityClasses(Collection pojoEntityClasses) {
        this.pojoEntityClasses = (ArrayList)pojoEntityClasses;
    }

    public void setPOJOEntityClassNames(Collection pojoEntityClassNames) {
        this.pojoEntityClassNames = (ArrayList)pojoEntityClassNames;
    }
}

