/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.Application;
import com.evermind.server.ApplicationConfig;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBInternalOutputStream;
import com.evermind.server.ejb.JGroupEJBService;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.SessionReplicationService;
import com.evermind.server.ejb.StatefulSessionContext;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatefulSessionEJBObject;
import com.evermind.server.ejb.logging.EJBRuntimeMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.server.ejb.session.persistence.InternalEJBSessionObject;
import com.evermind.server.ejb.session.persistence.InternalEJBSessionTableCreator;
import com.evermind.util.HTTPProperties;
import com.oracle.bricks.j2ee.JGroupConfig;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.JMSException;
import oracle.ias.container.persistence.InternalPM;
import oracle.ias.container.persistence.InternalPMManager;
import oracle.ias.container.persistence.InternalPersistenceException;
import oracle.j2ee.clustering.ClusteringMessages;
import org.jgroups.ChannelException;

public class PersistenceEJBService
implements SessionReplicationService {
    static Logger m_logger = EJBTraceLogger.getLogger(PersistenceEJBService.class);
    static final String projectFileName = "InternalEjbSessionPersistenceMapping.xml";
    private int promiseTimeout;
    private EJBContainer container;
    private String dataSourceName;
    private Map sessions;

    public PersistenceEJBService(EJBContainer ejbContainer, ApplicationConfig config) throws ChannelException {
        JGroupConfig jconfig = config.getClusterConfig();
        this.container = ejbContainer;
        this.promiseTimeout = jconfig.getPromiseTimeout();
        this.dataSourceName = jconfig.getDataSourceName();
        this.sessions = new HashMap();
        if (!this.container.getApplication().getConfig().getEJBPackages().isEmpty()) {
            String appName = ejbContainer.getApplication().getName();
            String protocol = config.getClusterConfig().getProtocol();
            ClusteringMessages.infoPersistenceSessionManagerStarted("EJB Persistence ", appName, this.dataSourceName, protocol);
            if (m_logger.isLoggable(Level.FINEST)) {
                m_logger.log(Level.FINEST, "EJB Persistence Clustering Service started for Application " + appName + " - state replication enabled over data source name " + this.dataSourceName + " using " + protocol + " protocol");
            }
        }
    }

    public boolean attemptSessionMigration(StatefulSessionEJBHome home) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(PersistenceEJBService.class.toString(), "attemptSessionMigration", new Object[]{home});
        }
        try {
            this.container.storeSessions(null, home, true);
        }
        catch (IOException e) {
            this.container.application.log("Error persisting sessions for " + home.bindingPath, e);
            return false;
        }
        return true;
    }

    public void restoreSessions() throws JMSException {
        m_logger.entering(PersistenceEJBService.class.toString(), "restoreSessions");
    }

    public void MigrateSFSBAtEndCall(StatefulSessionEJBObject sfsbObj) throws Exception, IOException, InterruptedException {
        m_logger.entering(PersistenceEJBService.class.toString(), "MigrateSFSBAtEndCall");
        if (sfsbObj.OC4J_isInvalidated() || sfsbObj.OC4J_isPassivated()) {
            return;
        }
        if (!sfsbObj.isRemote) {
            return;
        }
        this.flushSession(null, sfsbObj, false);
    }

    public void flushEJB(String bindingPath, Object primaryKey_x) throws JMSException {
        m_logger.entering(PersistenceEJBService.class.toString(), "flushEJB - not supported");
    }

    public void remove(StatefulSessionEJBObject sfsbObject) throws InterruptedException {
        m_logger.entering(PersistenceEJBService.class.toString(), "remove");
        InternalEJBSessionObject internalSession = null;
        try {
            InternalPM aPM = this.getPersistenceManager();
            internalSession = (InternalEJBSessionObject)aPM.selectById(InternalEJBSessionObject.class, new Long(sfsbObject.OC4J_getId()));
            aPM.deleteObject(internalSession);
            this.remove(sfsbObject.OC4J_getId());
            ClusteringMessages.fineInvalidateEjbSession(new Long(sfsbObject.OC4J_getId()));
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "invalidation interupted", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        m_logger.entering(PersistenceEJBService.class.toString(), "destroy");
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.clear();
            this.sessions = null;
            this.getPersistenceManager(false).destroy();
        }
    }

    public void sendSessionValueUpdate(StatefulSessionContext statefulSessionContext, String name, Object value) {
        m_logger.entering(PersistenceEJBService.class.toString(), "sendSessionValueUpdate");
        RemoteStatefulSessionEJBObject rsfso = (RemoteStatefulSessionEJBObject)statefulSessionContext.remoteWrapper;
        try {
            InternalEJBSessionObject internalSession = this.getEJBSession(rsfso.OC4J_getId());
            if (internalSession == null) {
                internalSession = this.createSession(rsfso);
            }
        }
        catch (Exception e) {
            m_logger.log(Level.SEVERE, "trouble sendSessionValueUpdate", e);
        }
    }

    public boolean shouldGetUser() {
        m_logger.entering(PersistenceEJBService.class.toString(), "shouldGetUser");
        return false;
    }

    public void requestSession(String bindingPath, long id, long checksum) {
        m_logger.entering(PersistenceEJBService.class.toString(), "requestSession");
        InternalEJBSessionObject internalSession = null;
        try {
            internalSession = this.getEJBSession(id, this.promiseTimeout);
            if (internalSession != null) {
                internalSession.setContainer(this.container);
                internalSession.unmarshall();
                this.add(internalSession);
            }
        }
        catch (IllegalStateException e) {
            m_logger.log(Level.SEVERE, "trouble getting requested session", e);
        }
        catch (Exception e) {
            m_logger.log(Level.WARNING, "trouble getting requested session", e);
        }
    }

    public void create(StatefulSessionEJBObject sfsbObject) {
        if (!sfsbObject.isRemote) {
            return;
        }
        this.createSession(sfsbObject);
    }

    private InternalEJBSessionObject createSession(StatefulSessionEJBObject sfsbObject) {
        ClusteringMessages.finePersistenceSessionCreatedWithId(sfsbObject.OC4J_getId());
        if (m_logger.isLoggable(Level.FINEST)) {
            m_logger.log(Level.FINEST, "Persistence Clustering Session created with id = '" + Long.toString(sfsbObject.OC4J_getId()) + "'");
        }
        try {
            InternalEJBSessionObject session = new InternalEJBSessionObject(sfsbObject.OC4J_getId(), sfsbObject.OC4J_getCreationTime());
            session.setContainer(this.container);
            session.setEJBObject(sfsbObject);
            this.add(session);
            return session;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void reified(StatefulSessionEJBObject sfsbObject, long id) {
        block5: {
            m_logger.entering(PersistenceEJBService.class.toString(), "reified session");
            InternalEJBSessionObject internalSession = null;
            JGroupEJBService.logNullSFSObject(sfsbObject, this.container.getApplication().getName());
            try {
                internalSession = this.getEJBSession(id);
                if (internalSession == null) break block5;
                try {
                    if (sfsbObject != null) {
                        internalSession.setEJBObject(sfsbObject);
                    }
                }
                catch (IllegalStateException e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void flushSession(EJBInternalOutputStream out, StatefulSessionEJBObject wrapper, boolean passivate) throws Exception {
        InternalEJBSessionObject internalSession = this.getEJBSession(wrapper.OC4J_getId());
        InternalPM aPM = this.getPersistenceManager();
        if (internalSession != null) {
            internalSession.setEJBObject(wrapper);
            internalSession.setLastAccessed(wrapper.OC4J_getLastAccessedTime());
            internalSession.setPassivate(passivate);
            internalSession.flush();
            aPM.writeObject(internalSession);
            this.remove(internalSession.getId());
            ClusteringMessages.finestSessionPersistedWithId(new Long(internalSession.getId()));
        } else {
            m_logger.log(Level.FINE, "asked to flush non-existing session" + wrapper.OC4J_getId() + " " + wrapper.getEJBHome_X().OC4J_getBindingPath());
        }
    }

    private InternalEJBSessionObject getEJBSession(long id) throws Exception {
        return this.getEJBSession(id, 1);
    }

    private InternalEJBSessionObject getEJBSession(long id, int timeout) throws Exception {
        InternalEJBSessionObject anInternalSession = this.get(id);
        if (anInternalSession == null) {
            anInternalSession = this.getEJBSessionFromDatabase(id);
        }
        return anInternalSession;
    }

    private InternalEJBSessionObject getEJBSessionFromDatabase(long id) {
        Long longId;
        InternalPM aPM = this.getPersistenceManager();
        InternalEJBSessionObject anInternalSession = (InternalEJBSessionObject)aPM.selectById(InternalEJBSessionObject.class, longId = new Long(id));
        if (anInternalSession != null) {
            anInternalSession.setContainer(this.container);
            ClusteringMessages.finePersistentSessionRetrieval((Serializable)((Object)longId.toString()));
        }
        return anInternalSession;
    }

    protected InternalPM getPersistenceManager() {
        return this.getPersistenceManager(true);
    }

    protected InternalPM getPersistenceManager(boolean forceInitialization) {
        Application application = this.container.getApplication();
        InternalPM aPM = InternalPMManager.getInstance().getNonTransactionalPM(application.getName(), application.getName(), application.getClassLoader());
        if (!forceInitialization && !aPM.isInitialized()) {
            return aPM;
        }
        if (!aPM.isInitialized()) {
            String aDataSourceName = this.dataSourceName == null ? this.container.getApplication().getConfig().getDefaultDataSource() : this.dataSourceName;
            aPM.initSession(projectFileName, aDataSourceName, HTTPProperties.getHttpClusterDebug());
            try {
                aPM.createTables(new InternalEJBSessionTableCreator());
            }
            catch (InternalPersistenceException e) {
                m_logger.log(Level.FINEST, "duplicate ignore table creation exception");
                EJBRuntimeMessages.infoDuplicateTableCreation(this.container.getApplication().getName());
            }
            catch (Exception e) {
                m_logger.log(Level.WARNING, "Unexpected Exception in PersistenceEJBService", e);
            }
        }
        return aPM;
    }

    private void add(InternalEJBSessionObject aSession) {
        if (aSession == null) {
            return;
        }
        this.sessions.put(new Long(aSession.getId()), aSession);
    }

    private InternalEJBSessionObject get(long id) {
        Object anObject = this.sessions.get(new Long(id));
        if (anObject == null) {
            return null;
        }
        return (InternalEJBSessionObject)anObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(long id) {
        Map map = this.sessions;
        synchronized (map) {
            this.sessions.remove(new Long(id));
        }
    }
}

