/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb;

import com.evermind.server.ejb.EJBHomeRemoteInvocationHandler;
import com.evermind.server.ejb.SessionContainer;
import com.evermind.server.ejb.SessionMigratedException;
import com.evermind.server.rmi.EvermindRemote;
import com.evermind.server.rmi.RMIClientConnection;
import com.evermind.server.rmi.RMIConnectionException;
import com.evermind.server.rmi.RMIContext;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;

public class StatefulSessionRemoteInvocationHandler
extends EJBHomeRemoteInvocationHandler {
    protected long id;
    protected long checksum;
    protected boolean transactionSucceeded;

    public StatefulSessionRemoteInvocationHandler(RMIClientConnection connection, RMIContext context, String bindingPath, long id, long checksum) {
        super(connection, context, bindingPath);
        this.id = id;
        this.checksum = checksum;
    }

    public Object invoke(Object object, Method method, Object[] arguments) throws Throwable {
        this.transactionSucceeded = false;
        try {
            return super.invoke(object, method, arguments);
        }
        catch (SessionMigratedException e) {
            return this.handleRecovery(new RMIConnectionException("Migrated EJB session", 1), object, method, arguments);
        }
        catch (RMIConnectionException t) {
            System.out.println("Primary Server went down going to get a fresh object elsewhere in the cluster");
            return super.invoke(this.getFreshObject(), method, arguments);
        }
    }

    protected EvermindRemote getFreshObject() throws Throwable {
        this.connection.getServer().shuffleConnections();
        SessionContainer container = (SessionContainer)((Object)super.getFreshObject());
        if (container != null) {
            EvermindRemote remote = (EvermindRemote)container.getRemoteSession(this.id, this.checksum);
            if (remote != null) {
                return remote;
            }
            throw new NoSuchObjectException("The associated session bean has been removed or timed out.");
        }
        return null;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public void setTransactionSucceeded() {
        this.transactionSucceeded = true;
    }

    protected Object handlePostInitialRecovery(RMIConnectionException e, Object object, Method method, Object[] args) throws Throwable {
        if (this.transactionSucceeded && method.getReturnType() == Void.TYPE) {
            return null;
        }
        throw e;
    }
}

