/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.Compilable;
import com.evermind.compiler.CompilationException;
import com.evermind.compiler.CompiledObject;
import com.evermind.compiler.SpecialCompilation;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.archive.MemoryArchiveContext;
import com.evermind.naming.file.FileContext;
import com.evermind.server.ApplicationConfigReference;
import com.evermind.server.ApplicationServer;
import com.evermind.server.ServerComponent;
import com.evermind.server.compilation.AbstractCompilation;
import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.database.DatabaseSchema;
import com.evermind.server.ejb.database.Table;
import com.evermind.server.ejb.database.TableNameContainer;
import com.evermind.server.ejb.database.TableView;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.ORNameMapper;
import com.evermind.server.ejb.logging.EJBCompilationMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import com.evermind.util.DBProperties;
import com.evermind.util.EJBProperties;
import com.evermind.util.LogEvent;
import com.oracle.server.ejb.compilation.RmicCompiler;
import com.sun.corba.ee.impl.util.PackagePrefixChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBLocalHome;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;
import javax.ejb.EntityContext;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.transaction.UserTransaction;
import oracle.j2ee.ws.server.codegen.WebServiceArtifactGen;
import oracle.jdbc.OracleConnection;
import oracle.oc4j.admin.internal.Notifier;

public class Compilation
extends AbstractCompilation
implements SpecialCompilation {
    private static Logger m_logger = EJBTraceLogger.getLogger(Compilation.class);
    public static final boolean MANUAL_COMMIT = false;
    public static final byte MAX_USED = 5;
    private static final String fs = System.getProperty("file.separator");
    private static final String OC4J_JAR = "oc4j.jar";
    public static boolean keepIiop = EJBProperties.getKeepIIOPCode();
    public static boolean iiopGen = EJBProperties.getGenerateIIOP();
    public static boolean iiopVerbose = EJBProperties.getIIOPVeborse();
    private String sqlError = null;
    private static final String PACKAGE_PREFIX = "org.omg.stub.";
    private ORNameMapper nameMapper = new ORNameMapper();
    private boolean webServiceDeployment = false;
    private boolean _compileIIOP = false;
    private Map tableLists;
    private List tablesToCreate;
    private String _defaultDataSource;
    protected Map callerVariables;
    protected Properties deploymentProperties = new Properties();
    protected EJBPackage ejbPackage;
    protected EJBPackageDeployment deployment;
    public EJBContainer container;
    public List defaultAllowedRoleNames;
    List compilations = new ArrayList();
    List genList = new ArrayList();
    Vector generatedFiles = new Vector();
    String tmpDirName = null;
    Context clientJarContext = null;
    Context appClientJarContext = null;
    Map tempFileMap = new HashMap();
    Map pathKeyAndSources = new HashMap();
    List webServicesClasses = null;
    private static final String DEFAULT_WRAPPER_DIR = "default";

    public Compilation(EJBContainer container, EJBPackageDeployment deployment, String classpath) throws InstantiationException {
        this.deployment = deployment;
        this.ejbPackage = deployment.getPackage();
        this.parent = this.ejbPackage.getEJBClassLoader();
        this.classpath = classpath;
        this.container = container;
        this.context = container.getApplication().getContext();
        this.compiler = container.getApplication().getServer().getCompiler();
        ApplicationConfigReference appConfigReference = container.getApplication().getApplicationConfigReference();
        if (appConfigReference != null) {
            this._compileIIOP = appConfigReference.isIiopEnabled();
        }
        this._defaultDataSource = this.container.getApplication().getConfig().getDefaultDataSource();
    }

    public void compile() throws CompilationException {
        throw new UnsupportedOperationException("Compilation.compile() is not supported!");
    }

    public void compile(boolean fullCompile) throws CompilationException {
        this.initializeCMPAndCMRFields();
        this.translateEjbqlQeries();
        this.generateAnyOldStyle();
        this.ejbPackage.notifyPMs(2, this);
        this.generateWebServices();
        this.generateWebServiceRefs();
    }

    public void doLoadCode(String moduleName) throws CompilationException, InstantiationException {
        HashMap<String, String> properties = new HashMap<String, String>();
        this.initProperties(properties);
        if (this._compileIIOP) {
            this.compiler.setCallback(this);
        }
        properties.put("deploy.batch", "load");
        properties.put("deploy.module.name", moduleName);
        ArrayList<CompiledObject> binaries = new ArrayList<CompiledObject>();
        try {
            if (!this.pathKeyAndSources.isEmpty()) {
                binaries.addAll(this.compiler.compile(this.pathKeyAndSources, properties));
            } else {
                ArrayList cleanClasses = new ArrayList(new HashSet(this.classes));
                binaries.addAll(this.compiler.compile(this.convertSourceToMap(cleanClasses, null), properties));
            }
        }
        catch (CompilationException ce) {
            if (m_logger.isLoggable(Level.FINE)) {
                this.writeWSDebugInfo(ce);
            }
            throw ce;
        }
        catch (InstantiationException ie) {
            if (m_logger.isLoggable(Level.FINE)) {
                this.writeWSDebugInfo(ie);
            }
            throw ie;
        }
        this.compiler.reset();
        if (this._compileIIOP) {
            Iterator i = this.ejbPackage.getAllBeans().iterator();
            while (i.hasNext()) {
                String fileName;
                BeanDescriptor bd = (BeanDescriptor)i.next();
                if (!bd.isSession() && !bd.isTopLinkCMP()) continue;
                ExposableBeanDescriptor ed = (ExposableBeanDescriptor)bd;
                if (ed.getRemoteHomeWrapper() != null) {
                    fileName = EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage) + "/" + ed.getRemoteHomeWrapperName() + ".class";
                    binaries.add(new CompiledObject(ed.getRemoteHomeWrapperName(), null, fileName));
                }
                if (ed.getRemoteWrapper() == null) continue;
                fileName = EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage) + "/" + ed.getRemoteWrapperName() + ".class";
                binaries.add(new CompiledObject(ed.getRemoteWrapperName(), null, fileName));
            }
        }
        Context deploymentContext = this.deployment.getWrapperClassContext();
        this.loadCompiledCode(binaries, deploymentContext);
        this.persistTables();
        this.postCompilationCleanup();
    }

    public Map doGenerateCode() throws CompilationException, InstantiationException {
        String dPath;
        this.webServicesClasses = new ArrayList();
        this.pathKeyAndSources = new HashMap();
        this.compile(false);
        HashMap<String, String> properties = new HashMap<String, String>();
        this.initProperties(properties);
        ArrayList cleanClasses = new ArrayList(new HashSet(this.classes));
        properties.put("deploy.batch", "generate");
        String wrapperPath = EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage);
        if (!cleanClasses.isEmpty()) {
            properties.put("source.directory", wrapperPath);
            properties.put("target.directory", wrapperPath);
            Collection sources = this.compiler.compile(this.convertSourceToMap(cleanClasses, wrapperPath), properties);
            this.setPathKeyAndSources(sources, wrapperPath);
        }
        if (!this.webServicesClasses.isEmpty() && !this.pathKeyAndSources.containsKey(dPath = EJBCompilationUtils.getDeploymentPath(this.ejbPackage))) {
            properties.put("source.directory", dPath);
            properties.put("target.directory", dPath);
            ArrayList webCleanClasses = new ArrayList(new HashSet(this.webServicesClasses));
            Collection webSources = this.compiler.compile(this.convertSourceToMap(webCleanClasses, dPath), properties);
            this.pathKeyAndSources.put(dPath, webSources);
        }
        this.compiler.reset();
        this.addSourcesToClasses(true);
        return this.pathKeyAndSources;
    }

    private void addSourcesToClasses(boolean clear) {
        if (this.pathKeyAndSources != null && !this.pathKeyAndSources.isEmpty()) {
            if (clear) {
                this.classes.clear();
            }
            Iterator pathKeys = this.pathKeyAndSources.keySet().iterator();
            while (pathKeys.hasNext()) {
                Collection compiledSources = (Collection)this.pathKeyAndSources.get(pathKeys.next());
                if (compiledSources.isEmpty()) continue;
                this.classes.addAll(compiledSources);
            }
        }
    }

    private Collection compileSource(List listSources, String wrapperPath, Map properties) throws CompilationException {
        Collection sources = null;
        try {
            sources = this.compiler.compile(this.convertSourceToMap(listSources, wrapperPath), properties);
            this.compiler.reset();
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage(), e);
        }
        return sources;
    }

    public Map getBatchSources() {
        return this.pathKeyAndSources;
    }

    public EJBPackageDeployment getEJBPackageDeployment() {
        return this.deployment;
    }

    private void initProperties(Map properties) throws InstantiationException {
        properties.put("classpath", this.classpath);
        properties.put("classLoader", this.parent);
        if (!new File("..\\emd-ejb.jar").exists()) {
            properties.put("debugInfo", Boolean.FALSE);
        }
        Context deploymentContext = this.deployment.getWrapperClassContext();
        properties.put("targetContext", deploymentContext);
    }

    private Map getInitProperties(String mode, String wrapperPath) throws CompilationException {
        HashMap<String, String> properties = new HashMap<String, String>();
        try {
            this.initProperties(properties);
            properties.put("deploy.batch", mode);
            properties.put("source.directory", wrapperPath);
            properties.put("target.directory", wrapperPath);
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage(), e);
        }
        return properties;
    }

    public void doBatchCompile(Map source) throws CompilationException, InstantiationException {
        String wrapperRootPath;
        HashMap<String, String> properties = new HashMap<String, String>();
        this.initProperties(properties);
        properties.put("deploy.batch", "compile");
        HashMap ejbSources = new HashMap();
        Iterator wrapperRootPaths = source.keySet().iterator();
        while (wrapperRootPaths.hasNext()) {
            wrapperRootPath = (String)wrapperRootPaths.next();
            if (!wrapperRootPath.endsWith("generated")) continue;
            ejbSources.put(wrapperRootPath, source.get(wrapperRootPath));
        }
        if (!ejbSources.isEmpty()) {
            this.invokeCompiler(ejbSources, properties);
        }
        wrapperRootPaths = source.keySet().iterator();
        while (wrapperRootPaths.hasNext()) {
            wrapperRootPath = (String)wrapperRootPaths.next();
            if (wrapperRootPath.endsWith("generated")) continue;
            properties.put("source.directory", wrapperRootPath);
            properties.put("target.directory", wrapperRootPath);
            this.invokeCompiler(this.convertSourceToMap((List)source.get(wrapperRootPath), wrapperRootPath), properties);
        }
        this.pathKeyAndSources = source;
    }

    public void compileClasses() throws CompilationException {
        throw new UnsupportedOperationException("Compilation.compile() not implemented");
    }

    private void writeWSDebugInfo(Exception e) {
        Notifier notifier = Notifier.getNotifier();
        if (notifier != null) {
            try {
                String[] params = new String[]{this.ejbPackage.getName()};
                notifier.sendNotification("ERROR_COMPILING_GENERATED_ARTIFACTS", params, e);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        e.printStackTrace();
    }

    private void loadCompiledCode(Collection binaries, Context deploymentContext) throws CompilationException, InstantiationException {
        try {
            try {
                Iterator binariesIterator = binaries.iterator();
                while (binariesIterator.hasNext()) {
                    CompiledObject binary = (CompiledObject)binariesIterator.next();
                    try {
                        deploymentContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                        binary.clean();
                    }
                    catch (IOException e) {
                        throw new CompilationException("Error reading wrapper class: " + e.getMessage(), e);
                    }
                    catch (NamingException e) {
                        throw new CompilationException("Error writing wrapper class: " + e.getMessage(), e);
                    }
                }
                if (this._compileIIOP) {
                    this.addAnySpecialClasses(deploymentContext);
                }
                try {
                    this.ejbPackage.storeDeployment();
                }
                catch (IOException e) {
                    throw new CompilationException("IO/Compilation error: " + e.getMessage(), e);
                }
                try {
                    ContextUtils.flush(deploymentContext);
                }
                catch (IOException e) {
                    throw new InstantiationException("IO error writing cache: " + e.getMessage());
                }
                Object var7_10 = null;
                if (this.compiler.needsSecurityManager()) {
                    ApplicationServer appServer = this.container.getApplication().getServer();
                    appServer.removeSecurityLayer();
                }
            }
            catch (InstantiationException e) {
                throw new CompilationException("Error instantiating compiler: " + e.getMessage(), e);
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (this.compiler.needsSecurityManager()) {
                ApplicationServer appServer = this.container.getApplication().getServer();
                appServer.removeSecurityLayer();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection invokeCompiler(Map sourceAndPath, Map properties) throws InstantiationException, CompilationException {
        Collection binaries = null;
        try {
            if (this._compileIIOP) {
                this.compiler.setCallback(this);
            }
            binaries = this.compiler.compile(sourceAndPath, properties);
            this.compiler.reset();
            Object var5_4 = null;
            if (this.compiler.needsSecurityManager()) {
                ApplicationServer appServer = this.container.getApplication().getServer();
                appServer.removeSecurityLayer();
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (this.compiler.needsSecurityManager()) {
                ApplicationServer appServer = this.container.getApplication().getServer();
                appServer.removeSecurityLayer();
            }
            throw throwable;
        }
        return binaries;
    }

    public BeanCompilation getBeanCompilation(String _beanName) {
        for (int i = 0; i < this.compilations.size(); ++i) {
            BeanCompilation beanCompilation = (BeanCompilation)this.compilations.get(i);
            if (!_beanName.equals(beanCompilation.getDescriptor().getLocation())) continue;
            return beanCompilation;
        }
        return null;
    }

    public String getCallerVariable(List users, String currentVar) {
        throw new UnsupportedOperationException("Compilation.getCallerVariable is not implemented");
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public Table getTable(TableNameContainer requestedName) {
        return this.nameMapper.getTable(requestedName);
    }

    public Table getTable(TableNameContainer requestedName, boolean firmRequest, DatabaseSchema schema) {
        return this.nameMapper.lookupTable(requestedName, firmRequest, schema);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void describeTable(TableView table, EntityBeanDescriptor desc, DataSourceConnectionContainer container) throws CompilationException {
        if (table == null) {
            throw new NullPointerException("table was null");
        }
        if (container == null) {
            throw new NullPointerException("container was null");
        }
        DataSourceConnection connection = null;
        try {
            if (connection == null) {
                connection = container.getConnection();
            }
        }
        catch (RemoteException e) {
            throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage(), e);
        }
        try {
            DatabaseMetaData data = connection.getConnection().getMetaData();
            String schemaName = table.getTable().getSchemaName();
            schemaName = schemaName != null ? schemaName.toUpperCase() : null;
            ResultSet rs = data.getColumns(null, schemaName, table.getTable().getShortName().toUpperCase(), "%");
            ResultSetMetaData rsmd = rs.getMetaData();
            int numCols = rsmd.getColumnCount();
            while (rs.next()) {
                String column = rs.getString(4);
                String type = rs.getString(6);
                int size = rs.getInt(7);
                Compilation.areWarnings(rs.getWarnings());
                ContainerManagedField field = table.getColumn(column);
                if (field == null) continue;
                field.setColumnLength(size);
                field.setColumnType(type);
            }
            rs.close();
        }
        catch (SQLException e) {
            System.err.println("SQL error: " + e.getMessage());
            if (connection != null) {
                connection.close(true);
                connection = null;
            }
        }
        finally {
            if (connection != null) {
                connection.close(false);
            }
        }
    }

    public void addGenerator(Compilable cg) {
        this.classes.add(cg);
    }

    public void setDefaultAllowedRoleNames(List names) {
        this.defaultAllowedRoleNames = names;
    }

    public List getDefaultAllowedRoleNames() {
        return this.defaultAllowedRoleNames;
    }

    public void setCompileIIOP(boolean compileIIOP) {
        this._compileIIOP = compileIIOP;
    }

    public boolean getCompileIIOP() {
        return this._compileIIOP;
    }

    public static String packagePrefix() {
        return PACKAGE_PREFIX;
    }

    public static String correctPackageName(String p) {
        if (p == null) {
            return p;
        }
        if (PackagePrefixChecker.hasOffendingPrefix((String)p)) {
            return PACKAGE_PREFIX + p;
        }
        return p;
    }

    public static boolean isOffendingPackage(String p) {
        return p != null && PackagePrefixChecker.hasOffendingPrefix((String)p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistTables() throws CompilationException {
        if (!this.container.getConfig().getAutoCreateTables()) {
            return;
        }
        if (!this.nameMapper.hasTables()) {
            return;
        }
        if (this.tablesToCreate == null) {
            return;
        }
        Iterator iterator = this.tablesToCreate.iterator();
        while (iterator.hasNext()) {
            Object[] holder = (Object[])iterator.next();
            TableView table = (TableView)holder[0];
            DataSourceConnectionContainer container = (DataSourceConnectionContainer)holder[1];
            DataSourceConnection connection = null;
            try {
                Statement statement;
                HashSet<String> tables;
                block30: {
                    block29: {
                        if (this.tableLists == null) {
                            this.tableLists = new HashMap();
                        }
                        tables = (HashSet<String>)this.tableLists.get(container);
                        if (tables == null) {
                            tables = new HashSet<String>();
                        }
                        try {
                            if (connection == null) {
                                connection = container.getConnection();
                            }
                        }
                        catch (RemoteException e) {
                            throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage(), e);
                        }
                        try {
                            String schemaName = table.getTable().getSchemaName();
                            String tableName = table.getTable().getShortName();
                            DatabaseMetaData data = connection.getConnection().getMetaData();
                            String dataSourceSchemaName = connection.getConnection() instanceof OracleConnection ? ((OracleConnection)connection.getConnection()).getUserName() : null;
                            schemaName = schemaName != null ? schemaName.toUpperCase() : dataSourceSchemaName;
                            ResultSet set = data.getTables(null, schemaName, tableName.toUpperCase(), new String[]{"TABLE", "VIEW"});
                            while (set.next()) {
                                tables.add((set.getString("TABLE_SCHEM") != null && schemaName != null ? set.getString("TABLE_SCHEM").toLowerCase() + "." : "") + set.getString("TABLE_NAME").toLowerCase());
                            }
                            set.close();
                        }
                        catch (SQLException e) {
                            System.err.println("SQL error: " + e.getMessage());
                            this.sqlError = e.getMessage();
                            if (connection == null) break block29;
                            connection.close(true);
                            connection = null;
                        }
                    }
                    this.tableLists.put(container, tables);
                    if (table.getTable() == null) {
                        throw new NullPointerException("table.getTable() was null");
                    }
                    if (table.getTable().getName() == null) {
                        throw new NullPointerException("table.getTable().getName() was null");
                    }
                    if (!tables.contains(table.getTable().getName().toLowerCase())) break block30;
                    if (!this.container.getConfig().getAutoDeleteTables()) continue;
                    try {
                        if (connection == null) {
                            connection = container.getConnection();
                        }
                    }
                    catch (RemoteException e) {
                        throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage(), e);
                    }
                    EJBCompilationMessages.infoAutoDeleteTable(this.ejbPackage, table);
                    statement = connection.getConnection().createStatement();
                    statement.executeUpdate("drop table " + table.getTable().getName());
                    statement.close();
                }
                try {
                    tables.add(table.getTable().getName().toLowerCase());
                    try {
                        if (connection == null) {
                            connection = container.getConnection();
                        }
                    }
                    catch (RemoteException e) {
                        throw new CompilationException("Error finding a suitable DataSource: " + e.getMessage(), e);
                    }
                    statement = connection.getConnection().createStatement();
                    String createTableStatement = table.getCreateTableStatement(true);
                    EJBCompilationMessages.infoAutoCreateTable(this.ejbPackage, createTableStatement);
                    statement.executeUpdate(createTableStatement);
                    statement.close();
                }
                catch (SQLException e) {
                    if (DBProperties.getJDBCDebug()) {
                        e.printStackTrace();
                    }
                    if (e.getErrorCode() == 955) {
                        System.err.println("Warning: " + e.getMessage());
                        this.container.getApplication().log(new LogEvent("Warning: " + e.getMessage(), e, 2, System.currentTimeMillis()));
                        continue;
                    }
                    System.err.println("Error creating table: " + e.getMessage());
                    this.container.getApplication().log(new LogEvent("Error creating table: " + e.getMessage(), e, 2, System.currentTimeMillis()));
                }
            }
            finally {
                if (connection == null) continue;
                connection.close(false);
            }
        }
    }

    public void createTable(TableView table, DataSourceConnectionContainer container) throws CompilationException {
        if (table == null) {
            throw new NullPointerException("table was null");
        }
        if (container == null) {
            throw new NullPointerException("container was null");
        }
        if (this.tablesToCreate == null) {
            this.tablesToCreate = new ArrayList();
        }
        this.tablesToCreate.add(new Object[]{table, container});
    }

    public boolean appendCloneSource(String prefix, boolean wrapTry, ByteString source, String variable, String wrapperSource, ContainerManagedField field, String assignedVariable, boolean local) {
        Class type = field.getType();
        if (ClassUtils.getPrimitiveType(type).isPrimitive() || type == String.class || EJBObject.class.isAssignableFrom(type) || EntityContext.class.isAssignableFrom(type) || EJBLocalObject.class.isAssignableFrom(type) || EJBLocalHome.class.isAssignableFrom(type) || EJBHome.class.isAssignableFrom(type) || EJBLocalObject.class.isAssignableFrom(type) || EJBLocalHome.class.isAssignableFrom(type) || UserTransaction.class.isAssignableFrom(type) || Locale.class.isAssignableFrom(type) || BigInteger.class.isAssignableFrom(type) || InitialContext.class.isAssignableFrom(type)) {
            source.append(prefix + variable + "." + field.getName() + ";\n");
        } else if (java.util.Date.class == type) {
            source.append(prefix + variable + "." + field.getName() + " == null ? null : new java.util.Date(" + variable + "." + field.getName() + ".getTime());\n");
        } else if (Date.class == type) {
            source.append(prefix + variable + "." + field.getName() + " == null ? null : new java.sql.Date(" + variable + "." + field.getName() + ".getTime());\n");
        } else if (Timestamp.class == type) {
            source.append(prefix + variable + "." + field.getName() + " == null ? null : new java.sql.Timestamp(" + variable + "." + field.getName() + ".getTime());\n");
            source.append("\nif (" + prefix + variable + "." + field.getName() + " != null) {");
            source.append(assignedVariable + ".setNanos(" + prefix + variable + "." + field.getName() + ".getNanos());");
            source.append("} // generated from Compilation\n");
        } else {
            if (wrapTry) {
                source.append("try\n{\n");
            }
            source.append(prefix + "(" + ClassUtils.getSourceNotation(type, 0) + ")" + wrapperSource + ".clone" + (local ? "Local" : "") + "Object(" + variable + "." + field.getName() + ");\n");
            if (wrapTry) {
                source.append("}\ncatch(java.rmi.RemoteException e)\n{\nthrow new RuntimeException(\"RemoteException while performing deepCopy: \" + e);\n}\n\n");
            }
        }
        return false;
    }

    public BeanCompilation getCompilation(String name) throws CompilationException {
        for (int i = 0; i < this.compilations.size(); ++i) {
            BeanCompilation compilation = (BeanCompilation)this.compilations.get(i);
            if (!compilation.getDescriptor().getName().equals(name)) continue;
            return compilation;
        }
        return null;
    }

    public boolean generateAnySpecialClasses() throws CompilationException {
        Vector<String> files = new Vector<String>();
        Vector<String> interfaces = new Vector<String>();
        Iterator i = this.ejbPackage.getAllBeans().iterator();
        while (i.hasNext()) {
            BeanDescriptor desc = (BeanDescriptor)i.next();
            if (!desc.isSession() && !desc.isEntity()) continue;
            ExposableBeanDescriptor ed = (ExposableBeanDescriptor)desc;
            if (ed.getRemoteHomeWrapperName() != null) {
                interfaces.add(ed.getRemoteHomeName());
                files.add(ed.getRemoteHomeWrapperName());
            }
            if (ed.getRemoteWrapperName() == null) continue;
            interfaces.add(ed.getRemoteInterfaceName());
            files.add(ed.getRemoteWrapperName());
        }
        if (files.size() == 0) {
            m_logger.log(Level.FINE, "Nothing to do, no files to generate ...");
            return false;
        }
        EJBCompilationMessages.finerGeneratedStubs(this.ejbPackage, files);
        int numRmicArgs = 8 + files.size();
        if (iiopVerbose) {
            ++numRmicArgs;
        }
        if (keepIiop) {
            ++numRmicArgs;
        }
        if (EJBProperties.getDebugIIOPWrapperCode()) {
            ++numRmicArgs;
        }
        String[] rmicArgs = new String[numRmicArgs];
        int rmicCnt = 0;
        rmicArgs[rmicCnt++] = "-iiop";
        rmicArgs[rmicCnt++] = "-poa";
        rmicArgs[rmicCnt++] = "-alwaysgenerate";
        if (iiopVerbose) {
            rmicArgs[rmicCnt++] = "-verbose";
        }
        if (keepIiop) {
            rmicArgs[rmicCnt++] = "-keepgenerated";
        }
        if (EJBProperties.getDebugIIOPWrapperCode()) {
            rmicArgs[rmicCnt++] = "-g";
        }
        rmicArgs[rmicCnt++] = "-nolocalstubs";
        rmicArgs[rmicCnt++] = "-classpath";
        rmicArgs[rmicCnt++] = this.classpath + File.pathSeparatorChar + EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage) + File.pathSeparatorChar + '.';
        rmicArgs[rmicCnt++] = "-d";
        rmicArgs[rmicCnt++] = this.getTempDirectory();
        String cname = "";
        Enumeration e1 = files.elements();
        while (e1.hasMoreElements()) {
            String className = (String)e1.nextElement();
            rmicArgs[rmicCnt++] = className;
            cname = cname + " " + className;
        }
        RmicCompiler rmic = new RmicCompiler(OC4J_JAR);
        if (iiopVerbose) {
            StringBuffer buf = new StringBuffer(100);
            buf.append("RMIC arguments are : ");
            for (int i2 = 0; i2 < rmicArgs.length; ++i2) {
                buf.append(rmicArgs[i2]);
                buf.append(' ');
            }
            m_logger.log(Level.FINEST, buf.toString());
        }
        rmic.compile(rmicArgs);
        m_logger.log(Level.FINE, "IIOP code generation done ..");
        this.computeGeneratedFiles(files, interfaces);
        return true;
    }

    private void initializeCMPAndCMRFields() throws CompilationException {
        try {
            DatabaseSchema schema = null;
            Iterator setFieldsIterator = this.ejbPackage.getBeans().iterator();
            while (setFieldsIterator.hasNext()) {
                BeanDescriptor descriptor = (BeanDescriptor)setFieldsIterator.next();
                if (!(descriptor instanceof EntityBeanDescriptor)) continue;
                EntityBeanDescriptor ebd = (EntityBeanDescriptor)descriptor;
                if (ebd.isContainerManaged()) {
                    boolean firmTableName;
                    if (schema == null) {
                        schema = this.container.getApplication().getDatabaseSchema(ebd.getDataSourceName());
                    }
                    boolean bl = firmTableName = ebd.getTableName(false) != null;
                    if (!firmTableName) {
                        if (this.container.getConfig().prependDeploymentName()) {
                            ebd.setTableName(this.container.getApplication().getName() + "_" + ebd.getLocation());
                        } else {
                            ebd.setTableName(ebd.getLocation());
                        }
                    }
                    this.getTable(ebd, firmTableName, schema);
                    ebd.initializeCMPFields(this.container, this.nameMapper);
                    continue;
                }
                if (!ebd.getCommitOption().useOCA()) continue;
                ebd.initializeOCAField(this.container, this.nameMapper);
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException(e.getMessage(), e);
        }
    }

    private void translateEjbqlQeries() throws CompilationException {
        block2: {
            try {
                this.ejbPackage.translateEjbqlQeries();
            }
            catch (Exception e) {
                if (!EJBUtils.isOrionCmpForced()) break block2;
                throw new CompilationException("Error translating EJBQL: " + e, e);
            }
        }
    }

    public void postCompilationCleanup() {
        if (this.classes != null) {
            this.classes.clear();
        }
        if (this.defaultAllowedRoleNames != null) {
            this.defaultAllowedRoleNames.clear();
        }
        if (this.callerVariables != null) {
            this.callerVariables.clear();
        }
        if (this.deploymentProperties != null) {
            this.deploymentProperties = new Properties();
        }
        if (this.compiler != null) {
            this.compiler.reset();
        }
        for (int i = 0; i < this.compilations.size(); ++i) {
            Object compilation = this.compilations.get(i);
            if (!(compilation instanceof EntityBeanCompilation)) continue;
            ((EntityBeanCompilation)compilation).reset();
        }
        this.compilations.clear();
        if (!this.tempFileMap.isEmpty()) {
            Iterator pathDirs = this.tempFileMap.keySet().iterator();
            while (pathDirs.hasNext()) {
                String pathDir = (String)pathDirs.next();
                List classes = (List)this.tempFileMap.get(pathDir);
                for (int i = 0; i < classes.size(); ++i) {
                    String className = pathDir + File.separator + (String)classes.get(i) + ".class";
                    File file = new File(className);
                    if (!file.exists()) continue;
                    file.delete();
                }
            }
        }
    }

    private static boolean areWarnings(SQLWarning warn) throws SQLException {
        boolean rc = false;
        if (warn != null) {
            EJBCompilationMessages.warningPrintMessage();
            rc = true;
            while (warn != null) {
                EJBCompilationMessages.warningPrintSQLState(warn.getSQLState());
                EJBCompilationMessages.warningPrintSQLMessage(warn.getMessage());
                EJBCompilationMessages.warningPrintSQLVendor(warn.getErrorCode());
                warn = warn.getNextWarning();
            }
        }
        return rc;
    }

    private void addAnySpecialClasses(Context deploymentContext) throws CompilationException {
        if (this.generatedFiles == null) {
            return;
        }
        m_logger.log(Level.FINE, "Now creating server and client jar files ...");
        try {
            this.appClientJarContext = this.deployment.getAppClientJarContext();
        }
        catch (InstantiationException ex) {
            throw new CompilationException("Error getting application iiop client jar : " + ex.getMessage(), ex);
        }
        try {
            this.clientJarContext = this.deployment.getClientJarContext();
            int clientJarSize = 0;
            try {
                clientJarSize = ((MemoryArchiveContext)this.clientJarContext).getData().length;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (clientJarSize > 0) {
                try {
                    NamingEnumeration<Binding> clientJarEnum = this.clientJarContext.listBindings("");
                    while (clientJarEnum.hasMore()) {
                        Binding entryBinding = clientJarEnum.next();
                        String entryName = entryBinding.getName();
                        Object entryObject = entryBinding.getObject();
                        if (entryObject instanceof Context) {
                            try {
                                this.appClientJarContext.destroySubcontext(entryName);
                            }
                            catch (Exception appEx) {}
                            continue;
                        }
                        try {
                            this.appClientJarContext.unbind(entryName);
                        }
                        catch (Exception appEx) {}
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            ((MemoryArchiveContext)this.clientJarContext).setData(new byte[0], 0, 0);
        }
        catch (InstantiationException ex) {
            throw new CompilationException("Error creating iiop client jar : " + ex.getMessage(), ex);
        }
        Enumeration e = this.generatedFiles.elements();
        while (e.hasMoreElements()) {
            String className = (String)e.nextElement();
            File classFile = new File(this.tmpDirName + fs + className.replace('.', File.separatorChar) + ".class");
            if (!classFile.exists()) {
                throw new CompilationException("Missing classfile: " + classFile);
            }
            try {
                FileInputStream in = new FileInputStream(classFile);
                byte[] data = new byte[(int)classFile.length()];
                in.read(data);
                in.close();
                CompiledObject binary = new CompiledObject(className, data);
                deploymentContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                this.clientJarContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
                this.appClientJarContext.rebind(binary.getName().replace('.', '/') + ".class", (Object)binary.getData());
            }
            catch (Exception t) {
                throw new CompilationException("Error adding the generated class: " + t.getMessage(), t);
            }
        }
        try {
            ContextUtils.flush(this.clientJarContext);
            ContextUtils.flush(this.appClientJarContext);
        }
        catch (IOException ex) {
            throw new CompilationException("Error creating client jar : " + ex.getMessage(), ex);
        }
        catch (Exception exc) {
            throw new CompilationException("Error creating client jar : " + exc.getMessage(), exc);
        }
        if (!keepIiop) {
            m_logger.log(Level.FINE, "Now deleting all the temporary files ...");
            if (this.tmpDirName != null) {
                this.deleteAll(new File(this.tmpDirName));
            }
        }
    }

    private void computeGeneratedFiles(Vector files, Vector interfaces) {
        Enumeration e = files.elements();
        while (e.hasMoreElements()) {
            String f = (String)e.nextElement();
            this.generatedFiles.add(new String("_" + f + "_Tie"));
        }
        e = interfaces.elements();
        while (e.hasMoreElements()) {
            String fullName = (String)e.nextElement();
            if (fullName == null) continue;
            String className = fullName;
            String packageName = "";
            int lastDot = fullName.lastIndexOf(46);
            if (lastDot != -1) {
                className = fullName.substring(lastDot + 1, fullName.length());
                packageName = fullName.substring(0, lastDot + 1);
            }
            String stubName = Compilation.correctPackageName(packageName) + "_" + className + "_Stub";
            this.generatedFiles.add(stubName);
        }
        if (m_logger.isLoggable(Level.FINER)) {
            m_logger.log(Level.FINER, "Generated files are: " + this.generatedFiles);
        }
    }

    private String getTempDirectory() throws CompilationException {
        String path = "_gen_";
        Context ctx = null;
        try {
            ctx = this.deployment.getDeploymentContext();
            ctx.createSubcontext(path);
        }
        catch (NameAlreadyBoundException e) {
        }
        catch (Throwable t) {
            throw new CompilationException("Couldn't create tmp directory : " + t.getMessage());
        }
        this.tmpDirName = ((FileContext)ctx).getFile(path).getPath();
        return this.tmpDirName;
    }

    private void deleteAll(File directory) throws CompilationException {
        try {
            if (!directory.isDirectory()) {
                directory.delete();
            } else {
                String[] entries = directory.list();
                if (entries == null) {
                    return;
                }
                for (int i = 0; i < entries.length; ++i) {
                    this.deleteAll(new File(directory.getPath(), entries[i]));
                }
                directory.delete();
            }
        }
        catch (Exception e) {
            throw new CompilationException("Error deleting the temp directory : " + e.getMessage(), e);
        }
    }

    private void generateAnyOldStyle() throws CompilationException {
        Iterator iterator = this.ejbPackage.getBeans().iterator();
        ArrayList tempFileNames = new ArrayList();
        ArrayList sessionBeanSources = new ArrayList();
        while (iterator.hasNext()) {
            EntityBeanDescriptor ed;
            String deployed;
            BeanDescriptor descriptor = (BeanDescriptor)iterator.next();
            if (!(descriptor instanceof EntityBeanDescriptor) || null == (deployed = (ed = (EntityBeanDescriptor)descriptor).isDeployed())) continue;
            System.out.println(ed.getName() + ": " + deployed);
            EntityBeanCompilation localBeanCompilation = null;
            EntityBeanCompilation remoteBeanCompilation = null;
            if (ed.getLocalInterface() != null) {
                localBeanCompilation = new EntityBeanCompilation(this, ed, true);
            }
            if (ed.getRemoteInterface() != null) {
                remoteBeanCompilation = new EntityBeanCompilation(this, ed, false);
            }
            if (ed.isContainerManaged()) {
                try {
                    if (ed.getDataSourceName() == null && ed.getDataSourceName() == null) {
                        if (this._defaultDataSource != null) {
                            ed.setDataSourceName(this._defaultDataSource);
                        } else {
                            ed.setDataSourceName(this.container.getApplication().getDefaultDataSourceJNDILocation());
                        }
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            if (localBeanCompilation != null) {
                this.compilations.add(localBeanCompilation);
            }
            if (remoteBeanCompilation == null) continue;
            this.compilations.add(remoteBeanCompilation);
        }
        for (int i = 0; i < this.compilations.size(); ++i) {
            ((BeanCompilation)this.compilations.get(i)).preCompile();
        }
        ArrayList compiledSourecs = new ArrayList();
        String key = EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage);
        ArrayList<BeanCompilation> listCompilation = new ArrayList<BeanCompilation>();
        Map properties = this.getInitProperties("generate", key);
        for (int i = 0; i < this.compilations.size(); ++i) {
            BeanCompilation beanCompilation = (BeanCompilation)this.compilations.get(i);
            beanCompilation.compile();
            if (!listCompilation.isEmpty()) {
                listCompilation.clear();
            }
            if (beanCompilation.getSource() == null || beanCompilation.getSource().getBytes().length <= 1) continue;
            listCompilation.add(beanCompilation);
            this.classes.remove(beanCompilation);
            Collection collection = this.compileSource(listCompilation, key, properties);
            if (collection == null) continue;
            compiledSourecs.addAll(collection);
        }
        this.setPathKeyAndSources(compiledSourecs, key);
        this.tempFileMap.put(EJBCompilationUtils.getWrapperCodeGenDir(this.ejbPackage), tempFileNames);
    }

    private void setPathKeyAndSources(Collection compiledSources, String pathKey) {
        if (!compiledSources.isEmpty()) {
            Collection collection = (Collection)this.pathKeyAndSources.get(pathKey);
            if (collection == null) {
                this.pathKeyAndSources.put(pathKey, compiledSources);
            } else {
                collection.addAll(compiledSources);
                this.pathKeyAndSources.put(pathKey, collection);
            }
        }
    }

    private void generateWebServices() throws CompilationException {
        ServerComponent sc = (ServerComponent)((Object)this.ejbPackage.getWebServicesDescriptor());
        if (sc == null) {
            return;
        }
        try {
            File file = ContextUtils.getFile(this.ejbPackage.getDeploymentContext(), false);
            Class<?> generatorC = Class.forName("oracle.j2ee.ws.server.codegen.ServerArtifactGenerator", false, this.parent);
            WebServiceArtifactGen generator = (WebServiceArtifactGen)generatorC.newInstance();
            generator.setDestnRootDir(file);
            generator.generateCompilables(sc, ContextUtils.getFile(this.ejbPackage.getContext(), false).getAbsolutePath(), this.parent);
            if (this.webServicesClasses != null) {
                this.webServicesClasses.addAll(generator.getCompilables());
            } else {
                this.classes.addAll(generator.getCompilables());
            }
            sc.storeDeployment();
        }
        catch (IOException e) {
            throw new CompilationException("IO/Compilation error: " + e.getMessage(), e);
        }
        catch (InstantiationException e) {
            throw new CompilationException("Error instantiating compiler: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.webServiceDeployment = true;
    }

    private void generateWebServiceRefs() throws CompilationException {
        try {
            File file = ContextUtils.getFile(this.ejbPackage.getDeploymentContext(), false);
            Class<?> generatorC = Class.forName("oracle.j2ee.ws.server.codegen.ServerArtifactGenerator", false, this.parent);
            Iterator iterator = this.ejbPackage.getAllBeans().iterator();
            while (iterator.hasNext()) {
                BeanDescriptor bd = (BeanDescriptor)iterator.next();
                if (bd.getServiceReferences().isEmpty()) continue;
                WebServiceArtifactGen generator = (WebServiceArtifactGen)generatorC.newInstance();
                generator.setDestnRootDir(file);
                generator.generateCompilables(bd, ContextUtils.getFile(this.ejbPackage.getContext(), false).getAbsolutePath(), this.ejbPackage, this.parent);
                if (this.webServicesClasses != null) {
                    this.webServicesClasses.addAll(generator.getCompilables());
                } else {
                    this.classes.addAll(generator.getCompilables());
                }
                this.webServiceDeployment = true;
            }
        }
        catch (InstantiationException e) {
            throw new CompilationException("Error instantiating compiler: " + e.getMessage(), e);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Map convertSourceToMap(List sources, String path) {
        HashMap mapSources = new HashMap();
        ArrayList cleanClasses = new ArrayList(new HashSet(sources));
        if (path == null) {
            mapSources.put("no_batch_compile", cleanClasses);
        } else {
            mapSources.put(path, cleanClasses);
        }
        return mapSources;
    }
}

