/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.compilation.BeanMethodCompilation;
import com.evermind.server.ejb.compilation.ClassCompilation;
import com.evermind.server.ejb.compilation.EJBCompilationUtils;
import com.evermind.server.ejb.compilation.EntityBeanCompilation;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.util.ByteString;
import com.evermind.util.ClassUtils;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class EntityBeanMethodCompilation
extends BeanMethodCompilation {
    protected EntityBeanCompilation compilation;
    protected boolean isGetterOnly;
    protected String qqHome;
    protected String qqWrapper;
    static /* synthetic */ Class class$java$lang$IllegalArgumentException;

    public EntityBeanMethodCompilation(EntityBeanCompilation compilation, Method method, String beanMethodName, boolean local) throws CompilationException {
        super(compilation, compilation.getDescriptor(), method, false, true, beanMethodName, local);
        this.compilation = compilation;
        this.synced = false;
        if (Modifier.isAbstract(this.beanMethod.getModifiers())) {
            if (this.beanMethod.getParameterTypes().length == 0) {
                this.isGetterOnly = true;
            }
        } else {
            this.isGetterOnly = compilation.isGetterOnly(new ByteString(this.beanMethod.getName()), new ByteString(ClassUtils.getCodedArguments(this.beanMethod.getParameterTypes(), this.beanMethod.getReturnType())));
        }
        this.qqHome = "((EntityEJBHome) getMyHome())";
        this.qqWrapper = local ? " ((EntityEJBObject) context.localWrapper)" : "((EntityEJBObject) context.remoteWrapper)";
    }

    protected void addStartTransactionMiddle() {
        this.addTrailCheck();
        if (this.compilation.descriptor.getValidityTimeout() > 0L) {
            this.source.append("if(this.validityCheck < OC4J_getCurrentTime() && this._getObject() != null)\n{\ntry\n{\nloadState(" + EJBCompilationUtils.getTransactionString() + ");\n" + "}\n" + "catch(java.io.IOException e)\n" + "{\n" + "releaseContext(false);\n" + "}\n" + "catch(ClassNotFoundException e)\n" + "{\n" + "releaseContext(false);\n" + "}\n" + "catch(java.sql.SQLException e)\n" + "{\n" + "releaseContext(false);\n" + "}\n" + "catch(javax.ejb.NoSuchEntityException e)\n" + "{\n" + "releaseContext(false);\n" + "}\n" + "}\n" + "\n");
        }
    }

    public void compile() throws CompilationException {
        this.addMethodWrapperStart();
        this.addTransactionWrapperStart(true);
        this.addLoadState();
        this.addCreateStateKeepers();
        this.addEJBInvocation();
        this.addOCALocking();
        this.addSaveState();
        this.addTransactionWrapperEnd(true);
        this.addMethodWrapperEnd();
    }

    private void addOCALocking() throws CompilationException {
        CommitOptionDescriptor co = this.compilation.descriptor.getCommitOption();
        this.source.append("// OC: " + this.getMethodName() + " " + this.isGetterOnly + " " + co.getOptionStr() + " " + co.getOption() + "\n");
        if (co.getOption() == 4) {
            this.source.append("// set oc flags ...\n");
            this.source.append("if(this.getEntityBean() != null)\n");
            if (this.isGetterOnly) {
                this.source.append("this._getObject()._setFlag(ExtendedContainerManagedObject.Flag.k_read,true);\n");
            } else {
                this.source.append("this._getObject()._setFlag(ExtendedContainerManagedObject.Flag.k_write,true);\n");
            }
        }
    }

    protected void addTrailCheck() {
        this.source.append("if((this.context == null) || (this.context.getObject() == null))\n{\ntraceLog(\"object is null\");\nif(trail == null) { \n");
        String localString = this.local ? "Local" : "";
        this.source.append("    traceLog(\"trail is also null, calling reActivateNew()\");\n    try {\n        reActivateNew" + localString + "();\n" + "    } catch (" + (this.local ? "" : "java.rmi.") + "NoSuchObject" + localString + "Exception e) {\n" + "        throw e;\n" + "    } catch (Exception e) {\n" + "        methodException = __handleThrowableException(thread, e, " + this.getIsUserTransactionExpression() + ", true, " + (this.local ? "true" : "false") + ", false, " + (this.local ? "true" : "false") + ", null, null);\n");
        if (!this.local) {
            this.source.append("        if (methodException instanceof java.rmi.RemoteException) {\n            throw (java.rmi.RemoteException) methodException;\n        }\n ");
        }
        this.source.append("        __throwUncheckedException(methodException);\n    }\n");
        this.source.append("}\n\nif(trail != null)\n{\nwhile(trail.trail != null) trail = trail.trail;\n");
        if (this.method.getReturnType() != Void.TYPE) {
            this.source.append("return ");
        } else {
            this.source.append("");
        }
        this.source.append("trail." + this.method.getName() + "(");
        for (int i = 0; i < this.args.length; ++i) {
            if (i > 0) {
                this.source.append(", ");
            }
            this.source.append("argument");
            this.source.append(i);
        }
        this.source.append(");\n");
        if (this.method.getReturnType() == Void.TYPE) {
            this.source.append("return;\n");
        }
        this.source.append("}\n}\n\n");
    }

    protected void addCreateStateKeepers() {
        if (!this.isGetterOnly && this.compilation.getEntityBeanDescriptor().isContainerManaged() && !this.compilation.hasIsModifiedMethod) {
            Iterator iterator = this.compilation.persistenceManagerCompilation.table.getFields().iterator();
            while (iterator.hasNext()) {
                ContainerManagedField field = (ContainerManagedField)iterator.next();
                if (field.getORMapping() != null && !field.getType().isArray()) continue;
                Class type = field.getType();
                this.source.append("");
                this.source.append(ClassUtils.getSourceNotation(type, 0));
                this.source.append(" _" + field.getName() + " = ");
                this.compilation.compilation.appendCloneSource("", false, this.source, "this._getObject()", "this.context", field, "_" + field.getName(), this.local);
            }
        }
    }

    protected void addSaveState() {
        if (!this.isGetterOnly) {
            this.source.append("if(this.context != null && this.context.getObject() != null) {\n");
            this.source.append(this.compilation.createCheckStateKeepers());
            this.source.append("boolean checkException =  methodException == null ||  !(methodException instanceof RuntimeException || methodException instanceof java.rmi.RemoteException);\n");
            this.source.append("if(" + EJBCompilationUtils.getTransactionString() + " == null && !isReentrantCall && checkException)\n" + "{\n" + "  saveState" + (this.isLocal() ? "Local" : "") + "(null);\n");
            if (!this.compilation.getEntityBeanDescriptor().isReadOnlyBMP() && this.compilation.getEntityBeanDescriptor().isBMP() && this.compilation.getEntityBeanDescriptor().getCommitOption().isCacheableOptionA()) {
                this.source.append(" _cacheMgr.put(getPrimaryKey(), this);");
            }
            if (this.compilation.getEntityBeanDescriptor().isContainerManaged()) {
                this.source.append("  Exception exceptionDuringSaveState = null;\n  try\n  {\n    Iterator ejbs = this._getObject().getOutOfTransDirtyEjbs();\n    while( ejbs.hasNext() )\n");
                if (this.local) {
                    this.source.append("    ((EntityEJBObject)ejbs.next()).saveStateLocal(null);\n");
                } else {
                    this.source.append("    try {\n      ((EntityEJBObject)ejbs.next()).saveState(null);\n    } catch( SQLException e ) {\n      exceptionDuringSaveState = e;\n    }\n");
                }
                this.source.append("\n  }\n  finally\n  {\n    this._getObject().clearOutOfTransDirtyEjbs();\n    if( exceptionDuringSaveState != null )\n      throw com.evermind.server.ejb.EJBUtils.createEJBException( \"Exception while attempting saveState of affected EJBs without a transaction context: \" + exceptionDuringSaveState.getMessage() );\n");
                this.source.append("  }\n");
            }
            this.source.append("}\n");
            if (!this.compilation.descriptor.getDelayUpdatesUntilCommit()) {
                this.source.append("// generated only if delay-updates-until-commit is false \n");
                this.source.append("else\n");
                this.source.append("{\n");
                if (this.local) {
                    this.source.append(ClassCompilation.convertRemoteException("saveState(" + EJBCompilationUtils.getTransactionString() + ")") + "\n");
                } else {
                    this.source.append("saveState(" + EJBCompilationUtils.getTransactionString() + ");\n");
                }
                this.source.append("}\n");
            }
            this.source.append("}\n");
        }
        if (this.compilation.getEntityBeanDescriptor().isContainerManaged() && !this.compilation.descriptor.hasExclusiveWriteAccess()) {
            boolean doCommit = false;
            this.source.append("if(connection != null && !isReentrantCall && transaction == null)\n{\n");
            if (doCommit) {
                this.source.append("try\n{\nconnection.commit();\n");
            }
            this.source.append("connection.release();\nthis.connection = null;\n");
            if (doCommit) {
                this.source.append("}\ncatch(Exception e)\n{\nreleaseContext(false);\n" + this.getLogAndRollbackCode("e", true) + "}\n");
            }
            this.source.append("}\n");
        }
    }

    protected void addLoadState() {
        if (!this.compilation.descriptor.hasExclusiveWriteAccess()) {
            this.source.append("if(" + EJBCompilationUtils.getTransactionString() + " == null && !isReentrantCall)\n" + "{\n");
            if (this.isLocal()) {
                this.source.append("methodException = __doLoadStateLocal(thread, " + this.getIsUserTransactionExpression() + ", false, " + (this.descriptor.getPackage().getCompatibility() >= 3) + ", " + this.throwsRemoteException + ", methodException);\n");
            } else {
                this.source.append("methodException = __doLoadStateRemote(thread, " + this.getIsUserTransactionExpression() + ", false, " + (this.descriptor.getPackage().getCompatibility() >= 3) + ", " + this.throwsRemoteException + ", methodException);\n");
            }
            this.source.append("}\n");
        }
    }

    public void appendResponseConverters() {
        if (this.compilation.containsORMapping && Collection.class.isAssignableFrom(this.method.getReturnType()) && !this.local) {
            this.source.append("if(response instanceof com.evermind.server.rmi.Replaceable) response = (" + this.getResponseTypeName() + ")((com.evermind.server.rmi.Replaceable)response).getReplacement();\n");
        }
        super.appendResponseConverters();
    }

    public boolean getRegisterTransactionSource() {
        return !this.compilation.descriptor.hasExclusiveWriteAccess();
    }

    protected void addPostCallSource(ByteString source) {
        if (!this.compilation.descriptor.hasExclusiveWriteAccess()) {
            source.append("if (this.context != null) \n{\n");
            source.append("if (transaction == null) this.context.setLazy(true);\n");
            source.append("if(transaction == null && this.context.getObject() != null && !isReentrantCall) removeFromCacheNew" + (this.local ? "Local" : "") + "(false, false, methodException != null);\n");
            source.append("}\n");
        }
    }

    protected void appendExtraCatches(List caughtExceptions) throws CompilationException {
        PropertyDescriptor[] descriptors;
        if (Modifier.isAbstract(this.beanMethod.getModifiers()) && (descriptors = this.compilation.descriptor.getProperties()) != null) {
            for (int i = 0; i < descriptors.length; ++i) {
                Method writeMethod = descriptors[i].getWriteMethod();
                if (writeMethod == null || !ClassUtils.signatureEquals(writeMethod, this.method)) continue;
                boolean alreadyCaught = false;
                for (int y = 0; y < caughtExceptions.size(); ++y) {
                    if (!((Class)caughtExceptions.get(y)).isAssignableFrom(class$java$lang$IllegalArgumentException == null ? EntityBeanMethodCompilation.class$("java.lang.IllegalArgumentException") : class$java$lang$IllegalArgumentException)) continue;
                    alreadyCaught = true;
                    break;
                }
                if (alreadyCaught) continue;
                this.source.append("catch(java.lang.IllegalArgumentException e)\n{\nmethodException = com.evermind.server.ejb.EJBUtils.createEJBException(e);\n}\n");
                caughtExceptions.add(class$java$lang$IllegalArgumentException == null ? EntityBeanMethodCompilation.class$("java.lang.IllegalArgumentException") : class$java$lang$IllegalArgumentException);
            }
        }
    }
}

