/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.compilation;

import com.evermind.compiler.CompilationException;
import com.evermind.server.ejb.LocalStatefulSessionEJBObject;
import com.evermind.server.ejb.RemoteStatefulSessionEJBObject;
import com.evermind.server.ejb.compilation.BeanCompilation;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.compilation.InterceptorBeanMethodCompilation;
import com.evermind.server.ejb.compilation.MethodCompilation;
import com.evermind.server.ejb.compilation.StatefulSessionHomeCompilation;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.util.ByteString;
import java.lang.reflect.Method;
import javax.ejb.EJBLocalObject;
import javax.ejb.EJBObject;

public class StatefulSessionBeanCompilation
extends BeanCompilation {
    public StatefulSessionHomeCompilation home;
    public SessionBeanDescriptor descriptor;

    public StatefulSessionBeanCompilation(Compilation compilation, SessionBeanDescriptor descriptor, boolean local) throws CompilationException {
        super(compilation, "StatefulSessionBeanWrapper", local ? descriptor.getLocalInterface() : descriptor.getRemoteInterface(), local);
        this.descriptor = descriptor;
        if (local) {
            if (descriptor.getLocalHomeWrapperName() == null) {
                this.home = new StatefulSessionHomeCompilation(this);
            }
        } else if (descriptor.getRemoteHomeWrapperName() == null) {
            this.home = new StatefulSessionHomeCompilation(this);
        }
        if (local) {
            descriptor.setLocalWrapperName(this.getName());
        } else {
            descriptor.setRemoteWrapperName(this.getName());
        }
    }

    public ExposableBeanDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void cleanSource() {
        this.resetSource();
    }

    public void compile() throws CompilationException {
        this.compileMethods();
        this.source.append("import javax.ejb.*;\nimport java.rmi.NoSuchObjectException;\nimport com.evermind.server.ejb.*;\nimport com.evermind.server.*;\nimport javax.transaction.*;\n\n");
        this.addSharedImports();
        this.appendClassHeader(this.source);
        this.appendExistingInstanceConstructor(this.source);
        this.appendNewInstanceConstructor(this.source);
        this.appendMethods();
        this.appendStaticDeclaration();
        this.appendStaticFunction();
        this.source.append("}\n");
        this.compilation.addGenerator(this);
        if (this.home != null) {
            this.home.compile();
        }
    }

    private void appendClassHeader(ByteString source) {
        source.append("public class " + this.className + " extends " + this.getBaseClass().getName() + " implements " + this.interfaceClass.getName() + "{\n");
        source.append("static final long serialVersionUID = ApplicationServer.computeSerialVersionUID(\"" + this.className + "\");\n");
    }

    private Class getBaseClass() {
        Class clazz = this.local ? LocalStatefulSessionEJBObject.class : RemoteStatefulSessionEJBObject.class;
        return clazz;
    }

    private void appendExistingInstanceConstructor(ByteString source) {
        source.append("public " + this.className + "(AbstractEJBHome _myHome, StatefulSessionContext context, long id, long checksum, String user) {\n" + "super( _myHome, context, id, checksum, user);\n");
        source.append("}\n\n");
    }

    private void appendNewInstanceConstructor(ByteString source) {
        source.append("public " + this.className + "(AbstractEJBHome _myHome, StatefulSessionContext context) {\n" + "super( _myHome, context);\n");
        source.append("}\n\n");
    }

    public MethodCompilation compileMethod(Method method) throws CompilationException {
        return this.compileMethod(method, this.local);
    }

    public MethodCompilation compileMethod(Method method, boolean local) throws CompilationException {
        Class clazz = local ? EJBLocalObject.class : EJBObject.class;
        if (method.getDeclaringClass() == clazz) {
            return null;
        }
        InterceptorBeanMethodCompilation methodWrapper = new InterceptorBeanMethodCompilation(this, this.getDescriptor(), method, false, false, method.getName(), local);
        ((MethodCompilation)methodWrapper).compile();
        return methodWrapper;
    }
}

