/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.database;

import com.evermind.server.ejb.DataSourceConnection;
import com.evermind.server.ejb.DataSourceConnectionContainer;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.AbstractDescribable;
import com.evermind.xml.XMLUtils;
import com.evermind.xml.XMLizable;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.EntityContext;
import javax.mail.internet.InternetAddress;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatabaseSchema
extends AbstractDescribable
implements XMLizable {
    private static final String NOT_HANDLED_STRING = "[none]";
    private boolean caseSensitive = true;
    private boolean useBrackets;
    private static Properties types = new Properties();
    private static Properties definedTypes = new Properties();
    private static Logger m_logger = EJBTraceLogger.getLogger(DatabaseSchema.class);
    private String nullName = "null";
    private String notNullName = "not null";
    private String primaryKeyName = "primary key";
    private Set disallowedFields;
    private int maxTableNameLength = 30;

    protected static void initTypes() {
        types.put("java.lang.String", "varchar (255)");
        types.put("int", "integer");
        types.put("long", "integer");
        types.put("float", "float");
        types.put("double", "double precision");
        types.put("byte", "smallint");
        types.put("boolean", "bit");
        types.put("short", "integer");
        types.put("char", "char");
        types.put("java.util.Date", "datetime");
        types.put("java.util.Locale", "varchar (5)");
        types.put("java.sql.Date", "date");
        types.put("java.sql.Clob", "clob");
        types.put("java.sql.Blob", "blob");
        types.put("java.sql.Timestamp", "timestamp");
        types.put("java.sql.Time", "date");
        types.put("javax.mail.internet.InterenetAddress", "varchar (127)");
        types.put("java.math.BigInteger", "varchar (100)");
        types.put("java.math.BigDecimal", "decimal");
        types.put("java.io.Serializable", "longvarbinary");
        definedTypes.put("java.lang.String", "Types.VARCHAR");
        definedTypes.put("int", "Types.INTEGER");
        definedTypes.put("long", "Types.BIGINT");
        definedTypes.put("float", "Types.FLOAT");
        definedTypes.put("double", "Types.DOUBLE");
        definedTypes.put("byte", "Types.SMALLINT");
        definedTypes.put("boolean", "Types.TINYINT");
        definedTypes.put("short", "Types.SMALLINT");
        definedTypes.put("char", "Types.CHAR");
        definedTypes.put("java.util.Date", "Types.DATE");
        definedTypes.put("java.util.Locale", "Types.VARCHAR");
        definedTypes.put("java.sql.Date", "Types.DATE");
        definedTypes.put("java.sql.Clob", "Types.CLOB");
        definedTypes.put("java.sql.Blob", "Types.BLOB");
        definedTypes.put("java.sql.Time", "Types.DATE");
        definedTypes.put("java.sql.Timestamp", "Types.TIMESTAMP");
        definedTypes.put("javax.mail.internet.InterenetAddress", "Types.VARCHAR");
        definedTypes.put("java.math.BigInteger", "Types.VARCHAR");
        definedTypes.put("java.math.BigDecimal", "Types.DECIMAL");
        definedTypes.put("java.io.Serializable", "Types.BINARY ");
    }

    public DatabaseSchema(DataSourceConnectionContainer container, String name) throws RemoteException, SQLException {
        this.setName(name);
        this.initTypes();
        DataSourceConnection connection = null;
        ResultSet set = null;
        try {
            connection = container.getConnection();
            Connection sqlConnection = connection.getConnection();
            DatabaseMetaData data = sqlConnection.getMetaData();
            this.maxTableNameLength = data.getMaxTableNameLength();
            String keywords = data.getSQLKeywords();
            this.addDisallowedField("ASC".toLowerCase());
            this.addDisallowedField("AUDIT".toLowerCase());
            this.addDisallowedField("BETWEEN".toLowerCase());
            this.addDisallowedField("BY".toLowerCase());
            this.addDisallowedField("CHAR".toLowerCase());
            this.addDisallowedField("CHECK".toLowerCase());
            this.addDisallowedField("CLUSTER".toLowerCase());
            this.addDisallowedField("COLUMN".toLowerCase());
            this.addDisallowedField("COMMENT".toLowerCase());
            this.addDisallowedField("COMPRESS".toLowerCase());
            this.addDisallowedField("CONNECT".toLowerCase());
            this.addDisallowedField("CREATE".toLowerCase());
            this.addDisallowedField("CURRENT".toLowerCase());
            this.addDisallowedField("DATE".toLowerCase());
            this.addDisallowedField("DECIMAL".toLowerCase());
            this.addDisallowedField("DEFAULT".toLowerCase());
            this.addDisallowedField("DELETE".toLowerCase());
            this.addDisallowedField("DESC".toLowerCase());
            this.addDisallowedField("DISTINCT".toLowerCase());
            this.addDisallowedField("DROP".toLowerCase());
            this.addDisallowedField("ELSE".toLowerCase());
            this.addDisallowedField("EXCLUSIVE".toLowerCase());
            this.addDisallowedField("EXISTS".toLowerCase());
            this.addDisallowedField("FILE".toLowerCase());
            this.addDisallowedField("FLOAT".toLowerCase());
            this.addDisallowedField("FOR".toLowerCase());
            this.addDisallowedField("FROM".toLowerCase());
            this.addDisallowedField("GRANT".toLowerCase());
            this.addDisallowedField("GROUP".toLowerCase());
            this.addDisallowedField("HAVING".toLowerCase());
            this.addDisallowedField("IDENTIFIED".toLowerCase());
            this.addDisallowedField("IMMEDIATE".toLowerCase());
            this.addDisallowedField("IN".toLowerCase());
            this.addDisallowedField("INCREMENT".toLowerCase());
            this.addDisallowedField("INDEX".toLowerCase());
            this.addDisallowedField("INITIAL".toLowerCase());
            this.addDisallowedField("INSERT".toLowerCase());
            this.addDisallowedField("INTEGER".toLowerCase());
            this.addDisallowedField("INTERSECT".toLowerCase());
            this.addDisallowedField("INTO".toLowerCase());
            this.addDisallowedField("IS".toLowerCase());
            this.addDisallowedField("LEVEL".toLowerCase());
            this.addDisallowedField("LIKE".toLowerCase());
            this.addDisallowedField("LOCK".toLowerCase());
            this.addDisallowedField("LONG".toLowerCase());
            this.addDisallowedField("MAXEXTENTS".toLowerCase());
            this.addDisallowedField("MINUS".toLowerCase());
            this.addDisallowedField("MLSLABEL".toLowerCase());
            this.addDisallowedField("MODE".toLowerCase());
            this.addDisallowedField("MODIFY".toLowerCase());
            this.addDisallowedField("NOAUDIT".toLowerCase());
            this.addDisallowedField("NOCOMPRESS".toLowerCase());
            this.addDisallowedField("NOT".toLowerCase());
            this.addDisallowedField("NOWAIT".toLowerCase());
            this.addDisallowedField("NULL".toLowerCase());
            this.addDisallowedField("NUMBER".toLowerCase());
            this.addDisallowedField("OF".toLowerCase());
            this.addDisallowedField("OFFLINE".toLowerCase());
            this.addDisallowedField("ON".toLowerCase());
            this.addDisallowedField("ONLINE".toLowerCase());
            this.addDisallowedField("OPTION".toLowerCase());
            this.addDisallowedField("OR".toLowerCase());
            this.addDisallowedField("ORDER".toLowerCase());
            this.addDisallowedField("PCTFREE".toLowerCase());
            this.addDisallowedField("PRIOR".toLowerCase());
            this.addDisallowedField("PRIVILEGES".toLowerCase());
            this.addDisallowedField("PUBLIC".toLowerCase());
            this.addDisallowedField("RAW".toLowerCase());
            this.addDisallowedField("RENAME".toLowerCase());
            this.addDisallowedField("RESOURCE".toLowerCase());
            this.addDisallowedField("REVOKE".toLowerCase());
            this.addDisallowedField("ROW".toLowerCase());
            this.addDisallowedField("ROWID".toLowerCase());
            this.addDisallowedField("ROWNUM".toLowerCase());
            this.addDisallowedField("ROWS".toLowerCase());
            this.addDisallowedField("SELECT".toLowerCase());
            this.addDisallowedField("SESSION".toLowerCase());
            this.addDisallowedField("SET".toLowerCase());
            this.addDisallowedField("SHARE".toLowerCase());
            this.addDisallowedField("SIZE".toLowerCase());
            this.addDisallowedField("SMALLINT".toLowerCase());
            this.addDisallowedField("START".toLowerCase());
            this.addDisallowedField("SUCCESSFUL".toLowerCase());
            this.addDisallowedField("SYNONYM".toLowerCase());
            this.addDisallowedField("SYSDATE".toLowerCase());
            this.addDisallowedField("TABLE".toLowerCase());
            this.addDisallowedField("THEN".toLowerCase());
            this.addDisallowedField("TO".toLowerCase());
            this.addDisallowedField("TRIGGER".toLowerCase());
            this.addDisallowedField("UID".toLowerCase());
            this.addDisallowedField("UNION".toLowerCase());
            this.addDisallowedField("UNIQUE".toLowerCase());
            this.addDisallowedField("UPDATE".toLowerCase());
            this.addDisallowedField("USER".toLowerCase());
            this.addDisallowedField("VALIDATE".toLowerCase());
            this.addDisallowedField("VALUES".toLowerCase());
            this.addDisallowedField("VARCHAR".toLowerCase());
            this.addDisallowedField("VARCHAR2".toLowerCase());
            this.addDisallowedField("VIEW".toLowerCase());
            this.addDisallowedField("WHENEVER".toLowerCase());
            this.addDisallowedField("WHERE".toLowerCase());
            this.addDisallowedField("WITH".toLowerCase());
            if (keywords != null) {
                StringTokenizer tokenizer = new StringTokenizer(keywords, " ,.:\n\r\t");
                while (tokenizer.hasMoreElements()) {
                    this.addDisallowedField(tokenizer.nextToken().toLowerCase());
                }
            }
            set = data.getTypeInfo();
            while (set.next()) {
                short type = set.getShort("DATA_TYPE");
                String typeName = set.getString("TYPE_NAME");
                switch (type) {
                    case -7: {
                        types.put("boolean", typeName);
                        break;
                    }
                    case 8: {
                        types.put("double", typeName);
                        break;
                    }
                    case 1: {
                        types.put("char", typeName);
                        break;
                    }
                    case 6: {
                        types.put("float", typeName);
                        break;
                    }
                    case -5: {
                        types.put("int", typeName);
                        types.put("long", typeName);
                        break;
                    }
                    case -4: {
                        types.put("java.io.Serializable", typeName);
                        break;
                    }
                    case 4: {
                        types.put("short", typeName);
                        break;
                    }
                    case 2000: {
                        types.put("java.io.Serializable", typeName);
                        break;
                    }
                    case 5: {
                        types.put("byte", typeName);
                        break;
                    }
                    case 93: {
                        types.put("java.util.Date", typeName);
                        types.put("java.sql.Date", typeName);
                        types.put("java.sql.Timestamp", typeName);
                        break;
                    }
                    case 12: {
                        types.put("java.lang.String", typeName + "(255)");
                        types.put("java.util.Locale", typeName + "(5)");
                        types.put("java.math.BigInteger", typeName + "(100)");
                        types.put("javax.mail.internet.InterenetAddress", typeName + "(127)");
                        break;
                    }
                    case 2004: {
                        types.put("java.sql.Blob", typeName);
                        break;
                    }
                    case 2005: {
                        types.put("java.sql.Clob", typeName);
                        break;
                    }
                    case 3: {
                        types.put("java.math.BigDecimal", typeName);
                    }
                }
            }
            if (set != null) {
                set.close();
            }
            if (sqlConnection != null) {
                sqlConnection.commit();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            if (connection != null) {
                connection.close(false);
            }
        }
    }

    public DatabaseSchema(String name) {
        this.setName(name);
        this.initTypes();
    }

    public DatabaseSchema(Node parent, String schemaName) throws InstantiationException {
        String primaryKeyName;
        String nullName;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.log(Level.FINE, "Schema: " + schemaName + " is used");
        }
        this.initTypes();
        this.setName(schemaName);
        NodeList list = parent.getChildNodes();
        String notNullName = XMLUtils.getNodeAttribute(parent, "not-null");
        String maxTableNameLengthString = XMLUtils.getNodeAttribute(parent, "max-table-name-length");
        this.useBrackets = "true".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "use-brackets"));
        boolean bl = this.caseSensitive = !"false".equalsIgnoreCase(XMLUtils.getNodeAttribute(parent, "case-sensitive"));
        if (maxTableNameLengthString != null) {
            try {
                this.maxTableNameLength = Integer.parseInt(maxTableNameLengthString);
            }
            catch (NumberFormatException e) {
                throw new InstantiationException("max-table-name-length must have a numerical value");
            }
        }
        if (notNullName != null) {
            this.notNullName = notNullName;
        }
        if ((nullName = XMLUtils.getNodeAttribute(parent, "null")) != null) {
            this.nullName = nullName;
        }
        if ((primaryKeyName = XMLUtils.getNodeAttribute(parent, "primary-key")) != null) {
            this.primaryKeyName = primaryKeyName;
        }
        if ((schemaName = XMLUtils.getNodeAttribute(parent, "name")) != null) {
            this.setName(schemaName);
        }
        if (list != null) {
            for (int i = 0; i < list.getLength(); ++i) {
                Node node = list.item(i);
                String name = node.getNodeName();
                if (name.equals("type-mapping")) {
                    String type = XMLUtils.getNodeAttribute(node, "type");
                    if (type == null) {
                        throw new InstantiationException("<type-mapping> with missing 'type' attribute");
                    }
                    this.setDatabaseType(type, XMLUtils.getNodeAttribute(node, "name"));
                    continue;
                }
                if (name.equals("disallowed-field")) {
                    String fieldName = XMLUtils.getNodeAttribute(node, "name");
                    if (fieldName == null) continue;
                    this.addDisallowedField(this.caseSensitive ? fieldName : fieldName.toLowerCase());
                    continue;
                }
                if (!name.equals("description")) continue;
                this.setDescription(XMLUtils.getStringValue(node));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDatabaseType(String fieldType, String databaseType) {
        if (databaseType != null && !databaseType.equals("")) {
            if (!databaseType.equalsIgnoreCase(NOT_HANDLED_STRING)) {
                types.put(fieldType, databaseType);
                return;
            }
        }
        types.put(fieldType, NOT_HANDLED_STRING);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void setDatabaseDefinedType(String fieldType, String databaseType) {
        if (databaseType != null && !databaseType.equals("")) {
            if (!databaseType.equalsIgnoreCase(NOT_HANDLED_STRING)) {
                definedTypes.put(fieldType, databaseType);
                return;
            }
        }
        definedTypes.put(fieldType, NOT_HANDLED_STRING);
    }

    public static String getDatabaseType(String fieldType) throws InstantiationException {
        String type = types.getProperty(fieldType);
        if (type == NOT_HANDLED_STRING) {
            throw new InstantiationException("The database does not handle persisting values of type " + fieldType);
        }
        return type;
    }

    public static String getDatabaseDefinedType(String fieldType) throws InstantiationException {
        String type = definedTypes.getProperty(fieldType);
        if (type == NOT_HANDLED_STRING) {
            throw new InstantiationException("The database does not handle persisting values of type " + fieldType);
        }
        return type;
    }

    public static String getDatabaseType(Class fieldType) throws InstantiationException {
        if (fieldType == EntityContext.class) {
            return null;
        }
        if (fieldType == String.class || fieldType == [C.class) {
            return DatabaseSchema.getDatabaseType("java.lang.String");
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return DatabaseSchema.getDatabaseType("int");
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return DatabaseSchema.getDatabaseType("long");
        }
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return DatabaseSchema.getDatabaseType("float");
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return DatabaseSchema.getDatabaseType("double");
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return DatabaseSchema.getDatabaseType("byte");
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return DatabaseSchema.getDatabaseType("boolean");
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return DatabaseSchema.getDatabaseType("short");
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return DatabaseSchema.getDatabaseType("char");
        }
        if (fieldType == java.util.Date.class) {
            return DatabaseSchema.getDatabaseType("java.util.Date");
        }
        if (fieldType == InternetAddress.class) {
            return DatabaseSchema.getDatabaseType("javax.mail.internet.InternetAddress");
        }
        if (fieldType == Date.class) {
            return DatabaseSchema.getDatabaseType("java.sql.Date");
        }
        if (fieldType == Timestamp.class) {
            return DatabaseSchema.getDatabaseType("java.sql.Timestamp");
        }
        if (fieldType == Time.class) {
            return DatabaseSchema.getDatabaseType("java.sql.Time");
        }
        if (fieldType == Locale.class) {
            return DatabaseSchema.getDatabaseType("java.util.Locale");
        }
        if (fieldType == BigInteger.class) {
            return DatabaseSchema.getDatabaseType("java.math.BigInteger");
        }
        if (fieldType == BigDecimal.class) {
            return DatabaseSchema.getDatabaseType("java.math.BigDecimal");
        }
        if (fieldType == Blob.class) {
            return DatabaseSchema.getDatabaseType("java.sql.Blob");
        }
        if (fieldType == Clob.class) {
            return DatabaseSchema.getDatabaseType("java.sql.Clob");
        }
        return DatabaseSchema.getDatabaseType("java.io.Serializable");
    }

    public static String getDatabaseDefinedType(Class fieldType) throws InstantiationException {
        if (fieldType == EntityContext.class) {
            return null;
        }
        if (fieldType == String.class || fieldType == [C.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.lang.String");
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return DatabaseSchema.getDatabaseDefinedType("int");
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return DatabaseSchema.getDatabaseDefinedType("long");
        }
        if (fieldType == Float.TYPE || fieldType == Float.class) {
            return DatabaseSchema.getDatabaseDefinedType("float");
        }
        if (fieldType == Double.TYPE || fieldType == Double.class) {
            return DatabaseSchema.getDatabaseDefinedType("double");
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return DatabaseSchema.getDatabaseDefinedType("byte");
        }
        if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
            return DatabaseSchema.getDatabaseDefinedType("boolean");
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return DatabaseSchema.getDatabaseDefinedType("short");
        }
        if (fieldType == Character.TYPE || fieldType == Character.class) {
            return DatabaseSchema.getDatabaseDefinedType("char");
        }
        if (fieldType == java.util.Date.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.util.Date");
        }
        if (fieldType == InternetAddress.class) {
            return DatabaseSchema.getDatabaseDefinedType("javax.mail.internet.InternetAddress");
        }
        if (fieldType == Date.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.sql.Date");
        }
        if (fieldType == Timestamp.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.sql.Timestamp");
        }
        if (fieldType == Time.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.sql.Time");
        }
        if (fieldType == Locale.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.util.Locale");
        }
        if (fieldType == BigInteger.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.math.BigInteger");
        }
        if (fieldType == BigDecimal.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.math.BigDecimal");
        }
        if (fieldType == Blob.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.sql.Blob");
        }
        if (fieldType == Clob.class) {
            return DatabaseSchema.getDatabaseDefinedType("java.sql.Clob");
        }
        return DatabaseSchema.getDatabaseDefinedType("java.io.Serializable");
    }

    public String getNull() {
        return this.nullName;
    }

    public String getNotNull() {
        return this.notNullName;
    }

    public String getPrimaryKey() {
        return this.primaryKeyName;
    }

    public void writeConfig(PrintWriter out) {
        out.println("<?xml version=\"1.0\"?>");
        out.println("<!DOCTYPE database-schema PUBLIC \"-//Evermind//DTD Database schema//EN\" \"http://xmlns.oracle.com/ias/dtds/database-schema.dtd\">");
        out.println();
        this.writeXML(out, "");
    }

    public void addDisallowedField(String name) {
        if (name == null) {
            throw new NullPointerException("name was null");
        }
        if (this.disallowedFields == null) {
            this.disallowedFields = new HashSet();
        }
        this.disallowedFields.add(this.caseSensitive ? name : name.toLowerCase());
    }

    public boolean isValid(String name) {
        if (this.disallowedFields == null || name == null) {
            return true;
        }
        return !this.disallowedFields.contains(this.caseSensitive ? name : name.toLowerCase());
    }

    public void writeXML(PrintWriter out, String indention) {
        out.print(indention + "<database-schema");
        if (this.getName() != null) {
            out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        }
        if (this.primaryKeyName != null) {
            out.print(" primary-key=\"" + XMLUtils.encode(this.primaryKeyName) + "\"");
        }
        if (this.nullName != null) {
            out.print(" null=\"" + XMLUtils.encode(this.nullName) + "\"");
        }
        if (this.notNullName != null) {
            out.print(" not-null=\"" + XMLUtils.encode(this.notNullName) + "\"");
        }
        if (this.maxTableNameLength > 0) {
            out.print(" max-table-name-length=\"" + this.maxTableNameLength + "\"");
        }
        out.print(" use-brackets=\"" + this.useBrackets + "\"");
        if (!this.caseSensitive) {
            out.print(" case-sensitive=\"false\"");
        }
        out.println(">");
        if (this.getDescription() != null) {
            out.print(indention + "<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        XMLUtils.writeCompressedMap(types, "type-mapping", out, "type", "name", indention + "\t");
        if (this.disallowedFields != null) {
            Iterator iterator = this.disallowedFields.iterator();
            while (iterator.hasNext()) {
                out.println(indention + "\t<disallowed-field name=\"" + XMLUtils.encode(iterator.next().toString()) + " />");
            }
        }
        out.print(indention + "</database-schema>");
    }

    public int getMaxTableNameLength() {
        return this.maxTableNameLength;
    }

    public boolean getUseBrackets() {
        return this.useBrackets;
    }

    public String toString() {
        return "Database schema: " + this.getName();
    }

    static {
        DatabaseSchema.initTypes();
    }
}

