/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.compiler.CompilableStringAdapter;
import com.evermind.io.IOUtils;
import com.evermind.io.LastModifiedContainer;
import com.evermind.naming.ContextUtils;
import com.evermind.naming.file.FileContext;
import com.evermind.security.UserManager;
import com.evermind.server.Application;
import com.evermind.server.ApplicationContext;
import com.evermind.server.ServerComponent;
import com.evermind.server.ThreadState;
import com.evermind.server.deployment.EnterpriseArchive;
import com.evermind.server.deployment.MessageDestination;
import com.evermind.server.deployment.SecurityRole;
import com.evermind.server.deployment.SecurityRoleContainer;
import com.evermind.server.deployment.SecurityRoleReference;
import com.evermind.server.deployment.WebModule;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.EJBPackageDeployment;
import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.compilation.Compilation;
import com.evermind.server.ejb.deployment.ApplicationException;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.ContainerManagedRelation;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBRelationship;
import com.evermind.server.ejb.deployment.EJBRelationshipRole;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExcludeList;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.InterceptorBinding;
import com.evermind.server.ejb.deployment.InterceptorDescriptor;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MessageDrivenBeanDescriptor;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.MethodPermission;
import com.evermind.server.ejb.deployment.PersistenceManagerDescriptor;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.deployment.SessionBeanDescriptor;
import com.evermind.server.ejb.exception.DeploymentException;
import com.evermind.server.ejb.exception.ValidationExceptions;
import com.evermind.server.ejb.logging.DiagnosticContext;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.server.ejb.logging.EJBTraceLogger;
import com.evermind.util.ByteString;
import com.evermind.util.ConfigUtils;
import com.evermind.util.EJBProperties;
import com.evermind.xml.XMLUtils;
import com.oracle.server.ejb.container.DeploymentInfo;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import com.oracle.server.ejb.container.deployment.RelationshipDescriptorImpl;
import com.oracle.server.ejb.container.deployment.RelationshipRoleDescriptorImpl;
import com.oracle.server.ejb.persistence.deployment.RelationshipRoleDescriptor;
import com.oracle.server.ejb.persistence.pm.PersistenceManager;
import com.sun.ejb.sqlgen.OracleGenericDBInfo;
import com.sun.ejb.sqlgen.SQLGenerator;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptorFactory;
import com.sun.enterprise.deployment.EjbDescriptor;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.jms.Destination;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.security.jacc.PolicyContextException;
import oracle.classloader.PolicyClassLoader;
import oracle.j2ee.ws.server.WebServicesDescriptorFactory;
import oracle.oc4j.security.SecurityUtil;
import oracle.oc4j.security.acc.JaccWrapper;
import oracle.security.jazn.JAZNConfig;
import oracle.security.jazn.oc4j.JAZNUserManager;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EJBPackage
extends ServerComponent
implements EntityResolver,
SecurityRoleContainer,
DiagnosticContext {
    public static final int UNDEPLOY = 0;
    public static final int PREINIT = 1;
    public static final int GENERATE_CODE = 2;
    public static final int POSTINIT = 3;
    public static final int SLSB = 99;
    public static final int SFSB = 98;
    public static final int BMP = 97;
    public static final int CMP20 = 96;
    public static final int MDB = 95;
    public static final int CMP = 94;
    public static final int NONE = -1;
    public static final int EJB_1_1 = 0;
    public static final int EJB_2_0 = 1;
    public static final int EJB_2_1 = 2;
    public static final int EJB_3_0 = 3;
    private EJBPackageDeployment deployment;
    protected EJBContainer container;
    protected SecurityRole defaultSecurityRole;
    protected EnterpriseArchive application;
    protected String smallIcon;
    protected String largeIcon;
    protected List beans = new ArrayList();
    protected List allBeans = null;
    protected PersistenceManagerDescriptor persistenceManagerDescriptor;
    protected List messageDestinations;
    protected List securityRoles;
    protected List ejbClientJars;
    private List containerTransactions;
    private List methodPermissions;
    private boolean remote;
    protected boolean ejb2_0;
    protected String relationshipsDescription;
    protected List ejbRelations;
    protected Map relationshipDescriptors;
    protected ExcludeList excludeList;
    protected Object _wsDeplData = null;
    private boolean haveEJBQueriesFlagInitialized = false;
    private boolean haveEJBQueriesFlag = false;
    private EjbBundleDescriptor ejbBundleDescriptor;
    private Boolean isPMDescriptorInJar;
    private int compatibility;
    private boolean isEjbJarFull = false;
    private Node assemblyDescriptorMainNode;
    private int jaasMode = JAZNConfig.JAAS_MODE_NULL;
    private Map interceptorDescriptors = new HashMap();
    private Map interceptorBindings = new HashMap();
    private Map applicationExceptions = new HashMap();
    private boolean disableDefaultPersistentUnit = false;
    List ppms = new ArrayList();
    private static Logger m_logger = EJBTraceLogger.getLogger(EJBPackage.class);

    public EJBPackage(EJBContainer container, Context context, Context deploymentContext, EJBPackageDeployment deployment, boolean remote) {
        if (container != null) {
            this.container = container;
            this.application = (EnterpriseArchive)container.getConfig();
        }
        if (this.getApplication() != null && this.getApplication().getCompatibility() >= 1) {
            this.setCompatibility(3);
        } else {
            this.setCompatibility(1);
        }
        this.setContext(context);
        if (deploymentContext != null) {
            this.setDeploymentContext(deploymentContext);
        }
        this.deployment = deployment;
        this.remote = remote;
        if (deployment != null && deployment.getModule() != null && deployment.getModule().getAltDD() != null) {
            String relativeAltDD;
            String absoluteAltDD = relativeAltDD = deployment.getModule().getAltDD();
            if (container != null && container.getApplication() != null && container.getApplication().getConfig() != null) {
                URL url = container.getApplication().getConfig().getURL();
                absoluteAltDD = ConfigUtils.getAbsolutePath(url, relativeAltDD);
            }
            this.setAltDD(absoluteAltDD);
        }
        this.defaultSecurityRole = new SecurityRole("<default-ejb-caller-role>");
        this.defaultSecurityRole.setImpliesAll(true);
        this.securityRoles = null;
    }

    public ClassLoader getEJBClassLoader() {
        return this.deployment.getEJBClassLoader();
    }

    public boolean isRemote() {
        return this.remote;
    }

    public EJBPackageDeployment getDeployment() {
        return this.deployment;
    }

    public long getTimeOfLastDeployment() {
        return this.deploymentTime;
    }

    public String isDeployed() throws InstantiationException {
        if (super.isDeployed() != null) {
            return super.isDeployed();
        }
        if (this.getPersistenceManagerDescriptor() != null) {
            String pmDescriptor = this.getPersistenceManagerDescriptor().getDescriptorName();
            String deployedPMDescriptor = this.getDefaultDeploymentSubname() + File.separator + pmDescriptor;
            if (ContextUtils.getFileLastModified(this.getContext(), deployedPMDescriptor) > ContextUtils.getFileLastModified(this.getDeploymentContext(), pmDescriptor)) {
                return pmDescriptor + " has been touched since the previous deployment";
            }
        }
        Iterator iterator = this.getAllBeans().iterator();
        while (iterator.hasNext()) {
            BeanDescriptor bean = (BeanDescriptor)iterator.next();
            String reason = bean.isDeployed();
            if (reason == null) continue;
            return reason;
        }
        return null;
    }

    public EJBContainer getContainer() {
        return this.container;
    }

    public synchronized void getBeansByInterface(Collection result, String homeName, String interfaceName, String type, String link, Boolean local) {
        Iterator beans = this.getAllBeans() == null ? this.getBeans().iterator() : this.getAllBeans().iterator();
        while (beans.hasNext()) {
            Set interfaces;
            BeanDescriptor bean = (BeanDescriptor)beans.next();
            if (!bean.isSession() && !bean.isEntity()) continue;
            ExposableBeanDescriptor exposable = (ExposableBeanDescriptor)bean;
            String linkName = null;
            if (link != null) {
                String string = linkName = link.indexOf("#") == -1 ? link : link.substring(link.indexOf("#") + 1);
            }
            if (link != null && !linkName.equals(exposable.getName()) && this.getName().equals(exposable.getEJBPackage().getName()) || (local != null ? (local == false ? exposable.getRemoteHomeName() == null : exposable.getLocalHomeName() == null) || homeName != null && !(local != false ? exposable.getLocalHomeName() : exposable.getRemoteHomeName()).equals(homeName) : homeName != null && !homeName.equals(exposable.getLocalHomeName()) && !homeName.equals(exposable.getRemoteHomeName()))) continue;
            ThreadState state = ThreadState.getCurrentState();
            if (state.getCurrentInvocation() == null || !exposable.isServiceEndpoint() ? interfaceName != null && (local != null ? !(interfaces = local != false ? exposable.getLocalInterfaceNames() : exposable.getRemoteInterfaceNames()).contains(interfaceName) : !exposable.getLocalInterfaceNames().contains(interfaceName) && !exposable.getRemoteInterfaceNames().contains(interfaceName)) : interfaceName != null && !exposable.getServiceEndpointName().equals(interfaceName)) continue;
            if (type != null && (bean.isEntity() && !type.equalsIgnoreCase("Entity") || bean.isSession() && !type.equalsIgnoreCase("Session"))) continue;
            result.add(bean);
        }
    }

    public synchronized BeanDescriptor getBeanByLocation(String location) {
        Iterator beans = this.getAllBeans().iterator();
        while (beans.hasNext()) {
            BeanDescriptor bean = (BeanDescriptor)beans.next();
            if (!(bean instanceof ExposableBeanDescriptor) || !((ExposableBeanDescriptor)bean).getLocation().equals(location)) continue;
            return bean;
        }
        return null;
    }

    public String toString() {
        if (this.getContext() != null) {
            return this.getContext().toString();
        }
        return "EJB-package";
    }

    public List getBeans() {
        return this.beans;
    }

    public List getAllBeans() {
        return this.allBeans;
    }

    public void setApplication(EnterpriseArchive application) {
        this.application = application;
        this.defaultSecurityRole.setImpliesAll(true);
    }

    public EnterpriseArchive getApplication() {
        return this.application;
    }

    protected void parseRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("version")) {
            if (value.equals("2.1")) {
                this.setCompatibility(2);
            } else if (value.equals("3.0")) {
                this.setCompatibility(3);
            }
        } else if (name.equals("metadata-complete") && value.equals("true")) {
            this.setIsEjbJarFull(true);
        }
    }

    protected void parseRootNode(Node node, boolean deployment) throws InstantiationException {
        if (deployment) {
            super.parseRootNode(node, deployment);
            return;
        }
        NamedNodeMap map = node.getAttributes();
        if (map != null) {
            int length = map.getLength();
            for (int i = 0; i < length; ++i) {
                Node item = map.item(i);
                String name = item.getNodeName();
                String value = item.getNodeValue();
                this.parseRootNodeValue(name, value);
            }
        }
        if (this.assemblyDescriptorMainNode != null) {
            throw new InstantiationException("Invalid ejb-jar.xml file: multiple root elements");
        }
        this.assemblyDescriptorMainNode = node;
    }

    public boolean hasAssemblyDescriptor() {
        return this.assemblyDescriptorMainNode != null;
    }

    public void parseEJBModule() throws InstantiationException {
        int i;
        if (this.assemblyDescriptorMainNode == null) {
            return;
        }
        NodeList nodes = this.assemblyDescriptorMainNode.getChildNodes();
        for (i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().startsWith("#")) continue;
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) {
                return;
            }
            if (name.equals("display-name")) {
                this.setDisplayName(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("description")) {
                this.setDescription(XMLUtils.getStringValue(node));
                continue;
            }
            if (name.equals("small-icon")) {
                this.smallIcon = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("large-icon")) {
                this.largeIcon = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("enterprise-beans")) {
                this.parseEnterpriseBeans(node);
                continue;
            }
            if (this.getCompatibility() >= 3 && name.equals("interceptors")) {
                this.parseInterceptors(node);
                continue;
            }
            if (name.equals("assembly-descriptor")) {
                this.parseAssemblyDescriptor(node);
                continue;
            }
            if (name.equals("ejb-client-jar")) {
                this.addEJBClientJarPath(XMLUtils.getStringValue(node));
                continue;
            }
            if (!name.equals("relationships")) continue;
            this.parseRelationships(node);
        }
        if (this.ejbRelations != null) {
            for (i = 0; i < this.ejbRelations.size(); ++i) {
                EJBRelationship relationship = (EJBRelationship)this.ejbRelations.get(i);
                this.processRelationshipRole(relationship.getFirstRole());
                this.processRelationshipRole(relationship.getSecondRole());
            }
        }
        this.assemblyDescriptorMainNode = null;
    }

    public void addEJBClientJarPath(String path) {
        if (this.ejbClientJars == null) {
            this.ejbClientJars = new ArrayList();
        }
        this.ejbClientJars.remove(path);
        this.ejbClientJars.add(path);
        this.firePropertyChangeEvent("clientJars", null, path);
    }

    public void removeEJBClientJarPath(String path) {
        if (this.ejbClientJars == null) {
            return;
        }
        this.ejbClientJars.remove(path);
        this.firePropertyChangeEvent("clientJars", path, null);
    }

    public void parseDeploymentMainNode(Node node) throws InstantiationException {
        String name;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "parseDeploymentMainNode", new Object[]{node.getNodeName()});
        }
        if ((name = node.getNodeName()).equals("enterprise-beans")) {
            this.parseOrionEnterpriseBeans(node);
        } else if (name.equals("assembly-descriptor")) {
            this.parseOrionAssemblyDescriptor(node);
        } else {
            super.parseDeploymentMainNode(node);
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "parseDeploymentMainNode", new Object[]{node.getNodeName()});
        }
    }

    public void addBean(BeanDescriptor bean) {
        this.beans.add(bean);
        this.firePropertyChangeEvent("beans", null, bean);
    }

    public void removeBean(BeanDescriptor bean) {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "removeBean", new Object[]{bean.getName()});
        }
        if (this.beans != null) {
            this.beans.remove(bean);
        }
        if (this.allBeans != null) {
            this.allBeans.remove(bean);
        }
        this.firePropertyChangeEvent("beans", bean, null);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "removeBean", new Object[]{bean.getName()});
        }
    }

    public void parseEnterpriseBeans(Node parent) throws InstantiationException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "parseEnterpriseBeans", new Object[]{parent.getNodeName()});
        }
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            String beanName = XMLUtils.getSubnodeValue(node, "ejb-name");
            BeanDescriptor desc = this.getBean(beanName);
            if (desc == null) {
                if (name.equals("session")) {
                    desc = new SessionBeanDescriptor(this, beanName);
                    this.addBean(desc);
                } else if (name.equals("entity")) {
                    desc = new EntityBeanDescriptor(this, beanName);
                    this.addBean(desc);
                } else if (name.equals("message-driven")) {
                    desc = new MessageDrivenBeanDescriptor(this, beanName);
                    this.addBean(desc);
                } else {
                    throw new InvalidEJBAssemblyException("Unknown enterprise-beans subtag: " + name, "22.5");
                }
                String ejbClassName = XMLUtils.getSubnodeValue(node, "ejb-class");
                if (ejbClassName == null) {
                    throw ValidationExceptions.missingEJBClass(desc);
                }
            }
            desc.parseEJBJarXML(node);
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "parseEnterpriseBeans", new Object[]{parent.getNodeName()});
        }
    }

    private void validateBeanTypeOverridden(BeanDescriptor desc, String beanType) throws InstantiationException {
        EJBDeploymentMessages.warningBeanTypeMismatch(desc, "orion-ejb-jar.xml", beanType);
    }

    public void parseInterceptors(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("interceptor")) {
                this.addInterceptorDescriptor(new InterceptorDescriptor().parseEJBJarXML(this, node));
                continue;
            }
            throw DeploymentException.unknownXmlSubtag(this, "interceptors", name, "interceptor");
        }
    }

    public void addInterceptorDescriptor(InterceptorDescriptor desc) {
        if (this.getInterceptorDescriptors().containsKey(desc.getInterceptorClassName())) {
            throw DeploymentException.duplicateInterceptorDefinition(this, desc.getInterceptorClassName());
        }
        this.getInterceptorDescriptors().put(desc.getInterceptorClassName(), desc);
    }

    public void parseInterceptorBinding(Node node) throws InstantiationException {
        InterceptorBinding binding = new InterceptorBinding().parseEJBJarXML(this, node);
        PolicyClassLoader tempLoader = this.getContainer().getTempMetadataParsingLoader();
        Iterator clsNameIter = binding.getInterceptorClassNames().iterator();
        while (clsNameIter.hasNext()) {
            String interceptorClsName = (String)clsNameIter.next();
            if (this.getInterceptorDescriptors().containsKey(interceptorClsName)) continue;
            this.addInterceptorDescriptor(EJBUtils.buildInterceptorClassDescriptor(interceptorClsName, (ClassLoader)tempLoader));
        }
        this.addInterceptorBinding(binding);
    }

    public void addInterceptorBinding(InterceptorBinding binding) {
        ArrayList<InterceptorBinding> ejbInterceptorBindings = (ArrayList<InterceptorBinding>)this.getInterceptorBindings().get(binding.getEjbName());
        if (ejbInterceptorBindings == null) {
            ejbInterceptorBindings = new ArrayList<InterceptorBinding>();
            this.getInterceptorBindings().put(binding.getEjbName(), ejbInterceptorBindings);
        } else if (binding.isDefault()) {
            throw DeploymentException.multipleDefaultInterceptorBindings(this);
        }
        ejbInterceptorBindings.add(binding);
    }

    public void parseApplicationException(Node node) throws InstantiationException {
        this.addApplicationException(new ApplicationException().parseEJBJarXML(this, node));
    }

    public void addApplicationException(ApplicationException ae) {
        this.applicationExceptions.put(ae.getClassName(), ae);
    }

    public ApplicationException getApplicationException(Throwable t) {
        return (ApplicationException)this.applicationExceptions.get(t.getClass().getName());
    }

    public void parseRelationships(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("description")) {
                this.relationshipsDescription = XMLUtils.getStringValue(node);
                continue;
            }
            if (name.equals("ejb-relation")) {
                this.addEJBRelation(new EJBRelationship(node));
                continue;
            }
            throw new InstantiationException("Unknown relationships subtag: " + name);
        }
    }

    public void parseAssemblyDescriptor(Node parent) throws InstantiationException {
        int i;
        NodeList nodes = parent.getChildNodes();
        ArrayList<MethodPermission> xmlMethodPermissions = new ArrayList<MethodPermission>();
        for (i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("security-role")) {
                this.addSecurityRole(new SecurityRole(node));
                continue;
            }
            if (name.equals("method-permission")) {
                xmlMethodPermissions.add(new MethodPermission(this, node));
                continue;
            }
            if (name.equals("message-destination")) {
                this.addMessageDestination(new MessageDestination(node));
                continue;
            }
            if (name.equals("container-transaction")) {
                this.addContainerTransaction(new ContainerTransaction(this, node));
                continue;
            }
            if (name.equals("exclude-list")) {
                if (this.getExcludeList() == null) {
                    this.setExcludeList(new ExcludeList(this, node));
                    continue;
                }
                this.getExcludeList().parseExcludeListNode(node);
                continue;
            }
            if (this.getCompatibility() >= 3 && name.equals("interceptor-binding")) {
                this.parseInterceptorBinding(node);
                continue;
            }
            if (this.getCompatibility() >= 3 && name.equals("application-exception")) {
                this.parseApplicationException(node);
                continue;
            }
            throw new InvalidEJBAssemblyException("Unknown assembly-descriptor subtag: " + name, "22.5");
        }
        if (!xmlMethodPermissions.isEmpty()) {
            if (this.methodPermissions != null) {
                for (i = 0; i < xmlMethodPermissions.size(); ++i) {
                    this.checkOrRemoveMethodPermission((MethodPermission)xmlMethodPermissions.get(i));
                }
            }
            for (i = 0; i < xmlMethodPermissions.size(); ++i) {
                this.addMethodPermission((MethodPermission)xmlMethodPermissions.get(i));
            }
        }
    }

    private void checkOrRemoveMethodPermission(MethodPermission xmlPermi) throws InstantiationException {
        for (int i = 0; i < this.methodPermissions.size(); ++i) {
            MethodPermission permi = (MethodPermission)this.methodPermissions.get(i);
            if (((Object)xmlPermi.getRoleNames()).equals(permi.getRoleNames()) && xmlPermi.getMethods().equals(permi.getMethods())) break;
            MethodDescriptor[] descs = permi.getMethods();
            MethodDescriptor[] xmlDescs = xmlPermi.getMethods();
            for (int j = 0; j < xmlDescs.length; ++j) {
                for (int k = 0; k < descs.length; ++k) {
                    if (!this.hasAnnotatedMethodPermission(descs[k], xmlDescs[j]) || ((Object)xmlPermi.getRoleNames()).equals(permi.getRoleNames())) continue;
                    permi.removeMethod(descs[k]);
                    this.checkOrRemoveExcludeList(descs[j]);
                }
            }
        }
    }

    private boolean hasAnnotatedMethodPermission(MethodDescriptor annotDesc, MethodDescriptor xmlDesc) {
        return annotDesc.implies(xmlDesc) > 0 && !annotDesc.getName().equals("*");
    }

    private void checkOrRemoveExcludeList(MethodDescriptor desc) {
        if (this.excludeList != null) {
            List excList = this.excludeList.getMethods();
            for (int k = 0; k < excList.size(); ++k) {
                if (((MethodDescriptor)excList.get(k)).implies(desc) <= 0) continue;
                this.excludeList.getMethods().remove((MethodDescriptor)excList.get(k));
            }
            if (this.excludeList.getMethods().isEmpty()) {
                this.excludeList = null;
            }
        }
    }

    public void setExcludeList(ExcludeList list) {
        this.excludeList = list;
    }

    public ExcludeList getExcludeList() {
        return this.excludeList;
    }

    public BeanDescriptor getBeanX(String _name) {
        return this.getBeanFrom(_name, this.allBeans);
    }

    private BeanDescriptor getBeanFrom(String _name, List _beans) {
        if (_beans != null) {
            Iterator iterator = _beans.iterator();
            while (iterator.hasNext()) {
                BeanDescriptor bean = (BeanDescriptor)iterator.next();
                if (bean.getName() == null || !bean.getName().equals(_name)) continue;
                return bean;
            }
        }
        return null;
    }

    public BeanDescriptor getBean(String name) {
        return this.getBeanFrom(name, this.beans);
    }

    private DeploymentInfo getOneDeploymentInfo(String _pmName) {
        if (this.ppms != null) {
            Iterator iterator = this.ppms.iterator();
            while (iterator.hasNext()) {
                DeploymentInfo _di = (DeploymentInfo)iterator.next();
                if (!_di.getPMName().equals(_pmName)) continue;
                return _di;
            }
        }
        return null;
    }

    private DeploymentInfo getDeploymentInfo(String _beanName) {
        if (this.ppms != null) {
            Iterator iterator = this.getPPMs().iterator();
            while (iterator.hasNext()) {
                DeploymentInfo di = (DeploymentInfo)iterator.next();
                if (!di.getEntityDescriptor().getBeanName().equals(_beanName)) continue;
                return di;
            }
        }
        return null;
    }

    public ContainerEntityDescriptor getEntityDescriptor(String _beanName) {
        DeploymentInfo _di = this.getDeploymentInfo(_beanName);
        if (_di != null) {
            return _di.getEntityDescriptor();
        }
        return null;
    }

    public PersistenceManager getPM(String _beanName) {
        DeploymentInfo _di = this.getDeploymentInfo(_beanName);
        if (_di != null) {
            return _di.getPM();
        }
        return null;
    }

    public Map getEntityDescriptors() {
        HashMap<String, ContainerEntityDescriptor> descriptors = new HashMap<String, ContainerEntityDescriptor>();
        if (this.ppms != null) {
            Iterator iterator = this.ppms.iterator();
            while (iterator.hasNext()) {
                DeploymentInfo di = (DeploymentInfo)iterator.next();
                ContainerEntityDescriptor ed = di.getEntityDescriptor();
                descriptors.put(ed.getBeanName(), ed);
            }
        }
        return descriptors;
    }

    public void initialize(EJBContainer container) throws InstantiationException {
        if (this.getExcludeList() != null && JaccWrapper.isJaccEnabled()) {
            try {
                new JaccWrapper(container.getApplication().getName()).addExcludeListforEJB(this.getExcludeList());
            }
            catch (PolicyContextException e) {
                throw (InstantiationException)new InstantiationException(e.toString()).initCause(e);
            }
        }
        if (this.getDefaultSecurityRole() != null && JaccWrapper.isJaccEnabled()) {
            try {
                new JaccWrapper(container.getApplication().getName()).addDefaultSecurityRole(this.getDefaultSecurityRole());
            }
            catch (PolicyContextException e) {
                throw (InstantiationException)new InstantiationException(e.toString()).initCause(e);
            }
        }
        if (EJBProperties.getUseJAAS()) {
            EJBDeploymentMessages.warningUseJaas(this);
            this.setJAASMode(JAZNConfig.JAAS_MODE_DOAS);
        } else {
            UserManager um = this.getApplication().getUserManager();
            if (um != null && SecurityUtil.isJAZN(um)) {
                JAZNUserManager jazn = SecurityUtil.toJAZN(um);
                this.setJAASMode(jazn.getJAZNConfig().getJaasMode());
            }
        }
        this.initializeEjbqlDescriptors();
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            ((BeanDescriptor)iterator.next()).initialize(container);
        }
        this.initSyntheticWebModules();
        this.initPersistenceManager();
        this.checkForEmptyModule();
    }

    protected void checkForEmptyModule() throws InstantiationException {
        if (this.getAllBeans().isEmpty()) {
            if (this.getCompatibility() >= 3) {
                EJBDeploymentMessages.warningGetBeansFromEJBModule(this);
            } else {
                throw new InstantiationException("[" + this.getContextId() + "] - EJB module contains no beans.");
            }
        }
    }

    public void setWSDeploymentData(Object deploymentData) {
        this._wsDeplData = deploymentData;
    }

    private void initSyntheticWebModules() throws InstantiationException {
        this.initWebServices();
        this.initRMITunnelWebModule();
    }

    private void initRMITunnelWebModule() throws InstantiationException {
        String prop = System.getProperty("createRMITunnelWebModule", "false");
        if (prop.equals("true")) {
            String name = this.getName();
            WebModule webModule = new WebModule(name, this.deployment.getModule().getName(), null, true);
            webModule.setContextRoot("/" + name);
            this.application.addModule(webModule, false);
        }
    }

    private void initWebServices() throws InstantiationException {
        boolean useDeploymentContext = false;
        List keepGeneratedSEIList = null;
        if (!ContextUtils.isInContext(this.getContext(), "META-INF/webservices.xml")) {
            if (this.getCompatibility() >= 3) {
                if (!ContextUtils.isInContext(this.getDeploymentContext(), "META-INF/webservices.xml")) {
                    return;
                }
                useDeploymentContext = true;
                keepGeneratedSEIList = this.createKeepGeneratedSEIList();
            } else {
                return;
            }
        }
        try {
            this.webServicesDescriptor = WebServicesDescriptorFactory.getInstance().newWebServicesDescriptor(this, useDeploymentContext);
        }
        catch (Exception e) {
            throw new InstantiationException(e.getMessage());
        }
        this.webServicesDescriptor.setDefaultDeploymentSubname("META-INF");
        ((ServerComponent)((Object)this.webServicesDescriptor)).setDeploymentContext(this.getDeploymentContext());
        this.webServicesDescriptor.setKeepGeneratedSEIList(keepGeneratedSEIList);
        ((ServerComponent)((Object)this.webServicesDescriptor)).init();
        if (this._wsDeplData != null) {
            ((ServerComponent)((Object)this.webServicesDescriptor)).setDeploymentData((String)this._wsDeplData);
        }
        ((ServerComponent)((Object)this.webServicesDescriptor)).initDeployment();
        String name = this.getName();
        this.application.addModule(new WebModule(name, this.deployment.getModule().getName(), this.webServicesDescriptor, true), false);
    }

    private List createKeepGeneratedSEIList() {
        ArrayList<String> keepList = new ArrayList<String>();
        Iterator it = this.getBeans().iterator();
        while (it.hasNext()) {
            SessionBeanDescriptor sbd;
            BeanDescriptor bd = (BeanDescriptor)it.next();
            if (!bd.isSession() || !bd.isStateless() || (sbd = (SessionBeanDescriptor)bd).getServiceEndpointName() != null) continue;
            keepList.add(sbd.getEJBClassName());
        }
        return keepList;
    }

    public void parseOrionEnterpriseBeans(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "parseOrionEnterpriseBeans", new Object[]{parent.getNodeName()});
        }
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("persistence-manager")) {
                this.parsePersistenceManager(node);
                continue;
            }
            if (name.equals("entity-deployment") || name.equals("session-deployment") || name.equals("message-driven-deployment") || name.equals("ejb-deployment")) {
                this.parseOrionBean(node);
                continue;
            }
            throw new InstantiationException("Unknown orion-ejb-jar subtag: '" + name + "'");
        }
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "parseOrionEnterpriseBeans", new Object[]{parent.getNodeName()});
        }
    }

    public void parseOrionAssemblyDescriptor(Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (XMLUtils.isCommentOrID(name)) continue;
            if (name.equals("security-role-mapping")) {
                String roleName = XMLUtils.getNodeAttribute(node, "name");
                if (roleName == null) {
                    throw new InstantiationException("security-role-mapping tag with missing 'name' attribute");
                }
                SecurityRole role = this.getSecurityRole(roleName);
                if (role == null) {
                    throw new InstantiationException("Unknown security-role in security-role-mapping: " + roleName);
                }
                role.readNode(node);
                continue;
            }
            if (name.equals("message-destination-mapping")) {
                String destName = XMLUtils.getNodeAttribute(node, "name");
                Destination destinationObject = null;
                Application application = this.container.getApplication();
                ApplicationContext context = application.getContext();
                if (destName == null) {
                    throw new InstantiationException("message-destination-mapping tag with missing 'name' attribute");
                }
                MessageDestination destination = this.getMessageDestination(destName);
                if (destination == null) {
                    throw new InstantiationException("message-destination-mapping 'name=" + destName + "' does not match any of message-destination-name tags");
                }
                destination.parseOrionXML(node);
                if (destination.getLocation() == null) {
                    throw new InstantiationException("message-destination-mapping tag with missing 'location' attribute");
                }
                try {
                    destinationObject = (Destination)context.lookup(destination.getLocation());
                }
                catch (NameNotFoundException e) {
                    throw (InstantiationException)new InstantiationException("No javax.jms.Destination found at the specified location " + destination.getLocation() + " for <message-destination> name " + destName).initCause(e);
                }
                catch (NamingException e) {
                    throw (InstantiationException)new InstantiationException("Error looking up javax.jms.Destination at the specified location " + destination.getLocation() + " for <message-destination> name " + destName + ":" + e.getMessage()).initCause(e);
                }
                catch (ClassCastException e) {
                    throw (InstantiationException)new InstantiationException("Namespace location javax.jms.Destination at the specified location " + destination.getLocation() + " for <message-destination> name " + destName + "did not contain a javax.jms.Destination" + e.getMessage()).initCause(e);
                }
                if (destinationObject instanceof Topic) {
                    destination.setType("javax.jms.Topic");
                    continue;
                }
                destination.setType("javax.jms.Queue");
                continue;
            }
            if (name.equals("default-method-access")) {
                Node subNode = XMLUtils.getSubnode(node, "security-role-mapping");
                if (subNode == null) continue;
                this.defaultSecurityRole.parseOrionXML(subNode);
                if (!JaccWrapper.isJaccEnabled()) continue;
                try {
                    new JaccWrapper(this.getName()).addDefaultSecurityRole(this.getDefaultSecurityRole());
                    continue;
                }
                catch (PolicyContextException pce) {
                    throw (InstantiationException)new InstantiationException("Error adding default security role to the jacc wrapper " + pce.getMessage()).initCause(pce);
                }
            }
            throw new InstantiationException("Unknown assembly-descriptor subtag: " + name);
        }
    }

    public void parsePersistenceManager(Node parent) throws InstantiationException {
        String pmName;
        if (this.getPersistenceManagerDescriptor() != null) {
            EJBDeploymentMessages.warningMultiplePMEntries(this, this.getPersistenceManagerDescriptor().getName());
        }
        if ((pmName = XMLUtils.getNodeAttribute(parent, "name")) == null) {
            pmName = "toplink";
        }
        if (EJBProperties.getOc4jEjbPmName() != null && !EJBProperties.getOc4jEjbPmName().equalsIgnoreCase(pmName)) {
            EJBDeploymentMessages.warningIgnoringPm(this, pmName);
            return;
        }
        this.persistenceManagerDescriptor = new PersistenceManagerDescriptor(pmName);
        this.persistenceManagerDescriptor.parseOrionXML(parent);
    }

    public void parseOrionBean(Node parent) throws InstantiationException {
        String beanName;
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "parseOrionBean", new Object[]{parent.getNodeName()});
        }
        if ((beanName = XMLUtils.getNodeAttribute(parent, "name")) == null) {
            beanName = XMLUtils.getSubnodeValue(parent, "ejb-name");
        }
        if (beanName == null) {
            return;
        }
        BeanDescriptor bean = this.getBean(beanName);
        if (bean == null) {
            m_logger.warning("Bean " + beanName + " does not exist; skipping deployment");
            return;
        }
        String beanTypeString = parent.getNodeName().substring(0, parent.getNodeName().length() - 11);
        if (bean.isSession() && !beanTypeString.equals("session")) {
            this.validateBeanTypeOverridden(bean, parent.getNodeName());
        }
        bean.parseOrionXML(parent);
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "parseOrionBean", new Object[]{parent.getNodeName()});
        }
    }

    public void writeOrionConfig(PrintWriter out) throws IOException {
        out.println("<?xml version=\"1.0\" encoding=\"" + this.getDocumentEncoding() + "\"?>");
        out.println();
        this.writeOrionXML(out, "");
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "writeOrionXML", new Object[]{out, indention});
        }
        this.deploymentTime = System.currentTimeMillis() + 2000L;
        out.print(indention + "<orion-ejb-jar xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:noNamespaceSchemaLocation=\"http://xmlns.oracle.com/oracleas/schema/orion-ejb-jar-10_0.xsd\" " + "deployment-version=\"" + XMLUtils.encode(this.getDeploymentVersion()) + "\" deployment-time=\"" + Long.toHexString(this.deploymentTime) + '\"');
        if (this.alwaysRedeploy) {
            out.print(" always-redeploy=\"true\"");
        }
        out.println(" schema-major-version=\"10\" schema-minor-version=\"0\" >");
        out.println(indention + "\t<enterprise-beans>");
        if (this.getPersistenceManagerDescriptor() != null) {
            this.getPersistenceManagerDescriptor().writeOrionXML(out, indention + "\t\t");
        }
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            BeanDescriptor descriptor = (BeanDescriptor)iterator.next();
            descriptor.writeOrionXML(out, indention + "\t\t");
        }
        iterator = this.ppms.iterator();
        while (iterator.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)iterator.next();
            ContainerEntityDescriptor ed = di.getEntityDescriptor();
            ed.getEntityBeanDescriptor().writeOrionXML(out, indention + "\t\t");
        }
        out.println(indention + "\t</enterprise-beans>");
        out.println(indention + "\t<assembly-descriptor>");
        iterator = this.getSecurityRoles().iterator();
        while (iterator.hasNext()) {
            SecurityRole role = (SecurityRole)iterator.next();
            if (this.application != null && this.application.getSecurityRole(role.getName()) != null) continue;
            role.writeOrionXML(out, indention + "\t\t");
        }
        iterator = this.getMessageDestinations().iterator();
        while (iterator.hasNext()) {
            ((MessageDestination)iterator.next()).writeOrionXML(out, indention + "\t");
        }
        out.println(indention + "\t\t<default-method-access>");
        this.defaultSecurityRole.writeOrionXML(out, indention + "\t\t\t");
        out.println(indention + "\t\t</default-method-access>");
        out.println(indention + "\t</assembly-descriptor>");
        out.println(indention + "</orion-ejb-jar>");
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.exiting(EJBPackage.class.toString(), "writeOrionXML", new Object[]{out, indention});
        }
    }

    public void writeConfig(PrintWriter out) throws IOException {
        if (m_logger.isLoggable(Level.FINE)) {
            m_logger.entering(EJBPackage.class.toString(), "writeConfig", new Object[]{out});
        }
        if (this.getCompatibility() >= 3) {
            out.println("<!--WARNING: This generated ebj-jar.xml is for EJB 3.0 debugging purpose only, it is currently not valid for use in deployment-->");
        }
        out.println("<?xml version=\"1.0\"?>");
        if (this.ejb2_0) {
            out.println("<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN\" \"http://java.sun.com/dtd/ejb-jar_2_0.dtd\">");
        } else {
            out.println("<!DOCTYPE ejb-jar PUBLIC \"-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN\" \"http://java.sun.com/j2ee/dtds/ejb-jar_1_1.dtd\">");
        }
        out.println();
        this.writeXML(out, "");
    }

    public void writeXML(PrintWriter out, String indention) throws IOException {
        if (this.getCompatibility() >= 3) {
            out.println(indention + "<ejb-jar version=\"3.0\">");
        } else {
            out.println(indention + "<ejb-jar>");
        }
        if (this.getDescription() != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.getDescription()) + "</description>");
        }
        if (this.getDisplayName() != null) {
            out.println(indention + "\t<display-name>" + XMLUtils.encode(this.getDisplayName()) + "</display-name>");
        }
        if (this.smallIcon != null) {
            out.println(indention + "\t<small-icon>" + XMLUtils.encode(this.smallIcon) + "</small-icon>");
        }
        if (this.largeIcon != null) {
            out.println(indention + "\t<large-icon>" + XMLUtils.encode(this.largeIcon) + "</large-icon>");
        }
        this.writeEnterpriseBeans(out, indention + "\t");
        if (this.ejbRelations != null || this.relationshipsDescription != null) {
            this.writeRelationships(out, indention + "\t");
        }
        this.writeInterceptors(out, indention + "\t");
        this.writeAssemblyDescriptor(out, indention + "\t");
        out.println("</ejb-jar>");
    }

    public void writeEnterpriseBeans(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<enterprise-beans>");
        XMLUtils.writeAll(this.beans, out, indention + "\t");
        out.println(indention + "</enterprise-beans>");
    }

    public void writeInterceptors(PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<interceptors>");
        XMLUtils.writeAll(this.getInterceptorDescriptors().values(), out, indentation + "\t");
        out.println(indentation + "</interceptors>");
    }

    public void writeRelationships(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<relationships>");
        if (this.relationshipsDescription != null) {
            out.println(indention + "\t<description>" + XMLUtils.encode(this.relationshipsDescription) + "</description>");
        }
        if (this.ejbRelations != null) {
            XMLUtils.writeAll(this.ejbRelations, out, indention + "\t");
        }
        out.println(indention + "</relationships>");
    }

    public void writeAssemblyDescriptor(PrintWriter out, String indention) throws IOException {
        out.println(indention + "<assembly-descriptor>");
        XMLUtils.writeAll(this.getSecurityRoles(), out, indention + "\t");
        if (this.methodPermissions != null) {
            XMLUtils.writeAll(this.methodPermissions, out, indention + "\t");
        }
        if (this.messageDestinations != null) {
            XMLUtils.writeAll(this.messageDestinations, out, indention + "\t");
        }
        if (this.containerTransactions != null) {
            XMLUtils.writeAll(this.containerTransactions, out, indention + "\t");
        }
        if (this.excludeList != null) {
            this.excludeList.writeXML(out, indention + "\t");
        }
        Iterator i = this.getInterceptorBindings().values().iterator();
        while (i.hasNext()) {
            XMLUtils.writeAll((Collection)i.next(), out, indention + "\t");
        }
        out.println(indention + "</assembly-descriptor>");
    }

    protected void verifyDocumentType(String type) throws InstantiationException {
        if (this.inDeploymentMode) {
            if (!type.equalsIgnoreCase("orion-ejb-jar")) {
                throw new InstantiationException("orion-ejb-jar file expected");
            }
        } else if (!type.equalsIgnoreCase("ejb-jar")) {
            throw new InstantiationException("ejb-jar file expected");
        }
    }

    protected void validateDocument(Document document) throws InstantiationException {
        if (this.inDeploymentMode) {
            this.validateOrionEnterpriseBeans(document);
        }
    }

    private void validateOrionEnterpriseBeans(Document document) throws InstantiationException {
        boolean enterpriseBeansFound = false;
        NodeList children = document.getDocumentElement().getChildNodes();
        if (children != null && children.getLength() > 1) {
            for (int index = 0; index < children.getLength(); ++index) {
                Node child = children.item(index);
                if (child.getNodeName() == null || !child.getNodeName().equals("enterprise-beans")) continue;
                if (enterpriseBeansFound) {
                    throw new InstantiationException("multiple <enterprise-beans> defined in orion-ejb-jar.xml");
                }
                enterpriseBeansFound = true;
            }
        }
    }

    public String getName() {
        String name = super.getName();
        if (name != null) {
            return name;
        }
        return "Generic EJBJar";
    }

    public void addSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            this.securityRoles = new ArrayList();
        }
        if (this.securityRoles.contains(role)) {
            return;
        }
        this.securityRoles.add(role);
        this.firePropertyChangeEvent("securityRoles", null, role);
    }

    public List getSecurityRoles() {
        if (this.securityRoles == null) {
            return Collections.EMPTY_LIST;
        }
        return this.securityRoles;
    }

    public SecurityRole getSecurityRole(String name) {
        if (name.equals("unchecked")) {
            if (this.securityRoles == null) {
                this.securityRoles = new ArrayList();
            }
            SecurityRole role = new SecurityRole("unchecked", true);
            this.securityRoles.add(role);
            return role;
        }
        if (this.securityRoles == null) {
            return null;
        }
        for (int i = 0; i < this.securityRoles.size(); ++i) {
            SecurityRole parentRole;
            SecurityRole role = (SecurityRole)this.securityRoles.get(i);
            if (!role.getName().equals(name)) continue;
            SecurityRole securityRole = parentRole = this.application == null ? null : this.application.getSecurityRole(name);
            if (parentRole != null) {
                return parentRole;
            }
            return role;
        }
        return null;
    }

    public List getEJBClientJars() {
        if (this.ejbClientJars == null) {
            return Collections.EMPTY_LIST;
        }
        return this.ejbClientJars;
    }

    public List getExcludeListMethods() {
        if (this.excludeList != null) {
            return this.excludeList.getMethods();
        }
        return new ArrayList();
    }

    public List getSecurityRoles(String beanName, Method method, boolean home, boolean local) {
        int i;
        boolean firstOptimized = true;
        ArrayList<String> invokers = null;
        if (this.excludeList != null) {
            for (i = 0; i < this.excludeList.getMethods().size(); ++i) {
                if (((MethodDescriptor)this.excludeList.getMethods().get(i)).implies(beanName, method, local ? (home ? 4 : 3) : (home ? 2 : 1)) <= 0) continue;
                return new ArrayList();
            }
        }
        if (this.methodPermissions != null) {
            for (i = 0; i < this.methodPermissions.size(); ++i) {
                MethodPermission permission = (MethodPermission)this.methodPermissions.get(i);
                if (permission.implies(beanName, method, home, local) <= 0) continue;
                if (permission.isOverride()) {
                    return permission.getRoleNames();
                }
                if (permission.isUnchecked()) {
                    return Collections.EMPTY_LIST;
                }
                if (invokers == null && permission.getRoleNames() != Collections.EMPTY_LIST) {
                    invokers = permission.getRoleNames();
                    continue;
                }
                if (firstOptimized) {
                    invokers = new ArrayList<String>(invokers);
                }
                firstOptimized = false;
                for (int y = 0; y < permission.getRoleNames().size(); ++y) {
                    String name = (String)permission.getRoleNames().get(y);
                    if (invokers == null) {
                        invokers = new ArrayList();
                    } else if (invokers.contains(name)) continue;
                    invokers.add(name);
                }
            }
        }
        return invokers;
    }

    public MessageDestination getMessageDestination(String name) {
        if (this.messageDestinations == null) {
            return null;
        }
        Iterator iterator = this.messageDestinations.iterator();
        while (iterator.hasNext()) {
            MessageDestination destination = (MessageDestination)iterator.next();
            if (!destination.getName().equals(name)) continue;
            return destination;
        }
        return null;
    }

    public List getSecurityRoles(String beanName, Method method, int methodOrigin) {
        int i;
        if (this.excludeList != null) {
            for (i = 0; i < this.excludeList.getMethods().size(); ++i) {
                if (((MethodDescriptor)this.excludeList.getMethods().get(i)).implies(beanName, method, methodOrigin) <= 0) continue;
                return new ArrayList();
            }
        }
        if (this.methodPermissions != null) {
            for (i = 0; i < this.methodPermissions.size(); ++i) {
                MethodPermission permission = (MethodPermission)this.methodPermissions.get(i);
                if (permission.implies(beanName, method, methodOrigin) <= 0) continue;
                if (permission.isUnchecked()) {
                    return Collections.EMPTY_LIST;
                }
                if (permission.getRoleNames() == Collections.EMPTY_LIST) continue;
                return permission.getRoleNames();
            }
        }
        return null;
    }

    public List getRuntimeSecurityRoles(Method method, String beanName, boolean isWebServiceCall) {
        ArrayList<String> result = null;
        if (isWebServiceCall) {
            result = this.getSecurityRoles(beanName, method, 5);
        }
        if (result != null && result != Collections.EMPTY_LIST) {
            return result;
        }
        result = new ArrayList<String>();
        result.add(new String("<<default>>"));
        return result;
    }

    public int getTransactionType(String beanName, Method method, boolean home, boolean local) {
        int level = 0;
        int beanType = this.getBeanType(beanName);
        int type = beanType == 96 ? 1 : (beanType == 95 ? 2 : (this.getCompatibility() < 3 ? 4 : 1));
        if (method.getName().equals("ejbTimeout")) {
            type = 2;
        }
        if (this.containerTransactions != null) {
            for (int i = 0; i < this.containerTransactions.size(); ++i) {
                ContainerTransaction newTransaction = (ContainerTransaction)this.containerTransactions.get(i);
                int newLevel = newTransaction.implies(beanName, method, home, local);
                if (newLevel <= level) {
                    newLevel = newTransaction.implies(beanName, method, 5);
                }
                if (newLevel <= level) continue;
                level = newLevel;
                type = newTransaction.getTransactionType();
            }
        }
        return type;
    }

    public List getContainerTransactions() {
        if (this.containerTransactions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.containerTransactions;
    }

    public List getMessageDestinations() {
        if (this.messageDestinations == null) {
            return Collections.EMPTY_LIST;
        }
        return this.messageDestinations;
    }

    public List getMethodPermissions() {
        if (this.methodPermissions == null) {
            return Collections.EMPTY_LIST;
        }
        return this.methodPermissions;
    }

    public void addContainerTransaction(ContainerTransaction transaction) {
        if (this.containerTransactions == null) {
            this.containerTransactions = new ArrayList();
        }
        this.containerTransactions.add(transaction);
        this.firePropertyChangeEvent("containerTransactions", null, transaction);
    }

    public void addMessageDestination(MessageDestination destination) {
        if (this.messageDestinations == null) {
            this.messageDestinations = new ArrayList();
        }
        this.messageDestinations.add(destination);
        this.firePropertyChangeEvent("messageDestination", null, destination);
    }

    public void addMethodPermission(MethodPermission permission) throws InstantiationException {
        if (this.methodPermissions == null) {
            this.methodPermissions = new ArrayList();
        }
        this.methodPermissions.add(permission);
        this.firePropertyChangeEvent("methodPermissions", null, permission);
        try {
            if (JaccWrapper.isJaccEnabled()) {
                new JaccWrapper(this.container.getApplication().getName()).addEJBMethodPermission(permission);
            }
        }
        catch (PolicyContextException e) {
            throw (InstantiationException)new InstantiationException(e.toString()).initCause(e);
        }
    }

    public void removeMessageDestination(MessageDestination destination) {
        if (this.messageDestinations == null) {
            return;
        }
        this.messageDestinations.remove(destination);
        this.firePropertyChangeEvent("messageDestination", destination, null);
    }

    public void removeMethodPermission(MethodPermission permission) {
        if (this.methodPermissions == null) {
            return;
        }
        this.methodPermissions.remove(permission);
        this.firePropertyChangeEvent("methodPermissions", permission, null);
    }

    public SecurityRole getDefaultSecurityRole() {
        return this.defaultSecurityRole;
    }

    protected String getDefaultDeploymentSubname() {
        return "META-INF";
    }

    public String getAssemblyDescriptorPath() {
        if (this.getAltDD() == null) {
            return "META-INF/ejb-jar.xml";
        }
        return this.getAltDD();
    }

    public String getDeploymentDescriptorPath() {
        return "orion-ejb-jar.xml";
    }

    public InputSource resolveEntity(String a, String b) {
        if (b != null && b.indexOf("2_0") >= 0 || a != null && a.indexOf("2_0") >= 0) {
            this.ejb2_0 = true;
        }
        return super.resolveEntity(a, b);
    }

    public boolean isEJB2_0() {
        return this.ejb2_0;
    }

    private void addEJBRelation(EJBRelationship relationship) {
        if (this.ejbRelations == null) {
            this.ejbRelations = new ArrayList();
        }
        this.ejbRelations.add(relationship);
        this.firePropertyChangeEvent("relations", null, relationship);
    }

    public List getEJBRelationships() {
        if (this.ejbRelations == null) {
            return Collections.EMPTY_LIST;
        }
        return this.ejbRelations;
    }

    public EJBRelationshipRole getPeer(EntityBeanDescriptor descriptor, String fieldName) {
        Iterator iterator = this.getEJBRelationships().iterator();
        while (iterator.hasNext()) {
            ContainerManagedRelation relation;
            EJBRelationship relationship = (EJBRelationship)iterator.next();
            String name = relationship.getFirstRole().getRoleSource().getName();
            if (name != null && (name.equals(descriptor.getName()) || descriptor.getAbstractSchemaName() != null && descriptor.getAbstractSchemaName().equals(name)) && (relation = relationship.getFirstRole().getRelation()) != null && relation.getName() != null && relation.getName().equals(fieldName)) {
                return relationship.getSecondRole();
            }
            name = relationship.getSecondRole().getRoleSource().getName();
            if (name == null || !name.equals(descriptor.getName()) && (descriptor.getAbstractSchemaName() == null || !descriptor.getAbstractSchemaName().equals(name)) || (relation = relationship.getSecondRole().getRelation()) == null || relation.getName() == null || !relation.getName().equals(fieldName)) continue;
            return relationship.getFirstRole();
        }
        return null;
    }

    public PrimaryKeyContext getPeer(EJBRelationshipRole role, EJBDeploymentContext container) throws InstantiationException {
        String ejbName = role.getRoleSource().getName();
        BeanDescriptor descriptor = this.getBean(ejbName);
        if (descriptor == null) {
            throw new InvalidEJBAssemblyException("No ejb by the ejb-name " + ejbName + " as specified by the relationship-role-source in ejb-relationship-role " + role.getDisplayName() + " found", "10.3.13");
        }
        if (!(descriptor instanceof EntityBeanDescriptor)) {
            throw new InvalidEJBAssemblyException("illegal relationship-role-source in ejb-relationship, target was not an entity", "10.3.13");
        }
        return (EntityBeanDescriptor)descriptor;
    }

    public void setEJB2_0(boolean is2_0) {
        this.ejb2_0 = is2_0;
    }

    public void removeSecurityRole(SecurityRole role) {
        if (this.securityRoles == null) {
            return;
        }
        this.securityRoles.remove(role);
        this.firePropertyChangeEvent("securityRoles", role, null);
    }

    public EntityBeanDescriptor getEntityBySchema(String abstractSchemaName) {
        Iterator iterator = this.beans.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (!(object instanceof EntityBeanDescriptor) || !abstractSchemaName.equals(((EntityBeanDescriptor)object).getAbstractSchemaName())) continue;
            return (EntityBeanDescriptor)object;
        }
        return null;
    }

    protected void processRelationshipRole(EJBRelationshipRole role) throws InstantiationException {
        BeanDescriptor bean = this.getBean(role.getRoleSource().getName());
        if (bean == null) {
            throw new InvalidEJBAssemblyException("Unknown relationship-role-source target in relationship role '" + role.getName() + "': '" + role.getRoleSource().getName() + "', no entity corresponding to that ejb-name", "10.3.13");
        }
        if (!(bean instanceof EntityBeanDescriptor)) {
            throw new InvalidEJBAssemblyException("Illegal relationship-role-source target in relationship role '" + role.getName() + "': '" + role.getRoleSource().getName() + "', it's not an entity", "10.3.13");
        }
        EntityBeanDescriptor entity = (EntityBeanDescriptor)bean;
        role.getRoleSource().setResolved(entity);
        if (role.getRelation() == null) {
            if (role.getPeer().getRelation() == null) {
                throw new InstantiationException("At least one side of an ejb-relationship must have a defined cmr-field");
            }
            ContainerManagedRelation relation = new ContainerManagedRelation(role.getPeer().getRoleSource().getName().replace('.', '_') + '_' + role.getPeer().getRelation().getName(), null, true);
            role.setRelation(relation);
        }
        ContainerManagedField field = new ContainerManagedField(null, (PrimaryKeyContext)entity, role.getRelation().getName());
        field.setEJBRelationshipRole(role);
        role.getRelation().setResolved(field);
        entity.addContainerManagedField(field);
        if (role.getRelation() == null && role.getPeer().isMany() && !role.isMany()) {
            throw new InstantiationException("No cmr-field defined for collection side of relationship for ejb-relation '" + role.getEJBRelationship().getDescription() + "'");
        }
    }

    public String appendNamespace(String name) {
        String jarName;
        String result = name;
        String appName = this.getApplication().getName();
        if (appName != null) {
            result = result + "_" + appName;
        }
        if ((jarName = this.getName()) != null) {
            int dotIdx = jarName.lastIndexOf(46);
            if (dotIdx > -1) {
                jarName = jarName.substring(0, dotIdx);
            } else {
                int filecolumn = jarName.lastIndexOf(58);
                if (filecolumn > -1) {
                    jarName = filecolumn + 1 < jarName.length() ? jarName.substring(filecolumn + 1) : "";
                }
            }
            result = result + "_" + jarName;
        }
        result = this.cleanText(result.trim());
        return result;
    }

    private String cleanText(String st) {
        if (st == null) {
            return "";
        }
        if (st.length() == 0) {
            return st;
        }
        StringBuffer buff = new StringBuffer();
        char[] chrs = st.toCharArray();
        for (int i = 0; i < chrs.length; ++i) {
            char c = chrs[i];
            if ('A' <= c && c <= 'Z' || 'a' <= c && c <= 'z' || '0' <= c && c <= '9') continue;
            chrs[i] = 95;
        }
        buff.append(chrs);
        return buff.toString();
    }

    private boolean haveEJBQueries() {
        if (this.haveEJBQueriesFlagInitialized) {
            return this.haveEJBQueriesFlag;
        }
        Iterator iterator = this.getBeans().iterator();
        while (iterator.hasNext()) {
            EntityBeanDescriptor ebd;
            BeanDescriptor bd = (BeanDescriptor)iterator.next();
            if (!(bd instanceof EntityBeanDescriptor) || (ebd = (EntityBeanDescriptor)bd).getQueries() == null || ebd.getQueries().size() <= 0) continue;
            this.haveEJBQueriesFlag = true;
            break;
        }
        this.haveEJBQueriesFlagInitialized = true;
        return this.haveEJBQueriesFlag;
    }

    public void init() throws InstantiationException {
        try {
            if (this.getAltDD() == null) {
                this.getContext().lookup(this.getAssemblyDescriptorPath());
            }
            super.init();
            return;
        }
        catch (NamingException namingException) {
            this.reset();
            this.setCompatibility(3);
            return;
        }
    }

    protected long getAssemblyDescriptorLastModified(LastModifiedContainer c) throws IOException {
        try {
            if (this.getAltDD() == null) {
                this.getContext().lookup(this.getAssemblyDescriptorPath());
            }
            return super.getAssemblyDescriptorLastModified(c);
        }
        catch (NamingException namingException) {
            return ContextUtils.getFile(this.getContext(), false).lastModified();
        }
    }

    public boolean needEjbqlTranslation() {
        return this.haveEJBQueries() && !EJBProperties.getDisableEJBQL();
    }

    private void initializeEjbqlDescriptors() throws InstantiationException {
        if (this.needEjbqlTranslation() && this.ejbBundleDescriptor == null) {
            try {
                ByteString content = ContextUtils.readFromContext(this.getContext(), this.getAssemblyDescriptorPath(), false);
                this.ejbBundleDescriptor = EjbBundleDescriptorFactory.makeEjbBundleDescriptor(this, new ByteArrayInputStream(content.data, content.offset, content.length), this, true);
            }
            catch (Exception e) {
                throw (InstantiationException)new InstantiationException("Failure to initialize EJBQL descriptors: " + e).initCause(e);
            }
        }
    }

    public void translateEjbqlQeries() throws Exception {
        if (this.needEjbqlTranslation() && this.ejbBundleDescriptor != null) {
            Iterator iterator = this.getBeans().iterator();
            while (iterator.hasNext()) {
                EntityBeanDescriptor ebd;
                BeanDescriptor bd = (BeanDescriptor)iterator.next();
                if (!(bd instanceof EntityBeanDescriptor) || !(ebd = (EntityBeanDescriptor)bd).isCMP2_0()) continue;
                String name = ebd.getName();
                EjbDescriptor info = this.ejbBundleDescriptor.getEjbByName(name);
                ebd.setEjbqlDescriptor(info);
            }
            this.patchEbds();
            SQLGenerator.generateSQL(this.ejbBundleDescriptor, null, true, new OracleGenericDBInfo());
        }
    }

    private String pMOpString(int _op) {
        switch (_op) {
            case 0: {
                return "UNDEPLOY";
            }
            case 1: {
                return "PREINIT";
            }
            case 2: {
                return "GENERATE_CODE";
            }
            case 3: {
                return "POSTINIT";
            }
        }
        return "NON_RECOGNIZED";
    }

    public void notifyPMs(int op, Compilation comp) {
        EJBDeploymentMessages.finerNotifyPMs(this, this.pMOpString(op));
        try {
            block8: for (int i = 0; i < this.ppms.size(); ++i) {
                DeploymentInfo di = (DeploymentInfo)this.ppms.get(i);
                switch (op) {
                    case 0: {
                        di.getPM().undeploy(di.getEntityDescriptor());
                        continue block8;
                    }
                    case 1: {
                        di.getPM().preInit(di.getEntityDescriptor());
                        continue block8;
                    }
                    case 2: {
                        if (comp == null) {
                            throw new RuntimeException("Null compilation passed in");
                        }
                        ContainerEntityDescriptor ed = di.getEntityDescriptor();
                        if (null == ed.getEntityBeanDescriptor().isDeployed()) continue block8;
                        StringWriter sw = new StringWriter(4000);
                        PrintWriter out = new PrintWriter(new BufferedWriter(sw));
                        di.getPM().generateBeanSubclass(di.getEntityDescriptor(), out);
                        out.flush();
                        comp.addGenerator(new CompilableStringAdapter(di.getEntityDescriptor().getConcreteBeanClassName(), new ByteString(sw.toString().getBytes())));
                        continue block8;
                    }
                    case 3: {
                        di.getPM().postInit(di.getEntityDescriptor());
                        continue block8;
                    }
                    default: {
                        m_logger.log(Level.WARNING, "Unknown persistence manager operation: " + op);
                    }
                }
            }
        }
        catch (Exception e) {
            EJBDeploymentMessages.warningNotifyingPluggablePMs(this, this.pMOpString(op), e);
        }
    }

    public List getPPMs() {
        return this.ppms;
    }

    private void patchEbds() {
        Iterator iterator = this.getPPMs().iterator();
        while (iterator.hasNext()) {
            DeploymentInfo di = (DeploymentInfo)iterator.next();
            ContainerEntityDescriptor ed = di.getEntityDescriptor();
            if (!ed.isEJB20()) continue;
            String name = ed.getBeanName();
            EjbDescriptor info = this.ejbBundleDescriptor.getEjbByName(name);
            ed.getEntityBeanDescriptor().setEjbqlDescriptor(info);
        }
    }

    public Collection getRelationshipDescriptorsForBean(String beanName) {
        if (this.relationshipDescriptors == null) {
            this.buildRelationshipDescriptors();
        }
        return (Collection)this.relationshipDescriptors.get(beanName);
    }

    private void buildRelationshipDescriptors() {
        this.relationshipDescriptors = new HashMap();
        Iterator relationships = this.getEJBRelationships().iterator();
        while (relationships.hasNext()) {
            EJBRelationship relationship = (EJBRelationship)relationships.next();
            RelationshipRoleDescriptor role1 = this.buildRelationshipRoleDescriptor(relationship.getFirstRole());
            RelationshipRoleDescriptor role2 = this.buildRelationshipRoleDescriptor(relationship.getSecondRole());
            this.addRelationshipDescriptor(role1, role2);
            this.addRelationshipDescriptor(role2, role1);
        }
    }

    private void addRelationshipDescriptor(RelationshipRoleDescriptor source, RelationshipRoleDescriptor target) {
        RelationshipDescriptorImpl relationshipDescriptor = new RelationshipDescriptorImpl();
        relationshipDescriptor.setSourceRole(source);
        relationshipDescriptor.setTargetRole(target);
        String beanName = source.getBeanName();
        ArrayList<RelationshipDescriptorImpl> beanRelationships = (ArrayList<RelationshipDescriptorImpl>)this.relationshipDescriptors.get(beanName);
        if (beanRelationships == null) {
            beanRelationships = new ArrayList<RelationshipDescriptorImpl>();
            this.relationshipDescriptors.put(beanName, beanRelationships);
        }
        beanRelationships.add(relationshipDescriptor);
    }

    private RelationshipRoleDescriptor buildRelationshipRoleDescriptor(EJBRelationshipRole oldRole) {
        RelationshipRoleDescriptorImpl role = new RelationshipRoleDescriptorImpl();
        role.setBeanName(oldRole.getRoleSource().getName());
        if (oldRole.getRelation() != null && !oldRole.getRelation().unspecifiedCMRField()) {
            role.setCmrFieldName(oldRole.getRelation().getName());
            role.setCmrFieldType(oldRole.getRelation().getType());
        }
        role.setIsMany(oldRole.isMany());
        role.setIsCascadeDelete(oldRole.isCascadeDelete());
        return role;
    }

    public InputStream getDeployedPMDescriptor(String _pmDescriptorFileName) {
        try {
            byte[] _bytes = this.getDeployedPMDescriptor(this.getDeploymentContext(), _pmDescriptorFileName);
            return new ByteArrayInputStream(_bytes);
        }
        catch (Exception e) {
            return new ByteArrayInputStream(new byte[0]);
        }
    }

    private byte[] getDeployedPMDescriptor(Context _appDeployedDir, String _pmDescriptorFileName) throws InstantiationException {
        try {
            return (byte[])_appDeployedDir.lookup(_pmDescriptorFileName);
        }
        catch (NameNotFoundException e) {
            m_logger.log(Level.FINEST, "Error get PM descriptor", e);
            return null;
        }
        catch (NamingException ne) {
            m_logger.log(Level.FINEST, "Error get PM descriptor", ne);
            return null;
        }
        catch (Exception e) {
            String message = "Unable to find/read persistence descriptorfor " + _pmDescriptorFileName + " (" + e.getMessage() + ")";
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Exception: " + message);
            }
            throw (InstantiationException)new InstantiationException(message).initCause(e);
        }
    }

    private byte[] getDefaultDescriptorFromPM(PersistenceManagerDescriptor _pmd) {
        DeploymentInfo _di = this.getOneDeploymentInfo(_pmd.getName());
        PersistenceManager _pm = _di.getPM();
        ContainerEntityDescriptor _ed = _di.getEntityDescriptor();
        ByteArrayOutputStream baOut = new ByteArrayOutputStream();
        PrintWriter _pwriter = new PrintWriter(new PrintStream(baOut, true));
        _pm.getPMDescriptorContents(_ed, _pwriter);
        _pwriter.flush();
        _pwriter.close();
        return baOut.toByteArray();
    }

    private byte[] getPMDescriptorFromEJBJar(Context _EJBJarMetaInf, PersistenceManagerDescriptor _pmd) throws InstantiationException {
        byte[] _descriptor = null;
        try {
            _descriptor = (byte[])_EJBJarMetaInf.lookup(_pmd.getDescriptorName());
            if (_descriptor == null || _descriptor.length == 0) {
                _descriptor = this.getDefaultDescriptorFromPM(_pmd);
            }
            return _descriptor;
        }
        catch (NameNotFoundException e) {
            return this.getDefaultDescriptorFromPM(_pmd);
        }
        catch (Exception e) {
            String message = "Unable to find/read persistence descriptorfor " + _pmd.getDescriptorName() + " (" + e.getMessage() + ")";
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Exception: " + message);
            }
            throw (InstantiationException)new InstantiationException(message).initCause(e);
        }
    }

    private void bindPMDescriptorToAD(Context _appDeployedDir, String _pmDescriptorFileName, byte[] _content) throws InstantiationException {
        try {
            _appDeployedDir.bind(_pmDescriptorFileName, (Object)_content);
        }
        catch (Exception e) {
            String message = "Unable to find/read persistence descriptorfor " + _pmDescriptorFileName + " (" + e.getMessage() + ")";
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "Exception: " + message);
            }
            throw (InstantiationException)new InstantiationException(message).initCause(e);
        }
    }

    private void initPersistenceManager() throws InstantiationException {
        this.sortBeansByPersistenceManager();
        this.copyPersistenceManagerDescriptor();
    }

    protected void sortBeansByPersistenceManager() throws InstantiationException {
        this.allBeans = new ArrayList(this.beans);
        this.beans.clear();
        boolean hasCMP = false;
        Iterator iterator = this.allBeans.iterator();
        while (iterator.hasNext()) {
            BeanDescriptor _bean = (BeanDescriptor)iterator.next();
            if (_bean.isEntity()) {
                EntityBeanDescriptor ebd = (EntityBeanDescriptor)_bean;
                if (ebd.isContainerManaged()) {
                    hasCMP = true;
                    if (this.getDefaultPersistenceManager().isOrionPM()) {
                        this.beans.add(_bean);
                        continue;
                    }
                    this.ppms.add(new DeploymentInfo(ebd.getEntityDescriptor()));
                    continue;
                }
                this.beans.add(_bean);
                continue;
            }
            this.beans.add(_bean);
        }
        if (!hasCMP && this.persistenceManagerDescriptor != null) {
            this.persistenceManagerDescriptor = null;
            EJBDeploymentMessages.warningPersistenceManagerWithNoCMP(this);
        }
    }

    public PersistenceManagerDescriptor getPersistenceManagerDescriptor() {
        return this.persistenceManagerDescriptor;
    }

    private PersistenceManagerDescriptor getDefaultPersistenceManager() {
        if (this.persistenceManagerDescriptor == null) {
            if (EJBProperties.getOc4jEjbPmName() != null) {
                EJBDeploymentMessages.warningPmNameSelected(this, EJBProperties.getOc4jEjbPmName());
                if (EJBProperties.getOc4jEjbPmName().equalsIgnoreCase("orion")) {
                    this.persistenceManagerDescriptor = PersistenceManagerDescriptor.buildOrionDescriptor();
                } else if (EJBProperties.getOc4jEjbPmName().equalsIgnoreCase("toplink")) {
                    this.persistenceManagerDescriptor = PersistenceManagerDescriptor.buildTopLinkDescriptor();
                }
            }
            if (this.persistenceManagerDescriptor == null) {
                this.persistenceManagerDescriptor = this.isDescriptorInEJBJar() ? PersistenceManagerDescriptor.buildTopLinkDescriptor() : (this.isOrionCmpMappingDefined() ? PersistenceManagerDescriptor.buildOrionDescriptor() : PersistenceManagerDescriptor.buildTopLinkDescriptor());
            }
        }
        return this.persistenceManagerDescriptor;
    }

    private void copyPersistenceManagerDescriptor() throws InstantiationException {
        PersistenceManagerDescriptor pmd = this.getPersistenceManagerDescriptor();
        if (pmd != null && !pmd.isOrionPM() && this.isSeparateDeploymentContext() && this.getContext() != null) {
            Context deploymentContext = null;
            try {
                deploymentContext = (Context)this.getContext().lookup(this.getDefaultDeploymentSubname());
            }
            catch (NamingException ne) {
                // empty catch block
            }
            Context targetContext = this.getDeploymentContext();
            byte[] _descriptor = this.getDeployedPMDescriptor(targetContext, pmd.getDescriptorName());
            if (_descriptor != null && _descriptor.length != 0) {
                return;
            }
            _descriptor = this.getPMDescriptorFromEJBJar(deploymentContext, pmd);
            this.bindPMDescriptorToAD(targetContext, pmd.getDescriptorName(), _descriptor);
        }
    }

    public boolean hasEjbByName(String name) {
        Iterator itr = this.getBeans().iterator();
        while (itr.hasNext()) {
            BeanDescriptor next = (BeanDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public BeanDescriptor getEjbByName(String name) {
        Iterator itr = this.getBeans().iterator();
        while (itr.hasNext()) {
            BeanDescriptor next = (BeanDescriptor)itr.next();
            if (!next.getName().equals(name)) continue;
            return next;
        }
        throw new IllegalArgumentException("Referencing error: this bundle has no bean of name: " + name);
    }

    public int getBeanType(String beanName) {
        BeanDescriptor beanDescriptor = this.getBeanX(beanName);
        if (beanDescriptor instanceof MessageDrivenBeanDescriptor) {
            return 95;
        }
        if (beanDescriptor instanceof SessionBeanDescriptor) {
            if (((SessionBeanDescriptor)beanDescriptor).isStateful()) {
                return 98;
            }
            return 99;
        }
        if (beanDescriptor instanceof EntityBeanDescriptor) {
            EntityBeanDescriptor ebd = (EntityBeanDescriptor)beanDescriptor;
            if (ebd.isContainerManaged()) {
                if (ebd.isCMP2_0()) {
                    return 96;
                }
                return 94;
            }
            return 97;
        }
        return -1;
    }

    void registerWithJACC(SecurityRoleReference securityRoleReference, String ejbName) throws PolicyContextException {
        if (JaccWrapper.isJaccEnabled()) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "registerWithJACC 1 " + securityRoleReference + " " + ejbName);
            }
            new JaccWrapper(this.container.getApplication().getName()).addEJBSecurityRoleRef(securityRoleReference, ejbName);
        }
    }

    public void registerWithJACC(SecurityRole securityRole) throws PolicyContextException {
        if (JaccWrapper.isJaccEnabled()) {
            if (m_logger.isLoggable(Level.FINE)) {
                m_logger.log(Level.FINE, "registerWithJACC 2 " + securityRole);
            }
            new JaccWrapper(this.container.getApplication().getName()).addRoleMapping(securityRole);
        }
    }

    private boolean isOrionCmpMappingDefined() {
        Iterator itr = this.getAllBeans().iterator();
        while (itr.hasNext()) {
            EntityBeanDescriptor ebd;
            BeanDescriptor beanDescriptor = (BeanDescriptor)itr.next();
            if (!(beanDescriptor instanceof EntityBeanDescriptor) || !(ebd = (EntityBeanDescriptor)beanDescriptor).isContainerManaged() || !this.isOrionCmpMappingDefinedForEntity(ebd)) continue;
            return true;
        }
        return false;
    }

    private boolean isOrionCmpMappingDefinedForEntity(EntityBeanDescriptor ebd) {
        if (ebd.getPrimaryKey() != null) {
            return true;
        }
        Iterator cmpFiledIter = ebd.getContainerManagedFields().iterator();
        while (cmpFiledIter.hasNext()) {
            ContainerManagedField cmpField = (ContainerManagedField)cmpFiledIter.next();
            if (cmpField.internalGetDatabaseName() == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isDescriptorInEJBJar() {
        if (this.isPMDescriptorInJar == null) {
            try {
                String deployedPMDescriptor = this.getDefaultDeploymentSubname() + "/" + "toplink-ejb-jar.xml";
                this.isPMDescriptorInJar = new Boolean(this.getContext().lookup(deployedPMDescriptor) != null);
            }
            catch (Exception e) {
                this.isPMDescriptorInJar = Boolean.FALSE;
            }
        }
        return this.isPMDescriptorInJar;
    }

    public void setCompatibility(int compatibility) {
        this.compatibility = compatibility;
    }

    public int getCompatibility() {
        return this.compatibility;
    }

    public void setIsEjbJarFull(boolean isEjbJarFull) {
        this.isEjbJarFull = isEjbJarFull;
    }

    public boolean isEjbJarFull() {
        return this.isEjbJarFull;
    }

    public int getJAASMode() {
        return this.jaasMode;
    }

    public void setJAASMode(int jaasMode) {
        this.jaasMode = jaasMode;
    }

    public Map getInterceptorDescriptors() {
        return this.interceptorDescriptors;
    }

    public Map getInterceptorBindings() {
        return this.interceptorBindings;
    }

    public List getDefaultInterceptorBindings() {
        return (List)this.interceptorBindings.get("*");
    }

    public void storeEJBJarXML() throws IOException, InstantiationException {
        block5: {
            if (!this.getDeployment().hasAnnotatedClass()) {
                return;
            }
            Context deploymentContext = this.getDeploymentContext();
            String assemblyPath = "ejb-jar.xml";
            if (deploymentContext == null) {
                IOUtils.writeContent(assemblyPath, this.getConfigContent());
                return;
            }
            File deploymentFile = ((FileContext)deploymentContext).getFile(assemblyPath);
            if (deploymentFile.exists() && !this.getDeployment().isIncrementalDeployed()) {
                return;
            }
            try {
                deploymentContext.bind(assemblyPath, (Object)this.getConfigContent());
            }
            catch (NamingException e) {
                if (deploymentFile.exists()) break block5;
                throw new IOException("Error writing out ejb-jar.xml");
            }
        }
    }

    public String getContextId() {
        return this.getApplication().getName() + ":" + this.getName();
    }

    protected void parseDeploymentRootNodeValue(String name, String value) throws InstantiationException {
        if (name.equals("disable-persistent-unit")) {
            this.disableDefaultPersistentUnit = value.equalsIgnoreCase("true");
        } else {
            super.parseDeploymentRootNodeValue(name, value);
        }
    }

    public boolean disableDefaultPersistentUnit() {
        return this.disableDefaultPersistentUnit;
    }
}

