/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.cache.CacheManagerTask;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.CommitOptionDescriptor;
import com.evermind.server.ejb.deployment.ContainerManagedField;
import com.evermind.server.ejb.deployment.DataSynchronizationOptionDescriptor;
import com.evermind.server.ejb.deployment.EJBQuery;
import com.evermind.server.ejb.deployment.EntityBeanDescriptor;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.FinderMethod;
import com.evermind.server.ejb.deployment.PersistenceManagerDescriptor;
import com.evermind.server.ejb.deployment.PrimaryKeyContext;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.util.EJBProperties;
import com.evermind.xml.XMLUtils;
import com.oracle.server.ejb.container.deployment.ContainerEntityDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EntityBeanDescriptorXMLFactory
extends ExposableBeanDescriptorXMLFactory {
    private static EntityBeanDescriptorXMLFactory instance = new EntityBeanDescriptorXMLFactory();

    private EntityBeanDescriptorXMLFactory() {
    }

    public static EntityBeanDescriptorXMLFactory getInstance() {
        return instance;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean parseEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        EntityBeanDescriptor descriptor = (EntityBeanDescriptor)desc;
        String name = node.getNodeName();
        String value = XMLUtils.getStringValue(node);
        if (name.equals("persistence-type")) {
            descriptor.setIsBMP("Bean".equalsIgnoreCase(value));
            return true;
        } else if (name.equals("primkey-class") || name.equals("prim-key-class")) {
            descriptor.setPrimaryKeyClassName(value);
            return true;
        } else if (name.equals("reentrant")) {
            descriptor.setIsReentrant(XMLUtils.parseBoolean(name, value));
            return true;
        } else if (name.equals("cmp-field")) {
            descriptor.addContainerManagedField(new ContainerManagedField(null, (PrimaryKeyContext)descriptor, node, true));
            return true;
        } else if (name.equals("primkey-field")) {
            descriptor.setPrimaryKeyFieldName(XMLUtils.getStringValue(node));
            return true;
        } else if (name.equals("cmp-version")) {
            String versionName = XMLUtils.getStringValue(node);
            if (versionName.equalsIgnoreCase("1.x")) {
                descriptor.setVersion("1.x");
                return true;
            } else {
                if (!versionName.equalsIgnoreCase("2.x")) throw new InstantiationException("Unsupported cmp-version: " + versionName + ", supported versions in this container are '1.x' and '2.x' as defined in the EJB 2.1 specification");
                descriptor.setVersion("2.x");
            }
            return true;
        } else if (name.equals("abstract-schema-name")) {
            descriptor.setAbstractSchemaName(XMLUtils.getStringValue(node));
            return true;
        } else {
            if (!name.equals("query")) return super.parseEJBJarXMLNode(descriptor, node);
            descriptor.addQuery(new EJBQuery(node));
        }
        return true;
    }

    protected boolean parseOracleEJBJarXMLAttribute(BeanDescriptor desc, String name, String value) throws InstantiationException {
        EntityBeanDescriptor descriptor = (EntityBeanDescriptor)desc;
        if (name.equals("data-source")) {
            descriptor.setDataSourceName(value);
        } else if (name.equals("table")) {
            descriptor.setTableName(value);
        } else if (name.equals("clustering-schema")) {
            descriptor.setClusteringSchema(this.parseClusteringSchema(value));
        } else if (name.equals("isolation")) {
            descriptor.setIsolationLevel(this.parseIsolationLevel(value));
        } else if (name.equals("validity-timeout")) {
            descriptor.setValidityTimeout(XMLUtils.parseLong("validity-timeout", value));
        } else if (name.equals("exclusive-write-access")) {
            descriptor.setExclusiveWriteAccess(XMLUtils.parseBoolean("exclusive-write-access", value));
        } else if (name.equals("do-select-before-insert")) {
            descriptor.setSelectBeforeInsert(XMLUtils.parseBoolean("do-select-before-insert", value));
        } else if (name.equals("data-synchronization-option")) {
            descriptor.setDataSynchronizationOption(new DataSynchronizationOptionDescriptor(value));
        } else if (name.equals("locking-mode")) {
            descriptor.setLockingMode(this.parseLockingMode(value, descriptor));
        } else if (name.equals("update-changed-fields-only")) {
            descriptor.setUpdateChangedFieldsOnly(XMLUtils.parseBoolean("update-changed-fields-only", value));
        } else if (name.equals("force-update")) {
            descriptor.setForceUpdate(XMLUtils.parseBoolean("force-update", value));
        } else if (name.equals("delay-updates-until-commit")) {
            descriptor.setDelayUpdatesUntilCommit(XMLUtils.parseBoolean("delay-updates-until-commit", value));
        } else if (name.equals("batch-size")) {
            descriptor.setBatchSize(XMLUtils.parseInt("batch-size", value));
        } else if (name.equals("pm-name")) {
            EJBDeploymentMessages.warningPMName(descriptor);
        } else if (name.equals("concrete-bean-class")) {
            descriptor.setConcreteBeanClassName(value);
        } else if (!name.equals("home-wrapper-name") && !name.equals("local-home-wrapper-name")) {
            if (name.equals("wrapper")) {
                descriptor.setRemoteHomeWrapperName(value);
            } else if (name.equals("local-wrapper")) {
                descriptor.setLocalHomeWrapperName(value);
            } else if (name.equals("findByPrimaryKey-lazy-loading")) {
                descriptor.setFindByPrimaryKeyLazyLoading(XMLUtils.parseBoolean("findByPrimaryKey-lazy-loading", value));
            } else {
                return super.parseOracleEJBJarXMLAttribute(descriptor, name, value);
            }
        }
        return true;
    }

    private int parseClusteringSchema(String value) throws InstantiationException {
        if (value.equals("default")) {
            return 1;
        }
        if (value.equals("asynchronous-cache")) {
            return 2;
        }
        throw new InstantiationException("Unknown clustering-schema value: " + value);
    }

    private int parseIsolationLevel(String value) throws InstantiationException {
        if (value.equalsIgnoreCase("none") || value.equalsIgnoreCase("default")) {
            return 2;
        }
        if (value.equalsIgnoreCase("serializable")) {
            return 8;
        }
        if (value.equalsIgnoreCase("uncommitted")) {
            return 1;
        }
        if (value.equalsIgnoreCase("committed")) {
            return 2;
        }
        if (value.equalsIgnoreCase("repeatable_read")) {
            return 4;
        }
        throw new InstantiationException("Invalid isolation attribute value specified, valid values are: serializable, committed, uncommitted, repeatable_read: '" + value + "'");
    }

    private int parseLockingMode(String value, EntityBeanDescriptor descriptor) throws InstantiationException {
        if (value.equalsIgnoreCase("pessimistic")) {
            return 1;
        }
        if (value.equalsIgnoreCase("optimistic")) {
            return 2;
        }
        if (value.equalsIgnoreCase("read-only")) {
            return 3;
        }
        if (value.equals("old_pessimistic")) {
            EJBDeploymentMessages.warningOldPessimisticLockingMode(descriptor);
            return 2;
        }
        throw new InstantiationException("Illegal locking-mode specified : " + value);
    }

    protected boolean parseOracleEJBJarXMLNode(BeanDescriptor desc, Node node) throws InstantiationException {
        EntityBeanDescriptor descriptor = (EntityBeanDescriptor)desc;
        String name = node.getNodeName();
        PersistenceManagerDescriptor pm = desc.getEJBPackage().getPersistenceManagerDescriptor();
        if (!EJBUtils.isOrionCmpForced() && (pm != null && !pm.isOrionPM() || pm == null && desc.getEJBPackage().isDescriptorInEJBJar()) && (name.equals("finder-method") || name.equals("cmp-field-mapping") || name.equals("primkey-mapping") || name.equals("commit-option") && descriptor.isContainerManaged())) {
            return true;
        }
        String value = XMLUtils.getStringValue(node);
        if (name.equals("finder-method")) {
            descriptor.addFinderMethod(new FinderMethod(node));
        } else if (name.equals("cmp-field-mapping")) {
            this.parseCMPFieldMapping(descriptor, node);
        } else if (name.equals("primkey-mapping")) {
            this.parsePrimaryKeyMapping(descriptor, node);
        } else if (name.equals("commit-option")) {
            this.parseCommitOption(descriptor, node);
        } else {
            return super.parseOracleEJBJarXMLNode(descriptor, node);
        }
        return true;
    }

    private void parseCMPFieldMapping(EntityBeanDescriptor descriptor, Node parent) throws InstantiationException {
        ContainerManagedField field;
        String fieldName = XMLUtils.getNodeAttribute(parent, "name");
        if (fieldName != null && (field = descriptor.getContainerManagedField(fieldName, descriptor)) != null) {
            field.parseOrionXML(parent, descriptor.getEJBPackage());
        }
    }

    private void parsePrimaryKeyMapping(EntityBeanDescriptor descriptor, Node parent) throws InstantiationException {
        NodeList nodes = parent.getChildNodes();
        if (nodes != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (!name.equals("cmp-field-mapping")) continue;
                this.parseCMPFieldMapping(descriptor, node);
                descriptor.setPrimaryKeyField(new ContainerManagedField(null, (PrimaryKeyContext)descriptor, ""));
                descriptor.getPrimaryKey().parseOrionXML(node, descriptor.getEJBPackage());
            }
        }
    }

    private void parseCommitOption(EntityBeanDescriptor descriptor, Node parent) {
        this.parseCommitOptionNodes(descriptor, parent);
        CommitOptionDescriptor commitOption = descriptor.getCommitOption();
        if (commitOption.useOCA()) {
            ContainerManagedField field = new ContainerManagedField(null, (PrimaryKeyContext)descriptor, commitOption.getName());
            field.setDatabaseType(commitOption.getDbType());
            field.setDatabaseName(commitOption.getDbNname());
            field.setPersistenceType(0);
            field.isOCA(true);
            descriptor.addContainerManagedField(field);
            commitOption.setField(field);
        }
    }

    private void parseCommitOptionNodes(EntityBeanDescriptor descriptor, Node parent) {
        NodeList nodes;
        CommitOptionDescriptor commitOption = descriptor.getCommitOption();
        NamedNodeMap attrs = parent.getAttributes();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node node = attrs.item(i);
                String name = node.getNodeName();
                if (name.equals("mode")) {
                    commitOption.setOption(node.getNodeValue(), descriptor.isContainerManaged());
                    continue;
                }
                if (name.equals("number-of-buckets")) {
                    commitOption.setNumberOfBuckets(Integer.parseInt(node.getNodeValue()));
                    continue;
                }
                if (name.equals("ttl")) {
                    commitOption.setTTL(Integer.parseInt(node.getNodeValue()));
                    CacheManagerTask.instance().updateTTL(commitOption.getTTL());
                    continue;
                }
                if (name.equals("name")) {
                    commitOption.setName(node.getNodeValue());
                    continue;
                }
                if (name.equals("type")) {
                    commitOption.setType(node.getNodeValue());
                    continue;
                }
                if (name.equals("persistence-name")) {
                    commitOption.setDbNname(node.getNodeValue());
                    continue;
                }
                System.err.println("Invalid Option " + name);
            }
        }
        if ((nodes = parent.getChildNodes()) != null) {
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String name = node.getNodeName();
                if (XMLUtils.isCommentOrID(name)) continue;
                if (name.equals("oca-field-mapping")) {
                    this.parseCommitOptionNodes(descriptor, node);
                }
                if (!name.equals("non-cmr-field")) continue;
                this.parseCommitOptionNonCMRNodes(descriptor, node);
            }
        }
    }

    private void parseCommitOptionNonCMRNodes(EntityBeanDescriptor descriptor, Node parent) {
        NamedNodeMap attrs = parent.getAttributes();
        String cname = null;
        String ctype = null;
        boolean cclone = false;
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                Node node = attrs.item(i);
                String name = node.getNodeName();
                if (name.equals("name")) {
                    cname = node.getNodeValue();
                    continue;
                }
                if (name.equals("type")) {
                    ctype = node.getNodeValue();
                    continue;
                }
                if (name.equals("clone")) {
                    cclone = node.getNodeValue().equalsIgnoreCase("true");
                    continue;
                }
                System.err.println("Invalid Option " + name);
            }
        }
        if (cname != null) {
            descriptor.getCommitOption().addNonCMRField(cname, ctype, cclone);
        } else {
            System.err.println("invalid non-cmr-field");
        }
    }

    public void writeEJBJarXML(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        out.println(indentation + "<" + "entity" + ">");
        super.writeEJBJarXML(descriptor, out, indentation);
        out.println(indentation + "</" + "entity" + ">");
    }

    public void writeOracleEJBJarXML(BeanDescriptor desc, PrintWriter out, String indentation) throws IOException {
        EntityBeanDescriptor descriptor = (EntityBeanDescriptor)desc;
        out.println(indentation + "<" + "entity-deployment" + this.getOracleEJBJarXMLAttributes(desc) + ">");
        if (descriptor.isContainerManaged() && descriptor.hasNonNativeOC4JPM()) {
            super.writeOracleEJBJarXML(desc, out, indentation);
        } else {
            Iterator iterator;
            if (descriptor.getPrimaryKey() != null) {
                out.println(indentation + "\t<" + "primkey-mapping" + ">");
                descriptor.getPrimaryKey().writeOrionXML(out, indentation + "\t\t");
                out.println(indentation + "\t</" + "primkey-mapping" + ">");
            }
            if (descriptor.getContainerManagedFields() != null) {
                iterator = descriptor.getContainerManagedFields().iterator();
                while (iterator.hasNext()) {
                    ((ContainerManagedField)iterator.next()).writeOrionXML(out, indentation + "\t");
                }
            }
            if (descriptor.getFinderMethods() != null) {
                iterator = descriptor.getFinderMethods().iterator();
                while (iterator.hasNext()) {
                    ((FinderMethod)iterator.next()).writeOrionXML(out, indentation + "\t");
                }
            }
            super.writeOracleEJBJarXML(desc, out, indentation);
            CommitOptionDescriptor commitOption = descriptor.getCommitOption();
            if (commitOption.getOption() != 3) {
                out.println(indentation + "<" + "commit-option" + " ");
                out.println(indentation + "mode=\"" + commitOption.getOptionStr() + "\" ");
                if (commitOption.isCacheable()) {
                    out.println(indentation + "number-of-buckets=\"" + commitOption.getNumberOfBuckets() + "\" ");
                    if (commitOption.getTTL() != -1) {
                        out.println(indentation + "ttl=\"" + commitOption.getTTL() + "\" ");
                    }
                }
                out.println(indentation + " >");
                if (commitOption.useOCA()) {
                    out.println(indentation + "<oca-field-mapping ");
                    out.println(indentation + "name=\"" + commitOption.getName() + "\" ");
                    out.println(indentation + "type=\"" + commitOption.getType() + "\" ");
                    out.println(indentation + "persistence-name=\"" + commitOption.getDbNname() + "\" ");
                    out.println(indentation + " />");
                }
                if (commitOption.hasNonCMRFields()) {
                    CommitOptionDescriptor.NonCMRField[] fields = commitOption.getNonCMRFields();
                    for (int i = 0; i < fields.length; ++i) {
                        CommitOptionDescriptor.NonCMRField o = fields[i];
                        out.println(indentation + "<non-cmr-field ");
                        out.println(indentation + "name=\"" + o.getName() + "\" ");
                        if (o.getType() != null) {
                            out.println(indentation + "type=\"" + o.getType() + "\" ");
                        }
                        if (o.getClone()) {
                            out.println(indentation + "clone=\"" + o.getClone() + "\" ");
                        }
                        out.println(indentation + " />");
                    }
                }
                out.println(indentation + "</" + "commit-option" + ">");
            }
        }
        out.println(indentation + "</" + "entity-deployment" + ">");
    }

    protected String getOracleEJBJarXMLAttributes(BeanDescriptor desc) {
        EntityBeanDescriptor descriptor = (EntityBeanDescriptor)desc;
        StringBuffer attributes = new StringBuffer(super.getOracleEJBJarXMLAttributes(desc));
        if (descriptor.isContainerManaged() && descriptor.hasNonNativeOC4JPM()) {
            attributes.append(this.getPersistenceManagerCMPOracleEJBJarXMLAttributes(descriptor));
        } else {
            attributes.append(this.getNativeCMPOracleEJBJarXMLAttributes(descriptor));
        }
        this.appendAttribute("wrapper", descriptor.getRemoteHomeWrapperName(), attributes);
        this.appendAttribute("local-wrapper", descriptor.getLocalHomeWrapperName(), attributes);
        return attributes.toString();
    }

    private String getNativeCMPOracleEJBJarXMLAttributes(EntityBeanDescriptor descriptor) {
        StringBuffer attributes = new StringBuffer();
        if (descriptor.getTableName() != null) {
            this.appendAttribute("table", descriptor.getTableName(), attributes);
        }
        if (!descriptor.getDataSynchronizationOption().isUnknown()) {
            this.appendAttribute("data-synchronization-option", descriptor.getDataSynchronizationOption().toString(), attributes);
        }
        if (descriptor.getIsolationLevel() != 0) {
            this.appendAttribute("isolation", this.getIsolationLevelAsString(descriptor.getIsolationLevel()), attributes);
        }
        if (descriptor.getDataSourceName() != null) {
            this.appendAttribute("data-source", descriptor.getDataSourceName(), attributes);
        }
        this.appendAttribute("exclusive-write-access", String.valueOf(descriptor.hasExclusiveWriteAccess()), attributes);
        if (!descriptor.getSelectBeforeInsert()) {
            this.appendAttribute("do-select-before-insert", String.valueOf(descriptor.getSelectBeforeInsert()), attributes);
        }
        if (descriptor.getValidityTimeout() != 0L) {
            this.appendAttribute("validity-timeout", String.valueOf(descriptor.getValidityTimeout()), attributes);
        }
        this.appendAttribute("locking-mode", this.getLockingModeAsString(descriptor.getLockingMode()), attributes);
        if (descriptor.getForceUpdate()) {
            this.appendAttribute("force-update", String.valueOf(descriptor.getForceUpdate()), attributes);
        }
        this.appendAttribute("update-changed-fields-only", String.valueOf(descriptor.getUpdateChangedFieldsOnly()), attributes);
        this.appendAttribute("delay-updates-until-commit", String.valueOf(descriptor.getDelayUpdatesUntilCommit()), attributes);
        if (descriptor.getBatchSize() != EJBProperties.getDefaultBatchSize()) {
            this.appendAttribute("batch-size", String.valueOf(descriptor.getBatchSize()), attributes);
        }
        this.appendAttribute("findByPrimaryKey-lazy-loading", String.valueOf(descriptor.getFindByPrimaryKeyLazyLoading()), attributes);
        if (descriptor.getClusteringSchema() != 1) {
            this.appendAttribute("clustering-schema", EntityBeanDescriptorXMLFactory.getClusteringSchemaAsString(descriptor.getClusteringSchema()), attributes);
        }
        return attributes.toString();
    }

    private static String getClusteringSchemaAsString(int type) {
        switch (type) {
            case 2: {
                return "asynchronous-cache";
            }
        }
        return "default";
    }

    private String getIsolationLevelAsString(int level) {
        switch (level) {
            case 2: {
                return "committed";
            }
            case 8: {
                return "serializable";
            }
            case 1: {
                return "uncommitted";
            }
            case 4: {
                return "repeatable_read";
            }
        }
        return null;
    }

    private String getLockingModeAsString(int mode) {
        switch (mode) {
            case 1: {
                return "pessimistic";
            }
            case 2: {
                return "optimistic";
            }
            case 3: {
                return "read-only";
            }
        }
        return null;
    }

    private String getPersistenceManagerCMPOracleEJBJarXMLAttributes(EntityBeanDescriptor descriptor) {
        StringBuffer attributes = new StringBuffer();
        ContainerEntityDescriptor ed = descriptor.getEntityDescriptor();
        if (ed == null) {
            throw new IllegalStateException("ed is null, EntityBeanDescriptor[" + this + "]");
        }
        this.appendAttribute("concrete-bean-class", ed.getConcreteBeanClassName(), attributes);
        if (descriptor.getDataSourceName() != null) {
            this.appendAttribute("data-source", descriptor.getDataSourceName(), attributes);
        }
        return attributes.toString();
    }

    protected void writeBeanSpecificEJBJarXMLTags(BeanDescriptor descriptor, PrintWriter out, String indentation) throws IOException {
        super.writeBeanSpecificEJBJarXMLTags(descriptor, out, indentation);
        EntityBeanDescriptor entityDescriptor = (EntityBeanDescriptor)descriptor;
        this.writeTag("persistence-type", entityDescriptor.isBMP() ? "Bean" : "Container", out, indentation);
        this.writeTag("prim-key-class", entityDescriptor.getPrimaryKeyClassName(), out, indentation);
        this.writeTag("reentrant", String.valueOf(entityDescriptor.isReentrant()), out, indentation);
        if (descriptor.getEJBPackage().getCompatibility() < 3) {
            this.writeTag("cmp-version", entityDescriptor.getVersion(), out, indentation);
        }
        this.writeTag("abstract-schema-name", entityDescriptor.getAbstractSchemaName(), out, indentation);
        if (entityDescriptor.getContainerManagedFields() != null) {
            XMLUtils.writeAll(entityDescriptor.getContainerManagedFields(), out, indentation + "\t");
        }
        this.writeTag("primkey-field", entityDescriptor.getPrimaryKeyFieldName(), out, indentation);
    }

    protected void validateBeanTypeOverridden(BeanDescriptor descriptor, Node rootNode, boolean isEjbJar) throws InstantiationException {
        if (isEjbJar && !rootNode.getNodeName().equals("entity") || !isEjbJar && !rootNode.getNodeName().equals("entity-deployment")) {
            this.failOnBeanTypeMismatch(descriptor, rootNode.getNodeName(), isEjbJar);
        }
    }
}

