/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.evermind.xml.XMLUtils;
import java.io.IOException;
import java.io.PrintWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PersistenceManagerDescriptor {
    private static final String DEFAULT_CLASS_NAME = "oracle.toplink.internal.ejb.cmp.oc4j.Oc4jPersistenceManager";
    public static final String DEFAULT_DESCRIPTOR = "toplink-ejb-jar.xml";
    public static final String DEFAULT_TOPLINK_PM = "toplink";
    public static final String ORION_PM = "orion";
    private static final String ORION_PM_OLD = "native_cmp";
    private String name;
    private String className = null;
    private String descriptorName = null;
    private Node properties = null;
    private boolean isUserDefined = false;

    public static PersistenceManagerDescriptor buildTopLinkDescriptor() {
        return new PersistenceManagerDescriptor(DEFAULT_TOPLINK_PM);
    }

    public static PersistenceManagerDescriptor buildOrionDescriptor() {
        PersistenceManagerDescriptor pm = new PersistenceManagerDescriptor(ORION_PM);
        pm.setClassName("");
        pm.setDescriptorName("");
        return pm;
    }

    public PersistenceManagerDescriptor(String newName) {
        if (newName == null) {
            newName = DEFAULT_TOPLINK_PM;
        }
        this.setName(newName);
        this.setClassName(DEFAULT_CLASS_NAME);
        this.setDescriptorName(DEFAULT_DESCRIPTOR);
    }

    public String getName() {
        return this.name;
    }

    private void setName(String newName) {
        this.name = newName;
    }

    public String getDescriptorName() {
        return this.descriptorName;
    }

    private void setDescriptorName(String newDescriptorName) {
        if (newDescriptorName != null) {
            this.descriptorName = newDescriptorName;
        }
    }

    private void setClassName(String newClassName) {
        if (newClassName != null) {
            this.className = newClassName;
        }
    }

    public String getClassName() {
        return this.className;
    }

    public Node getProperties() {
        return this.properties;
    }

    protected void parseOrionXML(Node parent) throws InstantiationException {
        this.isUserDefined = true;
        if (this.getName().equalsIgnoreCase(ORION_PM_OLD)) {
            EJBDeploymentMessages.warningNativeCMPName();
        }
        this.setClassName(XMLUtils.getNodeAttribute(parent, "class"));
        this.setDescriptorName(XMLUtils.getNodeAttribute(parent, "descriptor"));
        NodeList nodes = parent.getChildNodes();
        for (int i = 0; nodes != null && i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getNodeName();
            if (name.startsWith("#")) continue;
            if (name.equals("pm-properties")) {
                this.properties = node;
                continue;
            }
            throw new InstantiationException("Unknown persistence-manager tag: " + name);
        }
    }

    public void writeOrionXML(PrintWriter out, String indention) throws IOException {
        if (!this.isUserDefined) {
            return;
        }
        out.print(indention + "<persistence-manager");
        out.print(" name=\"" + XMLUtils.encode(this.getName()) + "\"");
        out.print(" class=\"" + XMLUtils.encode(this.className) + "\"");
        out.print(" descriptor=\"" + XMLUtils.encode(this.getDescriptorName()) + "\"");
        out.println(">");
        if (this.getProperties() != null) {
            try {
                out.print(indention + "\t");
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                DOMSource source = new DOMSource(this.getProperties());
                StreamResult result = new StreamResult(out);
                transformer.transform(source, result);
            }
            catch (TransformerException e) {
                throw new IOException(e.getMessage());
            }
        }
        out.println(indention + "</persistence-manager>");
    }

    public String toString() {
        StringBuffer string = new StringBuffer("Persistence Manager: ");
        string.append("\n\tname=");
        string.append(this.name);
        string.append("\n\tclass=");
        string.append(this.className);
        string.append("\n\tdescriptor=");
        string.append(this.descriptorName);
        return string.toString();
    }

    public static boolean isTopLinkPM(String name) {
        return name.equalsIgnoreCase(DEFAULT_TOPLINK_PM);
    }

    public static boolean isOrionPM(String name) {
        return name.equalsIgnoreCase(ORION_PM) || name.equalsIgnoreCase(ORION_PM_OLD);
    }

    public boolean isOrionPM() {
        return PersistenceManagerDescriptor.isOrionPM(this.name);
    }

    public boolean isTopLinkPM() {
        return PersistenceManagerDescriptor.isTopLinkPM(this.name);
    }
}

