/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.deployment;

import com.evermind.server.ApplicationConfig;
import com.evermind.server.ApplicationServer;
import com.evermind.server.OC4JServer;
import com.evermind.server.ejb.AbstractEJBHome;
import com.evermind.server.ejb.BeanPool;
import com.evermind.server.ejb.EJBContainer;
import com.evermind.server.ejb.StatefulSessionDefaultLocalHome;
import com.evermind.server.ejb.StatefulSessionDefaultLocalHomeImpl;
import com.evermind.server.ejb.StatefulSessionDefaultRemoteHome;
import com.evermind.server.ejb.StatefulSessionDefaultRemoteHomeImpl;
import com.evermind.server.ejb.StatefulSessionEJBHome;
import com.evermind.server.ejb.StatelessSessionBeanPool;
import com.evermind.server.ejb.StatelessSessionDefaultLocalHome;
import com.evermind.server.ejb.StatelessSessionDefaultLocalHomeImpl;
import com.evermind.server.ejb.StatelessSessionDefaultRemoteHome;
import com.evermind.server.ejb.StatelessSessionDefaultRemoteHomeImpl;
import com.evermind.server.ejb.StatelessSessionEJBHome;
import com.evermind.server.ejb.deployment.BeanDescriptorXMLFactory;
import com.evermind.server.ejb.deployment.ContainerTransaction;
import com.evermind.server.ejb.deployment.EJBDeploymentContext;
import com.evermind.server.ejb.deployment.EJBPackage;
import com.evermind.server.ejb.deployment.ExposableBeanDescriptor;
import com.evermind.server.ejb.deployment.InitMethod;
import com.evermind.server.ejb.deployment.InvalidEJBAssemblyException;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.deployment.RemoveMethod;
import com.evermind.server.ejb.deployment.SessionBeanDescriptorXMLFactory;
import com.evermind.server.ejb.exception.ValidationExceptions;
import com.evermind.server.ejb.logging.EJBDeploymentMessages;
import com.oracle.bricks.j2ee.ReplicationPolicy;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.ejb.SessionBean;
import oracle.dms.instrument.GroupRefresh;
import oracle.dms.instrument.Refresh;

public class SessionBeanDescriptor
extends ExposableBeanDescriptor
implements GroupRefresh {
    private String serviceEndpointName;
    private Set removeMethods;
    private Set initMethods;
    protected static final String PERSISTENCE_FILE_NONE = "[NONE]";
    private ReplicationPolicy replicationPolicy;
    private String persistenceFilename;
    protected static final int DEFAULT_TIMEOUT = 1800;
    protected static final int UNDEFINED_TIMEOUT = -1;
    protected static final int DEFAULT_IDLETIME = 300;
    protected static final int DEFAULT_MEMORY_THRESHOLD = 80;
    protected static final int DEFAULT_MAX_INSTANCES_THRESHOLD = 90;
    protected static final int DEFAULT_RESOURCE_CHECK_INTERVAL = 180;
    protected static final int INITIAL_PASSIVATE_COUNT = -1;
    protected static final int PASSIVATE_COUNT_DIVISOR = 3;
    protected static final String STATELESS_DEFAULT_LOCAL_HOME = "com.evermind.server.ejb.StatelessSessionDefaultLocalHome";
    protected static final String STATELESS_DEFAULT_REMOTE_HOME = "com.evermind.server.ejb.StatelessSessionDefaultRemoteHome";
    protected static final String STATELESS_DEFAULT_LOCAL_HOME_WRAPPER = "com.evermind.server.ejb.StatelessSessionDefaultLocalHomeImpl";
    protected static final String STATELESS_DEFAULT_REMOTE_HOME_WRAPPER = "com.evermind.server.ejb.StatelessSessionDefaultRemoteHomeImpl";
    protected static final String STATEFUL_DEFAULT_LOCAL_HOME = "com.evermind.server.ejb.StatefulSessionDefaultLocalHome";
    protected static final String STATEFUL_DEFAULT_REMOTE_HOME = "com.evermind.server.ejb.StatefulSessionDefaultRemoteHome";
    protected static final String STATEFUL_DEFAULT_LOCAL_HOME_WRAPPER = "com.evermind.server.ejb.StatefulSessionDefaultLocalHomeImpl";
    protected static final String STATEFUL_DEFAULT_REMOTE_HOME_WRAPPER = "com.evermind.server.ejb.StatefulSessionDefaultRemoteHomeImpl";
    private int timeout;
    private int transactionTimeout;
    private int idletime;
    private int memoryThreshold;
    private int maxInstancesThreshold;
    private int resourceCheckInterval;
    private int passivateCount;
    protected static final String EJB_WEBSERVICE_PROCESSOR = "oracle.j2ee.ws.common.metadata.annotation.EJBWebServiceAnnotationParser";
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$CreateException;

    public SessionBeanDescriptor(EJBPackage ejbPackage, String ejbName) {
        super(ejbPackage);
        this.setName(ejbName);
        this.setTimeout(1800);
        this.setTransactionTimeout(-1);
        this.setIdletime(300);
        this.setMemoryThreshold(80);
        this.setMaxInstancesThreshold(90);
        this.setResourceCheckInterval(180);
        this.setPassivateCount(-1);
        this.removeMethods = new HashSet();
        this.initMethods = new HashSet();
        this.replicationPolicy = null;
    }

    protected void initialize() throws InstantiationException {
        if (this.getBeanType() == 4) {
            this.setBeanType(2);
            EJBDeploymentMessages.warningMissingSessionBeanType(this, this.getName());
        }
        if (this.isServiceEndpoint() && this.isStateful()) {
            throw new InvalidEJBAssemblyException("Only stateless session beans can be declared as service endpoints", "6.11", "2.1");
        }
        if (this.isServiceEndpoint() && this.getRemoteHomeName() == null) {
            this.setIsServiceEndPointOnly(true);
        }
        if (this.isServiceEndpoint() && this.getRemoteInterfaceNames().isEmpty()) {
            this.addRemoteInterfaceName(this.getServiceEndpointName());
        }
        if (this.replicationPolicy == null) {
            this.replicationPolicy = new ReplicationPolicy();
            ApplicationConfig config = this.getPackage().getContainer().getApplication().getConfig();
            if (config != null && config.getClusterConfig() != null && config.getClusterConfig().getReplicationPolicy() != null) {
                this.replicationPolicy.setReplicationTrigger(ReplicationPolicy.convertReplicationTrigger(config.getClusterConfig().getReplicationPolicy().getReplicationTriggerName()));
            }
        }
        if (this.getPackage().getCompatibility() >= 3 && this.getLocalHomeName() == null && !this.getLocalInterfaceNames().isEmpty()) {
            if (this.isStateless()) {
                this.setGeneratedLocalHomeName(STATELESS_DEFAULT_LOCAL_HOME);
                this.setLocalHome(StatelessSessionDefaultLocalHome.class);
                this.setLocalHomeWrapperName(STATELESS_DEFAULT_LOCAL_HOME_WRAPPER);
                this.setLocalHomeWrapper(StatelessSessionDefaultLocalHomeImpl.class);
            } else {
                this.setGeneratedLocalHomeName(STATEFUL_DEFAULT_LOCAL_HOME);
                this.setLocalHome(StatefulSessionDefaultLocalHome.class);
                this.setLocalHomeWrapperName(STATEFUL_DEFAULT_LOCAL_HOME_WRAPPER);
                this.setLocalHomeWrapper(StatefulSessionDefaultLocalHomeImpl.class);
            }
        }
        if ((this.getPackage().getCompatibility() >= 3 || this.isServiceEndpoint()) && this.getRemoteHomeName() == null && !this.getRemoteInterfaceNames().isEmpty()) {
            if (this.isStateless()) {
                this.setGeneratedRemoteHomeName(STATELESS_DEFAULT_REMOTE_HOME);
                this.setRemoteHome(StatelessSessionDefaultRemoteHome.class);
                this.setRemoteHomeWrapperName(STATELESS_DEFAULT_REMOTE_HOME_WRAPPER);
                this.setRemoteHomeWrapper(StatelessSessionDefaultRemoteHomeImpl.class);
            } else {
                this.setGeneratedRemoteHomeName(STATEFUL_DEFAULT_REMOTE_HOME);
                this.setRemoteHome(StatefulSessionDefaultRemoteHome.class);
                this.setRemoteHomeWrapperName(STATEFUL_DEFAULT_REMOTE_HOME_WRAPPER);
                this.setRemoteHomeWrapper(StatefulSessionDefaultRemoteHomeImpl.class);
            }
        }
        if (!this.isStateful() && this.getRemoveMethods().size() > 0) {
            throw new InvalidEJBAssemblyException("Only stateful session beans may declare remove methods", null);
        }
        if (!this.isStateful() && this.getInitMethods().size() > 0) {
            throw new InvalidEJBAssemblyException("Only stateful session beans may declare init methods", null);
        }
        if (this.getPassivateCount() < 0) {
            if (this.getMaxInstances() >= 3) {
                this.setPassivateCount(this.getMaxInstances() / 3);
            } else {
                this.setPassivateCount(0);
            }
        }
        Iterator i = this.getPackage().getContainerTransactions().iterator();
        while (i.hasNext()) {
            ContainerTransaction tx = (ContainerTransaction)i.next();
            MethodDescriptor[] methods = tx.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                MethodDescriptor md = methods[j];
                String intfType = MethodDescriptor.getMethodOriginName(md.getType());
                if (intfType.equals("Unknown") && md.getName().equals("*") || md.getBeanName() == null || !md.getBeanName().equals(this.getName())) continue;
                if (this.getRemoteHomeName() != null && (intfType.equals("Unknown") || intfType.equals("Home")) && (md.getName().equals("create") || md.getName().equals("*"))) {
                    EJBDeploymentMessages.warningInvalidSessionCreateTransactionType(this);
                }
                if (this.getLocalHomeName() == null || !intfType.equals("Unknown") && !intfType.equals("LocalHome") || !md.getName().equals("create") && !md.getName().equals("*")) continue;
                EJBDeploymentMessages.warningInvalidSessionCreateTransactionType(this);
            }
        }
        super.initialize();
    }

    public void initialize(EJBDeploymentContext container) throws InstantiationException {
        super.initialize(container);
        this.validatePostInit();
    }

    public void validatePostInit() throws InstantiationException {
        if (this.getServiceEndpoint() != null) {
            Method[] methods = this.getServiceEndpoint().getDeclaredMethods();
            for (int index = 0; index < methods.length; ++index) {
                if (this.getTransactionType(methods[index], false, false) != 3) continue;
                throw new InvalidEJBAssemblyException(this.getServiceEndpoint().getName() + " is defined as the web service endpoint, Mandatory is not to be allowed by specification as one of the trans-attribute(s)", "17.4.1");
            }
        }
        if (this.getPackage().getCompatibility() < 3 && !SessionBean.class.isAssignableFrom(this.getEJBClass())) {
            throw new InvalidEJBAssemblyException(this.getEJBClassName() + " does not implement javax.ejb.SessionBean", "7.10.2");
        }
        if (this.getPackage().getCompatibility() >= 3 && this.isStateful() && !Serializable.class.isAssignableFrom(this.getEJBClass())) {
            throw new InvalidEJBAssemblyException(this.getEJBClassName() + " does not implement java.io.Serializable", null);
        }
        if (Modifier.isAbstract(this.getEJBClass().getModifiers())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must not be declared abstract");
        }
        if (Modifier.isFinal(this.getEJBClass().getModifiers())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must not be declared final");
        }
        if (!Modifier.isPublic(this.getEJBClass().getModifiers())) {
            throw new InstantiationException("Bean class " + this.getEJBClassName() + " must be declared public");
        }
        if (this.getLocalInterface() != null) {
            this.validateBusinessMethods(true);
        }
        if (this.getRemoteInterface() != null) {
            this.validateBusinessMethods(false);
        }
        if (this.getLocalHome() != null) {
            this.validateHomeMethods(true);
        }
        if (this.getRemoteHome() != null) {
            this.validateHomeMethods(false);
        }
    }

    protected void validateBusinessMethods(boolean local) throws InstantiationException {
        Class intf = local ? this.getLocalInterface() : this.getRemoteInterface();
        Method[] methods = intf.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getDeclaringClass() == (local ? (class$javax$ejb$EJBLocalObject == null ? SessionBeanDescriptor.class$("javax.ejb.EJBLocalObject") : class$javax$ejb$EJBLocalObject) : (class$javax$ejb$EJBObject == null ? SessionBeanDescriptor.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject))) continue;
            Class<?>[] exceptions = method.getExceptionTypes();
            boolean throwsRemoteException = false;
            for (int j = 0; j < exceptions.length; ++j) {
                if (!exceptions[j].isAssignableFrom(class$java$rmi$RemoteException == null ? SessionBeanDescriptor.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) continue;
                throwsRemoteException = true;
            }
            if (this.getPackage().getCompatibility() >= 3 || local || throwsRemoteException) continue;
            throw ValidationExceptions.sessionRemoteMethodMustThrowRemoteException(this, method.toString());
        }
    }

    protected void validateHomeMethods(boolean local) throws InstantiationException {
        boolean isAdaptedHome = (local ? this.isAdaptedLocalHome() : this.isAdaptedRemoteHome()) && this.isStateful() && this.getPackage().getCompatibility() >= 3;
        Class intf = local ? this.getLocalHome() : this.getRemoteHome();
        Method[] methods = intf.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (method.getDeclaringClass() == (local ? (class$javax$ejb$EJBLocalHome == null ? SessionBeanDescriptor.class$("javax.ejb.EJBLocalHome") : class$javax$ejb$EJBLocalHome) : (class$javax$ejb$EJBHome == null ? SessionBeanDescriptor.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome))) continue;
            if (!method.getName().startsWith("create")) {
                throw ValidationExceptions.sessionUnexpectedHomeMethod(this, method.toString(), local);
            }
            if (this.isStateless() && method.getParameterTypes().length > 0) {
                throw ValidationExceptions.sessionInvalidCreateMethod(this, method.toString(), local);
            }
            this.validateCreateMethod(method, local);
            if (!isAdaptedHome) continue;
            this.validateInitMethod(method);
        }
    }

    protected void validateCreateMethod(Method method, boolean local) throws InstantiationException {
        Class<?>[] exceptions = method.getExceptionTypes();
        boolean remoteSet = false;
        boolean createSet = false;
        for (int i = 0; i < exceptions.length; ++i) {
            if (exceptions[i].isAssignableFrom(class$java$rmi$RemoteException == null ? SessionBeanDescriptor.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException)) {
                remoteSet = true;
            }
            if (!exceptions[i].isAssignableFrom(class$javax$ejb$CreateException == null ? SessionBeanDescriptor.class$("javax.ejb.CreateException") : class$javax$ejb$CreateException)) continue;
            createSet = true;
        }
        if (!remoteSet && !local) {
            throw ValidationExceptions.sessionCreateMustThrowRemoteException(this, method.toString());
        }
        if (!createSet) {
            throw ValidationExceptions.sessionCreateMustThrowCreateException(this, method.toString(), local);
        }
        if (this.getPackage().getCompatibility() < 3 && !this.isServiceEndpoint() && method.getReturnType() != (local ? this.getLocalInterface() : this.getRemoteInterface())) {
            throw ValidationExceptions.sessionCreateMustReturnIntf(this, method.toString(), local ? this.getLocalInterfaceName() : this.getRemoteInterfaceName(), local);
        }
    }

    public void resetForCompile() {
        if (this.isStateless()) {
            if (this.getLocalHomeWrapperName() != null && !this.getLocalHomeWrapperName().equals(STATELESS_DEFAULT_LOCAL_HOME_WRAPPER)) {
                this.setLocalHomeWrapperName(null);
            }
            if (this.getRemoteHomeWrapperName() != null && !this.getRemoteHomeWrapperName().equals(STATELESS_DEFAULT_REMOTE_HOME_WRAPPER)) {
                this.setRemoteHomeWrapperName(null);
            }
        } else {
            if (this.getLocalHomeWrapperName() != null && !this.getLocalHomeWrapperName().equals(STATEFUL_DEFAULT_LOCAL_HOME_WRAPPER)) {
                this.setLocalHomeWrapperName(null);
            }
            if (this.getRemoteHomeWrapperName() != null && !this.getRemoteHomeWrapperName().equals(STATEFUL_DEFAULT_REMOTE_HOME_WRAPPER)) {
                this.setRemoteHomeWrapperName(null);
            }
        }
    }

    protected void addDMSAttrs() {
        if (ApplicationServer.DMS_GATE) {
            ApplicationServer.stateFactory().create(this.getBeanNoun(), "session-type", "", "session type", (Object)(this.isStateful() ? "Stateful" : "Stateless"));
            super.addDMSAttrs();
        }
    }

    public boolean isSession() {
        return true;
    }

    public boolean isStateful() {
        return this.getBeanType() == 1;
    }

    public boolean isStateless() {
        return this.getBeanType() == 2;
    }

    public int getIdletime() {
        return this.idletime;
    }

    public int getMaxInstancesThreshold() {
        return this.maxInstancesThreshold;
    }

    public int getMemoryThreshold() {
        return this.memoryThreshold;
    }

    public int getResourceCheckInterval() {
        return this.resourceCheckInterval;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public int getPassivateCount() {
        return this.passivateCount;
    }

    public String getServiceEndpointName() {
        return this.serviceEndpointName;
    }

    public boolean isServiceEndpoint() {
        return this.serviceEndpointName != null;
    }

    public Set getRemoveMethods() {
        return this.removeMethods;
    }

    public Set getInitMethods() {
        return this.initMethods;
    }

    public ReplicationPolicy getReplicationPolicy() {
        return this.replicationPolicy;
    }

    public void setReplicationPolicy(ReplicationPolicy replicationPolicy) {
        this.replicationPolicy = replicationPolicy;
    }

    public void setServiceEndpointName(String serviceEndpointName) {
        this.serviceEndpointName = serviceEndpointName;
    }

    public String getPersistenceFilename() {
        if (OC4JServer.getInstanceId() == null) {
            if (this.persistenceFilename == null) {
                return this.getLocation();
            }
            if (this.persistenceFilename.equalsIgnoreCase(PERSISTENCE_FILE_NONE)) {
                return null;
            }
            return this.persistenceFilename;
        }
        if (this.persistenceFilename == null) {
            if (this.getLocation().indexOf(OC4JServer.getInstanceId()) == -1) {
                return this.getLocation() + "." + OC4JServer.getInstanceId();
            }
            return this.getLocation();
        }
        if (this.persistenceFilename.equalsIgnoreCase(PERSISTENCE_FILE_NONE)) {
            return null;
        }
        if (this.persistenceFilename.indexOf(OC4JServer.getInstanceId()) == -1) {
            return this.persistenceFilename + "." + OC4JServer.getInstanceId();
        }
        return this.persistenceFilename;
    }

    protected void setPersistenceFilename(String filename) {
        this.persistenceFilename = filename == null ? PERSISTENCE_FILE_NONE : filename;
    }

    public void setIdletime(int idletime) {
        this.idletime = idletime;
    }

    public void setMaxInstancesThreshold(int maxInstancesThreshold) {
        this.maxInstancesThreshold = maxInstancesThreshold;
    }

    public void setMemoryThreshold(int memoryThreshold) {
        this.memoryThreshold = memoryThreshold;
    }

    public void setPassivateCount(int passivateCount) {
        this.passivateCount = passivateCount;
    }

    public void setResourceCheckInterval(int resourceCheckInterval) {
        this.resourceCheckInterval = resourceCheckInterval;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(int transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    public AbstractEJBHome createHomeInstance(EJBContainer container, ClassLoader loader, boolean local) throws InstantiationException {
        try {
            Class homeClass;
            if (local) {
                if (this.getLocalHomeWrapperName() == null) {
                    throw new InstantiationException("local wrapper name not specified in orion-ejb-jar.xml; redeploy");
                }
                homeClass = this.getLocalHomeWrapper();
            } else {
                if (this.getRemoteHomeWrapperName() == null) {
                    throw new InstantiationException("remote wrapper name not specified in orion-ejb-jar.xml; redeploy");
                }
                homeClass = this.getRemoteHomeWrapper();
            }
            AbstractEJBHome homeInstance = (AbstractEJBHome)homeClass.newInstance();
            homeInstance.setBeanDescriptor(this);
            homeInstance.setContainer(container, this.getEJBPackage().getDeployment(), this.getRoleReferences());
            homeInstance.setContainerManagedTransactions(this.getTransactionType() != 1);
            homeInstance.OC4J_setBindingPath(this.getLocation());
            if (this.isStateful()) {
                StatefulSessionEJBHome home = (StatefulSessionEJBHome)homeInstance;
                home.allowPassivate = ApplicationServer.getInstance().getConfig().getSFSBEnablePassivation();
                home.sessionTimeout = (long)this.timeout * 1000L;
                home.setCacheCheckInterval();
            }
            return homeInstance;
        }
        catch (InstantiationException e) {
            throw e;
        }
        catch (Exception e) {
            this.getEJBPackage().getContainer().getApplication().log("Error creating home instance for " + this.getName(), e);
            throw new InstantiationException("Error creating home instance: " + e.getClass().getName() + " (" + e.getMessage() + ")");
        }
    }

    public BeanDescriptorXMLFactory getBeanDescriptorXMLFactory() {
        return SessionBeanDescriptorXMLFactory.getInstance();
    }

    protected BeanPool createBeanPool(Object home) {
        if (this.isStateless()) {
            return new StatelessSessionBeanPool(this, (StatelessSessionEJBHome)home);
        }
        this.getReadyCountState();
        this.getPassivatedCountState();
        return null;
    }

    protected void createReadyCountState() {
        super.createReadyCountState();
        if (this.isStateful()) {
            this.readyCount.setRefresh((Refresh)this);
        }
    }

    public void createPassivatedCountState() {
        super.createPassivatedCountState();
        this.passivatedCount.setRefresh((Refresh)this);
    }

    public void refresh() {
        this.readyCount.update(this.__activeInstancesCount);
        this.passivatedCount.update(this.__passivatedInstancesCount);
    }

    public RemoveMethod getRemoveMethod(Method beanMethod) {
        int level = 0;
        RemoveMethod returnMethod = null;
        String beanName = null;
        Iterator it = this.getRemoveMethods().iterator();
        while (it.hasNext()) {
            RemoveMethod removeMethod = (RemoveMethod)it.next();
            int newLevel = removeMethod.getMethodDescriptor().implies(beanName, beanMethod, 0);
            if (newLevel <= level) continue;
            level = newLevel;
            returnMethod = removeMethod;
        }
        return returnMethod;
    }

    public String isDeployed() {
        String reason = null;
        reason = this.checkClassForUpdate(this.getServiceEndpointName());
        if (reason == null) {
            reason = this.checkWebServiceUpdate();
        }
        if (reason != null) {
            return reason;
        }
        if (this.getGenerateIIOP()) {
            return this.checkBeanUpdate();
        }
        return null;
    }

    private String checkWebServiceUpdate() {
        if (this.getEJBPackage().getCompatibility() < 3) {
            return null;
        }
        try {
            Class<?> ejbwspClass = Class.forName(EJB_WEBSERVICE_PROCESSOR);
            Method codeGenNeededMethod = ejbwspClass.getMethod("isWebServiceCodeGenNeeded", SessionBeanDescriptor.class);
            Object o = codeGenNeededMethod.invoke(null, this);
            return (String)o;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (NoSuchMethodException e) {
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    public ArrayList getInitMethod(Method beanMethod) {
        ArrayList<Object> returnMethodList = new ArrayList();
        if (beanMethod == null) {
            return returnMethodList;
        }
        String methodName = beanMethod.getName();
        Iterator it = this.initMethods.iterator();
        ArrayList<InitMethod> nameMethodList = new ArrayList<InitMethod>();
        ArrayList<InitMethod> paramMethodList = new ArrayList<InitMethod>();
        while (it.hasNext()) {
            InitMethod initMethod = (InitMethod)it.next();
            if (initMethod.getCreateMethodName() != null && initMethod.getCreateMethodName() != "") {
                if (!initMethod.getCreateMethodName().equals(methodName) || !this.cmpMethodSignature(beanMethod, initMethod.getMethodDescriptor())) continue;
                nameMethodList.add(initMethod);
                continue;
            }
            if (!this.cmpMethodSignature(beanMethod, initMethod.getMethodDescriptor())) continue;
            paramMethodList.add(initMethod);
        }
        returnMethodList = nameMethodList.size() != 0 ? nameMethodList : paramMethodList;
        return returnMethodList;
    }

    private boolean cmpMethodSignature(Method method, MethodDescriptor methodDesc) {
        MethodDescriptor tmpMethodDesc = new MethodDescriptor(null, method, 0);
        tmpMethodDesc.setName("*");
        int level = 0;
        int newLevel = tmpMethodDesc.implies(methodDesc);
        return newLevel > level;
    }

    public boolean isAdaptedLocalHome() {
        return this.getLocalHomeName() != null && !this.getLocalHomeName().equals(STATEFUL_DEFAULT_LOCAL_HOME);
    }

    public boolean isAdaptedRemoteHome() {
        return this.getRemoteHomeName() != null && !this.getRemoteHomeName().equals(STATEFUL_DEFAULT_REMOTE_HOME);
    }

    protected void validateInitMethod(Method createMethod) throws InstantiationException {
        String methodName = createMethod.getName();
        Class<?>[] paramTypes = createMethod.getParameterTypes();
        ArrayList methodList = this.getInitMethod(createMethod);
        if (methodList == null || methodList.size() == 0) {
            String beanMethodName = "ejbC" + methodName.substring(1);
            try {
                this.getEJBClass().getMethod(beanMethodName, paramTypes);
            }
            catch (NoSuchMethodException e) {
                throw ValidationExceptions.sessionCreateMustHaveInitMethod(this, methodName);
            }
        } else {
            if (methodList.size() == 1) {
                return;
            }
            StringBuffer methodNameBuf = new StringBuffer("");
            for (int i = 0; i < methodList.size(); ++i) {
                InitMethod initMethod = (InitMethod)methodList.get(i);
                methodNameBuf.append(initMethod.getMethodDescriptor().getName());
            }
            throw ValidationExceptions.sessionCreateCanOnlyHaveOneInitMethod(this, methodName, methodNameBuf.toString());
        }
    }
}

