/*
 * Decompiled with CFR 0.152.
 */
package com.evermind.server.ejb.interceptor.system;

import com.evermind.server.ejb.EJBUtils;
import com.evermind.server.ejb.deployment.BeanDescriptor;
import com.evermind.server.ejb.deployment.MethodDescriptor;
import com.evermind.server.ejb.interceptor.Interceptor;
import com.evermind.server.ejb.interceptor.InvocationContext;
import com.evermind.server.ejb.interceptor.MethodState;
import oracle.oc4j.rmi.OracleRemoteException;

public class ExcludeInterceptor
implements Interceptor {
    private static String EXCLUDE_EXCEPTION_MESSAGE = "Method in exclude-list";

    public static Interceptor getInstance(MethodState state) {
        if (ExcludeInterceptor.isInExcludeList(state)) {
            return new ExcludeInterceptor();
        }
        return null;
    }

    public Object invoke(InvocationContext ctx) throws Exception {
        if (!ctx.getMethodState().isLocal()) {
            throw ExcludeInterceptor.remoteExclude();
        }
        throw ExcludeInterceptor.localExclude();
    }

    public static boolean isInExcludeList(MethodState state) {
        BeanDescriptor descriptor = state.getBeanDescriptor();
        for (int i = 0; i < descriptor.getEJBPackage().getExcludeListMethods().size(); ++i) {
            if (((MethodDescriptor)descriptor.getEJBPackage().getExcludeListMethods().get(i)).implies(descriptor.getName(), state.getInterfaceMethod(), state.isLocal() ? (state.isHome() ? 4 : 3) : (state.isHome() ? 2 : 1)) <= 0) continue;
            return true;
        }
        return false;
    }

    public static Exception localExclude() {
        return EJBUtils.createEJBException(EXCLUDE_EXCEPTION_MESSAGE);
    }

    public static Exception remoteExclude() {
        return new OracleRemoteException(EXCLUDE_EXCEPTION_MESSAGE);
    }
}

